#include "g_local.h"
#include "g_sfx.h"
#include <string.h>
#include <stdio.h>
#include <winbase.h>


// Creates an enitity which thinks every half second. The owner is set
// to the player entity so I that I can use it.

void spawn_sfx(edict_t *self)
{
	edict_t *sfx;

	sfx = G_Spawn();
	sfx->think = sfx_think;

	sfx->nextthink = level.time + 0.5;

	sfx->owner = self;
}


// The think function contains code to determine the current surroundings
void sfx_think(edict_t *self)
{
	float radius;
	vec3_t	spot1, spot2;
	trace_t trace;

	//get player position
	VectorCopy(self->owner->s.origin, spot1);
	spot1[2] += self->owner->viewheight;
	
	radius = 0;

	//Calculate very rough radius of room. Room is treated as sphere
	//for the sheer hell of it!!! Very rough!!!!!
	//Basically 8 points of the compass are traced for 1000 units or
	//whatever as well as above or below, and the distances to a solid
	//are averaged to give and aproximate radius. Very approximate!!!
	//I'm just after a general size of the room.

	radius += getradius(707.1, spot1, self->owner); // average of distances at rough angle up
	radius += getradius(-707.1, spot1, self->owner);// and down
	radius += getradius(0, spot1, self->owner);     // and horizontal.  8 points of the compass for each. probably

	VectorCopy(spot1, spot2);
	spot2[2] += 1000;
	trace = gi.trace(spot1, NULL, NULL, spot2, self->owner, MASK_SOLID); // distance straight up
	radius += (trace.fraction) * 1000;
	spot2[2] -= 1000;
	trace = gi.trace(spot1, NULL, NULL, spot2, self->owner, MASK_SOLID); // distance straight down
	radius += (trace.fraction) * 1000;

	radius /= 5; //rough radius of room sphere
	self->nextthink = level.time + 0.5;
	if (self->owner->waterlevel == 3)
		radius = IN_WATER;

//	gi.bprintf(PRINT_HIGH, "Room size: %.2f\n", radius);

	set_effects(radius);
	if (self->owner->deadflag == DEAD_DEAD) // if player has died
		G_FreeEdict(self);                  // free the edict. 
}

// Get the average distance from player to solid for 8 directions at an angle
float getradius(float z_value, vec3_t spot1, edict_t *player)
{
	float radius;
	int loop;
	vec3_t spot2;
	trace_t trace;
    
	radius = 0;
// Shit hack, but if it can be done better I'd appreciate hearing about it.
	for(loop = 1; loop <= 8; loop++)
	{
		VectorCopy(spot1, spot2);
		spot2[2] += z_value;
		switch(loop)
		{
		case 1: 
			spot2[0] += 1000;
			break;
		case 2:
			spot2[0] -= 1000;
			break;
		case 3:
			spot2[1] += 1000;
			break;
		case 4:
			spot2[1] -= 1000;
			break;
		case 5:
			spot2[0] += 707.1;
			spot2[1] += 707.1;
			break;
		case 6:
			spot2[0] += 707.1;
			spot2[1] -= 707.1;
			break;
		case 7:
			spot2[0] -= 707.1;
			spot2[1] += 707.1;
			break;
		case 8:
			spot2[0] -= 707.1;
			spot2[1] -= 707.1;
			break;
		}
		trace = gi.trace(spot1, NULL, NULL, spot2, player, MASK_SOLID);
		radius += (trace.fraction) * 1000;
	}
	radius /= 8;
	return radius;
}

// Sets the apropriate effect if the room size has changed since last time
void set_effects(float radius)
{

	static float room_size = DEFAULT; // static to remember current size

	if (room_size == DEFAULT)
	{

		EffectsSend(0);
	
	}

	if (radius == IN_WATER && room_size != IN_WATER	)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Corridor\n");		
		room_size = IN_WATER;
		EffectsSend(6);  // Special circumstance for when player underwater
		return;
	}
	if (radius <= CORRIDOR && radius > IN_WATER && room_size != CORRIDOR)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Corridor\n");		
		room_size = CORRIDOR;
		EffectsSend(1);
		return;
	};

	if (radius <= SMALL_ROOM && radius > CORRIDOR && room_size != SMALL_ROOM)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Small Room\n");		
		room_size = SMALL_ROOM;
		EffectsSend(2);
		return;
	};
	if (radius <= LARGE_ROOM && radius > SMALL_ROOM && room_size != LARGE_ROOM)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Large Room\n");		
		room_size = LARGE_ROOM;
		EffectsSend(3);
		return;
	};
	if (radius <= LARGE_HALL && radius > LARGE_ROOM && room_size != LARGE_HALL)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Large Hall\n");		
		room_size = LARGE_HALL;
		EffectsSend(4);
		return;
	};
	if (radius <= OUTDOORS && radius > LARGE_HALL && room_size != OUTDOORS)
	{
//		gi.bprintf(PRINT_HIGH, "Room size: Outdoors\n");		
		room_size = OUTDOORS;
		EffectsSend(5);
		return;
	};

}

//FILE *debug;

void EffectsSend(int fxtype)
{
	static int devnum;
	static HMIDIOUT hmidiout;
	BYTE dry[] = {240, 67, 16, 76, 16, 0, 17, 0, 247};
	BYTE wet[] = {240, 67, 16, 76, 16, 0, 17, 127, 247};
	BYTE sysex[10];
	UINT level, variation;

	BYTE basement[] = BASEMENT;
	BYTE room1[] = ROOM1;
	BYTE room3[] = ROOM3;
	BYTE hall2[] = HALL2;


	
	
//  debug = fopen ("debug.txt", "a");

    if (fxtype == 0) // This is executed when the entity is created
	{

//		fprintf(debug, "GET DEVICE!\n");
//		fclose(debug);

		hmidiout = getdevice(&devnum); // Get the midi device handle
		xgreset(hmidiout);  // Setup the SW60XG
		dataout(hmidiout, (DWORD)177,(DWORD)94, (DWORD)127); // Initialize reverb level

		return;
	}
		

// Ready sysex buffer with appropriate reverb type
	switch (fxtype)
	{
	case 1: bytencopy(sysex, basement, 10);
			level = 127;
			variation = 0;
			break;
	case 2: bytencopy(sysex, room1, 10);
			level = 127;
			variation = 0;
			break;
	case 3: bytencopy(sysex, room3, 10);
			level = 127;
			variation = 0;
			break;
	case 4: bytencopy(sysex, hall2, 10);
			level = 64;
			variation = 0;
			break;
	case 5: bytencopy(sysex, hall2, 10);
			level = 127;
			variation = 0;
			break;
	case 6: level = 0;
			variation = 127;
			
	}

	if (fxtype != 6)
		sysexout(hmidiout, sysex, 10); // Send the sysex to the card

	if (variation == 127) // send variation level to card for underwater
	{
		dataout(hmidiout, (DWORD)176,(DWORD)94, (DWORD)variation);
		dataout(hmidiout, (DWORD)176,(DWORD)91, (DWORD)level);
		sysexout(hmidiout,dry, 9);
	}
	else  // or send data for reverb
	{
		dataout(hmidiout, (DWORD)176, (DWORD)91, (DWORD)level);
		dataout(hmidiout, (DWORD)176, (DWORD)94, (DWORD)variation);
		sysexout(hmidiout,wet, 9);
	}



}

// Finds SW60XG and opens it
HMIDIOUT getdevice(int *devnum)
{

// There is practically no error handling here
// So if the device fails to open for a wierd reason
// nothing will happen probably

	int numdevs;
	int loop;
	int midierror;
	LPHMIDIOUT handle;
	HMIDIOUT returnval;
	MIDIOUTCAPS midioutcaps;
	numdevs = midiOutGetNumDevs();

	handle = malloc(sizeof(HMIDIOUT));
	loop = 0;

//	debug = fopen ("debug.txt", "a");
//	fprintf(debug, "GETDEVCAPS!!!!!!! Number of Devices = %d\n", numdevs);
//	fclose(debug);

	midiOutGetDevCaps(loop, &midioutcaps, sizeof(MIDIOUTCAPS));

//	debug = fopen ("debug.txt", "a");
//	fprintf(debug, "device name = %s\n", midioutcaps.szPname);
//	fclose(debug);

	while ((strcmp(midioutcaps.szPname, "Yamaha SW60XG Driver") != 0) && (loop < numdevs - 1))
	{
		loop++;

//		debug = fopen ("debug.txt", "a");
//		fprintf(debug, "GETDEVCAPS!!!!!!!\n");
//		fclose(debug);

		midiOutGetDevCaps(loop, &midioutcaps, sizeof(MIDIOUTCAPS));

//		debug = fopen ("debug.txt", "a");
//		fprintf(debug, "device name = %s loop = %d\n", midioutcaps.szPname, loop);
//		fclose(debug);

	}

//	debug = fopen ("debug.txt", "a");
//	fprintf(debug, "OPENMIDIOUT!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
//	fclose(debug);

	if ((midierror = midiOutOpen(handle, loop, 0, 0, 0)) != 0)

	{
//		gi.bprintf(PRINT_HIGH, "Midi open failed!!!!!\n");

	}

//	debug = fopen ("debug.txt", "a");
//	fprintf(debug, "midi error: %d\n", midierror);
//	fclose(debug);

	*devnum = loop;
	returnval = *handle;
	free(handle);
	return returnval;
}

	
// I'll bet there is a C library function that does this!
void bytencopy(BYTE *destination, BYTE *source, int items)
{
	int loop;

	for (loop = 0; loop < items; loop++)
		destination[loop] = source[loop];
}

// Function to encapsulate sending of sysex data
void sysexout(HMIDIOUT hmidiout, BYTE sysex[], int bytenum)
{
	UINT error;
	struct MYMIDIHDR{
		HANDLE hdrHandle;
		LPMIDIHDR hdrPointer;
		HANDLE sysexHandle;
		LPSTR sysexPointer;} mymidihdr;

	
	mymidihdr.hdrHandle = GlobalAlloc(GMEM_SHARE|GMEM_MOVEABLE|GMEM_ZEROINIT, sizeof(MIDIHDR));
	mymidihdr.hdrPointer = GlobalLock(mymidihdr.hdrHandle);
	
	mymidihdr.sysexHandle = GlobalAlloc(GMEM_SHARE|GMEM_MOVEABLE|GMEM_ZEROINIT, bytenum);
	mymidihdr.sysexPointer = GlobalLock(mymidihdr.sysexHandle);
	mymidihdr.hdrPointer->lpData = mymidihdr.sysexPointer;
	mymidihdr.hdrPointer->dwBufferLength = bytenum;

	bytencopy(mymidihdr.sysexPointer, sysex, bytenum);

	mymidihdr.hdrPointer->dwUser = (DWORD)&mymidihdr;

//	debug = fopen ("debug.txt", "a");
//	fprintf(debug, "Prepare Header! or output long msg\n");
//	fclose(debug);

	if ((error = midiOutPrepareHeader(hmidiout, mymidihdr.hdrPointer, sizeof(MIDIHDR))) == 0)
		midiOutLongMsg(hmidiout, mymidihdr.hdrPointer, sizeof(MIDIHDR));
	else
	{	
//		debug = fopen ("debug.txt", "a");
//		fprintf(debug, "MidiOutPrepareHeader Failed! error number: %d\n", error);
//		fclose(debug);
	}

	midiOutUnprepareHeader(hmidiout, mymidihdr.hdrPointer, sizeof(MIDIHDR));
//	debug = fopen ("debug.txt", "a");
//		fprintf(debug, "Output Short Message\n");
//	fclose(debug);

	GlobalUnlock(mymidihdr.hdrHandle);
	GlobalUnlock(mymidihdr.sysexHandle);
	GlobalFree(mymidihdr.hdrHandle);
	GlobalFree(mymidihdr.sysexHandle);
}

// Function to simplify sending midi messages
void dataout(HMIDIOUT hmidiout, DWORD message, DWORD control, DWORD data1)
{
	DWORD midiout;

	midiout = message|(control << 8)|(data1 << 16);
	midiOutShortMsg(hmidiout, midiout);
}

// This function initialises the card and sets it up for action
void xgreset(HMIDIOUT hmidiout)
{
	BYTE xgon[] = {240, 67, 16, 76, 0, 0, 126, 0, 247};  // switch on the XG system
	BYTE reset[] = {240, 67, 16, 76, 0, 0, 127, 0, 247}; // reset all parameters
	BYTE adon[] = {240, 67, 16, 73, 01, 0, 0, 1, 247};   // activate A/D converter
	BYTE varsys[] = {240, 67, 16, 76, 2, 1, 90, 1, 247}; // set up variation effect for underwater
	BYTE ad1[] = {240, 67, 16, 76, 16, 0, 4, 0, 247};    // set ad1 to receive midi on channel 1
	BYTE stereo[] = {240, 67, 16, 76, 17, 0, 0, 1, 247}; // turn on stereo input
	BYTE wah[] = {240, 67, 16, 76, 2, 1, 64, 78, 0, 247};// set variation to autowah 
	BYTE wah1[] = {240, 67, 16, 76, 2, 1, 66, 0, 0, 247};// set autowah to sound muffled
	BYTE wah3[] = {240, 67, 16, 76, 2, 1, 68, 0, 0, 247};// like being underwater!
	BYTE wet[] = {240, 67, 16, 76, 16, 0, 17, 127, 247}; // uh can't remember. set dry input to max


// Please don't panic. Sleep is only called these times.
// It is there to give the sysex time to process.
// It doesn't break anything
	sysexout(hmidiout,xgon, 9);
	Sleep(51);
	sysexout(hmidiout,reset, 9);
	Sleep(51);
	sysexout(hmidiout,adon, 9);
	Sleep(51);
	sysexout(hmidiout,varsys, 9);
	Sleep(51);
	sysexout(hmidiout,ad1, 9);
	Sleep(51);
	sysexout(hmidiout,stereo, 9);
	Sleep(51);
	sysexout(hmidiout,wah, 10);
	Sleep(51);
	sysexout(hmidiout,wah1, 10);
	Sleep(51);
	sysexout(hmidiout,wah3, 10);
	Sleep(51);
	sysexout(hmidiout,wet, 9);
	dataout(hmidiout, (DWORD)176, (DWORD)7, (DWORD)115);
}
