//
// cch_perlq2.c
//
// Adding a perl interpreter to Quake 2

#include	<EXTERN.H>	// from the Perl distribution
#include	<perl.h>	// ditto

static PerlInterpreter	*myPerl;

void InitPerl()
{
	char	*argv[] = { "", "perlq2.pl" };
	int		argc = 2;

	myPerl = perl_alloc();
	perl_construct(myPerl);
	perl_parse(myPerl, NULL, argc, argv, NULL);
	perl_run(myPerl);
}

I32 PerlEval(char *string)
{
	return perl_eval_sv(newSVpv(string, 0), G_DISCARD);
}

int GetPerlInt(char *string)
{
	return SvIV(perl_get_sv(string, FALSE));
}

float GetPerlFloat(char *string)
{
	return SvNV(perl_get_sv(string, FALSE));
}

char *GetPerlString(char *string)
{
	STRLEN	length;

	return SvPV(perl_get_sv(string, FALSE), length);
}

void FreePerl()
{
	perl_destruct(myPerl);
	perl_free(myPerl);
}

