/* tab setting: 3
 *
 * l_gsctf.c
 *
 * Gibstats basic CTF logging support v. 1.0
 * Gibstats advanced CTF logging support v. 1.0
 *
 */

#include "g_local.h"
#include "l_gibstats.h"
#include "l_gsctf.h"

extern char *CTFTeamName (int team);

/* basic ctf logging */
void gsctf_join_team (edict_t *ent)
{
	if (gibstats->value >= GSCTF_BASIC)
   fprintf (gs_file, "\t\tPlayer\t%s\t%s\t%.1f\n", ent->client->pers.netname, CTFTeamName(ent->client->resp.ctf_team), level.time);
}

void gsctf_change_team (edict_t *ent)
{
	if (gibstats->value >= GSCTF_BASIC)
   fprintf (gs_file, "\t\tPlayerTeamChange\t%s\t%s\t%.1f\n", ent->client->pers.netname, CTFTeamName(ent->client->resp.ctf_team), level.time);
}

void gsctf_capture_flag (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_BASIC) && CTF_CAPTURE_BONUS)
   fprintf (gs_file, "\t\tCaptureFlag\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_team_capture (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_BASIC) && CTF_TEAM_BONUS)
   fprintf (gs_file, "%s\t\tTeamCapture\t\t%i\t%.1f\n", ent->client->pers.netname, CTF_TEAM_BONUS, level.time);
}

void gsctf_pickup_flag (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_BASIC) && CTF_FLAG_BONUS)
   fprintf (gs_file, "\t\tPickupFlag\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_recover_flag (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_BASIC) && CTF_RECOVERY_BONUS)
   fprintf (gs_file, "\t\tRecoverFlag\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

/* advanced ctf logging */
void gsctf_frag_carrier (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_FRAG_CARRIER_BONUS)
   fprintf (gs_file, "\t\tFragCarrier\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_carrier_danger_protect (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_CARRIER_DANGER_PROTECT_BONUS)
   fprintf (gs_file, "\t\tCarrierDangerProtect\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_carrier_protect (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_CARRIER_PROTECT_BONUS)
   fprintf (gs_file, "\t\tCarrierProtect\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_flag_defense (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_FLAG_DEFENSE_BONUS)
   fprintf (gs_file, "\t\tFlagDefense\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_return_flag_assist (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_RETURN_FLAG_ASSIST_BONUS)
   fprintf (gs_file, "\t\tReturnFlagAssist\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

void gsctf_frag_carrier_assist (edict_t *ent)
{
	if ((gibstats->value >= GSCTF_ADVANCED) && CTF_FRAG_CARRIER_ASSIST_BONUS)
   fprintf (gs_file, "\t\tFragCarrierAssist\t%s\t\t%.1f\n", ent->client->pers.netname, level.time);
}

/* end of file */
