diff -urN --exclude=*.$$$ c:\q2\game/g_spawn.c ./g_spawn.c
--- c:\q2\game/g_spawn.c	Tue Nov 25 02:44:54 1997
+++ ./g_spawn.c	Wed Jan 28 10:09:12 1998
@@ -668,6 +668,15 @@
 "	xv	148 "
 "	pic	11 "
 "endif "
+
+// CCH: rangefinder
+"if 16 "
+"   xv 210 "
+"	num 4	16 "
+"   xv 234 "
+"   yb -59 "
+"   string RANGE "
+"endif "
 ;
 
 char *dm_statusbar =
@@ -731,6 +740,15 @@
 "xr	-50 "
 "yt 2 "
 "num 3 14"
+
+// CCH: rangefinder
+"if 16 "
+"   xv 210 "
+"	num 4	16 "
+"   xv 234 "
+"   yb -59 "
+"   string RANGE "
+"endif "
 ;
 
 
diff -urN --exclude=*.$$$ c:\q2\game/game.h ./game.h
--- c:\q2\game/game.h	Thu Nov 20 23:22:14 1997
+++ ./game.h	Wed Jan 28 10:09:12 1998
@@ -1,7 +1,7 @@
 
 // game.h -- game dll information visible to server
 
-#define	GAME_API_VERSION	1
+#define	GAME_API_VERSION	2
 
 // edict->svflags
 
diff -urN --exclude=*.$$$ c:\q2\game/p_hud.c ./p_hud.c
--- c:\q2\game/p_hud.c	Wed Nov 26 23:26:12 1997
+++ ./p_hud.c	Wed Jan 28 10:13:32 1998
@@ -288,6 +288,10 @@
 	int			index, cells;
 	int			power_armor_type;
 
+	// CCH: local variables for rangefinder
+	vec3_t		start, forward, end;
+	trace_t		tr;
+
 	//
 	// health
 	//
@@ -425,5 +429,19 @@
 		ent->client->ps.stats[STAT_HELPICON] = gi.imageindex (ent->client->pers.weapon->icon);
 	else
 		ent->client->ps.stats[STAT_HELPICON] = 0;
+
+	//
+	// CCH: rangefinder
+	//
+	VectorCopy(ent->s.origin, start);
+	start[2] += ent->viewheight;
+	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
+	VectorMA(start, 8192, forward, end);
+	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
+	// check for sky and max the range if found
+	if ( tr.surface && (tr.surface->flags & SURF_SKY) )
+		ent->client->ps.stats[STAT_RANGEFINDER] = 9999;
+	else
+		ent->client->ps.stats[STAT_RANGEFINDER] = (int)(tr.fraction * 8192);
 }
 
diff -urN --exclude=*.$$$ c:\q2\game/q_shared.h ./q_shared.h
--- c:\q2\game/q_shared.h	Tue Nov 25 07:06:16 1997
+++ ./q_shared.h	Wed Jan 28 10:09:12 1998
@@ -799,6 +799,9 @@
 #define	STAT_FRAGS				14
 #define	STAT_FLASHES			15		// cleared each frame, 1 = health, 2 = armor
 
+// CCH: rangefinder stat
+#define	STAT_RANGEFINDER		16
+
 #define	MAX_STATS				32
 
 
