#include "g_local.h"

/*===========================================
 -= C H A S E =-           -= C A M E R A =-
 By James Williams for sATaN's BoX of FuN Edition 2
 ==========================================*/

void ChasecamTrack (edict_t *ent);

void ChasecamStart (edict_t *ent)
{

   edict_t      *chasecam;
        
   ent->client->chasetoggle = 1;

   ent->client->ps.gunindex = 0;
        
   chasecam = G_Spawn ();
   chasecam->owner = ent;
   chasecam->solid = SOLID_NOT;
   chasecam->movetype = MOVETYPE_FLYMISSILE;

   VectorCopy (ent->s.angles, chasecam->s.angles);
        
   VectorClear (chasecam->mins);
   VectorClear (chasecam->maxs);
        
   VectorCopy (ent->s.origin, chasecam->s.origin);
        
   chasecam->classname = "chasecam";
   chasecam->nextthink = level.time + 0.100;
   chasecam->think = ChasecamTrack;

   ent->client->chasecam = chasecam;
        
   ent->client->oldplayer = G_Spawn();

}

void ChasecamRestart (edict_t *ent)
{

   ent->nextthink = level.time + 0.100;

   if (ent->owner->health <= 0)
   {
      G_FreeEdict (ent);
      return;
   }

   if (ent->owner->waterlevel)
      return;
        
   ChasecamStart (ent->owner);
   G_FreeEdict (ent);

}

void ChasecamRemove (edict_t *ent, char *opt)
{

   VectorClear (ent->client->chasecam->velocity);
        
   ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);

   ent->s.modelindex = ent->client->oldplayer->s.modelindex;

   if (!strcmp(opt, "background"))
   {
      ent->client->chasetoggle = 3;
      ent->client->chasecam->nextthink = level.time + 0.100;
      ent->client->chasecam->think = ChasecamRestart;
   }

   else if (!strcmp(opt, "off"))
   {
      ent->client->chasetoggle = 0;
      G_FreeEdict (ent->client->chasecam);
   }

}

void ChasecamTrack (edict_t *ent)
{
        
   trace_t      tr;
   vec3_t       spot1, spot2, dir;
   vec3_t       forward, right, up;
   int          dist;
   int          cap;
        
   ent->nextthink = level.time + 0.100;

   if (ent->owner->waterlevel)
   {
      ChasecamRemove (ent->owner, "background");
      return;
   }

   AngleVectors (ent->owner->client->v_angle, forward, right, up);
        
   VectorMA (ent->owner->s.origin, -ent->chasedist1, forward, spot2);
        
   spot2[2] += 20.000;

   if (ent->owner->client->v_angle[0] < 0.000)
      VectorMA (spot2, (ent->owner->client->v_angle[0] * 0.2), up, spot2);

   else if (ent->owner->client->v_angle[0] > 0.000)
      VectorMA (spot2, (ent->owner->client->v_angle[0] * 0.2), up, spot2);

   tr = gi.trace (ent->owner->s.origin, NULL, NULL, spot2, ent->owner, MASK_SHOT);
        
   VectorSubtract (tr.endpos, ent->owner->s.origin, spot1);

   ent->chasedist1 = VectorLength (spot1);
        
   VectorMA (tr.endpos, 2, forward, spot2);

   VectorCopy (spot2, spot1);
   spot1[2] += 32;

   tr = gi.trace (spot2, NULL, NULL, spot1, ent->owner, MASK_SHOT);

   if (tr.fraction < 1.000)
   {
        VectorCopy (tr.endpos, spot2);
        spot2[2] -= 32;
   }

   VectorSubtract (spot2, ent->s.origin, dir);
   VectorNormalize (dir);
        
   VectorSubtract (spot2, ent->s.origin, spot1);
   dist = VectorLength (spot1);
        
   tr = gi.trace (ent->s.origin, NULL, NULL, spot2, ent->owner, MASK_SHOT);
        
   if (tr.fraction == 1.000)
   {

           /* Make the angles of the chasecam, the same as the player, so
            * we are always behind the player. (angles) */

           VectorCopy (ent->owner->s.angles, ent->s.angles);
        
           /* calculate the percentages of the distances, and make sure we're
            * not going too far, or too short, in relation to our panning
            * speed of the chasecam entity */

      cap = (dist * 0.400);

           /* if we're going too fast, make us top speed */

      if (cap > 5.200)
      {
           ent->velocity[0] = ((dir[0] * dist) * 5.2);
           ent->velocity[1] = ((dir[1] * dist) * 5.2);
           ent->velocity[2] = ((dir[2] * dist) * 5.2);
      }
      else
      {

              /* if we're NOT going top speed, but we're going faster than
               * 1, relative to the total, make us as fast as we're going */

         if ( (cap > 1.000) )
         {
            ent->velocity[0] = ((dir[0] * dist) * cap);
            ent->velocity[1] = ((dir[1] * dist) * cap);
            ent->velocity[2] = ((dir[2] * dist) * cap);

         }
         else
         {

              /* if we're not going faster than one, don't accelerate our
               * speed at all, make us go slow to our destination */

            ent->velocity[0] = (dir[0] * dist);
            ent->velocity[1] = (dir[1] * dist);
            ent->velocity[2] = (dir[2] * dist);

         }

      }
                
           /* subtract endpos;player position, from chasecam position to get
            * a length to determine whether we should accelerate faster from
            * the player or not */

      VectorSubtract (ent->owner->s.origin, ent->s.origin, spot1);

      if (VectorLength(spot1) < 20)
      {
         ent->velocity[0] *= 2; 
         ent->velocity[1] *= 2; 
         ent->velocity[2] *= 2; 

      }
        
   }

        /* if we DID hit something in the tr.fraction call ages back, then
         * make the spot2 we created, the position for the chasecamera. */

   else
      VectorCopy (spot2, ent->s.origin);

        /* If the distance is less than 90, then we haven't reached the
         * furthest point. If we HAVEN'T reached the furthest point, keep
         * going backwards. This was a fix for the "shaking". The camera was
         * getting forced backwards, only to be brought back, next think */

   if (ent->chasedist1 < 90.00)
        ent->chasedist1 += 1;

        /* if we're too far away, give us a maximum distance */

   else if (ent->chasedist1 > 90)
        ent->chasedist1 = 90;

        /* if we haven't gone anywhere since the last think routine, and we
         * are greater than 20 points in the distance calculated, add one to
         * the second chasedistance variable

         * The "ent->movedir" is a vector which is not used in this entity, so
         * we can use this a tempory vector belonging to the chasecam, which
         * can be carried through think routines. */

   if (ent->movedir == ent->s.origin)
   {
      if (dist > 20)
         ent->chasedist2++;
   }

        /* if we've buggered up more than 3 times, there must be some mistake,
         * so restart the camera so we re-create a chasecam, destroy the old one,
         * slowly go outwards from the player, and keep thinking this routing in
         * the new camera entity */

   if (ent->chasedist2 > 3)
   {
      ChasecamStart (ent->owner);
      G_FreeEdict(ent);
      return;
   }

        /* Copy the position of the chasecam now, and stick it to the movedir
         * variable, for position checking when we rethink this function */

   VectorCopy (ent->s.origin, ent->movedir);

}
        
void Cmd_Chasecam_Toggle (edict_t *ent)
{
   if (ent->client->chasetoggle)
      ChasecamRemove (ent, "off");
   else
      ChasecamStart (ent);
}

void CheckChasecam_Viewent (edict_t *ent)
{
        if ((ent->client->chasetoggle == 1) && (ent->client->oldplayer))
        {
                ent->client->oldplayer->s.frame = ent->s.frame;

                VectorCopy (ent->s.origin, ent->client->oldplayer->s.origin);
                VectorCopy (ent->velocity, ent->client->oldplayer->velocity);
                VectorCopy (ent->s.angles, ent->client->oldplayer->s.angles);

                ent->client->oldplayer->s.modelindex = ent->s.modelindex;
                ent->client->oldplayer->s.modelindex2 = ent->s.modelindex2;
        
                gi.linkentity (ent->client->oldplayer);
        }

}

