
/*

This modification allows use of Quake I -style teleports in Quake II
created by Toni Wilen <twilen@sci.fi> (26.12.1997)

*/

#include "g_local.h"

void teleporter_touch2(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i,client;
	vec3_t		destdir,tempvec;

	// is a player? (There are probably better ways to do this..)
	if(other->classname&&!strcmp(other->classname,"player")) {
		client=1;
	} else {
		client=0;
		if(!other->velocity) return;
	}

	dest = G_Find (NULL, FOFS(targetname), self->target);
	if (!dest)
	{
		gi.dprintf ("Couldn't find destination\n");
		return;
	}
	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	other->s.origin[2] += 9;

	// clear the velocity and hold them in place briefly (clients only)
	if(client) {
		VectorClear (other->velocity);
		other->client->ps.pmove.teleport_time = 50;
	}

	// draw the teleport splash at the destination
	other->s.event = EV_PLAYER_TELEPORT;

	if(client) {
		// set players' angles
		for (i=0 ; i<3 ; i++)
			other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);
		other->s.angles[PITCH] = 0;
		other->s.angles[YAW] = self->s.angles[YAW];
		other->s.angles[ROLL] = 0;
		VectorCopy (self->s.angles, other->client->ps.viewangles);
		VectorCopy (self->s.angles, other->client->v_angle);
	} else {
		// change velocity of projectiles
		VectorCopy(dest->s.angles,tempvec); // use temp because
		G_SetMovedir(tempvec,destdir); // G_SetMovedir clears source vector
		VectorScale(destdir,VectorLength(other->velocity),other->velocity);
	}

	// only clients can telefrag
	if(client) {
		if (!KillBox (other))
		{
		}
	}

	gi.linkentity (other);

}

extern void InitTrigger(edict_t*);
extern void SP_func_wall(edict_t*);

// FUNC_WALL teleport

void SP_func_wall2 (edict_t *self)
{
// is teleport?
if(self->target) {
	// convert to trigger
	InitTrigger(self);
	self->touch = teleporter_touch2;
	gi.linkentity (self);
	return;
}
// put visible if not already visible
if((self->spawnflags&128)&&(self->spawnflags&1)) self->spawnflags&=~1;
// normal func_wall continues
SP_func_wall(self);
}

// TRIGGER_TELEPORT

void SP_trigger_teleport(edict_t *self)
{
if (!self->target) {
	gi.dprintf ("trigger_teleport without a target.\n");
	G_FreeEdict (self);
	return;
}
InitTrigger(self);
self->touch=teleporter_touch2;
gi.linkentity(self);
}

void SP_info_teleport_destination(edict_t *ent)
{
}


extern void teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);

// remove misc_teleporter and misc_teleporter_destination -entities and triggers

void remove_teleporter_pads(int *inhibit)
{
edict_t *from,*trig,*dest;

// remove teleporter pads only if new teleports are detected
for (from=g_edicts;from < &g_edicts[globals.num_edicts]; from++) {
	if(!from->inuse||from->solid==SOLID_NOT) continue;
	if(!strcmp(from->classname,"trigger_teleport")||(!strcmp(from->classname,"func_wall")&&from->target)) break;
}
if(from==&g_edicts[globals.num_edicts]) return;
// remove pads
for (from=g_edicts;from < &g_edicts[globals.num_edicts]; from++) {
	if(!from->inuse) continue;
	if(from->solid==SOLID_NOT) continue;
	// misc_teleporter or misc_teleporter_destination without spawnflags&1?
	if(!(from->spawnflags&1)&&!strcmp(from->classname,"misc_teleporter")) {
		dest=G_Find(NULL,FOFS(targetname),from->target);
		for(trig=g_edicts;trig<&g_edicts[globals.num_edicts];trig++) {
			if(trig->touch==teleporter_touch&&trig->target==from->target) {
				G_FreeEdict(trig); // remove teleporter trigger
				(*inhibit)++;
				break;
			}
		}
		G_FreeEdict(dest); // remove misc_teleporter_destination
		G_FreeEdict(from); // remove misc_teleporter
		(*inhibit)+=2;
	}
}
}

