#include <ctype.h>

#include "g_local.h"
#include "m_player.h"

void AutoWave(edict_t *ent)
{
	int x, wave = -1;
	int len = strlen(ent->client->pers.autowave);

	if (len == 0)
		return;

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	x = rand() % len;
	if (isdigit(ent->client->pers.autowave[x])) {
		wave = ent->client->pers.autowave[x] - '0';
		
		ent->client->anim_priority = ANIM_WAVE;

		switch (wave)
		{
		case 0:
			gi.cprintf (ent, PRINT_HIGH, "flipoff\n");
			ent->s.frame = FRAME_flip01-1;
			ent->client->anim_end = FRAME_flip12;
			break;
		case 1:
			gi.cprintf (ent, PRINT_HIGH, "salute\n");
			ent->s.frame = FRAME_salute01-1;
			ent->client->anim_end = FRAME_salute11;
			break;
		case 2:
			gi.cprintf (ent, PRINT_HIGH, "taunt\n");
			ent->s.frame = FRAME_taunt01-1;
			ent->client->anim_end = FRAME_taunt17;
			break;
		case 3:
			gi.cprintf (ent, PRINT_HIGH, "wave\n");
			ent->s.frame = FRAME_wave01-1;
			ent->client->anim_end = FRAME_wave11;
			break;
		case 4:
		default:
			gi.cprintf (ent, PRINT_HIGH, "point\n");
			ent->s.frame = FRAME_point01-1;
			ent->client->anim_end = FRAME_point12;
			break;
		}
	}
}
