#include "g_local.h"

//default defines
#define CONFIG_OBSERVER_DISTANCE 200
#define CONFIG_DEFAULT_MOTD "motd.txt"
#define CONFIG_EMPTY ""
#define CONFIG_MOTD_JUMP -1
#define CONFIG_WEAPON_ALLOWED 1
#define CONFIG_WEAPON_NOT_ALLOWED 0
#define CONFIG_YES 1
#define CONFIG_NO 0
#define CONFIG_NOCHANGE -1

/*
==============
ResetLACfg

Resets LA config
==============
*/
void ResetLACfg (void)
{
	strcpy(config_server.gravity, CONFIG_EMPTY );
	strcpy(config_server.nextmap, CONFIG_EMPTY );
	strcpy(config_server.motd_file, CONFIG_DEFAULT_MOTD );

	strcpy(config_server.adminPass, CONFIG_EMPTY);
	config_server.admin = CONFIG_NO;

	config_server.allowShotgun = CONFIG_WEAPON_ALLOWED;
	config_server.allowSuperShotgun = CONFIG_WEAPON_ALLOWED;
	config_server.allowUzi = CONFIG_WEAPON_ALLOWED;
	config_server.allowChainGun = CONFIG_WEAPON_ALLOWED;
	config_server.allowGrenadeLauncher = CONFIG_WEAPON_ALLOWED;
	config_server.allowRocketLauncher = CONFIG_WEAPON_ALLOWED;
	config_server.allowHyperBlaster = CONFIG_WEAPON_ALLOWED;
	config_server.allowRailGun = CONFIG_WEAPON_ALLOWED;
	config_server.allowBFG = CONFIG_WEAPON_ALLOWED;

	config_server.motdtime = CONFIG_MOTD_JUMP; //wait for jump to activate

	config_server.unlimitedAmmo = CONFIG_NOCHANGE;
	config_server.weaponStay = CONFIG_NOCHANGE;
	config_server.fraglimit = CONFIG_NOCHANGE;
	config_server.timelimit = CONFIG_NOCHANGE;

	config_server.dmturrets = CONFIG_YES;
	config_server.motd = CONFIG_YES;
	
	config_server.observersAllowed = CONFIG_YES;			//Allow observers by default
	config_server.observerStart = CONFIG_NO;				//Start clients normally by default

	config_server.observer_distance= CONFIG_OBSERVER_DISTANCE;

	config_server.teamcomp = CONFIG_NO;						//compitition on?
	config_server.teamhurt = CONFIG_YES;					//team damage?
	config_server.teamready = CONFIG_NO;					//when everyones 'ready'
	config_server.teamplaying = CONFIG_NO;					//when game starts
	config_server.teamcountdown = CONFIG_NO;
	config_server.voteexitallowed = CONFIG_YES;
}

/*
==============
ParseLACfg

Reads config.server and sets up level stuff.
==============
*/

void ParseLACfg (void)
{
	FILE *config;
	char line[100];
	cvar_t *config_file;
	char l_command[100];
	char l_var1[100];
	char l_var2[100];

	ResetLACfg();
	config_file = gi.cvar ("configfile", "config.server", CVAR_SERVERINFO);

	if (config = fopen(config_file->string, "r"))
	{
		// we successfully opened the file "config.server"
		while ( fgets(line, 80, config) )
		{
			// Read in each line for processing....
			if ((line[0] != ';') && (strlen(line) > 0))
			{
				l_command[0] = 0;
				l_var1[0] = 0;
				l_var2[0] = 0;
				sscanf (line, "%s %s %s", l_command, l_var1, l_var2);
				if (!stricmp("LevelSelect:", l_command ))
				{
					if (strlen(l_var2) > 0)
					{
						if (!stricmp(l_var1, level.mapname))
						{
							strcpy (config_server.nextmap, l_var2);
							gi.dprintf ("NextMap set to %s\n", config_server.nextmap);
						}
					}
					else if ((strlen(l_var1) > 0) && (strlen(config_server.nextmap) == 0))
					{
						strcpy (config_server.nextmap, l_var1);
						gi.dprintf ("NextMap set to %s\n", config_server.nextmap);
					}
				}
				else if (!stricmp(l_command, "FragLimit:"))
				{
					if ((!stricmp(l_var1, level.mapname)) && (strlen(l_var2) > 0))
					{
						config_server.fraglimit = atoi(l_var2);
						gi.dprintf ("Fraglimit set to %i\n", config_server.fraglimit);
					}
				}
				else if (!stricmp(l_command, "TimeLimit:"))
				{
					if ((!stricmp(l_var1, level.mapname)) && (strlen(l_var2) > 0))
					{
						config_server.timelimit = atoi(l_var2);
						gi.dprintf ("Timelimit changed to %i\n", config_server.timelimit);
					}
				}

				else if (!stricmp(l_command, "LevelGrav:"))
				{
					if (strlen(l_var2) > 0)
					{
						if (!stricmp(l_var1, level.mapname))
						{
							strcpy (config_server.gravity, l_var2);
							gi.dprintf ("Level gravity set to %i\n", config_server.gravity);
						}
					}
					else if ((strlen(l_var1) > 0) && (strlen(config_server.gravity) == 0))
					{
						strcpy (config_server.gravity, l_var1);
						gi.dprintf ("Level gravity set to %i\n", config_server.gravity);
					}
				}
				else if (!stricmp(l_command, "WeaponStay:"))
				{
					if ((!stricmp(l_var1, level.mapname)) && (strlen(l_var2) > 0))
					{
							if (!stricmp ("YES", l_var2))
								config_server.weaponStay = CONFIG_YES;
							else if (!stricmp ("NO", l_var2))
								config_server.weaponStay = CONFIG_NO;

							gi.dprintf ("Weapon Stay changed to %s\n", l_var1);
					}
					
				}
				else if (!stricmp(l_command, "UnlimitedAmmo:"))
				{
					if ((!stricmp(l_var1, level.mapname)) && (strlen(l_var2) > 0))
					{
						if (!stricmp ("YES", l_var2))
							config_server.unlimitedAmmo = CONFIG_YES;
						else if (!stricmp ("NO", l_var2))
							config_server.unlimitedAmmo = CONFIG_NO;

						gi.dprintf ("Unlimited Ammo changed to %s\n", l_var1);
					}
					
				}
				else if (!stricmp(l_command, "AllowObservers:"))
				{
					if ((strlen(l_var1) > 0))
					{
						if (!stricmp (l_var1, "NO"))
							config_server.observersAllowed = CONFIG_NO;
						else if (!stricmp ("YES", l_var1))
							config_server.observersAllowed = CONFIG_YES;
						gi.dprintf ("Allow Observers set to %s\n", l_var1);
					}
					
				}
				else if (!stricmp(l_command, "StartObserver:"))
				{
					if ((strlen(l_var1) > 0))
					{
						if (!stricmp (l_var1, "YES"))
							config_server.observerStart = CONFIG_YES;
						else
							config_server.observerStart = CONFIG_NO;
						gi.dprintf ("Observer Start set to %s\n", l_var1);
					}
					
				}
				else if (!stricmp(l_command, "DMTurrets:"))
				{
					if ((strlen(l_var1) > 0))
					{
						if (!stricmp (l_var1, "NO"))
							config_server.dmturrets = CONFIG_NO;
						else if (!stricmp ("YES", l_var1))
							config_server.dmturrets = CONFIG_YES;
						gi.dprintf ("Deathmatch Turrets set to %s\n", l_var1);
					}
					
				}
				else if (!stricmp(l_command, "MotdTime:"))
				{
					if (strlen(l_var2) > 0)
					{
						if (!stricmp(l_var1, level.mapname))
						{
							if (!stricmp (l_var2, "jump"))
								config_server.motdtime = CONFIG_MOTD_JUMP;
							else
								config_server.motdtime = atoi(l_var2);
							gi.dprintf ("motd time set to %i, -1 = jump\n", config_server.motdtime);
						}
					}
					else if (strlen(l_var1) > 0)
					{
						if (!stricmp (l_var1, "jump"))
							config_server.motdtime = CONFIG_MOTD_JUMP;
						else
							config_server.motdtime = atoi(l_var1);
						gi.dprintf ("motd time set to %i, -1 = jump\n", config_server.motdtime);
					}
				}
				else if (!stricmp(l_command, "MOTD:"))
				{
					if ((strlen(l_var1) > 0))
					{
						if (!stricmp (l_var1, "NO"))
							config_server.motd = CONFIG_NO;
						else if (!stricmp ("YES", l_var1))
							config_server.motd = CONFIG_YES;
						gi.dprintf ("motd set to %i\n", config_server.motd);
					}
					
				}
				else if (!stricmp(l_command, "MotdFile:"))
				{
					if (strlen(l_var2) > 0)
					{
						if (!stricmp(l_var1, level.mapname))
						{
							gi.dprintf ("motd file changed to: %s\n", l_var2);
							strcpy (config_server.motd_file, l_var2);
						}
					}
					else if (strlen(l_var1) > 0)
					{
						gi.dprintf ("motd file changed to %s\n", l_var1);
						strcpy (config_server.motd_file, l_var1);
					}

				}
				else if ((!stricmp(l_command, "TeamCompitition:")) && (strlen(l_var1) > 0))
				{
					if (!stricmp (l_var1, "YES"))
						config_server.teamcomp = CONFIG_YES;
					else  if (!stricmp ("NO", l_var1))
						config_server.teamcomp = CONFIG_NO;
					gi.dprintf ("teamcomp set to %i\n", config_server.teamcomp);
				}
				else if ((!stricmp(l_command, "TeamDamage:")) && (strlen(l_var1) > 0))
				{
					if (!stricmp (l_var1, "NO"))
						config_server.teamhurt = CONFIG_NO;
					else if (!stricmp (l_var1, "YES"))
						config_server.teamhurt = CONFIG_YES;
					gi.dprintf ("teamhurt set to %i\n", config_server.teamhurt);
				}
				else if (l_command[0])
				{
					gi.dprintf ("Unknown Line:\"%s %s %s\"\n", l_command,l_var1,l_var2);
				}
			}
		}

		// close the file
    	fclose(config);
	}
	else
	{
		return;
	}

}
