#include "g_local.h"
#include "g_observer.h"
#include "g_teamplay.h"
/*
used in g_cmds.c, causes playet to go into observer mode.  Use with caution.  
Will erase positive frags and all that fun stuff.  
*/

void GoObserver (edict_t *ent)
{
	if (config_server.teamcomp)
		setTeam(ent, "");

	ent->observer.observertarget = NULL;

	ent->observer.observer = 1;

	//make modelnothing
	ent->model = "";
	gi.setmodel (ent, ent->model);

	//make noclipping
	ent->movetype = MOVETYPE_NOCLIP;

	//make non-solid
	ent->solid = SOLID_NOT;

	//set size to nothing...
	/*ent->mins[0] = 0;
	ent->mins[1] = 0;
	ent->mins[2] = 0;
	ent->maxs[0] = 0;
	ent->maxs[1] = 0;
	ent->maxs[2] = 0;*/

	//reset score to 0 if positive....
	if (ent->client->resp.score > 0) 
		ent->client->resp.score = 0;

	//remove weapons
	ent->client->pers.weapon = NULL;
	ChangeWeapon(ent);
}

/*
used in g_cmds.c, causes player to come out of observer mode.
This will also make them respawn.
*/
void GoPlayer (edict_t *ent)
{
	ent->observer.observertarget = NULL;
	ent->observer.observer = 0;
	ent->movetype = MOVETYPE_WALK;
	respawn(ent);
}

void ObserverSwitchMode (edict_t *ent)
{
	if (ent->observer.observermode < 2)
	{
		ent->observer.observermode ++;
		if (ent->observer.observermode == 1)
			ObserverSwitchTarget (ent);
	}
	else
	{
		ent->observer.observermode = 0;
		ent->observer.observertarget = NULL;
	}

	gi.cprintf(ent, PRINT_HIGH, "Observer Mode %i\n", ent->observer.observermode);

}

//observer mode 1 keeps the observer close to the target
void ObserverMode_1(edict_t *ent)
{
	float t_x,t_y,t_z;

	if (!ent->observer.observertarget)
	{
		ent->observer.observermode = 0;
		return;
	}

	//retrieve distance to hold them by looking at config.
	if (ent->s.origin[0] > (ent->observer.observertarget->s.origin[0] + config_server.observer_distance))
		ent->s.origin[0] = ent->observer.observertarget->s.origin[0] + config_server.observer_distance;
	if (ent->s.origin[0] < (ent->observer.observertarget->s.origin[0] - config_server.observer_distance))
		ent->s.origin[0] = ent->observer.observertarget->s.origin[0] - config_server.observer_distance;
	if (ent->s.origin[1] > (ent->observer.observertarget->s.origin[1] + config_server.observer_distance))
		ent->s.origin[1] = ent->observer.observertarget->s.origin[1] + config_server.observer_distance;
	if (ent->s.origin[1] < (ent->observer.observertarget->s.origin[1] - config_server.observer_distance))
		ent->s.origin[1] = ent->observer.observertarget->s.origin[1] - config_server.observer_distance;
	if (ent->s.origin[2] > (ent->observer.observertarget->s.origin[2] + config_server.observer_distance))
		ent->s.origin[2] = ent->observer.observertarget->s.origin[2] + config_server.observer_distance;
	if (ent->s.origin[2] < (ent->observer.observertarget->s.origin[2] - config_server.observer_distance))
		ent->s.origin[2] = ent->observer.observertarget->s.origin[2] - config_server.observer_distance;

	while (!visible(ent->observer.observertarget, ent))
	{
		//gi.cprintf(ent, PRINT_HIGH, "Not Visible\n");
		if (ent->s.origin[0] > ent->observer.observertarget->s.origin[0])
			ent->s.origin[0] = ent->s.origin[0] - 0.5;

		if (ent->s.origin[0] < ent->observer.observertarget->s.origin[0])
			ent->s.origin[0] = ent->s.origin[0] + 0.5;

		if (ent->s.origin[1] > ent->observer.observertarget->s.origin[1])
			ent->s.origin[1] = ent->s.origin[1] - 0.5;

		if (ent->s.origin[1] < ent->observer.observertarget->s.origin[1])
			ent->s.origin[1] = ent->s.origin[1] + 0.5;

		if (ent->s.origin[2] > ent->observer.observertarget->s.origin[2])
			ent->s.origin[2] = ent->s.origin[2] - 0.5;

		if (ent->s.origin[2] < ent->observer.observertarget->s.origin[2])
			ent->s.origin[2] = ent->s.origin[2] + 0.5;

		t_x = ent->s.origin[0] - ent->observer.observertarget->s.origin[0];
		t_y = ent->s.origin[1] - ent->observer.observertarget->s.origin[1];
		t_z = ent->s.origin[2] - ent->observer.observertarget->s.origin[2]; 

		if (((t_x + t_y + t_z) < 3) && ((t_x + t_y + t_z) > -3))
			break;
	}
}


//moves the client along with the target.  we need the old position of the target
void ObserverMode_2(edict_t *ent)
{
	

	float t_xdiff,t_ydiff,t_zdiff;

	if (!ent->observer.observertarget)
	{
		ent->observer.observermode = 0;
		return;
	}

	t_xdiff = ent->observer.old_observer_origin[0]-ent->observer.observertarget->s.origin[0];
	t_ydiff = ent->observer.old_observer_origin[1]-ent->observer.observertarget->s.origin[1];
	t_zdiff = ent->observer.old_observer_origin[2]-ent->observer.observertarget->s.origin[2];
	
	ent->s.origin[0]-=t_xdiff;
	ent->s.origin[1]-=t_ydiff;
	ent->s.origin[2]-=t_zdiff;

}



void ObserverMode_3(edict_t *ent)
{
	if (!ent->observer.observertarget)
	{
		ent->observer.observermode = 0;
		return;
	}

	ent->s.origin[0] = ent->observer.observertarget->s.origin[0];
	ent->s.origin[1] = ent->observer.observertarget->s.origin[1];
	ent->s.origin[2] = ent->observer.observertarget->s.origin[2];
	ent->s.angles[0] = ent->observer.observertarget->s.angles[0];
	ent->s.angles[0] = ent->observer.observertarget->s.angles[1];
	ent->s.angles[0] = ent->observer.observertarget->s.angles[2];

	VectorCopy(ent->client->ps.viewangles, ent->observer.observertarget->client->ps.viewangles);
	
	gi.linkentity(ent);
}



void ObserverThink (edict_t *ent)
{
	if (!ent->observer.observertarget)
	{
		ent->observer.observermode = 0;
		return;
	}

	switch (ent->observer.observermode)
	{
		case 0: return; break;
		case 3: ObserverMode_3(ent); 
				break;
		case 2: ObserverMode_2(ent); 
		case 1: ObserverMode_1(ent); 
		default : break;
	}
	//update old_origin
	ent->observer.old_observer_origin[0] = ent->observer.observertarget->s.origin[0];
	ent->observer.old_observer_origin[1] = ent->observer.observertarget->s.origin[1];
	ent->observer.old_observer_origin[2] = ent->observer.observertarget->s.origin[2];
}


void ObserverSwitchTarget (edict_t *ent)
{
	edict_t *spot;

	spot = G_Find (ent->observer.observertarget, FOFS(classname), "player");

	while (spot != ent->observer.observertarget)
	{
		if ((spot) && (spot != ent) && (!spot->observer.observer))
		{
			gi.centerprintf(ent, "Now Targeting %s.\n", spot->client->pers.netname);
			break;
		}
		spot = G_Find (spot, FOFS(classname), "player");
	}

	if ((ent->observer.observertarget == spot) && (!spot))
	{
		ent->observer.observermode = 0;
		gi.cprintf(ent, PRINT_HIGH, "No Available Targets.\n");
	}
	else
	{
		ent->observer.observertarget = spot;
		//update old_origin
		ent->observer.old_observer_origin[0] += ent->observer.observertarget->s.origin[0];
		ent->observer.old_observer_origin[1] += ent->observer.observertarget->s.origin[1];
		ent->observer.old_observer_origin[2] += ent->observer.observertarget->s.origin[2];
	}


}
