//			
// g_teamplay.c -- Teamplay Comitition Modifications
// by Brian Nelson and Michael Judge
//

#include "g_local.h"
#include "g_teamplay.h"
#include "g_observer.h"

void RegisterTeam (edict_t *ent, const char *teamname)
{
	edict_t *targ=NULL;

	if (config_server.teamplaying)
		return;

	strcpy(ent->teamstruct.teamname, teamname);
	gi.bprintf(PRINT_HIGH, "%s creates Team: %s\n", ent->client->pers.netname, ent->teamstruct.teamname);
	ent->teamstruct.teammaster = ent;

	setTeam(ent, ent->teamstruct.teamname);

}

void RegisterPlayer (edict_t *ent, const char *teamname)
{
	edict_t *targ=NULL;

 
	if (strlen(teamname) < 2)
	{
		gi.cprintf(ent, PRINT_HIGH, "Team names should be at least 2 characters long.\n");
		return;
	}
	else if (strlen(teamname) > 10)
	{
		gi.cprintf(ent, PRINT_HIGH, "Team names should be no more then 10 characters long.\n");
		return;
	}

    while(targ = G_Find (targ, FOFS(classname), "player"))
	{
        if (stricmp(targ->teamstruct.teamname, teamname) == 0)
		{
			strcpy(ent->teamstruct.teamname, targ->teamstruct.teamname);
			gi.bprintf(PRINT_HIGH, "%s joins Team: %s\n", ent->client->pers.netname, ent->teamstruct.teamname);
			ent->teamstruct.teammaster = targ->teamstruct.teammaster;
			CheckTeamplaySkins(ent, ent->client->pers.userinfo);
			setTeam(ent, ent->teamstruct.teamname);
			return;
		}
    }

	RegisterTeam (ent, teamname);
}


/*
UnRegisters players from a team
*/
void UnRegisterPlayer (edict_t *ent)
{
    edict_t *targ,*targ1,*t_master;

	gi.bprintf(PRINT_HIGH, "%s leaves Team: %s\n", ent->client->pers.netname, ent->teamstruct.teamname);

	targ = NULL;
	targ1 = NULL;
	t_master = NULL;
	
	if (ent->teamstruct.teammaster == ent)
	{
		while (targ = G_Find (targ, FOFS(classname), "player"))
		{
			if ((stricmp(targ->teamstruct.teamname, ent->teamstruct.teamname) == 0) && ent != targ)
			{
				t_master = targ;
				t_master->teamstruct.teammaster = t_master;
				t_master->teamstruct.teamscore = ent->teamstruct.teamscore;
				gi.bprintf(PRINT_HIGH, "%s becomes %s's Team Master!\n", t_master->client->pers.netname, t_master->teamstruct.teamname);
				break;
			}
		}

		
		if (t_master)
		{
			ent->teamstruct.teamname[0] = 0;
			ent->teamstruct.teammaster = NULL;
			targ1 = NULL;
			while (targ1 = G_Find (targ1, FOFS(classname), "player"))
			{	
				if ((stricmp(targ1->teamstruct.teamname, t_master->teamstruct.teamname) == 0))
				{
					targ1->teamstruct.teammaster = t_master;
					gi.bprintf(PRINT_HIGH, "Changing %s's Master to %s\n",targ1->client->pers.netname, t_master->client->pers.netname);
				}
			}
		} 
		else
		{
			gi.bprintf(PRINT_HIGH, "Team %s has been disolved.\n", ent->teamstruct.teamname);
			if (config_server.teamplaying)
				CloseTeamsOut();
		}
	}

	ent->teamstruct.teamname[0] = 0;
	ent->teamstruct.teammaster = NULL;
}

void CheckTeamplaySkins (edict_t *ent, char *userinfo)
{
	char	*s;
	int		playernum;
	edict_t	*t_master;
//	char	stuff_skin[200];

	if (config_server.teamcomp)
	{
		t_master = ent->teamstruct.teammaster;
	}

	// set skin
	s = Info_ValueForKey (t_master->client->pers.userinfo, "skin");

	// decide sound directory
	if (s[0] == 'f' || s[0] == 'F')
		strcpy (ent->client->pers.sounddir, "player/female");
	else
		strcpy (ent->client->pers.sounddir, "player/male");

	playernum = ent-g_edicts-1;

	// combine name and skin into a configstring
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s", ent->client->pers.netname, s) );

	gi.cprintf(ent, PRINT_HIGH, "syncing skin....\n");

	Info_SetValueForKey (ent->client->pers.userinfo, "skin", s);

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, sizeof(ent->client->pers.userinfo)-1);

	setSkin (ent, s);

}

void CheckTeamplayTeams (edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH, "Syncing teams...\n");
	setTeam(ent, ent->teamstruct.teammaster->teamstruct.teamname);
}

void setSkin (edict_t *ent, char *skin)
{
	char skinstuff[900];

	skinstuff[0] = 0;
	strcpy(skinstuff, "skin \"");
	strcat(skinstuff, skin);
	strcat(skinstuff, "\" u;wait;wait;");
	strcat(skinstuff, "skin \"");
	strcat(skinstuff, skin);
	strcat(skinstuff, "\" u");
//	gi.cprintf(ent, PRINT_HIGH, "Sending '%s'\n", skinstuff);
	strcat(skinstuff, "\n");
	stuffcmd(ent, skinstuff);
	Info_SetValueForKey (ent->client->pers.userinfo, "skin", skin);
}

void setTeam (edict_t *ent, char *teamname)
{
	char teamstuff[300];

	teamstuff[0] = 0;
	strcpy(teamstuff, "set team \"");
	strcat(teamstuff, teamname);
	strcat(teamstuff, "\" u;wait;wait;");
	strcat(teamstuff, "set team \"");
	strcat(teamstuff, teamname);
	strcat(teamstuff, "\" u");
//	gi.cprintf(ent, PRINT_HIGH, "Sending '%s'\n", teamstuff);
	strcat(teamstuff, "\n");
	stuffcmd(ent, teamstuff);
	Info_SetValueForKey (ent->client->pers.userinfo, "team", teamname);
}

void ShowTeamScores (edict_t *ent)
{
	edict_t		*targ;	
	targ=NULL;

	while(targ = G_Find (targ, FOFS(classname), "player"))
	{
		if (targ->observer.observer)
			gi.cprintf(ent, PRINT_HIGH, "Observer: %s\n", targ->client->pers.netname);
		else if (config_server.teamcomp)
			gi.cprintf(ent, PRINT_HIGH, "Player:   %s, Frags: %i  Team: %s\n", targ->client->pers.netname, targ->client->resp.score, targ->teamstruct.teamname);
		else
			gi.cprintf(ent, PRINT_HIGH, "Player:   %s, Frags: %i\n", targ->client->pers.netname, targ->client->resp.score);
	}

}


BOOL CheckReady(edict_t *ent)
{
	int t_ready, teams;
	char t_name[80];
	edict_t *targ=NULL;

	t_name[0] = 0;
	teams = 0;
	t_ready = 0;
	if (strcmp(ent->teamstruct.teamname, ""))
	{
		if (ent->teamstruct.teamready==1)
		{
			gi.cprintf(ent, PRINT_HIGH, "Already Ready.  Type 'notready' to unready yourself.\n");
			return 0;
		}
		t_ready = 0;
		targ = NULL;
		ent->teamstruct.teamready=1; //check to see if everyone is ready.
		gi.cprintf(ent, PRINT_HIGH, "%s ready's up!\nNow:\n",ent->client->pers.netname);
		while(targ = G_Find (targ, FOFS(classname), "player"))
		{
			if (strcmp(targ->teamstruct.teamname, ""))
			{
				if ((strcmp(targ->teamstruct.teamname, t_name)) && (strcmp(targ->teamstruct.teamname, "")))
					teams++;
				if ((targ->teamstruct.teamready))
				{
					gi.bprintf(PRINT_HIGH, "%s is ready!\n", targ->client->pers.netname);
				}
				else
				{
					gi.bprintf(PRINT_HIGH, "Waiting on: %s. Use 'ready' to ready up!\n",targ->client->pers.netname);
					t_ready = 1;
				}
			}
		}
		if (teams < 2)
		{
			gi.bprintf(PRINT_HIGH, "Waiting for another team\n");
			ent->teamstruct.teamready = 0;
			t_ready = 1;			
		}
	}
	else
	{
		 gi.cprintf(ent, PRINT_HIGH, "Not in a team.\n Use 'cmd PLAYER <TEAMNAME>'\n");
		 return FALSE;
	}
	if (t_ready == 1)
		return FALSE;
	else
		return TRUE;
}

void CloseTeamsOut (void)
{
	int			topscore, tie, tiescore;
	edict_t		*targ;
	char		winningteam[20], tieteam[20];

	targ = NULL;
	winningteam[0] = 0;
	tieteam[0] = 0;
	topscore = 0;
	tiescore = 0;
	tie = 0;
	

	while(targ = G_Find (targ, FOFS(classname), "player"))
	{
		ShowTeamScores(targ);
		if (targ->teamstruct.teammaster == targ)
		{
			if (targ->teamstruct.teamscore > topscore)
			{
				topscore = targ->teamstruct.teamscore;
				strcpy(winningteam, targ->teamstruct.teamname);
				tie = 0;
			}
			else if (targ->teamstruct.teamscore == topscore)
			{
				tiescore = targ->teamstruct.teamscore;
				strcpy(tieteam, targ->teamstruct.teamname);
				tie = 1;
			}
		}
    }
	if (tie)
	{
		gi.bprintf(PRINT_HIGH, "   ***TIE GAME***\n%s tied with %s with %i frags!\n",winningteam,tieteam,tiescore);
	}
	else
	{
		gi.bprintf(PRINT_HIGH, "%s wins with %i frags.\n", winningteam, topscore);
	}

	targ = NULL;

	while(targ = G_Find (targ, FOFS(classname), "player"))
		targ->teamstruct.teamready = 0;

	respawnPlayers(0);

	config_server.teamplaying = 0;
	config_server.teamready = 0;
	config_server.teamcountdown = 0;
}


typedef struct timestruct_s
{
	int	time;
	int duration; //cannot be 1
	int begin;
	int end;
} timestruct_t;

#define NUM_TIMEPERIODS 4

timestruct_t g_times[NUM_TIMEPERIODS];
int g_timeinit;

#define COUNTDOWN 0
#define MINUTESLEFT 1
#define THIRTYSECONDWARNING 2
#define SECONDSLEFT 3
#define DEFAULT_TIMELIMIT 20

void InitTimes(timestruct_t p_times[NUM_TIMEPERIODS])
{
	if (!timelimit->value)
		timelimit->value = DEFAULT_TIMELIMIT;
	p_times[COUNTDOWN].time=0;
	p_times[COUNTDOWN].duration=1;
	p_times[COUNTDOWN].begin=15;
	p_times[COUNTDOWN].end=0;

	p_times[MINUTESLEFT].time=0;
	p_times[MINUTESLEFT].duration=60;
	p_times[MINUTESLEFT].begin=(timelimit->value -1) * 60;
	p_times[MINUTESLEFT].end=60;

	p_times[THIRTYSECONDWARNING].time=30;
	p_times[THIRTYSECONDWARNING].duration=1;
	p_times[THIRTYSECONDWARNING].begin=30;
	p_times[THIRTYSECONDWARNING].end=30;

	p_times[SECONDSLEFT].time=15;
	p_times[SECONDSLEFT].duration=1;
	p_times[SECONDSLEFT].begin=15;
	p_times[SECONDSLEFT].end=0;
}


void OutputTimeString(int seconds)
{
	int t_minutes;
	int t_seconds;
	char scharminutes=' ';
	char scharseconds=' ';

	t_minutes= (int)(seconds /60);
	t_seconds= seconds- (t_minutes*60);
	if (t_minutes>1)
		scharminutes='s';
	if (t_seconds>1)
		scharseconds='s';
	if (t_minutes)
		gi.bprintf(PRINT_HIGH, "%i minute%c  ",t_minutes,scharminutes);
	if (t_seconds)
		gi.bprintf(PRINT_HIGH, "%i second%c ",t_seconds,scharseconds);
	if (t_minutes || t_seconds)
		gi.bprintf(PRINT_HIGH, "left.\n");


}




void CheckTeamplayRules()
{
	int diff;
	int index=config_server.teamplaying;

	if (!(config_server.teamready))
	{
		g_timeinit=FALSE;
		return;
	}

	if (level.time != (int)level.time)
		return;

	if (config_server.teamplaying >	NUM_TIMEPERIODS)  //we have a -1 to index the array
		return;

	if (!g_timeinit)
	{
		InitTimes(g_times);
		g_timeinit=TRUE;
		index=0;
	}
	if (g_times[index].time)
	{
		g_times[index].time--;
		return;
	}
		
	diff= (int) level.time -config_server.teamready;
	if (index>0)
		diff -= g_times[index].time;
	if ( ! (diff % g_times[index].duration)) 
	{
		OutputTimeString(g_times[index].begin);
		if (g_times[index].begin<=g_times[index].end)
		{
			//change time to be time passed
			config_server.teamplaying++;
			//specioal shit
			if (config_server.teamplaying== 1)
			{
				respawnPlayers(1);
				gi.bprintf(PRINT_HIGH, "Good luck!  Begin! \n");
				OutputTimeString(g_times[index+1].begin+60);//add a minute to give acurate representation of time limit.
			}
			if (config_server.teamplaying >=	NUM_TIMEPERIODS)  //we have a -1 to index the array
				CloseTeamsOut();

			g_times[index].time = diff +1;  //+1 for next second to give you a 0 diff
		}
		g_times[index].begin-=g_times[index].duration;
	}
}


void respawnPlayers(int e)
{
	edict_t *targ=NULL;
	while(targ = G_Find (targ, FOFS(classname), "player"))
	{
		if (strcmp("", targ->teamstruct.teamname))
		{
			PutClientInServer(targ);
			if (e)
			{
				targ->teamstruct.teamscore = 0;
				targ->client->resp.score = 0;
			}
		}
	}
}


void ServerReady(BOOL p_ready)
{
	edict_t *targ=NULL;

	if (!p_ready)
	{
		//disable shit
		//cant touch anything
		//cant hurt anything
		config_server.teamready=FALSE;
		if ((config_server.teamcountdown) && (config_server.teamplaying < 1)) 
		{
			gi.bprintf(PRINT_HIGH, "Stopping Match!\n");
		}
	}
	else
	{
		//hurt,touch kill kill kill
		gi.bprintf(PRINT_HIGH, "starting!\n");
		config_server.teamready = level.time;
		config_server.teamcountdown = 0;
	}
}
