/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include<errno.h>
#include"buffer.h"
#include"misc.h"
#include"buffile.h"
#include"pak.h"

#define PAK_MAGIC	"PACK"

static buffer *loadfile(char *pakpath,FILE *pakfile,char *path)
{
	char magic[] = PAK_MAGIC;
	char filename[0x38];
	unsigned long diroffset,dirsize;
	unsigned long offset,size;
	buffer *buf;

	buf = buf_fread(pakpath,pakfile,0,strlen(PAK_MAGIC));
	if(buf == NULL) return NULL;

	getmem(buf,magic,strlen(PAK_MAGIC));

	freebuffer(buf);

	if(memcmp(magic,PAK_MAGIC,strlen(PAK_MAGIC)))
	{
		fprintf(stderr,"%s: bad magic\n",pakpath);
		return NULL;
	}

	buf = buf_fread(pakpath,pakfile,strlen(PAK_MAGIC),8);
	if(buf == NULL) return NULL;

	diroffset = getLEu32(buf);
	dirsize = getLEu32(buf);

	freebuffer(buf);

	buf = buf_fread(pakpath,pakfile,diroffset,dirsize);
	if(buf == NULL) return NULL;

	while(bufgetgpos(buf) < getsize(buf))
	{
		getmem(buf,filename,sizeof(filename));
		offset = getLEu32(buf);
		size = getLEu32(buf);

		if(!strncmp(path,filename,sizeof(filename)))
		{
			freebuffer(buf);
			return buf_fread(pakpath,pakfile,offset,size);
		}
	}

	freebuffer(buf);
	return NULL;
}

buffer *pak_loadfile(char *pakpath,char *path)
{
	FILE *pakfile;
	buffer *buf;

	pakfile = fopen(pakpath,"rb");
	if(!pakfile) return NULL;

	buf = loadfile(pakpath,pakfile,path);

	fclose(pakfile);

	return buf;
}

