/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#ifdef HAVE_LIMITS_H
#include<limits.h>
#endif

#include"bot.h"
#include"misc.h"
#include"defaults.h"

static void usage(void);
static void version(void);

static void usage(void)
{
	fprintf(stderr,
		"usage: " PACKAGE " [--game|-g path] [--name|-n name]"
				" [--rate|-r rate] [host][:port]\n"
		"       " PACKAGE " [--help|-h] [--version|-v]\n");
}

static void version(void)
{
	fprintf(stderr, "GoodBot" " version " VERSION "\n"
		"Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>\n");
}

int main(int argc,char *argv[])
{
	char *path = xstrdup(DEFAULT_GAME);
	char *name = xstrdup(DEFAULT_NAME);
	char *host = xstrdup(DEFAULT_HOST);
	unsigned short port = DEFAULT_PORT;
	unsigned long  rate = DEFAULT_RATE;
	unsigned long ul;
	char *tmp = NULL;
	int info = 0;
	int c;

	for(c=1;c<argc;c++)
	{
		if((!strcmp(argv[c],"--version")) || (!strcmp(argv[c],"-v")))
		{
			version();
			info++;
		}
		else if((!strcmp(argv[c],"--help")) || (!strcmp(argv[c],"-h")))
		{
			usage();
			info++;
		}
		else if((!strcmp(argv[c],"--game")) || (!strcmp(argv[c],"-g")))
		{
			if(!argv[c+1])
			{
				fprintf(stderr,"%s without path\n",argv[c]);
				return -1;
			}

			tmp = path;
			path = va_strcat(argv[++c],":",tmp,NULL);
			free(tmp);
			tmp = NULL;
		}
		else if((!strcmp(argv[c],"--name")) || (!strcmp(argv[c],"-n")))
		{
			if(!argv[c+1])
			{
				fprintf(stderr,"%s without name\n",argv[c]);
				return -1;
			}

			free(name);
			name = xstrdup(argv[++c]);
		}
		else if((!strcmp(argv[c],"--rate")) || (!strcmp(argv[c],"-r")))
		{
			if(!argv[c+1])
			{
				fprintf(stderr,
					"%s without value for rate\n",argv[c]);
				return -1;
			}

			rate = strtoul(argv[++c],NULL,0);
			if((rate == 0) || (rate == ULONG_MAX))
			{
				fprintf(stderr,"bad value for rate\n");
				return -1;
			}
		}
		else
		{
			free(host);
			host = xstrdup(argv[c]);
			port = DEFAULT_PORT;

			tmp = strrchr(host,':');

			if(tmp)
			{
				*tmp = '\0';
				tmp++;

				ul = strtoul(tmp,NULL,0);
				if((ul <= 0) || (ul >= 65536))
				{
					fprintf(stderr,"bad value for port\n");
					return -1;
				}

				port = (unsigned short)ul;

				tmp = host;
				host = xstrdup(tmp);

				free(tmp);
				tmp = NULL;
			}

			if(!strlen(host))
			{
				free(host);
				host = xstrdup(DEFAULT_HOST);
			}
		}
	}

	if(info) return 0;

	return bot(delim_to_array(path,':'),name,rate,host,port);
}

