/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include<errno.h>
#include"misc.h"
#include"buffer.h"
#include"buffile.h"
#include"pak.h"
#include"findfile.h"

static buffer *f_readfile(FILE *f,char *filepath)
{
	long size;

	if(fseek(f,0,SEEK_END))
	{
		fprintf(stderr,"%s: fseek: %s\n",filepath,strerror(errno));
		return NULL;
	}

	size = ftell(f);
	if(size < 0)
	{
		fprintf(stderr,"%s: ftell: %s\n",filepath,strerror(errno));
		return NULL;
	}

	return buf_fread(filepath,f,0,size);
}

static buffer *readfile(char *filepath)
{
	FILE *f;
	buffer *buf;

	f = fopen(filepath,"rb");
	if(!f) return NULL;

	buf = f_readfile(f,filepath);

	fclose(f);

	return buf;
}

static buffer *path_findfile(char *path,char *name)
{
	char pakname[16];
	char *filepath;
	int pak_num;
	buffer *buf;

	for(pak_num=9;pak_num>=0;pak_num--)
	{
		sprintf(pakname,"pak%d.pak",pak_num);
		filepath = va_strcat(path,"/",pakname,NULL);

		buf = pak_loadfile(filepath,name);

		free(filepath);
		if(buf) return buf;

		sprintf(pakname,"PAK%d.PAK",pak_num);
		filepath = va_strcat(path,"/",pakname,NULL);

		buf = pak_loadfile(filepath,name);

		free(filepath);
		if(buf) return buf;
	}

	filepath = va_strcat(path,"/",name,NULL);
	buf = readfile(filepath);
	free(filepath);

	return buf;
}

buffer *findfile(char **path,char *name)
{
	buffer *buf;

	for(;*path;path++)
	{
		buf = path_findfile(*path,name);
		if(buf) return buf;
	}

	fprintf(stderr,"%s: file not found\n",name);

	return NULL;
}

