/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include"global.h"
#include"md4.h"
#include"checksum.h"

/*
derived from q2source-3.14/utils3/qdata/anorms.h
and q2source-3.14/utils3/qdata/models.c 61-65
the last 3 bytes in this array are from the
quake2-3.14a-i386-unknown-linux2.0 binary
*/
static unsigned char dir_data[0x798 + 3] =
{
	0x4f,0x96,0x06,0xbf,0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0x3f,
	0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0x3f,
	0xf6,0x29,0x97,0xbe,0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0x3f,
	0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0x3f,
	0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0x3f,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,
	0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0x3f,0x4f,0x96,0x06,0x3f,
	0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0x3f,
	0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0x3f,
	0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0x3f,0x44,0xc4,0x59,0x3f,
	0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0x3f,
	0x4f,0x96,0x06,0x3f,0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0x3f,
	0xf6,0x29,0x97,0x3e,0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0x3f,
	0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0x3f,
	0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0x3f,
	0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0x3f,
	0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0x3f,
	0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0x3f,
	0x44,0xc4,0x59,0xbf,0x4f,0x96,0x06,0x3f,0x00,0x00,0x00,0x00,
	0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0x3e,
	0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0x3e,
	0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0x3e,
	0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0x3e,
	0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0x3e,
	0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0x3f,
	0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0xbe,
	0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0xbe,
	0x4f,0x96,0x06,0xbf,0x44,0xc4,0x59,0x3f,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0x3f,0x4f,0x96,0x06,0xbf,
	0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0xbe,
	0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0x3f,0xf6,0x29,0x97,0xbe,
	0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0xbe,
	0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0x3f,0xf6,0x29,0x97,0x3e,
	0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0x3e,
	0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0x3e,
	0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0x3e,
	0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0x3e,
	0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0xbe,
	0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0xbe,
	0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0xbe,
	0x44,0xc4,0x59,0x3f,0x4f,0x96,0x06,0x3f,0x00,0x00,0x00,0x00,
	0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0x3e,
	0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0xbe,
	0x4f,0x96,0x06,0x3f,0x44,0xc4,0x59,0x3f,0x00,0x00,0x00,0x00,
	0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0x3f,
	0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0x3e,
	0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0x3e,
	0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0x3f,
	0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0x3f,
	0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0x3f,
	0x9a,0x96,0x74,0x3f,0xf6,0x29,0x97,0x3e,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0x3e,
	0x44,0xc4,0x59,0x3f,0x4f,0x96,0x06,0xbf,0x00,0x00,0x00,0x00,
	0x9a,0x96,0x74,0x3f,0xf6,0x29,0x97,0xbe,0x00,0x00,0x00,0x00,
	0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0x3e,
	0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0x3e,
	0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0x3f,
	0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0x3f,
	0x44,0xc4,0x59,0x3f,0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0x3f,
	0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0xbe,
	0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0xbf,
	0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0xbe,
	0x4f,0x96,0x06,0x3f,0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0xbf,
	0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0xbf,
	0x12,0x85,0x2e,0x3f,0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0xbf,
	0x44,0xc4,0x59,0x3f,0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0xbf,
	0xbd,0x1b,0x4f,0x3f,0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0xbf,
	0x6d,0x3b,0x5d,0x3f,0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0xbe,
	0x68,0x78,0x73,0x3f,0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0xbe,
	0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0xbf,
	0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0xbf,
	0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0xbf,
	0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0xbf,
	0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0xbf,
	0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0xbe,
	0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0xbf,
	0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0xbf,
	0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0x3f,0x44,0xc4,0x59,0xbf,
	0x4f,0x96,0x06,0xbf,0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0xbf,
	0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0xbf,
	0xf6,0x29,0x97,0xbe,0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0xbf,
	0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xbf,
	0xf6,0x29,0x97,0x3e,0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0xbf,
	0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0xbf,
	0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0xbf,
	0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0xbf,
	0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0xbf,
	0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0xbf,0x4f,0x96,0x06,0xbf,
	0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0xbf,
	0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0xbf,
	0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0xbf,0x44,0xc4,0x59,0xbf,
	0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0xbf,
	0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0xbf,
	0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0xbf,
	0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0xbe,
	0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0xbe,
	0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0xbf,
	0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0xbe,
	0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0xbe,
	0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0xbf,
	0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0xbf,0xf6,0x29,0x97,0xbe,
	0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xbf,0x00,0x00,0x00,0x00,
	0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0xbe,
	0x00,0x00,0x00,0x00,0x44,0xc4,0x59,0xbf,0x4f,0x96,0x06,0x3f,
	0x00,0x00,0x00,0x00,0x9a,0x96,0x74,0xbf,0xf6,0x29,0x97,0x3e,
	0xab,0x96,0x74,0x3e,0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0x3e,
	0x5f,0x96,0x86,0x3e,0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0x3e,
	0x00,0x00,0x00,0x3f,0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0x3e,
	0xef,0x70,0x37,0x3f,0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0x3e,
	0x4f,0x96,0x06,0x3f,0x44,0xc4,0x59,0xbf,0x00,0x00,0x00,0x00,
	0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0xbe,
	0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0xbe,
	0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0xbe,
	0x44,0xc4,0x59,0xbf,0x4f,0x96,0x06,0xbf,0x00,0x00,0x00,0x00,
	0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0xbe,
	0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0x3e,
	0x4f,0x96,0x06,0xbf,0x44,0xc4,0x59,0xbf,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0x3e,
	0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0x3e,
	0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0x3e,
	0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0x3e,
	0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0x3f,
	0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0x3e,
	0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0x3f,
	0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0x3f,
	0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0x3f,
	0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0x3f,
	0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0x3f,
	0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0x3f,
	0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0x3f,
	0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0xbe,0x6d,0x3b,0x5d,0x3f,
	0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0xbe,0x68,0x78,0x73,0x3f,
	0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0xbf,0xbd,0x1b,0x4f,0x3f,
	0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0xbf,0x12,0x85,0x2e,0x3f,
	0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0xbf,0x44,0xc4,0x59,0x3f,
	0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0x3f,
	0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0x3f,
	0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0x3e,
	0x9a,0x96,0x74,0xbf,0xf6,0x29,0x97,0x3e,0x00,0x00,0x00,0x00,
	0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0x3e,
	0x00,0x00,0x80,0xbf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x44,0xc4,0x59,0xbf,0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0x3f,
	0x9a,0x96,0x74,0xbf,0xf6,0x29,0x97,0xbe,0x00,0x00,0x00,0x00,
	0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0x3e,
	0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0x3e,0xab,0x96,0x74,0xbe,
	0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0x3e,0x5f,0x96,0x86,0xbe,
	0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0x3e,0x00,0x00,0x00,0xbf,
	0x6d,0x3b,0x5d,0xbf,0xf0,0xbe,0xe2,0xbe,0xab,0x96,0x74,0xbe,
	0x68,0x78,0x73,0xbf,0xea,0x5b,0x26,0xbe,0x5f,0x96,0x86,0xbe,
	0xbd,0x1b,0x4f,0xbf,0x7a,0x37,0x9e,0xbe,0x00,0x00,0x00,0xbf,
	0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0x3e,0xef,0x70,0x37,0xbf,
	0x12,0x85,0x2e,0xbf,0xf6,0x29,0x17,0xbe,0xef,0x70,0x37,0xbf,
	0x44,0xc4,0x59,0xbf,0x00,0x00,0x00,0x00,0x4f,0x96,0x06,0xbf,
	0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0x3f,0x33,0xc4,0xd9,0xbe,
	0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0x3e,0x49,0x2d,0x30,0xbf,
	0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0x3f,0x14,0x79,0x16,0xbf,
	0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0xbf,
	0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0xbe,0x49,0x2d,0x30,0xbf,
	0x49,0x2d,0x30,0xbf,0x14,0x79,0x16,0xbf,0x33,0xc4,0xd9,0xbe,
	0x80,0x00,0x00
};

/*derived from q2source-3.14/utils3/common/md4.c 264-277*/
static unsigned iCom_BlockChecksum(unsigned char *buffer,unsigned length)
{
	unsigned char digest[16];
	unsigned val[4],c;
	MD4_CTX ctx;

	MD4Init(&ctx);
	MD4Update(&ctx,buffer,length);
	MD4Final(digest,&ctx);

	for(c=0;c<4;c++)
	{
		val[c]  = digest[c*4];
		val[c] |= digest[c*4 + 1] <<  8;
		val[c] |= digest[c*4 + 2] << 16;
		val[c] |= digest[c*4 + 3] << 24;
	}

	return val[0] ^ val[1] ^ val[2] ^ val[3];
}

/*reverse engineered by Jorgen Karlsson <zappa@mbox305.swipnet.se>*/
unsigned checksum(unsigned char *data,unsigned length,unsigned long seq)
{
	unsigned char tbuf[64],*p;
	unsigned offset;

	offset = (seq % 0x798);
	p = dir_data + offset;
	if(length > 60) length = 60;

	memcpy(tbuf,data,length);
	tbuf[length]   = p[0] ^ seq;
	tbuf[length+1] = p[1];
	tbuf[length+2] = p[2] ^ (seq >> 8);
	tbuf[length+3] = p[3];

	return iCom_BlockChecksum(tbuf,length+4) & 0xFF;
}

