/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _AI_H
#define _AI_H

#include"bsp.h"
#include"shared.h"

typedef struct
{
	char *team;
	double weapon_last;
	unsigned weapon_index;
	double idle_last;
	unsigned idle_index;
	char **path;
	bsp *map;
	shared_data *shared;
} ai;

ai *ai_init(shared_data *shared,char **path);
void ai_free(ai *state);

usercmd_t ai_getmove(ai *state);
void ai_proc_console_command(ai *state,char *line);

#endif /*ndef _AI_H*/
