COPYRIGHT NOTICE
~~~~~~~~~~~~~~~~
Copyright 1995 M. Scott Jordan.
All rights reserved. This program and corresponding documentation is to 
be freely distributed with no fees beyond a reasonable copying cost.

If you feel that this is a really swell program and you want to give 
money, send a couple of extra bucks to your local United Way campaign.


SPECIAL THANKS
~~~~~~~~~~~~~~
Thanks to Bill McClendon (bill.mcclendon@creature.com) for ideas, testing, 
and proofreading.  Bill is the author of an invaluable document, The 
Unofficial WAD Designers' Handbook (HANDBK12.ZIP), available on 
ftp.cdrom.com.  It contains a lot of useful information for beginning 
level designers. Bill's efforts transformed this document to its current
readable state! Thanks Bill!


INTRODUCTION
~~~~~~~~~~~~
TCOUNT is a DOS program intended to provide level authors with a starting 
point for determining how much health, armor, and ammo to place in a WAD, 
based on the total number of damage points of the monsters in the WAD.
Basically, it's designed to give you a rough guideline of how much stuff
to put in to give your players a "balanced" level.

Only items in single player mode are analyzed.  Multiplayer-only items 
are listed in the raw data file (THINGDAT.TXT) but do not show up in the 
analyses.

Items in "secret" locations are counted in the analysis. TCOUNT assumes 
that the player is going to find the secrets.  If they're probably not
going to find the secrets, you can always take the items off the map
before you run this program.

In addition, TCOUNT can be used to examine existing WADS to list the 
THINGS, find where they are, when they show up, etc.


DISCLAIMER
~~~~~~~~~~
Let me emphasize that cut-and-dried numbers are not intended to replace 
careful and deliberate play-testing.  This program is no substitute for 
beta-testing.  Fun is fun, and numbers don't insure that you are going 
to have fun.  TCOUNT will give you a quick read on a level to tell you 
how much stuff you've given the player compared to the quantity and 
types of monsters.  This should speed WAD development and reduce play- 
testing (but not eliminate it!).  If you wish, you can use TCOUNT to 
look at other people's WADs to tell if they are overloaded with stuff, 
have the right number of Deathmatch locations, and have differences in 
their skill levels.  (It can also tell you at a glance how well-thought-
out Thing placement is...)

WARNING:  CyberDemons (400 damage points) and SpiderDemons (300 damage 
points) can skew the analysis badly because they carry a tremendous 
number of damage points, and because defeating these monsters is nearly
always a "special-case scenario".  My preferred approach is to leave 
these out of the initial analysis in order for the ratios to be properly 
(and fairly) calculated, then add them later and handle them specially.


PREMISE
~~~~~~~
The more monsters you have and the more dangerous they are, the more 
ammo, health, and armor you will need to kill them all.  TCOUNT makes 
the assumption that ammo, health, and armor quantities are a function 
of the total number of damage points of the monsters.  Damage point 
figures were derived from the DOOM FAQ.  Moreover, you can use some 
rules of thumb to assess a WAD to determine if the loading of `stuff' 
is typical for the number and the types of monsters.

For instance, if we wanted to have twice as many ammo points as monster
damage points, we could say that 1 demon (14 points) merits 2*14 = 28 
ammo points.  As WAD designers, we then determine how to split up these 
ammo points.  Maybe it will be 28 bullets; perhaps 4 shells, at 7 ammo 
points a shell.  It's up to you, as TCOUNT doesn't make the distinction.

Different skill levels use different ratios. Using TCOUNT, you can make 
progressively-more-difficult levels more easily and populate them more 
consistently.


USE
~~~
Running TCOUNT with no arguments gives the following help screen,
which is about as user-friendly as it gets:

===============================================================
Syntax:

TCOUNT wadfile level     (for info on that level)
TCOUNT wadfile /L        (for names of entries in wadfile)

Examples:

TCOUNT c:\doom2\doom2.wad map04
TCOUNT c:\doom\doom.wad e3m7
TCOUNT c:\doom\wads\mywad.wad /L
===============================================================

To get information on a level in a WAD the syntax is:

	TCOUNT wad_file_name level_name

To list the contents of a WAD's directory:

	TCOUNT wad_file_name /l

There may be a lot of directory entries and you can use the DOS 
redirection to pipe them to a file:

	TCOUNT c:\doom2\doom2.wad /l  > d2_list.txt

This is helpful when you've forgotten which (or how many) levels are in
a WAD.

The basic approach is to build your WAD, put all the monsters in place, 
then run TCOUNT to see how much stuff (health, armor, ammo) you should 
start with.  With this starting point, you can then play-test to tune 
the amount of stuff you want to place.  You can also put stuff in as 
you see fit, run TCOUNT, then examine the numbers before you plow 
ahead with more playtesting.


DATA FILE
~~~~~~~~~
The data file TCOUNT3X.DAT tells TCOUNT the names associated with 
different thing numbers and the health, armor, ammo, and damage points 
associated with them.  TCOUNT3X.DAT must reside in the directory that
TCOUNT is run from; this can be any directory.  It's recommended that
you put TCOUNT and it's associated files in whatever directory you use
to store your works-in-progress in, for ease of use.  TCOUNT3X.DAT
contains the relevant information on individual things: values for 
ammo, armor, health, and points.

NOTE: Invulnerability, Berserk Packs, Megaspheres, and other "special"
Things have variable effects on the difficulty of your level.  You may 
wish to set values to these to meet your needs. 

You may edit TCOUNT3X.DAT to properly represent the monster and ammo mix
in your level.  (Actually, this is encouraged, because every level is a
little bit different, and as TCOUNT doesn't figure for architectural 
quirks, your TCOUNT results, as compared to your playtest results, might
come up a bit skewed.)  

	***  ***  JUST DON'T CHANGE THE LAST LINE!!  ***  *** 
		
The last line starts with a "!" and tells TCOUNT when it has read 
in all the data.

Comments may be made anywhere except the last line.  A comment begins 
with a "#" like this statement:

# comments have '#' as the first character in the line

Any thing with a "*" character as the first character on the "name" line 
will not be displayed on the detailed thing listing for that level. 
For example, if you don't want "Floor lamp" listed, call it:

*Floor lamp

The asterisk will keep it from being listed.  This is helpful for 
removing long lists of decorations from the analysis.  Even if a name 
starts with a "*", the health, armor, ammo, and damage values are still 
figured into the ratio analysis.  If you don't want something figured in 
to the ratio analysis, set the health, armor, ammo, and damage values to 
zero.

The detailed Thing listing is sequenced the same as is in TCOUNT3X.DAT. 
If you want to see ammo first, move it up to the top of the file.  If 
you don't like the way things are ordered here, switch them around.
TCOUNT does not need the information in any specific order.

There must be no gaps between the thing text and the number, health, 
etc.; that's because TCOUNT expects (and needs) to find the numbers 
on the line immediately after the name.

The last valid line in the data file must start with a "!".  The 
exclamation point tells TCOUNT to stop reading data.  You can put stuff 
in the data file after the "!"; however, it will be ignored.  The other 
note is that there must a line starting with "!" in the data file or 
TCOUNT will hit EOF prematurely and quit.

The data file format of a line entry for a thing is:

THING TEXT
NUMBER    HEALTH  ARMOR   AMMO    DAMAGE

THING TEXT: Up to 29 descriptive characters.  You can edit the file to 
rename things to your liking.

NUMBER: The id thing number from the DOOM Specs.

HEALTH, ARMOR, AMMO, DAMAGE: Points as described in the DOOM FAQ.  Edit 
these to meet your needs.  Note that each value must be separated from
the next value by at least one space; you can use more, but not less. 

Let's look at an example:

FORMER HUMAN SERGEANT
9       0       0       28      3

Here you see that Sarge is thing number 9.  He carries no health or 
armor points.  The 28 ammo points are from the shotgun he drops when
you kill him; the shotgun has 4 shells at 7 ammo points each.  The 
last number, 3, means that it takes 3 damage points to kill Sarge.

There must be no gaps between the thing text and the number, health, 
etc.; that's because TCOUNT expects to find the numbers on the line 
immediately after the name.  (Hey, I'm not a code wizard...)


OUTPUT
~~~~~~
TCOUNT generates 3 output files:

THINGDAT.TXT: A thing by thing listing showing what is in the WAD file.
Note that this file can be rather large; average observed sizes on a
variety of WADs is about 40k.  This file is created for each running
of TCOUNT -- if you need to keep previous copies of this for some
reason, you should rename them, as TCOUNT will overwrite them without
a warning or prompt.

*.TXT: Detailed analysis file showing thing counts by level, summation 
data and ratio data.  The "*" corresponds to the mission or map which you 
specified.  Note that TCOUNT will overwrite (without asking) a previous
file with the same name.  Also, the name of the *.TXT file will be the
level designation; i.e., MAP01.TXT for MAP01 levels.  This file is where
most of the useful information will be found.  These run really small
next to THINGDAT.TXT -- about 10k.

*.SUM:  A summary file suitable for importing into many spread sheet 
programs.  This is useful for really geeky analyses such as the ones 
shown later in this document.  Another 10k, average.

Of note: the "*" in the filenames above corresponds to the level number
of the WAD you're analyzing; i.e., if you were analyzing a level that
was MAP01, you'd get THINGDAT.TXT, MAP01.TXT and MAP01.SUM as your output.
Note again that all three of these files will overwrite any previously-
existing files of the same name without warning.

===============================================================
Sample THINGDAT.TXT
~~~~~~~~~~~~~~~~~~~

Thing analysis of c:\doom\doom.wad  Level: E2M7

       XCOORD YCOORD  ANGLE   TYPE ATTRIB   |1+2| 3 | 4 | D | M |
     0   1904   -352     45   3001      7   | X | X | X |   |   |
     1   1168    176    180   3002      7   | X | X | X |   |   |
     2    -32    448     45   3001      7   | X | X | X |   |   |
     3    176    816      0   3001      7   | X | X | X |   |   |
     etc....

Number on left:  Just a sequence number
XCOORD, YCOORD:  the X and Y coordinates of the Thing's location.
ANGLE         :  the facing of the Thing; 0 is north, 90 is east, etc.
TYPE          :  the Thing's "type" number, from the DOOM Specs.
ATTRIBute     :  I have no idea, but there it is in case you need it. (ho ho)

1+2: X'd if the Thing is present on skill levels 1+2
3  : X'd if the Thing is present on skill level   3
4  : X'd if the Thing is present on skill level   4
D  : X'd if the Thing is flagged "deaf"
M  : X'd if the Thing is flagged "multiplayer-only"
===============================================================
Sample E2M7.TXT
~~~~~~~~~~~~~~~

Detailed Thing List of c:\doom\doom.wad  Level: E2M7

 1+2    3    4 PNTS   DESCRIPTION                    HLTH ARMR AMMO THNG

   3    4    4    3   FORMER HUMAN SERGEANT             0    0   28    9
  40   41   46    6   IMP                               0    0    0 3001
  18   26   33   14   DEMON                             0    0    0 3002
   0    1    5   14   SPECTRE                           0    0    0   58
   2    5    5   36   CACODEMON                         0    0    0 3005
   1    1    2  100   BARON OF HELL                     0    0    0 3003
   1    1    1    0   Backpack                          0    0   98    8
   1    1    1    0   Chainsaw                          0    0    0 2005
   1    1    1    0   Chaingun  gatling gun             0    0   20 2002
  16   16   16    0   Ammo clip                         0    0   10 2007
   3    3    3    0   Box of Ammo                       0    0   50 2048
   6    6    6    0   Shotgun shells                    0    0   28 2008
   6    6    6    0   Box of Shells                     0    0  140 2049
   1    1    1    0   Rocket launcher                   0    0   40 2003
   etc...

(Here you get a listing of counts of the different things you have, 
 broken down by skill level.  Monster Damage points are shown immediately 
 to the left of the names.  To the right are the number of health, armor, 
 and ammo points associated with a single use of the Thing.  The point 
 values are straight out of TCOUNT3X.DAT.  On the far right is the id 
 thing number, or TYPE from the previous chart.)

(NOTE THAT YOU CAN ALSO USE THIS TO COUNT THE NUMBER OF DEATHMATCH SPOTS 
 BEFORE FINDING OUT THE HARD WAY.)

Unknowns

No Unknowns Found

(If there is a thing with no number for it in the data file, you will 
 see an entry here.  Very helpful if you accidentally edit out something 
 important in the data file.)

E2M7 Totals by Difficulty:

	HEALTH    ARMOR     AMMO   POINTS
1+2        444      312     2200      673
 3         444      312     2228      916
 4         444      312     2228     1200

(Totals by skill level.  You can check to see how much difference there 
 is between skill levels in your WAD.  You can also check other peoples' 
 WADs to see if they even bothered to build in different skill levels.)

(Multiplying these numbers and your desired starting ratios gives the 
 total number of health, armor, and ammo points to build into your WAD 
 for starters, should you desire to populate your level in this manner.)

Ratios to POINTS by Difficulty:

	  HEALTH      ARMOR       AMMO
1+2         0.66       0.46       3.27
 3          0.48       0.34       2.43
 4          0.37       0.26       1.86

(Here's where we get down to serious business.  Look at the ratios and 
 see how they stack up against your expectations.  More on expectations 
 in the next section.)

(WADs with 0 damage points for a given skill level get no ratio data for 
 that level.  This would require division by 0.)

===============================================================
TYPICAL VALUES

Ahh... here's the tricky part.  While Jerry Falwell and Newt Gingrich may 
believe that there is one and only one set of acceptable values, the 
fact is that these are going to vary from person to person and WAD to 
WAD, especially when architectural quirks (such as low lighting and
tight corridors) are figured into the final count.  10 Demons in a 
narrow bright hallway are far less difficult to kill than 10 Demons in 
an open dark room, yet to TCOUNT, both sets of Demons are equally 
easy to kill.  We both know they're not, though, are they?  This is 
why it is so vital to change the TCOUNT3X.DAT file for each level you 
analyze.

Listed below are values which I've gotten from analyzing v1.666 of 
DOOM 1 and 2. My basic approach was to look at "typical" levels, then 
throw out levels which produced odd results. In Doom 1, data from the 
first episode was omitted as it seemed significantly different from 
the second two episodes -- the health ratios were particularly odd. 
Levels with CyberDemons and SpiderDemons were omitted, as these monsters 
threw the analysis off.  Look in the D1.PRN and D2.PRN files to 
see which levels were included in this analysis.

=======================================================
DOOM 1 SUMMARY VALUES
			     HEALTH/  ARMOR/   AMMO/
	   AVERAGES   POINTS  POINTS  POINTS  POINTS
		1+2      426    1.40    0.95    4.99
		  3      846    0.73    0.47    2.61
		  4     1260    0.47    0.29    1.74

	 LOW VALUES
		1+2      252    0.82    0.46    3.27
		  3      611    0.48    0.31    2.33
		  4      871    0.37    0.18    1.43

	HIGH VALUES
		1+2      560    1.90    1.57    6.82
		  3     1018    0.97    0.62    3.01
		  4     1723    0.65    0.38    2.15
=======================================================
DOOM 2 SUMMARY VALUES
			     HEALTH/  ARMOR/   AMMO/
	   AVERAGES   POINTS  POINTS  POINTS  POINTS
		1+2      404    1.28    0.70    5.94
		  3      964    0.67    0.30    2.82
		  4     1435    0.45    0.20    2.25

	 LOW VALUES
		1+2      153    0.93    0.24    4.14
		  3      309    0.40    0.10    2.06
		  4      423    0.26    0.06    1.26

	HIGH VALUES
		1+2      797    1.86    1.45    7.60
		  3     1553    0.96    0.59    3.76
		  4     2493    0.73    0.37    3.20
=======================================================

The high and low values are the highest and lowest included in my 
analysis.  It gives you a feel for what the original id values were. 
Average values are just typical values. Some WADs will be lower, some 
will be higher.

What does this mean, though?  Let's take an example:

Suppose that you are doing a DOOM 2 level and you want to check out the 
numbers for skill level 4 (Ultra-Violence).  You would run TCOUNT on your 
WAD.  If your WAD's HEALTH/POINTS number was less than 0.45, your WAD has 
less HEALTH items than a typical DOOM 2 WAD on skill 4.  If it's below 
0.26, then it has a *whole* lot less than what you typically see in D2. 
You might wish to take out a few monsters, use some less lethal 
monsters, or add some more health; alternately, you may prefer to have 
your level be more difficult, relatively speaking, than the originals.
On the other side, if your WAD's HEALTH/POINTS number is well above 0.73, 
then you should look closely to see if there's too much health.

You can run TCOUNT on a WAD with no stuff (other than monsters) in it to 
get the total number of monster points on the different levels.  Once you 
know the number of monster points, you can use the typical numbers above, 
or ones of your own, to estimate how much stuff to put in. 

Getting back to the D2 example listed above, let's say that your WAD has 
1500 POINTS of monsters.  For skill 4 this would suggest that you start 
out with:

	HEALTH = 0.45 * 1500 = 675 health points
	ARMOR  = 0.20 * 1500 = 300 armor points
	AMMO   = 2.25 * 1500 = 3375 ammo points

After populating your WAD with this much stuff, you start testing and 
tuning.  Note that, in my experience, it's better to add everything
first and play-test it, then run TCOUNT on it to see if the ratios
match up with the play-testing data you've gathered, rather than say,
"Okay, I need to add 63 medikits and 3 suits of green armor because
that's how much TCOUNT says I need."

It's interesting to note how the ratios change with skill level.  Here 
you can see how id changed their loadings for the different skills. 
POINTS reflects the monster population; you can see that skills 1+2 have 
about 1/2 the monsters of skill 3.  Skill 4 has about 50% more monsters 
than skill 3.

Full listings of the data used in the analysis can be found in D1.PRN 
and D2.PRN.  You can generate full listings for D1 and D2 by using the 
TEST1.BAT and TEST2.BAT routines included in the archive.


MISCELLANEOUS
~~~~~~~~~~~~~
TCOUNT will probably work for HERETIC too; someone just needs to make 
up a data file.  Not being a HERETIC person, I'll leave that to others.

My current e-mail addresses are:
SJORDAN@MAIL.WIN.ORG
SJORDAN@MEMC.COM

I don't pay for either one of these.  If your message bounces, try 
the other one.

The analysis of D1 and D2 data was done with Microsoft Excel.  If you 
would like a copy of the spread sheet, drop me mail and I'll try to send 
you a UUEncoded copy.

TCOUNT's front end is pretty straightforward, if you like command-line
parameters.  I don't write them to look nice -- I just try to do a job. 
If there's enough interest and need, I could probably be cajoled into 
writing a Windows 3.1 version with a decent user interface.


ABOUT THE AUTHOR
~~~~~~~~~~~~~~~~
Scott Jordan is a 37 year old engineering supervisor in the Epi area at 
MEMC's St. Peters plant. He is a chemical engineer by background and 
writes code on an "as needed" basis... which goes a long way to explaining 
the lack of a decent interface on TCOUNT.
