#include "patch.h"

// Open the control files, make the output wad

int main(int argc,char **argv)
{
	int ky,i,j,k,n;
	char *p,*q;
	int first=1;
	int err,cleared=0;
	FILE *tst;

	iwadname[0]='\0';
	if ((p=getenv("IWAD"))!=NULL)
		strcpy(iwadname,p);

	nclstrs=0;
	clstrs=NULL;
	CopyEnvironmentCLArgs("MAK",argc,argv);

	nclopts=nclfiles=0;
	cloptions=clfiles=NULL;
	cloptsense=NULL;
	ParseCommandLine(-1,1);	// Get any number of options, up to three parms

	InitDir(&pdir);
	InitTextures(&pwt);
	InitRanges();
	InitDTex();
	InitDoomFont();

	if (nclfiles!=1)
	{
		printf("\nMAK.EXE by Jim Flynn, Copyright 1996 v1.2 -- Freeware --\n");
		printf("Make a wad from a resource file and resource tree\n");
		printf("\nUsage: MAK [options] resfile[.res]\n");
		printf("\n Resource selection option:\n");
		printf(" +XYZ does only XYZ resources, -XYZ does all BUT XYZ resources.\n");
		printf(" L LUMPS      W WADS       T TEXTURES\n");
		printf(" E EFFECTS    M MUSICS     G GRAPHICS\n");
		printf(" S SPRITES    P PATCHES    F FLATS\n");
		printf("\n General options, use SET MAK=options to set defaults:\n");
		printf(" /V verbose mode           /1 Convert FF_END to F_END, etc.\n");
		printf(" /I create IWAD            /2 Convert F_END to FF_END, etc.\n");
		printf(" /R create resource WAD    /O:filename  Specify output wad name\n");
		printf("\nSee MAK.TXT for details\n");

		exit(1);
	}

	cleared=0;
	strcpy(outname,"");

	for (i=0;i<nclopts;i++)
	{
		n = strspn(cloptions[i],"lwtemgspfLWTEMGSPF"); // its a sel option
		if (n==strlen(cloptions[i]))	// if all are res selection chars
		{
			if (!cleared)	// if first selection option
			{
				if (cloptsense[i])	// clear all if it adds types
				{
					DoLumps=DoWads=DoTextures=DoEffects=DoMusics=0;
					DoGraphics=DoSprites=DoPatches=DoFlats=0;
				}
				else if (!cloptsense[i]) // set all if it subtracts types
				{
					DoLumps=DoWads=DoTextures=DoEffects=DoMusics=1;
					DoGraphics=DoSprites=DoPatches=DoFlats=1;
				}
				cleared=1;	// but don't do it for following selection opts
			}
			for (j=0;j<strlen(cloptions[i]);j++)	// enable or disable
			{										// each resource for
				switch(tolower(cloptions[i][j]))	// which a letter occurs
				{
					case 'l':
						DoLumps = cloptsense[i];
						break;
					case 'w':
						DoWads = cloptsense[i];
						break;
					case 't':
						DoTextures = cloptsense[i];
						break;
					case 'e':
						DoEffects = cloptsense[i];
						break;
					case 'm':
						DoMusics = cloptsense[i];
						break;
					case 'g':
						DoGraphics = cloptsense[i];
						break;
					case 's':
						DoSprites = cloptsense[i];
						break;
					case 'p':
						DoPatches = cloptsense[i];
						break;
					case 'f':
						DoFlats = cloptsense[i];
						break;
				}
			}
		}
		else if (tolower(cloptions[i][0])=='v')
			Verbose = 1;
 		else if (tolower(cloptions[i][0])=='i')
			MakeIwad = 1;
 		else if (tolower(cloptions[i][0])=='r')
			MakeRwad = 1;
 		else if (cloptions[i][0]=='1')
			SingleMarker = 1;
 		else if (cloptions[i][0]=='2')
			DoubleMarker = 1;
		else if (tolower(cloptions[i][0])=='o' && cloptions[i][1]==':')
			strcpy(outname,cloptions[i]+2);
		else printf("Warning: command line option: %s not understood\n",cloptions[i]);
	}
	strcpy(pwadname,clfiles[0]);

	FreeDynStr(&clstrs,&nclstrs);
	FreeDynStr(&clfiles,&nclfiles);
	FreeDynStr(&cloptions,&nclopts);

	if (Verbose)
	{
		printf("Heap at program start\n");
		heap_dump();
	}

	p=strrchr(pwadname,'.');
    if (p!=NULL) *p='\0';
	strcat(pwadname,".RES");

	if (outname[0]=='\0')
		strcpy(outname,pwadname);
	p=strrchr(outname,'.');
	if (p!=NULL) *p='\0';
	strcat(outname,".RES");

	segs = (Segment *)malloc(sizeof(Segment)*256);
	assert(segs);
	nsegs = 0;

	ReadResourceControl(pwadname, outname);

	if (Verbose)
	{
		printf("Heap at program end\n");
		heap_dump();
	}
	return 0;
}

