//
// MOOD: DOOM behind the Looking Glass 
//
// Written by Serge Slepov
// Idea by Michael N. Novikov
//
// Comments from the project team:
//
// Serge Slepov:
//    Hey, it took me a whole work day to punch this code in!
//    Gee, my boss is gonna kill me!....  If he finds out ;)
//
// Michael Novikov:  Segre!!! you are super-puper cool !!!  Big thenks for this prorgamm!!  It's very very mega cool!  Rulez!!  Doom foreva!!! ARGHHH!!!!!
//    

#include <vector>    //  std::vector
#include <fstream>   //  / (ifstream, ofstream)
#include <iostream>  //  / (cout, cerr, endl...)
#include <algorithm> // min ()
#include <cstdlib>   // exit ()

using namespace std;

#ifdef _MSC_VER
#if (_MSC_VER == 1200) // VC6.0 complains that min is not a member of std::
namespace std {
    template <class T> T min (const T & x, const T & y) {
        return (x<y) ? x:y;
    }
};
#endif
#endif


// 4   /     

short GetShort (istream & is) {
    unsigned short b0 = (unsigned char) (is.get ());
    unsigned short b1 = (unsigned char) (is.get ());
    return b0 + (b1 << 8);
}

long GetLong (istream & is) {
    unsigned long b0 = (unsigned char) (is.get ());
    unsigned long b1 = (unsigned char) (is.get ());
    unsigned long b2 = (unsigned char) (is.get ());
    unsigned long b3 = (unsigned char) (is.get ());
    return b0 + (b1 << 8) + (b2 << 16) + (b3 << 24);
}

void PutShort (ostream & os, short x) {
    os  << char (x & 0xFF) 
        << char ((x & 0xFF00) >> 8);
}

void PutLong (ostream & os, long x) {
    os  << char (x & 0xFF) 
        << char ((x & 0x0000FF00) >> 8)
        << char ((x & 0x00FF0000) >> 16)
        << char ((x & 0xFF000000) >> 24);
}

void Transform (short & x, short & /*y*/) {
    x = -x;
}

void TransformVertex (istream & in, ostream & out) {
    short x = GetShort (in);
    short y = GetShort (in);
    Transform (x,y);
    PutShort (out, x);
    PutShort (out, y);
}

void Copy (istream & in, ostream & out, size_t size) {
    char buf [0x1000];
    for (size_t i=0; i < size; i += sizeof (buf)) { 
        size_t blockSize = std::min (size - i, sizeof (buf));
        in.read (buf, streamsize (blockSize));
        out.write (buf, streamsize (blockSize));
    }
}

bool batchMode = false; //  ,    ; 
                        // to do:  

void PressEnter () {
    if (!batchMode) {
        cout << "Press enter to exit... ";
        cin.get ();
    }
    exit (-1);
}

//  ,    
const size_t nameSize = 8;
struct Lump {
    char name [nameSize];
    long offset;
    long size;
};

void DoIt (istream & in, ostream & out) 
{
    typedef vector <Lump> Directory; // ,   
    Directory directory;

    char c = in.get ();
    if ((c != 'P' && c != 'I')
        || in.get () != 'W'
        || in.get () != 'A'
        || in.get () != 'D')
    {
        cerr << "Input file is not a WAD file: "
            << "IWAD/PWAD signature missing." << endl;
        PressEnter ();
    }

    const long nLumps = GetLong (in);
    const long dirOffset = GetLong (in);
    cout << "Total Lumps: " << nLumps << endl;

    out << c << "WAD";
    PutLong (out, nLumps); 
    PutLong (out, dirOffset); //      

    directory.reserve (nLumps); //      
    in.seekg (dirOffset, ios_base::beg); //    
    cout << "Please wait";
    bool levelDataFound = false;
    for (long i=0; i < nLumps; ++i) {
        if (i % 50 == 0) cout << '.';
        Lump lump;
        lump.offset = GetLong (in);
        lump.size   = GetLong (in);
        in.read (lump.name, nameSize);
        directory.push_back (lump); //   
        if (lump.size == 0) {
            if (    (strncmp (lump.name, "MAP", 3) == 0 
                     && isdigit (lump.name [3]) 
                     && isdigit (lump.name [4]) 
                     && lump.name [5] == '\0'
                    ) ||
                    (lump.name [0] == 'E' && isdigit (lump.name [1]) &&
                     lump.name [2] == 'M' && isdigit (lump.name [3]) &&
                     lump.name [4] == '\0'
                    )
               ) 
            {
                levelDataFound = true;
            }
            continue; //     ("")
        }
        //    ,      
        const long offset = in.tellg (); 
        in.seekg  (lump.offset, ios_base::beg); //    
        out.seekp (lump.offset, ios_base::beg);
        if (strncmp (lump.name, "VERTEXES", nameSize) == 0) {
            const long n = lump.size / 4;
            for (long i=0; i < n; ++i) { 
                TransformVertex (in, out);
            }
        } else 
        if (strncmp (lump.name, "THINGS", nameSize) == 0) {
            const long n = lump.size / 10;
            for (long i=0; i < n; ++i) { 
                TransformVertex (in, out);
                const short angle = GetShort (in);
                PutShort (out, (360 + 180 - angle) % 360);
                Copy (in, out, 4);
            }
        } else 
        if (strncmp (lump.name, "LINEDEFS", nameSize) == 0) {
            long n = lump.size / 14;
            for (long i=0; i < n; ++i) { 
                const short v1 = GetShort (in);
                const short v2 = GetShort (in);
                PutShort (out, v2); //     
                PutShort (out, v1);
                Copy (in, out, 10);
            }
        } else 
        if (strncmp (lump.name, "SEGS", nameSize) == 0) {
            long n = lump.size / 12;
            for (long i=0; i < n; ++i) { 
                const short v1 = GetShort (in);
                const short v2 = GetShort (in);
                PutShort (out, v2);
                PutShort (out, v1);
                const short angle = GetShort (in);
                PutShort (out, -angle); //   !
                Copy (in, out, 6);
            }
        } else 
        if (strncmp (lump.name, "NODES", nameSize) == 0) {
            long n = lump.size / 28;
            for (long i=0; i < n; ++i) { 
                TransformVertex (in, out);
                short dx = GetShort (in);
                short dy = GetShort (in);
                Transform (dx,dy);
                PutShort (out, -dx);
                PutShort (out, -dy);

                short ry2 = GetShort (in); short ry1 = GetShort (in);
                short rx1 = GetShort (in); short rx2 = GetShort (in);
                short ly2 = GetShort (in); short ly1 = GetShort (in);
                short lx1 = GetShort (in); short lx2 = GetShort (in);
                Transform (rx2,ry2);
                Transform (rx1,ry1);
                Transform (lx2,ly2);
                Transform (lx1,ly1);
                PutShort (out, ry2); PutShort (out, ry1);
                PutShort (out, rx2); PutShort (out, rx1); //  
                PutShort (out, ly2); PutShort (out, ly1);
                PutShort (out, lx2); PutShort (out, lx1); //  

                Copy (in, out, 4);
            }
        } else
        if (strncmp (lump.name, "BLOCKMAP", nameSize) == 0) {
            const short left   = GetShort (in);
            const short bottom = GetShort (in);
            const short ncols  = GetShort (in);
            const short nrows  = GetShort (in);
            PutShort (out, -left - ncols*128);
            PutShort (out, bottom);
            PutShort (out, ncols);
            PutShort (out, nrows);
            vector <short> vec (ncols);
            for (short row=0; row < nrows; ++row) {
                short col;
                for (col=0; col < ncols; ++col) {
                    vec [col] = GetShort (in);
                }
                for (col=ncols-1; col >= 0; --col) {
                    PutShort (out, vec [col]);
                }
            }
            Copy (in, out, lump.size - 4 - 2*ncols*nrows);
        } else { 
            //   
            Copy (in, out, lump.size);
        }
        in.seekg (offset, ios_base::beg); //   
    }
    //     
    out.seekp (dirOffset, ios_base::beg);
    for (size_t j=0; j < directory.size (); ++j) {
        const Lump & lump = directory [j];
        PutLong (out, lump.offset);
        PutLong (out, lump.size);
        out.write (lump.name, nameSize);
    }
    cout << "done" << endl;
    if (!levelDataFound) {
        cout << "Warning: No level data has been found in this WAD." << endl;
    }
}

int main (int argc, char * argv [])
{
    cout << "MOOD v 1.2 by Serge Slepov & Maikl Novikov, doomer@newmail.ru" << endl;

    if (argc < 2) {
        cout << "Usage: mood <infile>.wad [<outfile>.wad]" << endl;
        cout << "Check out mood.txt for more info." << endl;
        PressEnter ();
    }

    string outPath;
    if (argc > 2) {
        outPath = argv [2];
    }
    else {
        // warning: the code in this block is Windows-specific
	    char newPath [_MAX_PATH], drive [_MAX_DRIVE], path [_MAX_DIR], name [_MAX_FNAME], ext [_MAX_EXT];

	    _splitpath (argv [1], drive, path, name, ext);
        string title (name);
        reverse (title.begin (), title.end ()); //   STL! :)
	    _makepath (newPath , drive, path, title.c_str (), ext);
        outPath = newPath;
    }

    ifstream in  (argv [1],         ios_base::binary);
    ofstream out (outPath.c_str (), ios_base::binary);

    cout << "Processing " << argv [1] << " to " << outPath.c_str () << endl;

    try {
        in .exceptions (ios_base::badbit | ios_base::failbit);
        out.exceptions (ios_base::badbit | ios_base::failbit);

        DoIt (in, out);
    }
    catch (ios_base::failure & ) {
        cout << "Could not read the input file or write to the output file" << endl;
        PressEnter ();
    }
    catch (exception & e) {
        cout << "Error: " << e.what () << endl;
        PressEnter ();
    }

    cout << '\a'; // beep
    return 0;
}
