/* DOOM wad file structures and procedures */
#ifndef WADS_H
#define WADS_H

#define MYLIB_YES
#define MYFILEIO_YES
#include "mylib.h"
#define INIT_ALLOC 50
#define REALLOC_INCR 50
#define MAX_FCOPY_BUFSIZE 65532
#define FCOPY_BUFSIZE 65536-16384
/* if the object to be copied is shorter than MAX_FCOPY_BUFSIZE,
   fcopynbytes tries to alocate exactly enough memory to copy the
   whole thing at once; otherwise, FCOPY_BUFSIZE is allocated. */


typedef struct {
  short int x;
  short int y;
  short int angle;
  short int type;
  short int attrib;
} Thing;

typedef struct {
  short int from;
  short int to;
  short int attrib;
  short int type;
  short int tag;
  short int first_sidedef;
  short int second_sidedef;
} LineDef;

typedef struct {
  short int x_offset;
  short int y_offset;
  char upper_texture[8];
  char lower_texture[8];
  char full_texture[8];
  short int sector;
} SideDef;

typedef struct {
  short int x;
  short int y;
} Vertex;

typedef struct {
  short int from;
  short int to;
  short int angle;
  short int linedef;
  short int direction;
  short int offset;
} Seg;

typedef struct {
  short int num_segs;
  short int first_seg;
} Ssector;

typedef struct {
  short int x;
  short int y;
  short int dx;
  short int dy;
  short int r_maxy;
  short int r_miny;
  short int r_minx;
  short int r_maxx;
  short int l_maxy;
  short int l_miny;
  short int l_minx;
  short int l_maxx;
  short int right_child;
  short int left_child;
} Node;

typedef struct {
  short int floor_height;
  short int ceiling_height;
  char floor_texture[8];
  char ceiling_texture[8];
  short int brightness;
  short int type;
  short int tag;
} Sector;

typedef struct {
  char name[8];
  long num_things;
  long num_linedefs;
  long num_sidedefs;
  long num_vertexes;
  long num_segs;
  long num_ssectors;
  long num_nodes;
  long num_sectors;
  long reject_length;
  long blockmap_length;
  Thing *things;
  LineDef *linedefs;
  SideDef *sidedefs;
  Vertex *vertexes;
  Seg *segs;
  Ssector *ssectors;
  Node *nodes;
  Sector *sectors;
  void *reject;
  void *blockmap;
} Map;

typedef struct {
  char type[4];
  long num_entries;
  long dir_start;
} Header;

typedef struct {
  long int start;
  long int length;
  char name[8];
} DirEntry;

typedef struct {
  FILE *fp;
  DirEntry *dirptr;
  long num_entries;
  long dirsize;
} WAD;

void UsageError (char *message,...);
int wc (char *str);
int wcmatch (char *pattern, char *str);
char *str2name (char *str, char *name, int length);
char *name2str (char *name, char *str, int length);
int mapname (char *name);
int map_data (char *name);
int wadfile (FILE *fp);
WAD *new_wad (char *fname);
long fcopynbytes (FILE* from, FILE* to, long n);
void copy_file_to_wad (WAD *dest, FILE* src, char *entry_name);
void copy_entry_to_file (FILE *dest, FILE* src, DirEntry entry);
void copy_entry_to_wad  (WAD *dest,  FILE* src, DirEntry entry);
void close_wad (WAD *wad, int iwad);

#endif