#include "wads.h"

void Usage (void)
{
  printf ("Usage: list filename.wad [pattern]\n");
  printf ("\tfilename.wad is any valid .WAD file (IWAD or PWAD);\n");
  printf ("\tpattern (default=*) specifies which entries to list;\n");
  exit (1);
}

main (int argc, char *argv[])
{
  FILE *infile;
  Header header;
  DirEntry direntry;
  unsigned long i=0;
  unsigned long item_count=0;
  unsigned long size_count=0;
  int indent=0;
  int incr_indent=0;
  int map=0;
  int j;
  char *pattern;
  char temp[9];

  printf ("WAD list utility by Serge Smirnov -- compiled on %s at %s\n\n",__DATE__,__TIME__);

  if ((argc<2)||(argc>3))
    Usage();
  pattern = (argc<3) ? "*" : argv[2];

  if ((infile=fopen(argv[1],"rb"))==NULL)
    UsageError ("can't open %s",argv[1]);
  fread (&header, sizeof (header), 1, infile);
  if (strcmp (name2str(header.type+1,temp,3),"WAD"))
    UsageError ("%s is not a WAD file",argv[1]);

  fseek (infile, header.dir_start,SEEK_SET);
  for (i=0;i<header.num_entries;i++) {
    fread (&direntry, sizeof (direntry), 1, infile);
    name2str(direntry.name,temp,8);
    if (incr_indent) {
      indent++;
      incr_indent=0;
    }
    if ((map)&&(!map_data(temp))) {
      map=0;
      indent--;
    }
    if (mapname(temp)) {
      map=1;
      incr_indent=1;
    }
    if ((wcmatch("?_START",temp))||(wcmatch("??_START",temp)))
      incr_indent=1;
    if ((wcmatch("?_END",temp))||(wcmatch("??_END",temp)))
      indent--;
    if (wcmatch(pattern,temp)) {
      for (j=0;j<indent;j++)
	printf ("   ");
      printf ("%-8s\t%12ld%12ld\t0x%08lX\n",temp,direntry.length,direntry.start,direntry.start);
      size_count+=direntry.length;
      item_count++;
    } /* if wcmatch... */
  } /* for every directory entry in the WAD */

  fclose (infile);
  if (item_count) {
    printf ("\n%ld entries, %lu bytes.\n",item_count,size_count);
    return(0);
  }
  else {
    printf ("no match\n");
    return(1);
  }
}
