@echo off
if "%1"=="" goto usage
if not exist %1\doom.wad goto usage
if not exist %1\main.wad goto ok
   echo.
   echo %1\main.wad already exists.  Press any key to overwrite, Ctrl-C to cancel.
   echo.
   pause
:ok

rem check if Doom1 registered
list %1\doom.wad D_E3M9 >nul
if errorlevel 1 goto wrong_version

rem check if 1.666 or above
list %1\doom.wad STTMINUS >nul
if errorlevel 1 goto wrong_version

extract %1\doom.wad * -bDPPISTOL -wuptod.wad
extract %1\doom.wad * -ADPPISTOL -BDSGETPOW -wdps1.wad
extract %1\doom.wad * -ADPPLASMA -BDSMETAL -wdps2.wad
extract %1\doom.wad * -AD_E1M1 -BD_E1M9 -wd_e1mx.wad
extract %1\doom.wad * -AD_E2M1 -BD_E3M9 -wd_e23mx.wad
extract %1\doom.wad * -AD_INTER -BD_INTROA -wd_misc.wad
extract %1\doom.wad * -AD_BUNNY -wbunny_on.wad

wadcomp -I%1\main.wad uptod.wad dps1.wad dps2.wad d_e1mx.wad d_e23mx.wad d_misc.wad bunny_on.wad

echo Done.  Press any key to delete the temorary files
pause

del uptod.wad
del dps1.wad
del dps2.wad
del d_e1mx.wad
del d_e23mx.wad
del d_misc.wad
del bunny_on.wad

goto end

:usage
  echo.
  echo Usage: %0 path_to_main
  echo.
  echo The original doom.wad will NOT be modified.
  echo The modified version will be stored as main.wad in the same directory.
  echo.
  echo Example: %0 c:\games\doom
  echo.
goto end

:wrong_version
  echo.
  echo This batch program will only work with DOOM I registered 1.666-1.9
  echo.
goto end

:end
