#ifndef __WADOPT_H__
#define __WADOPT_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

WAD entry optimisation

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddir.h"

/**********************************************************************************************************************************/
/********************************************** WAD Entry Copy Out with Optimization **********************************************/
/**********************************************************************************************************************************/

// Copy entries of WAD file directory (optimized)
void CopyDirectoryEntriesOptimized (
	FILE *infile,												// file to copy entries from
	FILE *outfile,												// file to copy entries to
	WADDIR_t *WADDIR,											// directory to copy entries of
	const LST_t *LST,											// symbol table resulting from initial scan
	bool_t truncate_waves,										// remove wasted space at the end of sound resources
	bool_t rebuild_blockmaps,									// rebuild (no pack/unpack) blockmaps to remove wasted space
	bool_t pack_blockmaps,										// pack blockmaps to remove current and potential wasted space
	bool_t unpack_blockmaps,									// unpack blockmaps into normalised (but inefficient) format
	bool_t flush_blockmaps,										// write out modified blockmaps even if the size has not changed
	bool_t rebuild_pictures,									// rebuild (no pack/unpack) pictures to remove wasted space
	bool_t pack_pictures,										// pack pictures to remove current and potential wasted space
	bool_t unpack_pictures,										// unpack pictures into normalised (but inefficient) format
	bool_t flush_pictures,										// write out modified pictures even if the size has not changed
	bool_t reuse_lumps,											// reuse lumps where directory entries specify same size and offset
	bool_t pack_lumps,											// share lumps with identical contents between directory entries
	bool_t unpack_lumps,										// output each lump explicitly even if it could be shared or reused
	bool_t unpack_conflicts,									// do not preserve ineligible lump reuse (if tolerated)
	bool_t align_resources,										// align resources on 32-bit boundaries for speed at cost of space
	bool_t align_directory,										// align directory on 32-bit boundaries for speed at cost of space
	bool_t maintain_blockmaps,									// maintain nonstandard blockmaps (preserve non-optimal blocks)
	bool_t maintain_pictures);									// maintain nonstandard pictures (preserve non-optimal columns)

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WADOPT_H__
