#ifndef __WADLRU_H__
#define __WADLRU_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad lump reuse

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include <stdio.h>
#include "services.h"
#include "waddef.h"
#include "wadlst.h"
#include "waddir.h"

/**********************************************************************************************************************************/
/********************************************************* WAD lump reuse *********************************************************/
/**********************************************************************************************************************************/

// Check for lumps being reused between entries
void WADCheckForAnyReuse(
	const WADDIR_t *WADDIR,										// WAD file directory that was scanned
	bool_t *found_reuse);										// flag for some lump reuse was found

// Handle (on input) existing reuse of a list of lumps
void WADHandleExistingReuseOnInput (
	const WADDIR_t *WADDIR,										// WAD file directory that was scanned
	const LST_t *LST,											// symbol table resulting from the scan of that directory
	bool_t reuse_lumps,											// reuse lumps where directory entries specify same size and offset
	bool_t pack_lumps,											// share lumps with identical contents between directory entries
	bool_t unpack_lumps,										// output each lump explicitly even if it could be shared or reused
	bool_t tolerate_links,										// do not treat lump reuse as an error
	bool_t quiet_links,											// do not treat lump reuse as a problem
	bool_t tolerate_conflicts,									// do not treat ineligible lump reuse as an error
	bool_t quiet_conflicts,										// do not treat ineligible lump reuse as a problem
	verbosity_t priority,										// priority selection (must be WARNINGS or ERRORS)
	bool_t *found_errors);										// report if any errors were found (ignored if processing WARNINGS)

// Handle (on output) existing reuse of a given lump
void WADHandleExistingReuseOnOutput (
	const WADDIR_t *WADDIR,										// WAD file directory to check for reuse in
	const LST_t *LST,											// symbol table resulting from the scan of that directory
	bool_t reuse_lumps,											// reuse lumps where directory entries specify same size and offset
	bool_t pack_lumps,											// share lumps with identical contents between directory entries
	bool_t unpack_lumps,										// output each lump explicitly even if it could be shared or reused
	bool_t unpack_conflicts,									// do not preserve ineligible lump reuse (if tolerated)
	size_t wanted,												// index of entry to check for reuse of
	bool_t *reused);											// flag for this lump reuses a previous directory entry

// Identify (on output) new reuse of a given lump
void WADIdentifyNewReuseOnOutput (
	FILE *outfile,												// WAD file to search in
	const WADDIR_t *WADDIR,										// WAD file directory to look for potential reuse in
	const LST_t *LST,											// symbol table resulting from the scan of that directory
	const void *lump_wanted,									// lump to check for potential reuse of
	size_t wanted,												// index in WAD file directory of the lump
	void (canonicalize) (										// lump canonicalization function
		const void *lump_in,									// lump to process
		const WADDIR_t *WADDIR,									// WAD file directory to take entry metrics from
		size_t index,											// index of lump in directory entries
		bool_t truncate_waves,									// remove wasted space at the end of sound resources
		bool_t rebuild_blockmaps,								// rebuild (no pack/unpack) blockmaps to remove wasted space
		bool_t pack_blockmaps,									// pack blockmaps to remove current and potential wasted space
		bool_t unpack_blockmaps,								// unpack blockmaps into normalised (but inefficient) format
		bool_t flush_blockmaps,									// write out modified blockmaps even if the size has not changed
		bool_t rebuild_pictures,								// rebuild (no pack/unpack) pictures to remove wasted space
		bool_t pack_pictures,									// pack pictures to remove current and potential wasted space
		bool_t unpack_pictures,									// unpack pictures into normalised (but inefficient) format
		bool_t flush_pictures,									// write out modified pictures even if the size has not changed
		bool_t maintain_blockmaps,								// maintain nonstandard blockmaps (preserve non-optimal blocks)
		bool_t maintain_pictures,								// maintain nonstandard pictures (preserve non-optimal columns)
		bool_t process_only,									// issue no messages except for fatal errors
		void **lump_out,										// processed lump
		size_t *size_out),										// size of processed lump
	bool_t truncate_waves,										// remove wasted space at the end of sound resources
	bool_t rebuild_blockmaps,									// rebuild (no pack/unpack) blockmaps to remove wasted space
	bool_t pack_blockmaps,										// pack blockmaps to remove current and potential wasted space
	bool_t unpack_blockmaps,									// unpack blockmaps into normalised (but inefficient) format
	bool_t flush_blockmaps,										// write out modified blockmaps even if the size has not changed
	bool_t rebuild_pictures,									// rebuild (no pack/unpack) pictures to remove wasted space
	bool_t pack_pictures,										// pack pictures to remove current and potential wasted space
	bool_t unpack_pictures,										// unpack pictures into normalised (but inefficient) format
	bool_t flush_pictures,										// write out modified pictures even if the size has not changed
	bool_t maintain_blockmaps,									// maintain nonstandard blockmaps (preserve non-optimal blocks)
	bool_t maintain_pictures,									// maintain nonstandard pictures (preserve non-optimal columns)
	bool_t process_only,										// issue no messages except for fatal errors
	bool_t *reused,												// flag for this lump reuses a previous directory entry
	size_t *reused_index);										// index of entry that this lump can now reuse

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __WADLRU_H__
