/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Wad lump type identification by name

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "waddef.h"
#include "wadlin.h"

/**********************************************************************************************************************************/
/****************************************************** Kind Identification *******************************************************/
/**********************************************************************************************************************************/

typedef bool_t games_t[GAME_MAXPLUSONE];

typedef struct
{
	games_t games;												// games in which this combination of name and list appears
	list_t list;												// list to which this name belongs
	bool_t wild;												// name string contains wildcards
	char name[9];												// name
	kind_t kind;												// kind (result of the lookup process)
} kind_map_t;

#define NUMKINDMAPS 192

//
// Read the comments in "waddef.h", just above the definition
// of "kind_t", before even THINKING of modifying this table!
//

static kind_map_t kind_maps[NUMKINDMAPS]=
{
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_UNKNOWN  , FALSE , ""         , KIND_BEGINLIST           },
	//
	// DOOM/STRIFE MUSIC NAMES
	//
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , TRUE  , "D_E#M#"   , KIND_1________D_EXMY     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_LOGO"   , KIND________S_D_LOGO     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_ACTION" , KIND________S_D_ACTION   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_TAVERN" , KIND________S_D_TAVERN   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_DANGER" , KIND________S_D_DANGER   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_FAST"   , KIND________S_D_FAST     },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_INTRO"  , KIND_1______S_D_INTRO    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_DARKER" , KIND________S_D_DARKER   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_STRIKE" , KIND________S_D_STRIKE   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_SLIDE"  , KIND________S_D_SLIDE    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_TRIBAL" , KIND________S_D_TRIBAL   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_MARCH"  , KIND________S_D_MARCH    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_MOOD"   , KIND________S_D_MOOD     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_CASTLE" , KIND________S_D_CASTLE   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_FIGHT"  , KIND________S_D_FIGHT    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_SPENSE" , KIND________S_D_SPENSE   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_DARK"   , KIND________S_D_DARK     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_TECH"   , KIND________S_D_TECH     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_DRONE"  , KIND________S_D_DRONE    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_PANTHR" , KIND________S_D_PANTHR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_SAD"    , KIND________S_D_SAD      },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_INSTRY" , KIND________S_D_INSTRY   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_HAPPY"  , KIND________S_D_HAPPY    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_MUSICS   , FALSE , "D_END"    , KIND________S_D_END      },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_INTROA" , KIND_1________D_INTROA   },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_INTER"  , KIND_1________D_INTER    },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_VICTOR" , KIND_1________D_VICTOR   },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_BUNNY"  , KIND_1________D_BUNNY    },
	//
	// DOOM2/TNT/PLUTONIA MUSIC NAMES
	//
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_RUNNIN" , KIND__2TP_____D_RUNNIN   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_STALKS" , KIND__2TP_____D_STALKS   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_COUNTD" , KIND__2TP_____D_COUNTD   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_BETWEE" , KIND__2TP_____D_BETWEE   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DOOM"   , KIND__2TP_____D_DOOM     },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_THE_DA" , KIND__2TP_____D_THE_DA   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_SHAWN"  , KIND__2TP_____D_SHAWN    },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DDTBLU" , KIND__2TP_____D_DDTBLU   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_IN_CIT" , KIND__2TP_____D_IN_CIT   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DEAD"   , KIND__2TP_____D_DEAD     },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_STLKS2" , KIND__2TP_____D_STLKS2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_THEDA2" , KIND__2TP_____D_THEDA2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DOOM2"  , KIND__2TP_____D_DOOM2    },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DDTBL2" , KIND__2TP_____D_DDTBL2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_RUNNI2" , KIND__2TP_____D_RUNNI2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DEAD2"  , KIND__2TP_____D_DEAD2    },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_STLKS3" , KIND__2TP_____D_STLKS3   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_ROMERO" , KIND__2TP_____D_ROMERO   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_SHAWN2" , KIND__2TP_____D_SHAWN2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_MESSAG" , KIND__2TP_____D_MESSAG   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_COUNT2" , KIND__2TP_____D_COUNT2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DDTBL3" , KIND__2TP_____D_DDTBL3   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_AMPIE"  , KIND__2TP_____D_AMPIE    },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_THEDA3" , KIND__2TP_____D_THEDA3   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_ADRIAN" , KIND__2TP_____D_ADRIAN   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_MESSG2" , KIND__2TP_____D_MESSG2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_ROMER2" , KIND__2TP_____D_ROMER2   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_TENSE"  , KIND__2TP_____D_TENSE    },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_SHAWN3" , KIND__2TP_____D_SHAWN3   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_OPENIN" , KIND__2TP_____D_OPENIN   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_EVIL"   , KIND__2TP_____D_EVIL     },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_ULTIMA" , KIND__2TP_____D_ULTIMA   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_READ_M" , KIND__2TP_____D_READ_M   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DM2TTL" , KIND__2TP_____D_DM2TTL   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "D_DM2INT" , KIND__2TP_____D_DM2INT   },
	//
	// HERETIC MUSIC NAMES
	//
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_MUSICS   , TRUE  , "MUS_E#M#" , KIND_____H____D_EXMY     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "MUS_TITL" , KIND_____H____D_TITL     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "MUS_INTR" , KIND_____H____D_INTR     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_MUSICS   , FALSE , "MUS_CPTD" , KIND_____H____D_CPTD     },
	//
	// HEXEN/DEATHKINGS MUSIC NAMES
	//
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "WINNOWR"  , KIND______XD__D_WINNOWR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "JACHR"    , KIND______XD__D_JACHR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "SIMONR"   , KIND______XD__D_SIMONR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "WUTZITR"  , KIND______XD__D_WUTZITR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "FALCONR"  , KIND______XD__D_FALCONR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "LEVELR"   , KIND______XD__D_LEVELR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHARTR"   , KIND______XD__D_CHARTR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "SWAMPR"   , KIND______XD__D_SWAMPR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "DEEPR"    , KIND______XD__D_DEEPR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "FUBASR"   , KIND______XD__D_FUBASR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "GROVER"   , KIND______XD__D_GROVER   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "FORTR"    , KIND______XD__D_FORTR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "FOOJAR"   , KIND______XD__D_FOOJAR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "SIXATER"  , KIND______XD__D_SIXATER  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "WOBABYR"  , KIND______XD__D_WOBABYR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CRYPTR"   , KIND______XD__D_CRYPTR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "FANTAR"   , KIND______XD__D_FANTAR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "BLECHR"   , KIND______XD__D_BLECHR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "VOIDR"    , KIND______XD__D_VOIDR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHAP_1R"  , KIND______XD__D_CHAP_1R  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHAP_2R"  , KIND______XD__D_CHAP_2R  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHAP_3R"  , KIND______XD__D_CHAP_3R  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHAP_4R"  , KIND______XD__D_CHAP_4R  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHIPPYR"  , KIND______XD__D_CHIPPYR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "PERCR"    , KIND______XD__D_PERCR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "SECRETR"  , KIND______XD__D_SECRETR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "BONESR"   , KIND______XD__D_BONESR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "OCTOR"    , KIND______XD__D_OCTOR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "RITHMR"   , KIND______XD__D_RITHMR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "STALKR"   , KIND______XD__D_STALKR   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "BORKR"    , KIND______XD__D_BORKR    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CRUCIBR"  , KIND______XD__D_CRUCIBR  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "HEXEN"    , KIND______XD__D_HEXEN    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "HUB"      , KIND______XD__D_HUB      },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "HALL"     , KIND______XD__D_HALL     },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "ORB"      , KIND______XD__D_ORB      },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_MUSICS   , FALSE , "CHESS"    , KIND______XD__D_CHESS    },
	//
	// LUMP NAMES
	//
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , TRUE  , "DEMO#"    , KIND_12TPHXDS_L_DEMO     },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "ANIMATED" , KIND_12TPHXDS_L_ANIMATED },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "ANIMDEFS" , KIND_12TPHXDS_L_ANIMDEFS },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "DECALDEF" , KIND_12TPHXDS_L_DECALDEF },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "DECORATE" , KIND_12TPHXDS_L_DECORATE },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DEHACKED" , KIND_12TP_____L_DEHACKED },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DEHSUPP"  , KIND_12TP_____L_DEHSUPP  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "KEYCONF"  , KIND_12TPHXDS_L_KEYCONF  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "MAPINFO"  , KIND_12TPHXDS_L_MAPINFO  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "SNDINFO"  , KIND_12TPHXDS_L_SNDINFO  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "SNDSEQ"   , KIND_12TPHXDS_L_SNDSEQ   },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "TERRAIN"  , KIND_12TPHXDS_L_TERRAIN  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFLANG"  , KIND_12TP_____L_DDFLANG  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFSFX"   , KIND_12TP_____L_DDFSFX   },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFCOLM"  , KIND_12TP_____L_DDFCOLM  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFATK"   , KIND_12TP_____L_DDFATK   },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFWEAP"  , KIND_12TP_____L_DDFWEAP  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFTHING" , KIND_12TP_____L_DDFTHING },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFPLAY"  , KIND_12TP_____L_DDFPLAY  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFLINE"  , KIND_12TP_____L_DDFLINE  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFSECT"  , KIND_12TP_____L_DDFSECT  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFSWTH"  , KIND_12TP_____L_DDFSWTH  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFANIM"  , KIND_12TP_____L_DDFANIM  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFGAME"  , KIND_12TP_____L_DDFGAME  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DDFLEVL"  , KIND_12TP_____L_DDFLEVL  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "RSCRIPT"  , KIND_12TP_____L_RSCRIPT  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "LOADING"  , KIND_____H____L_LOADING  },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "ENDOOM"   , KIND_12TP_____L_ENDOOM   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "ENDTEXT"  , KIND_____H____L_ENDTEXT  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "CLUS1MSG" , KIND______XD__L_CLUS1MSG },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "CLUS2MSG" , KIND______XD__L_CLUS2MSG },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "CLUS3MSG" , KIND______XD__L_CLUS3MSG },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "CLUS4MSG" , KIND______XD__L_CLUS4MSG },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "WIN1MSG"  , KIND______XD__L_WIN1MSG  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "WIN2MSG"  , KIND______XD__L_WIN2MSG  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "WIN3MSG"  , KIND______XD__L_WIN3MSG  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "T1TEXT"   , KIND________S_L_T1TEXT   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "C1TEXT"   , KIND________S_L_C1TEXT   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "ENDSTRF"  , KIND________S_L_ENDSTRF  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL0" , KIND______XD__L_TRANTBL0 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL1" , KIND______XD__L_TRANTBL1 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL2" , KIND______XD__L_TRANTBL2 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL3" , KIND______XD__L_TRANTBL3 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL4" , KIND______XD__L_TRANTBL4 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL5" , KIND______XD__L_TRANTBL5 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL6" , KIND______XD__L_TRANTBL6 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL7" , KIND______XD__L_TRANTBL7 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL8" , KIND______XD__L_TRANTBL8 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBL9" , KIND______XD__L_TRANTBL9 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLA" , KIND______XD__L_TRANTBLA },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLB" , KIND______XD__L_TRANTBLB },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLC" , KIND______XD__L_TRANTBLC },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLD" , KIND______XD__L_TRANTBLD },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLE" , KIND______XD__L_TRANTBLE },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLF" , KIND______XD__L_TRANTBLF },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLG" , KIND______XD__L_TRANTBLG },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLH" , KIND______XD__L_TRANTBLH },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLI" , KIND______XD__L_TRANTBLI },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLJ" , KIND______XD__L_TRANTBLJ },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TRANTBLK" , KIND______XD__L_TRANTBLK },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "PLAYPAL"  , KIND_12TPHXDS_L_PLAYPAL  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "E2PAL"    , KIND_____H____L_E2PAL    },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "COLORMAP" , KIND_12TPHXDS_L_COLORMAP },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "FOGMAP"   , KIND______XD__L_FOGMAP   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "TINTTAB"  , KIND_____HXD__L_TINTTAB  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "XLATAB"   , KIND________S_L_XLATAB   },
	{ {TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "GENMIDI"  , KIND_12TPHXDS_L_GENMIDI  },
	{ {TRUE ,TRUE ,FALSE,FALSE,FALSE,TRUE ,TRUE ,TRUE ,TRUE } , LIST_LUMPS    , FALSE , "DMXGUS"   , KIND_1___HXDS_L_DMXGUS   },
	{ {TRUE ,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "DMXGUSC"  , KIND__2TP_____L_DMXGUSC  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "AUTOPAGE" , KIND_____HXD__L_AUTOPAGE },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "STARTUP"  , KIND______XD__L_STARTUP  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STARTUP0" , KIND________S_L_STARTUP0 },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTLZ1"  , KIND________S_L_STRTLZ1  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTLZ2"  , KIND________S_L_STRTLZ2  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTBOT"  , KIND________S_L_STRTBOT  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTPA1"  , KIND________S_L_STRTPA1  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTPB1"  , KIND________S_L_STRTPB1  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTPC1"  , KIND________S_L_STRTPC1  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "STRTPD1"  , KIND________S_L_STRTPD1  },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "SNDCURVE" , KIND_____HXD__L_SNDCURVE },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_LUMPS    , FALSE , "EXTENDED" , KIND_____H____L_EXTENDED },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_LUMPS    , FALSE , "XXTIC"    , KIND______XD__L_XXTIC    },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "SERIAL"   , KIND________S_L_SERIAL   },
	{ {TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_LUMPS    , FALSE , "COPYRITE" , KIND________S_L_COPYRITE },
#if 0
	/* BEGIN ************************************************
    * Graphic ordering not yet implemented (compiler limit) *
	********************************************************/
	//
	// DOOM/DOOM2/TNT/PLUTONIA GRAPHIC NAMES
	//
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "AMMNUM#"  , KIND_12TP_____G_AMMNUM   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_L"   , KIND_12TP_____G_BRDR_L   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_R"   , KIND_12TP_____G_BRDR_R   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_B"   , KIND_12TP_____G_BRDR_B   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_T"   , KIND_12TP_____G_BRDR_T   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_BL"  , KIND_12TP_____G_BRDR_BL  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_BR"  , KIND_12TP_____G_BRDR_BR  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_TL"  , KIND_12TP_____G_BRDR_TL  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BRDR_TR"  , KIND_12TP_____G_BRDR_TR  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "TITLEPIC" , KIND_12TP_____G_TITLEPIC },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INTERPIC" , KIND_12TP_____G_INTERPIC },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "VICTORY2" , KIND_1________G_VICTORY2 },
	{ {FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BOSSBACK" , KIND__2TP_____G_BOSSBACK },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "CREDIT"   , KIND_12TP_____G_CREDIT   },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "HELP1"    , KIND_1________G_HELP1    },
	{ {FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "HELP"     , KIND__2TP_____G_HELP     },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "PFUB#"    , KIND_1________G_PFUB     },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "ENDPIC"   , KIND_1________G_ENDPIC   },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "END#"     , KIND_1________G_END      },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "M_*"      , KIND_12TP_____G_M_MENU   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STBAR"    , KIND_12TP_____G_STBAR    },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STARMS"   , KIND_12TP_____G_STARMS   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STKEYS#"  , KIND_12TP_____G_STKEYS   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STDISK"   , KIND_12TP_____G_STDISK   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STCDROM"  , KIND_12TP_____G_STCDROM  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STGNUM#"  , KIND_12TP_____G_STGNUM   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STTMINUS" , KIND_12TP_____G_STTMINUS },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STTNUM#"  , KIND_12TP_____G_STTNUM   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STTPRCNT" , KIND_12TP_____G_STTPRCNT },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STYSNUM#" , KIND_12TP_____G_STYSNUM  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STCFN0##" , KIND_12TP_____G_STCFN0   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STCFN1##" , KIND_12TP_____G_STCFN1   },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STFB#"    , KIND_12TP_____G_STFB     },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "STPB#"    , KIND_12TP_____G_STPB     },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST01"  , KIND_12TP_____G_STFST01  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST00"  , KIND_12TP_____G_STFST00  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST02"  , KIND_12TP_____G_STFST02  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTL00"  , KIND_12TP_____G_STFTL00  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTR00"  , KIND_12TP_____G_STFTR00  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFOUCH0" , KIND_12TP_____G_STFOUCH0 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFEVL0"  , KIND_12TP_____G_STFEVL0  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFKILL0" , KIND_12TP_____G_STFKILL0 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST11"  , KIND_12TP_____G_STFST11  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST10"  , KIND_12TP_____G_STFST10  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST12"  , KIND_12TP_____G_STFST12  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTL10"  , KIND_12TP_____G_STFTL10  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTR10"  , KIND_12TP_____G_STFTR10  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFOUCH1" , KIND_12TP_____G_STFOUCH1 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFEVL1"  , KIND_12TP_____G_STFEVL1  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFKILL1" , KIND_12TP_____G_STFKILL1 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST21"  , KIND_12TP_____G_STFST21  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST20"  , KIND_12TP_____G_STFST20  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST22"  , KIND_12TP_____G_STFST22  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTL20"  , KIND_12TP_____G_STFTL20  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTR20"  , KIND_12TP_____G_STFTR20  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFOUCH2" , KIND_12TP_____G_STFOUCH2 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFEVL2"  , KIND_12TP_____G_STFEVL2  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFKILL2" , KIND_12TP_____G_STFKILL2 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST31"  , KIND_12TP_____G_STFST31  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST30"  , KIND_12TP_____G_STFST30  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST32"  , KIND_12TP_____G_STFST32  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTL30"  , KIND_12TP_____G_STFTL30  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTR30"  , KIND_12TP_____G_STFTR30  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFOUCH3" , KIND_12TP_____G_STFOUCH3 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFEVL3"  , KIND_12TP_____G_STFEVL3  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFKILL3" , KIND_12TP_____G_STFKILL3 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST41"  , KIND_12TP_____G_STFST41  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST40"  , KIND_12TP_____G_STFST40  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFST42"  , KIND_12TP_____G_STFST42  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTL40"  , KIND_12TP_____G_STFTL40  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFTR40"  , KIND_12TP_____G_STFTR40  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFOUCH4" , KIND_12TP_____G_STFOUCH4 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFEVL4"  , KIND_12TP_____G_STFEVL4  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFKILL4" , KIND_12TP_____G_STFKILL4 },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFGOD0"  , KIND_12TP_____G_STFGOD0  },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STFDEAD0" , KIND_12TP_____G_STFDEAD0 },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "WIMAP#"   , KIND_1________G_WIMAP    },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "WIA#####" , KIND_1________G_WIA      },
	{ {FALSE,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "WILV##"   , KIND_1________G_WILV     },
	{ {FALSE,FALSE,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "CWILV##"  , KIND__2TP_____G_CWILV    },
	{ {FALSE,TRUE ,TRUE ,TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "WI*"      , KIND_12TP_____G_WI       },
	//
	// HERETIC GRAPHIC NAMES
	//
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDL"    , KIND_____H____G_BORDL    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDR"    , KIND_____H____G_BORDR    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDT"    , KIND_____H____G_BORDT    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDB"    , KIND_____H____G_BORDB    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDTL"   , KIND_____H____G_BORDTL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDTR"   , KIND_____H____G_BORDTR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDBL"   , KIND_____H____G_BORDBL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BORDBR"   , KIND_____H____G_BORDBR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "STATBAR"  , KIND_____H____G_STATBAR  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BLACKSQ"  , KIND_____H____G_BLACKSQ  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "ARMCLEAR" , KIND_____H____G_ARMCLEAR },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INVBAR"   , KIND_____H____G_INVBAR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "ARTIBOX"  , KIND_____H____G_ARTIBOX  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SELECTBO" , KIND_____H____G_SELECTBO },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIA" , KIND_____H____G_USEARTIA },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIB" , KIND_____H____G_USEARTIB },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIC" , KIND_____H____G_USEARTIC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "USEARTID" , KIND_____H____G_USEARTID },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIE" , KIND_____H____G_USEARTIE },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INVGEML1" , KIND_____H____G_INVGEML1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INVGEMR1" , KIND_____H____G_INVGEMR1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INVGEML2" , KIND_____H____G_INVGEML2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INVGEMR2" , KIND_____H____G_INVGEMR2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BKEYICON" , KIND_____H____G_BKEYICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "GKEYICON" , KIND_____H____G_GKEYICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "YKEYICON" , KIND_____H____G_YKEYICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "IN#"      , KIND_____H____G_IN       },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "NEGNUM"   , KIND_____H____G_NEGNUM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LAME"     , KIND_____H____G_LAME     },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "SMALLIN#" , KIND_____H____G_SMALLIN  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMGLD"  , KIND_____H____G_INAMGLD  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMBOW"  , KIND_____H____G_INAMBOW  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMBST"  , KIND_____H____G_INAMBST  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMRAM"  , KIND_____H____G_INAMRAM  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMPNX"  , KIND_____H____G_INAMPNX  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "INAMLOB"  , KIND_____H____G_INAMLOB  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LIFEBAR"  , KIND_____H____G_LIFEBAR  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "BARBACK"  , KIND_____H____G_BARBACK  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "CHAINBAC" , KIND_____H____G_CHAINBAC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "CHAIN"    , KIND_____H____G_CHAIN    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGEM0" , KIND_____H____G_LIFEGEM0 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGEM1" , KIND_____H____G_LIFEGEM1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGEM2" , KIND_____H____G_LIFEGEM2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGEM3" , KIND_____H____G_LIFEGEM3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "GOD1"     , KIND_____H____G_GOD1     },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "GOD2"     , KIND_____H____G_GOD2     },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LTFACE"   , KIND_____H____G_LTFACE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "RTFACE"   , KIND_____H____G_RTFACE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "LTFCTOP"  , KIND_____H____G_LTFCTOP  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "RTFCTOP"  , KIND_____H____G_RTFCTOP  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEA0"   , KIND_____H____G_FACEA0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEA1"   , KIND_____H____G_FACEA1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEA2"   , KIND_____H____G_FACEA2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEA3"   , KIND_____H____G_FACEA3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEB0"   , KIND_____H____G_FACEB0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEB1"   , KIND_____H____G_FACEB1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEB2"   , KIND_____H____G_FACEB2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "FACEB3"   , KIND_____H____G_FACEB3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , TRUE  , "M_*"      , KIND_____H____G_M_MENU   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK0"  , KIND_____H____G_SPINBK0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK1"  , KIND_____H____G_SPINBK1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK2"  , KIND_____H____G_SPINBK2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK3"  , KIND_____H____G_SPINBK3  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK4"  , KIND_____H____G_SPINBK4  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK5"  , KIND_____H____G_SPINBK5  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK6"  , KIND_____H____G_SPINBK6  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK7"  , KIND_____H____G_SPINBK7  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK8"  , KIND_____H____G_SPINBK8  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK9"  , KIND_____H____G_SPINBK9  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK10" , KIND_____H____G_SPINBK10 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK11" , KIND_____H____G_SPINBK11 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK12" , KIND_____H____G_SPINBK12 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK13" , KIND_____H____G_SPINBK13 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK14" , KIND_____H____G_SPINBK14 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPINBK15" , KIND_____H____G_SPINBK15 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY0"   , KIND_____H____G_SPFLY0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY1"   , KIND_____H____G_SPFLY1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY2"   , KIND_____H____G_SPFLY2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY3"   , KIND_____H____G_SPFLY3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY4"   , KIND_____H____G_SPFLY4   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY5"   , KIND_____H____G_SPFLY5   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY6"   , KIND_____H____G_SPFLY6   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY7"   , KIND_____H____G_SPFLY7   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY8"   , KIND_____H____G_SPFLY8   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY9"   , KIND_____H____G_SPFLY9   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY10"  , KIND_____H____G_SPFLY10  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY11"  , KIND_____H____G_SPFLY11  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY12"  , KIND_____H____G_SPFLY12  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY13"  , KIND_____H____G_SPFLY13  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY14"  , KIND_____H____G_SPFLY14  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY15"  , KIND_____H____G_SPFLY15  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "MAPE1"    , KIND_____H____G_MAPE1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "MAPE2"    , KIND_____H____G_MAPE2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "MAPE3"    , KIND_____H____G_MAPE3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "IN_X"     , KIND_____H____G_IN_X     },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "IN_YAH"   , KIND_____H____G_IN_YAH   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "E2END"    , KIND_____H____G_E2END    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "PAUSED"   , KIND_____H____G_PAUSED   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE} , LIST_GRAPHICS , FALSE , "ADVISOR"  , KIND_____H____G_ADVISOR  },
	//
	// HEXEN/DEATHKINGS GRAPHIC NAMES
	//
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDL"    , KIND______XD__G_BORDL    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDR"    , KIND______XD__G_BORDR    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDT"    , KIND______XD__G_BORDT    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDB"    , KIND______XD__G_BORDB    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDTL"   , KIND______XD__G_BORDTL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDTR"   , KIND______XD__G_BORDTR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDBL"   , KIND______XD__G_BORDBL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "BORDBR"   , KIND______XD__G_BORDBR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "STATBAR"  , KIND______XD__G_STATBAR  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "H2BAR"    , KIND______XD__G_H2BAR    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "H2TOP"    , KIND______XD__G_H2TOP    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LFEDGE"   , KIND______XD__G_LFEDGE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "RTEDGE"   , KIND______XD__G_RTEDGE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARMCLS"   , KIND______XD__G_ARMCLS   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARTICLS"  , KIND______XD__G_ARTICLS  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "INVBAR"   , KIND______XD__G_INVBAR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARTIBOX"  , KIND______XD__G_ARTIBOX  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SELECTBO" , KIND______XD__G_SELECTBO },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIA" , KIND______XD__G_USEARTIA },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIB" , KIND______XD__G_USEARTIB },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIC" , KIND______XD__G_USEARTIC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "USEARTID" , KIND______XD__G_USEARTID },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "USEARTIE" , KIND______XD__G_USEARTIE },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "INVGEML1" , KIND______XD__G_INVGEML1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "INVGEMR1" , KIND______XD__G_INVGEMR1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "INVGEML2" , KIND______XD__G_INVGEML2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "INVGEMR2" , KIND______XD__G_INVGEMR2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , TRUE  , "IN#"      , KIND______XD__G_IN       },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "NEGNUM"   , KIND______XD__G_NEGNUM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , TRUE  , "SMALLIN#" , KIND______XD__G_SMALLIN  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , TRUE  , "INRED#"   , KIND______XD__G_INRED    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANAVL1"  , KIND______XD__G_MANAVL1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANAVL2"  , KIND______XD__G_MANAVL2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANAVL1D" , KIND______XD__G_MANAVL1D },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANAVL2D" , KIND______XD__G_MANAVL2D },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANACLS"  , KIND______XD__G_MANACLS  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANADIM1" , KIND______XD__G_MANADIM1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANADIM2" , KIND______XD__G_MANADIM2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANABRT1" , KIND______XD__G_MANABRT1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "MANABRT2" , KIND______XD__G_MANABRT2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "TALLYTOP" , KIND______XD__G_TALLYTOP },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "TALLYLFT" , KIND______XD__G_TALLYLFT },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHESSC"   , KIND______XD__G_CHESSC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHESSM"   , KIND______XD__G_CHESSM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHESSALL" , KIND______XD__G_CHESSALL },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KILLS"    , KIND______XD__G_KILLS    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYBAR"   , KIND______XD__G_KEYBAR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT1" , KIND______XD__G_KEYSLOT1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT2" , KIND______XD__G_KEYSLOT2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT3" , KIND______XD__G_KEYSLOT3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT4" , KIND______XD__G_KEYSLOT4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT5" , KIND______XD__G_KEYSLOT5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT6" , KIND______XD__G_KEYSLOT6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT7" , KIND______XD__G_KEYSLOT7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT8" , KIND______XD__G_KEYSLOT8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOT9" , KIND______XD__G_KEYSLOT9 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOTA" , KIND______XD__G_KEYSLOTA },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "KEYSLOTB" , KIND______XD__G_KEYSLOTB },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARMSLOT1" , KIND______XD__G_ARMSLOT1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARMSLOT2" , KIND______XD__G_ARMSLOT2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARMSLOT3" , KIND______XD__G_ARMSLOT3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ARMSLOT4" , KIND______XD__G_ARMSLOT4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPSLOT0"  , KIND______XD__G_WPSLOT0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPSLOT1"  , KIND______XD__G_WPSLOT1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPSLOT2"  , KIND______XD__G_WPSLOT2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPFULL0"  , KIND______XD__G_WPFULL0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPFULL1"  , KIND______XD__G_WPFULL1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPFULL2"  , KIND______XD__G_WPFULL2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEF1" , KIND______XD__G_WPIECEF1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEF2" , KIND______XD__G_WPIECEF2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEF3" , KIND______XD__G_WPIECEF3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEC1" , KIND______XD__G_WPIECEC1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEC2" , KIND______XD__G_WPIECEC2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEC3" , KIND______XD__G_WPIECEC3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEM1" , KIND______XD__G_WPIECEM1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEM2" , KIND______XD__G_WPIECEM2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "WPIECEM3" , KIND______XD__G_WPIECEM3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHAIN"    , KIND______XD__G_CHAIN    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHAIN2"   , KIND______XD__G_CHAIN2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "CHAIN3"   , KIND______XD__G_CHAIN3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGEM"  , KIND______XD__G_LIFEGEM  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF2" , KIND______XD__G_LIFEGMF2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF3" , KIND______XD__G_LIFEGMF3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF4" , KIND______XD__G_LIFEGMF4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF5" , KIND______XD__G_LIFEGMF5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF6" , KIND______XD__G_LIFEGMF6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF7" , KIND______XD__G_LIFEGMF7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMF8" , KIND______XD__G_LIFEGMF8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC1" , KIND______XD__G_LIFEGMC1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC2" , KIND______XD__G_LIFEGMC2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC3" , KIND______XD__G_LIFEGMC3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC4" , KIND______XD__G_LIFEGMC4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC5" , KIND______XD__G_LIFEGMC5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC6" , KIND______XD__G_LIFEGMC6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC7" , KIND______XD__G_LIFEGMC7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMC8" , KIND______XD__G_LIFEGMC8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM1" , KIND______XD__G_LIFEGMM1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM2" , KIND______XD__G_LIFEGMM2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM3" , KIND______XD__G_LIFEGMM3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM4" , KIND______XD__G_LIFEGMM4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM5" , KIND______XD__G_LIFEGMM5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM6" , KIND______XD__G_LIFEGMM6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM7" , KIND______XD__G_LIFEGMM7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LIFEGMM8" , KIND______XD__G_LIFEGMM8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , TRUE  , "M_*"      , KIND______XD__G_M_MENU   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY0"   , KIND______XD__G_SPFLY0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY1"   , KIND______XD__G_SPFLY1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY2"   , KIND______XD__G_SPFLY2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY3"   , KIND______XD__G_SPFLY3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY4"   , KIND______XD__G_SPFLY4   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY5"   , KIND______XD__G_SPFLY5   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY6"   , KIND______XD__G_SPFLY6   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY7"   , KIND______XD__G_SPFLY7   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY8"   , KIND______XD__G_SPFLY8   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY9"   , KIND______XD__G_SPFLY9   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY10"  , KIND______XD__G_SPFLY10  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY11"  , KIND______XD__G_SPFLY11  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY12"  , KIND______XD__G_SPFLY12  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY13"  , KIND______XD__G_SPFLY13  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY14"  , KIND______XD__G_SPFLY14  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPFLY15"  , KIND______XD__G_SPFLY15  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD0"  , KIND______XD__G_SPSHLD0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD1"  , KIND______XD__G_SPSHLD1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD2"  , KIND______XD__G_SPSHLD2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD3"  , KIND______XD__G_SPSHLD3  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD4"  , KIND______XD__G_SPSHLD4  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD5"  , KIND______XD__G_SPSHLD5  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD6"  , KIND______XD__G_SPSHLD6  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD7"  , KIND______XD__G_SPSHLD7  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD8"  , KIND______XD__G_SPSHLD8  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD9"  , KIND______XD__G_SPSHLD9  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD10" , KIND______XD__G_SPSHLD10 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD11" , KIND______XD__G_SPSHLD11 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD12" , KIND______XD__G_SPSHLD12 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD13" , KIND______XD__G_SPSHLD13 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD14" , KIND______XD__G_SPSHLD14 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPSHLD15" , KIND______XD__G_SPSHLD15 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT0"  , KIND______XD__G_SPBOOT0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT1"  , KIND______XD__G_SPBOOT1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT2"  , KIND______XD__G_SPBOOT2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT3"  , KIND______XD__G_SPBOOT3  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT4"  , KIND______XD__G_SPBOOT4  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT5"  , KIND______XD__G_SPBOOT5  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT6"  , KIND______XD__G_SPBOOT6  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT7"  , KIND______XD__G_SPBOOT7  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT8"  , KIND______XD__G_SPBOOT8  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT9"  , KIND______XD__G_SPBOOT9  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT10" , KIND______XD__G_SPBOOT10 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT11" , KIND______XD__G_SPBOOT11 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT12" , KIND______XD__G_SPBOOT12 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT13" , KIND______XD__G_SPBOOT13 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT14" , KIND______XD__G_SPBOOT14 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPBOOT15" , KIND______XD__G_SPBOOT15 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO0"  , KIND______XD__G_SPMINO0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO1"  , KIND______XD__G_SPMINO1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO2"  , KIND______XD__G_SPMINO2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO3"  , KIND______XD__G_SPMINO3  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO4"  , KIND______XD__G_SPMINO4  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO5"  , KIND______XD__G_SPMINO5  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO6"  , KIND______XD__G_SPMINO6  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO7"  , KIND______XD__G_SPMINO7  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO8"  , KIND______XD__G_SPMINO8  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO9"  , KIND______XD__G_SPMINO9  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO10" , KIND______XD__G_SPMINO10 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO11" , KIND______XD__G_SPMINO11 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO12" , KIND______XD__G_SPMINO12 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO13" , KIND______XD__G_SPMINO13 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO14" , KIND______XD__G_SPMINO14 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SPMINO15" , KIND______XD__G_SPMINO15 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "LOADICON" , KIND______XD__G_LOADICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "SAVEICON" , KIND______XD__G_SAVEICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "TELEICON" , KIND______XD__G_TELEICON },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "PAUSED"   , KIND______XD__G_PAUSED   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,TRUE ,FALSE} , LIST_GRAPHICS , FALSE , "ADVISOR"  , KIND______XD__G_ADVISOR  },
	//
	// STRIFE GRAPHIC NAMES
	//
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "AMMNUM#"  , KIND________S_G_AMMNUM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "PLMNUM#"  , KIND________S_G_PLMNUM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_L"   , KIND________S_G_BRDR_L   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_R"   , KIND________S_G_BRDR_R   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_B"   , KIND________S_G_BRDR_B   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_T"   , KIND________S_G_BRDR_T   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_BL"  , KIND________S_G_BRDR_BL  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_BR"  , KIND________S_G_BRDR_BR  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_TL"  , KIND________S_G_BRDR_TL  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "BRDR_TR"  , KIND________S_G_BRDR_TR  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "TITLEPIC" , KIND________S_G_TITLEPIC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "VELLOGO"  , KIND________S_G_VELLOGO  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "RGELOGO"  , KIND________S_G_RGELOGO  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "CREDIT"   , KIND________S_G_CREDIT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "HELP0"    , KIND________S_G_HELP0    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "HELP1"    , KIND________S_G_HELP1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "HELP2"    , KIND________S_G_HELP2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "HELP3"    , KIND________S_G_HELP3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL0"   , KIND________S_G_PANEL0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL1"   , KIND________S_G_PANEL1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL2"   , KIND________S_G_PANEL2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL3"   , KIND________S_G_PANEL3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL4"   , KIND________S_G_PANEL4   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL5"   , KIND________S_G_PANEL5   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL6"   , KIND________S_G_PANEL6   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "PANEL7"   , KIND________S_G_PANEL7   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS2F1"    , KIND________S_G_SS2F1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS2F2"    , KIND________S_G_SS2F2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS2F3"    , KIND________S_G_SS2F3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS2F4"    , KIND________S_G_SS2F4    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS3F1"    , KIND________S_G_SS3F1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS3F2"    , KIND________S_G_SS3F2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS3F3"    , KIND________S_G_SS3F3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS3F4"    , KIND________S_G_SS3F4    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS4F1"    , KIND________S_G_SS4F1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS4F2"    , KIND________S_G_SS4F2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS4F3"    , KIND________S_G_SS4F3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS4F4"    , KIND________S_G_SS4F4    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS5F1"    , KIND________S_G_SS5F1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS5F2"    , KIND________S_G_SS5F2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS5F3"    , KIND________S_G_SS5F3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS6F1"    , KIND________S_G_SS6F1    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS6F2"    , KIND________S_G_SS6F2    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "SS6F3"    , KIND________S_G_SS6F3    },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "STBACK##" , KIND________S_G_STBACK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STDISK"   , KIND________S_G_STDISK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR1" , KIND________S_G_STCOLOR1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR2" , KIND________S_G_STCOLOR2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR3" , KIND________S_G_STCOLOR3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR4" , KIND________S_G_STCOLOR4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR5" , KIND________S_G_STCOLOR5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR6" , KIND________S_G_STCOLOR6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR7" , KIND________S_G_STCOLOR7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "STCOLOR8" , KIND________S_G_STCOLOR8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "STBFN0##" , KIND________S_G_STBFN0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "STCFN0##" , KIND________S_G_STCFN0   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVBACK"  , KIND________S_G_INVBACK  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVPBAK2" , KIND________S_G_INVPBAK2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVPOP"   , KIND________S_G_INVPOP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVPOP2"  , KIND________S_G_INVPOP2  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVTOP"   , KIND________S_G_INVTOP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVPBAK"  , KIND________S_G_INVPBAK  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVCURS"  , KIND________S_G_INVCURS  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG0" , KIND________S_G_INVFONG0 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG1" , KIND________S_G_INVFONG1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG2" , KIND________S_G_INVFONG2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG3" , KIND________S_G_INVFONG3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG4" , KIND________S_G_INVFONG4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG5" , KIND________S_G_INVFONG5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG6" , KIND________S_G_INVFONG6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG7" , KIND________S_G_INVFONG7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG8" , KIND________S_G_INVFONG8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG9" , KIND________S_G_INVFONG9 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONG%" , KIND________S_G_INVFONGP },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY0" , KIND________S_G_INVFONY0 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY1" , KIND________S_G_INVFONY1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY2" , KIND________S_G_INVFONY2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY3" , KIND________S_G_INVFONY3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY4" , KIND________S_G_INVFONY4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY5" , KIND________S_G_INVFONY5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY6" , KIND________S_G_INVFONY6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY7" , KIND________S_G_INVFONY7 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY8" , KIND________S_G_INVFONY8 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY9" , KIND________S_G_INVFONY9 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "INVFONY%" , KIND________S_G_INVFONYP },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BKPK"   , KIND________S_G_I_BKPK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_ARM1"   , KIND________S_G_I_ARM1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_ARM2"   , KIND________S_G_I_ARM2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BLIT"   , KIND________S_G_I_BLIT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SHD1"   , KIND________S_G_I_SHD1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_STMP"   , KIND________S_G_I_STMP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_KY1G"   , KIND________S_G_I_KY1G   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_KY2S"   , KIND________S_G_I_KY2S   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_ROKT"   , KIND________S_G_I_ROKT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_KY3B"   , KIND________S_G_I_KY3B   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_MDKT"   , KIND________S_G_I_MDKT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BRY1"   , KIND________S_G_I_BRY1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GRN1"   , KIND________S_G_I_GRN1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GRN2"   , KIND________S_G_I_GRN2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_HAND"   , KIND________S_G_I_HAND   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_ORAC"   , KIND________S_G_I_ORAC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_XQRL"   , KIND________S_G_I_XQRL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PQRL"   , KIND________S_G_I_PQRL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_COIN"   , KIND________S_G_I_COIN   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_TPAS"   , KIND________S_G_I_TPAS   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_CRD1"   , KIND________S_G_I_CRD1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_CRD2"   , KIND________S_G_I_CRD2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_TARG"   , KIND________S_G_I_TARG   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_CHST"   , KIND________S_G_I_CHST   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_MASK"   , KIND________S_G_I_MASK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BEAC"   , KIND________S_G_I_BEAC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PRIS"   , KIND________S_G_I_PRIS   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PWR3"   , KIND________S_G_I_PWR3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PWR1"   , KIND________S_G_I_PWR1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PWR2"   , KIND________S_G_I_PWR2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GYID"   , KIND________S_G_I_GYID   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_FUSL"   , KIND________S_G_I_FUSL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_FUBR"   , KIND________S_G_I_FUBR   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GOID"   , KIND________S_G_I_GOID   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GUNT"   , KIND________S_G_I_GUNT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_HELT"   , KIND________S_G_I_HELT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_REPT"   , KIND________S_G_I_REPT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_FULL"   , KIND________S_G_I_FULL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_REBL"   , KIND________S_G_I_REBL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_WARE"   , KIND________S_G_I_WARE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_RELC"   , KIND________S_G_I_RELC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_COMM"   , KIND________S_G_I_COMM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PMUP"   , KIND________S_G_I_PMUP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_UNIF"   , KIND________S_G_I_UNIF   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_XPRK"   , KIND________S_G_I_XPRK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_GASG"   , KIND________S_G_I_GASG   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_TOKN"   , KIND________S_G_I_TOKN   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BOAT"   , KIND________S_G_I_BOAT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_AQID"   , KIND________S_G_I_AQID   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_PROC"   , KIND________S_G_I_PROC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_ANKH"   , KIND________S_G_I_ANKH   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_RCRY"   , KIND________S_G_I_RCRY   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BCRY"   , KIND________S_G_I_BCRY   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_CHAP"   , KIND________S_G_I_CHAP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_TUNL"   , KIND________S_G_I_TUNL   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BLTK"   , KIND________S_G_I_BLTK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SGL1"   , KIND________S_G_I_SGL1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SGL2"   , KIND________S_G_I_SGL2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SGL3"   , KIND________S_G_I_SGL3   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SGL4"   , KIND________S_G_I_SGL4   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SGL5"   , KIND________S_G_I_SGL5   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_BFLM"   , KIND________S_G_I_BFLM   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_RING"   , KIND________S_G_I_RING   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_EARS"   , KIND________S_G_I_EARS   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_CRYS"   , KIND________S_G_I_CRYS   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_OFIC"   , KIND________S_G_I_OFIC   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_EPI1"   , KIND________S_G_I_EPI1   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_EPI2"   , KIND________S_G_I_EPI2   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_OTOK"   , KIND________S_G_I_OTOK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_RATT"   , KIND________S_G_I_RATT   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_COUP"   , KIND________S_G_I_COUP   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_SECK"   , KIND________S_G_I_SECK   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "I_MINE"   , KIND________S_G_I_MINE   },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_PEAS1"  , KIND________S_G_M_PEAS1  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_PEAS7"  , KIND________S_G_M_PEAS7  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_LEDR0"  , KIND________S_G_M_LEDR0  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_DERWIN" , KIND________S_G_M_DERWIN },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_DKWRKR" , KIND________S_G_M_DKWRKR },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_FALSP1" , KIND________S_G_M_FALSP1 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_FALSP2" , KIND________S_G_M_FALSP2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_FALSP3" , KIND________S_G_M_FALSP3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GEOFF"  , KIND________S_G_M_GEOFF  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD"  , KIND________S_G_M_GUARD  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD2" , KIND________S_G_M_GUARD2 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD3" , KIND________S_G_M_GUARD3 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD4" , KIND________S_G_M_GUARD4 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD5" , KIND________S_G_M_GUARD5 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_GUARD6" , KIND________S_G_M_GUARD6 },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_JUDGE"  , KIND________S_G_M_JUDGE  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_KETRIC" , KIND________S_G_M_KETRIC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_KEVIN"  , KIND________S_G_M_KEVIN  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_MCGUFF" , KIND________S_G_M_MCGUFF },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_ORACLE" , KIND________S_G_M_ORACLE },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_PRISNR" , KIND________S_G_M_PRISNR },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_QUINCY" , KIND________S_G_M_QUINCY },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_RETRIC" , KIND________S_G_M_RETRIC },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_RICHTR" , KIND________S_G_M_RICHTR },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_SAMMIS" , KIND________S_G_M_SAMMIS },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_TEKBRN" , KIND________S_G_M_TEKBRN },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_TEKGRY" , KIND________S_G_M_TEKGRY },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_TEKTAN" , KIND________S_G_M_TEKTAN },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_WARDEN" , KIND________S_G_M_WARDEN },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_WERAN"  , KIND________S_G_M_WERAN  },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , FALSE , "M_WORNER" , KIND________S_G_M_WORNER },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE } , LIST_GRAPHICS , TRUE  , "M_*"      , KIND________S_G_M_MENU   },
	/* ENDOF ************************************************
    * Graphic ordering not yet implemented (compiler limit) *
	********************************************************/
#endif
	//
	// END OF KINDS
	//
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_UNKNOWN  , FALSE , ""         , KIND_PUTINLIST           },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_UNKNOWN  , FALSE , ""         , KIND_ENDOFLIST           },
	{ {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE} , LIST_UNKNOWN  , FALSE , ""         , KIND_MAXPLUSONE          }
};

// Identify lump kind by metrics
kind_t LINIdentifyLumpKindByMetrics (
	const char *s,												// name of the lump whose kind is to be determined
	list_t list,												// list membership of the lump
	game_t game)												// game in which this combination of lump name and list appears
{
	// VARIABLES
	size_t i=0;
	bool_t found=FALSE;

	// HANDLE TRIVIAL CASES
	if ( (list!=LIST_MUSICS) && (list!=LIST_LUMPS) && (list!=LIST_GRAPHICS) )
	{
		return KIND_PUTINLIST;
	}

	// PERFORM THE LOOKUP
	while ( (!found) && (i<NUMKINDMAPS) )
	{
		if ( (kind_maps[i].games[game]) && (kind_maps[i].list==list) )
		{
			if (kind_maps[i].wild)
			{
				if (wcmatch(s,kind_maps[i].name))
				{
					found=TRUE;
				}
			}
			else
			{
				if (wnmatch(s,kind_maps[i].name))
				{
					found=TRUE;
				}
			}
		}
		i++;
	}

	// RETURN RESULT
	if (found)
	{
		return kind_maps[i].kind;
	}
	else
	{
		return KIND_PUTINLIST;
	}
}

/**********************************************************************************************************************************/
/****************************************************** Lump Identification *******************************************************/
/**********************************************************************************************************************************/

// Is it a DOOM graphic
static bool_t is_doom1graphic(const char *s)
{
#define NUMDOOM1GRAPHICS 371
	static const char *stuff[NUMDOOM1GRAPHICS] =
	{
		// Doom 1 IWAD graphic names
		"AMMNUM0"  , "AMMNUM1"  , "AMMNUM2"  , "AMMNUM3"  , "AMMNUM4"  , "AMMNUM5"  ,
		"AMMNUM6"  , "AMMNUM7"  , "AMMNUM8"  , "AMMNUM9"  , "BRDR_B"   , "BRDR_BL"  ,
		"BRDR_BR"  , "BRDR_L"   , "BRDR_R"   , "BRDR_T"   , "BRDR_TL"  , "BRDR_TR"  ,
		"CREDIT"   , "END0"     , "END1"     , "END2"     , "END3"     , "END4"     ,
		"END5"     , "END6"     , "ENDPIC"   , "HELP1"    , "INTERPIC" , "M_DETAIL" ,
		"M_DISOPT" , "M_DISP"   , "M_DOOM"   , "M_ENDGAM" , "M_EPI1"   , "M_EPI2"   ,
		"M_EPI3"   , "M_EPI4"   , "M_EPISOD" , "M_GDHIGH" , "M_GDLOW"  , "M_HURT"   ,
		"M_JKILL"  , "M_LGTTL"  , "M_LOADG"  , "M_LSCNTR" , "M_LSLEFT" , "M_LSRGHT" ,
		"M_MESSG"  , "M_MSENS"  , "M_MSGOFF" , "M_MSGON"  , "M_MUSVOL" , "M_NEWG"   ,
		"M_NGAME"  , "M_NMARE"  , "M_OPTION" , "M_OPTTTL" , "M_PAUSE"  , "M_QUITG"  ,
		"M_RDTHIS" , "M_ROUGH"  , "M_SAVEG"  , "M_SCRNSZ" , "M_SFXVOL" , "M_SGTTL"  ,
		"M_SKILL"  , "M_SKULL1" , "M_SKULL2" , "M_SVOL"   , "M_THERML" , "M_THERMM" ,
		"M_THERMO" , "M_THERMR" , "M_ULTRA"  , "PFUB1"    , "PFUB2"    , "STARMS"   ,
		"STBAR"    , "STCDROM"  , "STCFN033" , "STCFN034" , "STCFN035" , "STCFN036" ,
		"STCFN037" , "STCFN038" , "STCFN039" , "STCFN040" , "STCFN041" , "STCFN042" ,
		"STCFN043" , "STCFN044" , "STCFN045" , "STCFN046" , "STCFN047" , "STCFN048" ,
		"STCFN049" , "STCFN050" , "STCFN051" , "STCFN052" , "STCFN053" , "STCFN054" ,
		"STCFN055" , "STCFN056" , "STCFN057" , "STCFN058" , "STCFN059" , "STCFN060" ,
		"STCFN061" , "STCFN062" , "STCFN063" , "STCFN064" , "STCFN065" , "STCFN066" ,
		"STCFN067" , "STCFN068" , "STCFN069" , "STCFN070" , "STCFN071" , "STCFN072" ,
		"STCFN073" , "STCFN074" , "STCFN075" , "STCFN076" , "STCFN077" , "STCFN078" ,
		"STCFN079" , "STCFN080" , "STCFN081" , "STCFN082" , "STCFN083" , "STCFN084" ,
		"STCFN085" , "STCFN086" , "STCFN087" , "STCFN088" , "STCFN089" , "STCFN090" ,
		"STCFN091" , "STCFN092" , "STCFN093" , "STCFN094" , "STCFN095" , "STCFN121" ,
		"STDISK"   , "STFB0"    , "STFB1"    , "STFB2"    , "STFB3"    , "STFDEAD0" ,
		"STFEVL0"  , "STFEVL1"  , "STFEVL2"  , "STFEVL3"  , "STFEVL4"  , "STFGOD0"  ,
		"STFKILL0" , "STFKILL1" , "STFKILL2" , "STFKILL3" , "STFKILL4" , "STFOUCH0" ,
		"STFOUCH1" , "STFOUCH2" , "STFOUCH3" , "STFOUCH4" , "STFST00"  , "STFST01"  ,
		"STFST02"  , "STFST10"  , "STFST11"  , "STFST12"  , "STFST20"  , "STFST21"  ,
		"STFST22"  , "STFST30"  , "STFST31"  , "STFST32"  , "STFST40"  , "STFST41"  ,
		"STFST42"  , "STFTL00"  , "STFTL10"  , "STFTL20"  , "STFTL30"  , "STFTL40"  ,
		"STFTR00"  , "STFTR10"  , "STFTR20"  , "STFTR30"  , "STFTR40"  , "STGNUM0"  ,
		"STGNUM1"  , "STGNUM2"  , "STGNUM3"  , "STGNUM4"  , "STGNUM5"  , "STGNUM6"  ,
		"STGNUM7"  , "STGNUM8"  , "STGNUM9"  , "STKEYS0"  , "STKEYS1"  , "STKEYS2"  ,
		"STKEYS3"  , "STKEYS4"  , "STKEYS5"  , "STPB0"    , "STPB1"    , "STPB2"    ,
		"STPB3"    , "STTMINUS" , "STTNUM0"  , "STTNUM1"  , "STTNUM2"  , "STTNUM3"  ,
		"STTNUM4"  , "STTNUM5"  , "STTNUM6"  , "STTNUM7"  , "STTNUM8"  , "STTNUM9"  ,
		"STTPRCNT" , "STYSNUM0" , "STYSNUM1" , "STYSNUM2" , "STYSNUM3" , "STYSNUM4" ,
		"STYSNUM5" , "STYSNUM6" , "STYSNUM7" , "STYSNUM8" , "STYSNUM9" , "TITLEPIC" ,
		"VICTORY2" , "WIA00000" , "WIA00001" , "WIA00002" , "WIA00100" , "WIA00101" ,
		"WIA00102" , "WIA00200" , "WIA00201" , "WIA00202" , "WIA00300" , "WIA00301" ,
		"WIA00302" , "WIA00400" , "WIA00401" , "WIA00402" , "WIA00500" , "WIA00501" ,
		"WIA00502" , "WIA00600" , "WIA00601" , "WIA00602" , "WIA00700" , "WIA00701" ,
		"WIA00702" , "WIA00800" , "WIA00801" , "WIA00802" , "WIA00900" , "WIA00901" ,
		"WIA00902" , "WIA10000" , "WIA10100" , "WIA10200" , "WIA10300" , "WIA10400" ,
		"WIA10500" , "WIA10600" , "WIA10700" , "WIA10701" , "WIA10702" , "WIA20000" ,
		"WIA20001" , "WIA20002" , "WIA20100" , "WIA20101" , "WIA20102" , "WIA20200" ,
		"WIA20201" , "WIA20202" , "WIA20300" , "WIA20301" , "WIA20302" , "WIA20400" ,
		"WIA20401" , "WIA20402" , "WIA20500" , "WIA20501" , "WIA20502" , "WIBP1"    ,
		"WIBP2"    , "WIBP3"    , "WIBP4"    , "WICOLON"  , "WIENTER"  , "WIF"      ,
		"WIFRGS"   , "WIKILRS"  , "WILV00"   , "WILV01"   , "WILV02"   , "WILV03"   ,
		"WILV04"   , "WILV05"   , "WILV06"   , "WILV07"   , "WILV08"   , "WILV10"   ,
		"WILV11"   , "WILV12"   , "WILV13"   , "WILV14"   , "WILV15"   , "WILV16"   ,
		"WILV17"   , "WILV18"   , "WILV20"   , "WILV21"   , "WILV22"   , "WILV23"   ,
		"WILV24"   , "WILV25"   , "WILV26"   , "WILV27"   , "WILV28"   , "WILV30"   ,
		"WILV31"   , "WILV32"   , "WILV33"   , "WILV34"   , "WILV35"   , "WILV36"   ,
		"WILV37"   , "WILV38"   , "WIMAP0"   , "WIMAP1"   , "WIMAP2"   , "WIMINUS"  ,
		"WIMSTAR"  , "WIMSTT"   , "WINUM0"   , "WINUM1"   , "WINUM2"   , "WINUM3"   ,
		"WINUM4"   , "WINUM5"   , "WINUM6"   , "WINUM7"   , "WINUM8"   , "WINUM9"   ,
		"WIOSTF"   , "WIOSTI"   , "WIOSTK"   , "WIOSTS"   , "WIP1"     , "WIP2"     ,
		"WIP3"     , "WIP4"     , "WIPAR"    , "WIPCNT"   , "WISCRT2"  , "WISPLAT"  ,
		"WISUCKS"  , "WITIME"   , "WIURH0"   , "WIURH1"   , "WIVCTMS"
	};
	size_t i;
	for (i=0;i<NUMDOOM1GRAPHICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a DOOM2 graphic
static bool_t is_doom2graphic(const char *s)
{
#define NUMDOOM2GRAPHICS 292
	static const char *stuff[NUMDOOM2GRAPHICS] =
	{
		// Doom 2 IWAD graphic names (valid also for TNT and PLUTONIA)
		"AMMNUM0"  , "AMMNUM1"  , "AMMNUM2"  , "AMMNUM3"  , "AMMNUM4"  , "AMMNUM5"  ,
		"AMMNUM6"  , "AMMNUM7"  , "AMMNUM8"  , "AMMNUM9"  , "BOSSBACK" , "BRDR_B"   ,
		"BRDR_BL"  , "BRDR_BR"  , "BRDR_L"   , "BRDR_R"   , "BRDR_T"   , "BRDR_TL"  ,
		"BRDR_TR"  , "CREDIT"   , "CWILV00"  , "CWILV01"  , "CWILV02"  , "CWILV03"  ,
		"CWILV04"  , "CWILV05"  , "CWILV06"  , "CWILV07"  , "CWILV08"  , "CWILV09"  ,
		"CWILV10"  , "CWILV11"  , "CWILV12"  , "CWILV13"  , "CWILV14"  , "CWILV15"  ,
		"CWILV16"  , "CWILV17"  , "CWILV18"  , "CWILV19"  , "CWILV20"  , "CWILV21"  ,
		"CWILV22"  , "CWILV23"  , "CWILV24"  , "CWILV25"  , "CWILV26"  , "CWILV27"  ,
		"CWILV28"  , "CWILV29"  , "CWILV30"  , "CWILV31"  , "HELP"     , "INTERPIC" ,
		"M_DETAIL" , "M_DISOPT" , "M_DISP"   , "M_DOOM"   , "M_ENDGAM" , "M_EPI1"   ,
		"M_EPI2"   , "M_EPI3"   , "M_EPISOD" , "M_GDHIGH" , "M_GDLOW"  , "M_HURT"   ,
		"M_JKILL"  , "M_LGTTL"  , "M_LOADG"  , "M_LSCNTR" , "M_LSLEFT" , "M_LSRGHT" ,
		"M_MESSG"  , "M_MSENS"  , "M_MSGOFF" , "M_MSGON"  , "M_MUSVOL" , "M_NEWG"   ,
		"M_NGAME"  , "M_NMARE"  , "M_OPTION" , "M_OPTTTL" , "M_PAUSE"  , "M_QUITG"  ,
		"M_RDTHIS" , "M_ROUGH"  , "M_SAVEG"  , "M_SCRNSZ" , "M_SFXVOL" , "M_SGTTL"  ,
		"M_SKILL"  , "M_SKULL1" , "M_SKULL2" , "M_SVOL"   , "M_THERML" , "M_THERMM" ,
		"M_THERMO" , "M_THERMR" , "M_ULTRA"  , "STARMS"   , "STBAR"    , "STCDROM"  ,
		"STCFN033" , "STCFN034" , "STCFN035" , "STCFN036" , "STCFN037" , "STCFN038" ,
		"STCFN039" , "STCFN040" , "STCFN041" , "STCFN042" , "STCFN043" , "STCFN044" ,
		"STCFN045" , "STCFN046" , "STCFN047" , "STCFN048" , "STCFN049" , "STCFN050" ,
		"STCFN051" , "STCFN052" , "STCFN053" , "STCFN054" , "STCFN055" , "STCFN056" ,
		"STCFN057" , "STCFN058" , "STCFN059" , "STCFN060" , "STCFN061" , "STCFN062" ,
		"STCFN063" , "STCFN064" , "STCFN065" , "STCFN066" , "STCFN067" , "STCFN068" ,
		"STCFN069" , "STCFN070" , "STCFN071" , "STCFN072" , "STCFN073" , "STCFN074" ,
		"STCFN075" , "STCFN076" , "STCFN077" , "STCFN078" , "STCFN079" , "STCFN080" ,
		"STCFN081" , "STCFN082" , "STCFN083" , "STCFN084" , "STCFN085" , "STCFN086" ,
		"STCFN087" , "STCFN088" , "STCFN089" , "STCFN090" , "STCFN091" , "STCFN092" ,
		"STCFN093" , "STCFN094" , "STCFN095" , "STCFN121" , "STDISK"   , "STFB0"    ,
		"STFB1"    , "STFB2"    , "STFB3"    , "STFDEAD0" , "STFEVL0"  , "STFEVL1"  ,
		"STFEVL2"  , "STFEVL3"  , "STFEVL4"  , "STFGOD0"  , "STFKILL0" , "STFKILL1" ,
		"STFKILL2" , "STFKILL3" , "STFKILL4" , "STFOUCH0" , "STFOUCH1" , "STFOUCH2" ,
		"STFOUCH3" , "STFOUCH4" , "STFST00"  , "STFST01"  , "STFST02"  , "STFST10"  ,
		"STFST11"  , "STFST12"  , "STFST20"  , "STFST21"  , "STFST22"  , "STFST30"  ,
		"STFST31"  , "STFST32"  , "STFST40"  , "STFST41"  , "STFST42"  , "STFTL00"  ,
		"STFTL10"  , "STFTL20"  , "STFTL30"  , "STFTL40"  , "STFTR00"  , "STFTR10"  ,
		"STFTR20"  , "STFTR30"  , "STFTR40"  , "STGNUM0"  , "STGNUM1"  , "STGNUM2"  ,
		"STGNUM3"  , "STGNUM4"  , "STGNUM5"  , "STGNUM6"  , "STGNUM7"  , "STGNUM8"  ,
		"STGNUM9"  , "STKEYS0"  , "STKEYS1"  , "STKEYS2"  , "STKEYS3"  , "STKEYS4"  ,
		"STKEYS5"  , "STPB0"    , "STPB1"    , "STPB2"    , "STPB3"    , "STTMINUS" ,
		"STTNUM0"  , "STTNUM1"  , "STTNUM2"  , "STTNUM3"  , "STTNUM4"  , "STTNUM5"  ,
		"STTNUM6"  , "STTNUM7"  , "STTNUM8"  , "STTNUM9"  , "STTPRCNT" , "STYSNUM0" ,
		"STYSNUM1" , "STYSNUM2" , "STYSNUM3" , "STYSNUM4" , "STYSNUM5" , "STYSNUM6" ,
		"STYSNUM7" , "STYSNUM8" , "STYSNUM9" , "TITLEPIC" , "WIBP1"    , "WIBP2"    ,
		"WIBP3"    , "WIBP4"    , "WICOLON"  , "WIENTER"  , "WIF"      , "WIFRGS"   ,
		"WIKILRS"  , "WIMINUS"  , "WIMSTAR"  , "WIMSTT"   , "WINUM0"   , "WINUM1"   ,
		"WINUM2"   , "WINUM3"   , "WINUM4"   , "WINUM5"   , "WINUM6"   , "WINUM7"   ,
		"WINUM8"   , "WINUM9"   , "WIOSTF"   , "WIOSTI"   , "WIOSTK"   , "WIOSTS"   ,
		"WIP1"     , "WIP2"     , "WIP3"     , "WIP4"     , "WIPAR"    , "WIPCNT"   ,
		"WISCRT2"  , "WISUCKS"  , "WITIME"   , "WIVCTMS"
	};
	size_t i;
	for (i=0;i<NUMDOOM2GRAPHICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HERETIC graphic
static bool_t is_hereticgraphic(const char *s)
{
#define NUMHERETICGRAPHICS 142
	static const char *stuff[NUMHERETICGRAPHICS] =
	{
		// Heretic IWAD graphic names
		"ADVISOR"  , "ARMCLEAR" , "ARTIBOX"  , "BARBACK"  , "BKEYICON" , "BLACKSQ"  ,
		"BORDB"    , "BORDBL"   , "BORDBR"   , "BORDL"    , "BORDR"    , "BORDT"    ,
		"BORDTL"   , "BORDTR"   , "CHAIN"    , "CHAINBAC" , "FACEA0"   , "FACEA1"   ,
		"FACEA2"   , "FACEA3"   , "FACEB0"   , "FACEB1"   , "FACEB2"   , "FACEB3"   ,
		"GKEYICON" , "GOD1"     , "GOD2"     , "IN_X"     , "IN_YAH"   , "IN0"      ,
		"IN1"      , "IN2"      , "IN3"      , "IN4"      , "IN5"      , "IN6"      ,
		"IN7"      , "IN8"      , "IN9"      , "INAMBOW"  , "INAMBST"  , "INAMGLD"  ,
		"INAMLOB"  , "INAMPNX"  , "INAMRAM"  , "INVBAR"   , "INVGEML1" , "INVGEML2" ,
		"INVGEMR1" , "INVGEMR2" , "LAME"     , "LIFEBAR"  , "LIFEGEM0" , "LIFEGEM1" ,
		"LIFEGEM2" , "LIFEGEM3" , "LTFACE"   , "LTFCTOP"  , "M_FSLOT"  , "M_HTIC"   ,
		"M_SKL00"  , "M_SKL01"  , "M_SKL02"  , "M_SKL03"  , "M_SKL04"  , "M_SKL05"  ,
		"M_SKL06"  , "M_SKL07"  , "M_SKL08"  , "M_SKL09"  , "M_SKL10"  , "M_SKL11"  ,
		"M_SKL12"  , "M_SKL13"  , "M_SKL14"  , "M_SKL15"  , "M_SKL16"  , "M_SKL17"  ,
		"M_SLCTR1" , "M_SLCTR2" , "M_SLDKB"  , "M_SLDLT"  , "M_SLDMD1" , "M_SLDMD2" ,
		"M_SLDRT"  , "MAPE1"    , "MAPE2"    , "MAPE3"    , "NEGNUM"   , "PAUSED"   ,
		"RTFACE"   , "RTFCTOP"  , "SELECTBO" , "SMALLIN0" , "SMALLIN1" , "SMALLIN2" ,
		"SMALLIN3" , "SMALLIN4" , "SMALLIN5" , "SMALLIN6" , "SMALLIN7" , "SMALLIN8" ,
		"SMALLIN9" , "SPFLY0"   , "SPFLY1"   , "SPFLY10"  , "SPFLY11"  , "SPFLY12"  ,
		"SPFLY13"  , "SPFLY14"  , "SPFLY15"  , "SPFLY2"   , "SPFLY3"   , "SPFLY4"   ,
		"SPFLY5"   , "SPFLY6"   , "SPFLY7"   , "SPFLY8"   , "SPFLY9"   , "SPINBK0"  ,
		"SPINBK1"  , "SPINBK10" , "SPINBK11" , "SPINBK12" , "SPINBK13" , "SPINBK14" ,
		"SPINBK15" , "SPINBK2"  , "SPINBK3"  , "SPINBK4"  , "SPINBK5"  , "SPINBK6"  ,
		"SPINBK7"  , "SPINBK8"  , "SPINBK9"  , "STATBAR"  , "USEARTIA" , "USEARTIB" ,
		"USEARTIC" , "USEARTID" , "USEARTIE" , "YKEYICON"
	};
	size_t i;
	for (i=0;i<NUMHERETICGRAPHICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HEXEN graphic (valid also for DEATHKINGS)
static bool_t is_hexengraphic(const char *s)
{
#define NUMHEXENGRAPHICS 242
	static const char *stuff[NUMHEXENGRAPHICS] =
	{
		// Hexen IWAD graphic names
		"ADVISOR"  , "ARMCLS"   , "ARMSLOT1" , "ARMSLOT2" , "ARMSLOT3" , "ARMSLOT4" ,
		"ARTIBOX"  , "ARTICLS"  , "BORDB"    , "BORDBL"   , "BORDBR"   , "BORDL"    ,
		"BORDR"    , "BORDT"    , "BORDTL"   , "BORDTR"   , "CHAIN"    , "CHAIN2"   ,
		"CHAIN3"   , "CHESSALL" , "CHESSC"   , "CHESSM"   , "H2BAR"    , "H2TOP"    ,
		"IN0"      , "IN1"      , "IN2"      , "IN3"      , "IN4"      , "IN5"      ,
		"IN6"      , "IN7"      , "IN8"      , "IN9"      , "INRED0"   , "INRED1"   ,
		"INRED2"   , "INRED3"   , "INRED4"   , "INRED5"   , "INRED6"   , "INRED7"   ,
		"INRED8"   , "INRED9"   , "INVBAR"   , "INVGEML1" , "INVGEML2" , "INVGEMR1" ,
		"INVGEMR2" , "KEYBAR"   , "KEYSLOT1" , "KEYSLOT2" , "KEYSLOT3" , "KEYSLOT4" ,
		"KEYSLOT5" , "KEYSLOT6" , "KEYSLOT7" , "KEYSLOT8" , "KEYSLOT9" , "KEYSLOTA" ,
		"KEYSLOTB" , "KILLS"    , "LFEDGE"   , "LIFEGEM"  , "LIFEGMC1" , "LIFEGMC2" ,
		"LIFEGMC3" , "LIFEGMC4" , "LIFEGMC5" , "LIFEGMC6" , "LIFEGMC7" , "LIFEGMC8" ,
		"LIFEGMF2" , "LIFEGMF3" , "LIFEGMF4" , "LIFEGMF5" , "LIFEGMF6" , "LIFEGMF7" ,
		"LIFEGMF8" , "LIFEGMM1" , "LIFEGMM2" , "LIFEGMM3" , "LIFEGMM4" , "LIFEGMM5" ,
		"LIFEGMM6" , "LIFEGMM7" , "LIFEGMM8" , "LOADICON" , "M_CBOX"   , "M_CWALK1" ,
		"M_CWALK2" , "M_CWALK3" , "M_CWALK4" , "M_FBOX"   , "M_FSLOT"  , "M_FWALK1" ,
		"M_FWALK2" , "M_FWALK3" , "M_FWALK4" , "M_HTIC"   , "M_MBOX"   , "M_MWALK1" ,
		"M_MWALK2" , "M_MWALK3" , "M_MWALK4" , "M_SKL00"  , "M_SKL01"  , "M_SKL02"  ,
		"M_SKL03"  , "M_SKL04"  , "M_SKL05"  , "M_SKL06"  , "M_SKL07"  , "M_SKL08"  ,
		"M_SKL09"  , "M_SKL10"  , "M_SKL11"  , "M_SKL12"  , "M_SKL13"  , "M_SKL14"  ,
		"M_SKL15"  , "M_SKL16"  , "M_SKL17"  , "M_SLCTR1" , "M_SLCTR2" , "M_SLDKB"  ,
		"M_SLDLT"  , "M_SLDMD1" , "M_SLDMD2" , "M_SLDRT"  , "MANABRT1" , "MANABRT2" ,
		"MANACLS"  , "MANADIM1" , "MANADIM2" , "MANAVL1"  , "MANAVL1D" , "MANAVL2"  ,
		"MANAVL2D" , "NEGNUM"   , "PAUSED"   , "RTEDGE"   , "SAVEICON" , "SELECTBO" ,
		"SMALLIN0" , "SMALLIN1" , "SMALLIN2" , "SMALLIN3" , "SMALLIN4" , "SMALLIN5" ,
		"SMALLIN6" , "SMALLIN7" , "SMALLIN8" , "SMALLIN9" , "SPBOOT0"  , "SPBOOT1"  ,
		"SPBOOT10" , "SPBOOT11" , "SPBOOT12" , "SPBOOT13" , "SPBOOT14" , "SPBOOT15" ,
		"SPBOOT2"  , "SPBOOT3"  , "SPBOOT4"  , "SPBOOT5"  , "SPBOOT6"  , "SPBOOT7"  ,
		"SPBOOT8"  , "SPBOOT9"  , "SPFLY0"   , "SPFLY1"   , "SPFLY10"  , "SPFLY11"  ,
		"SPFLY12"  , "SPFLY13"  , "SPFLY14"  , "SPFLY15"  , "SPFLY2"   , "SPFLY3"   ,
		"SPFLY4"   , "SPFLY5"   , "SPFLY6"   , "SPFLY7"   , "SPFLY8"   , "SPFLY9"   ,
		"SPMINO0"  , "SPMINO1"  , "SPMINO10" , "SPMINO11" , "SPMINO12" , "SPMINO13" ,
		"SPMINO14" , "SPMINO15" , "SPMINO2"  , "SPMINO3"  , "SPMINO4"  , "SPMINO5"  ,
		"SPMINO6"  , "SPMINO7"  , "SPMINO8"  , "SPMINO9"  , "SPSHLD0"  , "SPSHLD1"  ,
		"SPSHLD10" , "SPSHLD11" , "SPSHLD12" , "SPSHLD13" , "SPSHLD14" , "SPSHLD15" ,
		"SPSHLD2"  , "SPSHLD3"  , "SPSHLD4"  , "SPSHLD5"  , "SPSHLD6"  , "SPSHLD7"  ,
		"SPSHLD8"  , "SPSHLD9"  , "STATBAR"  , "TALLYLFT" , "TALLYTOP" , "TELEICON" ,
		"USEARTIA" , "USEARTIB" , "USEARTIC" , "USEARTID" , "USEARTIE" , "WPFULL0"  ,
		"WPFULL1"  , "WPFULL2"  , "WPIECEC1" , "WPIECEC2" , "WPIECEC3" , "WPIECEF1" ,
		"WPIECEF2" , "WPIECEF3" , "WPIECEM1" , "WPIECEM2" , "WPIECEM3" , "WPSLOT0"  ,
		"WPSLOT1"  , "WPSLOT2"
	};
	size_t i;
	for (i=0;i<NUMHEXENGRAPHICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE graphic
static bool_t is_strifegraphic(const char *s)
{
#define NUMSTRIFEGRAPHICS 375
	static const char *stuff[NUMSTRIFEGRAPHICS] =
	{
		// Strife IWAD graphic names
		"AMMNUM0"  , "AMMNUM1"  , "AMMNUM2"  , "AMMNUM3"  , "AMMNUM4"  , "AMMNUM5"  ,
		"AMMNUM6"  , "AMMNUM7"  , "AMMNUM8"  , "AMMNUM9"  , "BRDR_B"   , "BRDR_BL"  ,
		"BRDR_BR"  , "BRDR_L"   , "BRDR_R"   , "BRDR_T"   , "BRDR_TL"  , "BRDR_TR"  ,
		"CREDIT"   , "HELP0"    , "HELP1"    , "HELP2"    , "HELP3"    , "I_ANKH"   ,
		"I_AQID"   , "I_ARM1"   , "I_ARM2"   , "I_BCRY"   , "I_BEAC"   , "I_BFLM"   ,
		"I_BKPK"   , "I_BLIT"   , "I_BLTK"   , "I_BOAT"   , "I_BRY1"   , "I_CHAP"   ,
		"I_CHST"   , "I_COIN"   , "I_COMM"   , "I_COUP"   , "I_CRD1"   , "I_CRD2"   ,
		"I_CRYS"   , "I_EARS"   , "I_EPI1"   , "I_EPI2"   , "I_FUBR"   , "I_FULL"   ,
		"I_FUSL"   , "I_GASG"   , "I_GOID"   , "I_GRN1"   , "I_GRN2"   , "I_GUNT"   ,
		"I_GYID"   , "I_HAND"   , "I_HELT"   , "I_KY1G"   , "I_KY2S"   , "I_KY3B"   ,
		"I_MASK"   , "I_MDKT"   , "I_MINE"   , "I_OFIC"   , "I_ORAC"   , "I_OTOK"   ,
		"I_PMUP"   , "I_PQRL"   , "I_PRIS"   , "I_PROC"   , "I_PWR1"   , "I_PWR2"   ,
		"I_PWR3"   , "I_RATT"   , "I_RCRY"   , "I_REBL"   , "I_RELC"   , "I_REPT"   ,
		"I_RING"   , "I_ROKT"   , "I_SECK"   , "I_SGL1"   , "I_SGL2"   , "I_SGL3"   ,
		"I_SGL4"   , "I_SGL5"   , "I_SHD1"   , "I_STMP"   , "I_TARG"   , "I_TOKN"   ,
		"I_TPAS"   , "I_TUNL"   , "I_UNIF"   , "I_WARE"   , "I_XPRK"   , "I_XQRL"   ,
		"INVBACK"  , "INVCURS"  , "INVFONG%" , "INVFONG0" , "INVFONG1" , "INVFONG2" ,
		"INVFONG3" , "INVFONG4" , "INVFONG5" , "INVFONG6" , "INVFONG7" , "INVFONG8" ,
		"INVFONG9" , "INVFONY%" , "INVFONY0" , "INVFONY1" , "INVFONY2" , "INVFONY3" ,
		"INVFONY4" , "INVFONY5" , "INVFONY6" , "INVFONY7" , "INVFONY8" , "INVFONY9" ,
		"INVPBAK"  , "INVPBAK2" , "INVPOP"   , "INVPOP2"  , "INVTOP"   , "M_CURS1"  ,
		"M_CURS2"  , "M_CURS3"  , "M_CURS4"  , "M_CURS5"  , "M_CURS6"  , "M_CURS7"  ,
		"M_CURS8"  , "M_DERWIN" , "M_DKWRKR" , "M_ENDGAM" , "M_FALSP1" , "M_FALSP2" ,
		"M_FALSP3" , "M_GEOFF"  , "M_GUARD"  , "M_GUARD2" , "M_GUARD3" , "M_GUARD4" ,
		"M_GUARD5" , "M_GUARD6" , "M_HURT"   , "M_JKILL"  , "M_JUDGE"  , "M_KETRIC" ,
		"M_KEVIN"  , "M_LEDR0"  , "M_LOADG"  , "M_LSCNTR" , "M_LSLEFT" , "M_LSRGHT" ,
		"M_MAIN"   , "M_MCGUFF" , "M_MSENS"  , "M_MUSVOL" , "M_NGAME"  , "M_NMARE"  ,
		"M_OPTION" , "M_ORACLE" , "M_PAUSE"  , "M_PEAS1"  , "M_PEAS7"  , "M_PRISNR" ,
		"M_QUINCY" , "M_QUITG"  , "M_RDTHIS" , "M_RETRIC" , "M_RICHTR" , "M_ROUGH"  ,
		"M_SAMMIS" , "M_SAVEG"  , "M_SCRNSZ" , "M_SFXVOL" , "M_SKILL"  , "M_STRIFE" ,
		"M_SVOL"   , "M_TEKBRN" , "M_TEKGRY" , "M_TEKTAN" , "M_THERML" , "M_THERMM" ,
		"M_THERMO" , "M_THERMR" , "M_ULTRA"  , "M_VOIVOL" , "M_WARDEN" , "M_WERAN"  ,
		"M_WORNER" , "PANEL0"   , "PANEL1"   , "PANEL2"   , "PANEL3"   , "PANEL4"   ,
		"PANEL5"   , "PANEL6"   , "PANEL7"   , "PLMNUM0"  , "PLMNUM1"  , "PLMNUM2"  ,
		"PLMNUM3"  , "PLMNUM4"  , "PLMNUM5"  , "PLMNUM6"  , "PLMNUM7"  , "PLMNUM8"  ,
		"PLMNUM9"  , "RGELOGO"  , "SS2F1"    , "SS2F2"    , "SS2F3"    , "SS2F4"    ,
		"SS3F1"    , "SS3F2"    , "SS3F3"    , "SS3F4"    , "SS4F1"    , "SS4F2"    ,
		"SS4F3"    , "SS4F4"    , "SS5F1"    , "SS5F2"    , "SS5F3"    , "SS6F1"    ,
		"SS6F2"    , "SS6F3"    , "STBACK01" , "STBACK02" , "STBACK03" , "STBACK04" ,
		"STBACK05" , "STBACK06" , "STBACK07" , "STBACK08" , "STBFN033" , "STBFN034" ,
		"STBFN035" , "STBFN036" , "STBFN037" , "STBFN038" , "STBFN039" , "STBFN040" ,
		"STBFN041" , "STBFN042" , "STBFN043" , "STBFN044" , "STBFN045" , "STBFN046" ,
		"STBFN047" , "STBFN048" , "STBFN049" , "STBFN050" , "STBFN051" , "STBFN052" ,
		"STBFN053" , "STBFN054" , "STBFN055" , "STBFN056" , "STBFN057" , "STBFN058" ,
		"STBFN059" , "STBFN060" , "STBFN061" , "STBFN062" , "STBFN063" , "STBFN064" ,
		"STBFN065" , "STBFN066" , "STBFN067" , "STBFN068" , "STBFN069" , "STBFN070" ,
		"STBFN071" , "STBFN072" , "STBFN073" , "STBFN074" , "STBFN075" , "STBFN076" ,
		"STBFN077" , "STBFN078" , "STBFN079" , "STBFN080" , "STBFN081" , "STBFN082" ,
		"STBFN083" , "STBFN084" , "STBFN085" , "STBFN086" , "STBFN087" , "STBFN088" ,
		"STBFN089" , "STBFN090" , "STBFN091" , "STBFN092" , "STBFN093" , "STBFN094" ,
		"STBFN095" , "STCFN033" , "STCFN034" , "STCFN035" , "STCFN036" , "STCFN037" ,
		"STCFN038" , "STCFN039" , "STCFN040" , "STCFN041" , "STCFN042" , "STCFN043" ,
		"STCFN044" , "STCFN045" , "STCFN046" , "STCFN047" , "STCFN048" , "STCFN049" ,
		"STCFN050" , "STCFN051" , "STCFN052" , "STCFN053" , "STCFN054" , "STCFN055" ,
		"STCFN056" , "STCFN057" , "STCFN058" , "STCFN059" , "STCFN060" , "STCFN061" ,
		"STCFN062" , "STCFN063" , "STCFN064" , "STCFN065" , "STCFN066" , "STCFN067" ,
		"STCFN068" , "STCFN069" , "STCFN070" , "STCFN071" , "STCFN072" , "STCFN073" ,
		"STCFN074" , "STCFN075" , "STCFN076" , "STCFN077" , "STCFN078" , "STCFN079" ,
		"STCFN080" , "STCFN081" , "STCFN082" , "STCFN083" , "STCFN084" , "STCFN085" ,
		"STCFN086" , "STCFN087" , "STCFN088" , "STCFN089" , "STCFN090" , "STCFN091" ,
		"STCFN092" , "STCFN093" , "STCFN094" , "STCFN095" , "STCOLOR1" , "STCOLOR2" ,
		"STCOLOR3" , "STCOLOR4" , "STCOLOR5" , "STCOLOR6" , "STCOLOR7" , "STCOLOR8" ,
		"STDISK"   , "TITLEPIC" , "VELLOGO"
	};
	size_t i;
	for (i=0;i<NUMSTRIFEGRAPHICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a DOOM PC Speaker sound
static bool_t is_doom1pcsfx(const char *s)
{
#define NUMDOOM1PCSFXS 67
	static const char *stuff[NUMDOOM1PCSFXS] =
	{
		// Doom 1 IWAD sound names
		"DPBAREXP" , "DPBDCLS"  , "DPBDOPN"  , "DPBFG"    , "DPBGACT"  , "DPBGDTH1" ,
		"DPBGDTH2" , "DPBGSIT1" , "DPBGSIT2" , "DPBRSDTH" , "DPBRSSIT" , "DPCACDTH" ,
		"DPCACSIT" , "DPCLAW"   , "DPCYBDTH" , "DPCYBSIT" , "DPDMACT"  , "DPDMPAIN" ,
		"DPDORCLS" , "DPDOROPN" , "DPFIRSHT" , "DPFIRXPL" , "DPGETPOW" , "DPHOOF"   ,
		"DPITEMUP" , "DPITMBK"  , "DPMETAL"  , "DPNOWAY"  , "DPOOF"    , "DPPDIEHI" ,
		"DPPISTOL" , "DPPLASMA" , "DPPLDETH" , "DPPLPAIN" , "DPPODTH1" , "DPPODTH2" ,
		"DPPODTH3" , "DPPOPAIN" , "DPPOSACT" , "DPPOSIT1" , "DPPOSIT2" , "DPPOSIT3" ,
		"DPPSTART" , "DPPSTOP"  , "DPPUNCH"  , "DPRLAUNC" , "DPRXPLOD" , "DPSAWFUL" ,
		"DPSAWHIT" , "DPSAWIDL" , "DPSAWUP"  , "DPSGCOCK" , "DPSGTATK" , "DPSGTDTH" ,
		"DPSGTSIT" , "DPSHOTGN" , "DPSKLATK" , "DPSKLDTH" , "DPSLOP"   , "DPSPIDTH" ,
		"DPSPISIT" , "DPSTNMOV" , "DPSWTCHN" , "DPSWTCHX" , "DPTELEPT" , "DPTINK"   ,
		"DPWPNUP"
	};
	size_t i;
	for (i=0;i<NUMDOOM1PCSFXS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a DOOM2 PC Speaker sound
static bool_t is_doom2pcsfx(const char *s)
{
#define NUMDOOM2PCSFXS 107
	static const char *stuff[NUMDOOM2PCSFXS] =
	{
		// Doom 2 IWAD sound names (valid also for TNT and PLUTONIA)
		"DPBAREXP" , "DPBDCLS"  , "DPBDOPN"  , "DPBFG"    , "DPBGACT"  , "DPBGDTH1" ,
		"DPBGDTH2" , "DPBGSIT1" , "DPBGSIT2" , "DPBOSCUB" , "DPBOSDTH" , "DPBOSPIT" ,
		"DPBOSPN"  , "DPBOSSIT" , "DPBRSDTH" , "DPBRSSIT" , "DPBSPACT" , "DPBSPDTH" ,
		"DPBSPSIT" , "DPBSPWLK" , "DPCACDTH" , "DPCACSIT" , "DPCLAW"   , "DPCYBDTH" ,
		"DPCYBSIT" , "DPDBCLS"  , "DPDBLOAD" , "DPDBOPN"  , "DPDMACT"  , "DPDMPAIN" ,
		"DPDORCLS" , "DPDOROPN" , "DPDSHTGN" , "DPFIRSHT" , "DPFIRXPL" , "DPFLAME"  ,
		"DPFLAMST" , "DPGETPOW" , "DPHOOF"   , "DPITEMUP" , "DPITMBK"  , "DPKEENDT" ,
		"DPKEENPN" , "DPKNTDTH" , "DPKNTSIT" , "DPMANATK" , "DPMANDTH" , "DPMANSIT" ,
		"DPMETAL"  , "DPMNPAIN" , "DPNOWAY"  , "DPOOF"    , "DPPDIEHI" , "DPPEDTH"  ,
		"DPPEPAIN" , "DPPESIT"  , "DPPISTOL" , "DPPLASMA" , "DPPLDETH" , "DPPLPAIN" ,
		"DPPODTH1" , "DPPODTH2" , "DPPODTH3" , "DPPOPAIN" , "DPPOSACT" , "DPPOSIT1" ,
		"DPPOSIT2" , "DPPOSIT3" , "DPPSTART" , "DPPSTOP"  , "DPPUNCH"  , "DPRADIO"  ,
		"DPRLAUNC" , "DPRXPLOD" , "DPSAWFUL" , "DPSAWHIT" , "DPSAWIDL" , "DPSAWUP"  ,
		"DPSGCOCK" , "DPSGTATK" , "DPSGTDTH" , "DPSGTSIT" , "DPSHOTGN" , "DPSKEACT" ,
		"DPSKEATK" , "DPSKEDTH" , "DPSKEPCH" , "DPSKESIT" , "DPSKESWG" , "DPSKLATK" ,
		"DPSKLDTH" , "DPSLOP"   , "DPSPIDTH" , "DPSPISIT" , "DPSSDTH"  , "DPSSSIT"  ,
		"DPSTNMOV" , "DPSWTCHN" , "DPSWTCHX" , "DPTELEPT" , "DPTINK"   , "DPVILACT" ,
		"DPVILATK" , "DPVILDTH" , "DPVILSIT" , "DPVIPAIN" , "DPWPNUP"
	};
	size_t i;
	for (i=0;i<NUMDOOM2PCSFXS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE PC Speaker sound
static bool_t is_strifepcsfx(const char *s)
{
#define NUMSTRIFEPCSFXS 135
	static const char *stuff[NUMSTRIFEPCSFXS] =
	{
		// Strife IWAD sound names
		"DPAGRAC1" , "DPAGRAC2" , "DPAGRAC3" , "DPAGRAC4" , "DPAGRDPN" , "DPAGRDTH" ,
		"DPAGRSEE" , "DPAIRLCK" , "DPALARM"  , "DPALNACT" , "DPALNDTH" , "DPALNPN"  ,
		"DPALNSEE" , "DPAMALN1" , "DPAMALN2" , "DPAMALN3" , "DPAMALN4" , "DPAMALN5" ,
		"DPAMALN6" , "DPAMBBAR" , "DPAMBPPL" , "DPBAREXP" , "DPBDCLS"  , "DPBDOPN"  ,
		"DPBGLASS" , "DPBURNME" , "DPCHAIN"  , "DPCHANT"  , "DPDIFOOL" , "DPDRCHNC" ,
		"DPDRCHNO" , "DPDRLMTC" , "DPDRLMTO" , "DPDRLWUD" , "DPDRSMTC" , "DPDRSMTO" ,
		"DPDRSTON" , "DPDRSWUD" , "DPDSRPTR" , "DPEXPLOD" , "DPFIRXPL" , "DPFLBURN" ,
		"DPFLIDL"  , "DPINQACT" , "DPINQDTH" , "DPINQJMP" , "DPINQSEE" , "DPITEMUP" ,
		"DPITMBK"  , "DPKEYCRD" , "DPLGFIRE" , "DPLORPN"  , "DPLORSEE" , "DPMASK"   ,
		"DPMEATHT" , "DPMISLHT" , "DPMNALDT" , "DPMNALSE" , "DPMTALHT" , "DPNOWAY"  ,
		"DPOOF"    , "DPPCRUSH" , "DPPESPNA" , "DPPESPNB" , "DPPESPNC" , "DPPESPND" ,
		"DPPGRACT" , "DPPGRDAT" , "DPPGRDPN" , "DPPGRDTH" , "DPPGRSEE" , "DPPHOOT"  ,
		"DPPLASMA" , "DPPLDETH" , "DPPLPAIN" , "DPPLXDTH" , "DPPRGPN"  , "DPPROGAC" ,
		"DPPROTFL" , "DPPROTON" , "DPPSDTHA" , "DPPSDTHB" , "DPPSDTHC" , "DPPSTART" ,
		"DPPSTOP"  , "DPPULCHN" , "DPRADIO"  , "DPRATACT" , "DPRB2ACT" , "DPRB2DTH" ,
		"DPRB2PN"  , "DPRB2SEE" , "DPREACTR" , "DPREAVAT" , "DPREAVPN" , "DPREBACT" ,
		"DPREBDTH" , "DPREVACT" , "DPREVBLD" , "DPREVDTH" , "DPREVSEE" , "DPRFLITE" ,
		"DPRIFLE"  , "DPRLAUNC" , "DPSGLHIT" , "DPSIGIL"  , "DPSIGLUP" , "DPSLOP"   ,
		"DPSMFIRE" , "DPSNTACT" , "DPSNTDTH" , "DPSNTSEE" , "DPSPDATK" , "DPSPDWLK" ,
		"DPSPIDTH" , "DPSPISIT" , "DPSTATIC" , "DPSTNMOV" , "DPSWBOLT" , "DPSWISH"  ,
		"DPSWKNOB" , "DPSWSCAN" , "DPSWSTON" , "DPSWTCHN" , "DPTELEPT" , "DPTEND"   ,
		"DPVALVE"  , "DPWBRLDT" , "DPWDRIP"  , "DPWFALL"  , "DPWPNUP"  , "DPWRIVER" ,
		"DPWSPLSH" , "DPXBOW"   , "DPYEAH"
	};
	size_t i;
	for (i=0;i<NUMSTRIFEPCSFXS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a DOOM sound
static bool_t is_doom1sound(const char *s)
{
#define NUMDOOM1SOUNDS 67
	static const char *stuff[NUMDOOM1SOUNDS] =
	{
		// Doom 1 IWAD sound names
		"DSBAREXP" , "DSBDCLS"  , "DSBDOPN"  , "DSBFG"    , "DSBGACT"  , "DSBGDTH1" ,
		"DSBGDTH2" , "DSBGSIT1" , "DSBGSIT2" , "DSBRSDTH" , "DSBRSSIT" , "DSCACDTH" ,
		"DSCACSIT" , "DSCLAW"   , "DSCYBDTH" , "DSCYBSIT" , "DSDMACT"  , "DSDMPAIN" ,
		"DSDORCLS" , "DSDOROPN" , "DSFIRSHT" , "DSFIRXPL" , "DSGETPOW" , "DSHOOF"   ,
		"DSITEMUP" , "DSITMBK"  , "DSMETAL"  , "DSNOWAY"  , "DSOOF"    , "DSPDIEHI" ,
		"DSPISTOL" , "DSPLASMA" , "DSPLDETH" , "DSPLPAIN" , "DSPODTH1" , "DSPODTH2" ,
		"DSPODTH3" , "DSPOPAIN" , "DSPOSACT" , "DSPOSIT1" , "DSPOSIT2" , "DSPOSIT3" ,
		"DSPSTART" , "DSPSTOP"  , "DSPUNCH"  , "DSRLAUNC" , "DSRXPLOD" , "DSSAWFUL" ,
		"DSSAWHIT" , "DSSAWIDL" , "DSSAWUP"  , "DSSGCOCK" , "DSSGTATK" , "DSSGTDTH" ,
		"DSSGTSIT" , "DSSHOTGN" , "DSSKLATK" , "DSSKLDTH" , "DSSLOP"   , "DSSPIDTH" ,
		"DSSPISIT" , "DSSTNMOV" , "DSSWTCHN" , "DSSWTCHX" , "DSTELEPT" , "DSTINK"   ,
		"DSWPNUP"
	};
	size_t i;
	for (i=0;i<NUMDOOM1SOUNDS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a DOOM2 sound
static bool_t is_doom2sound(const char *s)
{
#define NUMDOOM2SOUNDS 107
	static const char *stuff[NUMDOOM2SOUNDS] =
	{
		// Doom 2 IWAD sound names (valid also for TNT and PLUTONIA)
		"DSBAREXP" , "DSBDCLS"  , "DSBDOPN"  , "DSBFG"    , "DSBGACT"  , "DSBGDTH1" ,
		"DSBGDTH2" , "DSBGSIT1" , "DSBGSIT2" , "DSBOSCUB" , "DSBOSDTH" , "DSBOSPIT" ,
		"DSBOSPN"  , "DSBOSSIT" , "DSBRSDTH" , "DSBRSSIT" , "DSBSPACT" , "DSBSPDTH" ,
		"DSBSPSIT" , "DSBSPWLK" , "DSCACDTH" , "DSCACSIT" , "DSCLAW"   , "DSCYBDTH" ,
		"DSCYBSIT" , "DSDBCLS"  , "DSDBLOAD" , "DSDBOPN"  , "DSDMACT"  , "DSDMPAIN" ,
		"DSDORCLS" , "DSDOROPN" , "DSDSHTGN" , "DSFIRSHT" , "DSFIRXPL" , "DSFLAME"  ,
		"DSFLAMST" , "DSGETPOW" , "DSHOOF"   , "DSITEMUP" , "DSITMBK"  , "DSKEENDT" ,
		"DSKEENPN" , "DSKNTDTH" , "DSKNTSIT" , "DSMANATK" , "DSMANDTH" , "DSMANSIT" ,
		"DSMETAL"  , "DSMNPAIN" , "DSNOWAY"  , "DSOOF"    , "DSPDIEHI" , "DSPEDTH"  ,
		"DSPEPAIN" , "DSPESIT"  , "DSPISTOL" , "DSPLASMA" , "DSPLDETH" , "DSPLPAIN" ,
		"DSPODTH1" , "DSPODTH2" , "DSPODTH3" , "DSPOPAIN" , "DSPOSACT" , "DSPOSIT1" ,
		"DSPOSIT2" , "DSPOSIT3" , "DSPSTART" , "DSPSTOP"  , "DSPUNCH"  , "DSRADIO"  ,
		"DSRLAUNC" , "DSRXPLOD" , "DSSAWFUL" , "DSSAWHIT" , "DSSAWIDL" , "DSSAWUP"  ,
		"DSSGCOCK" , "DSSGTATK" , "DSSGTDTH" , "DSSGTSIT" , "DSSHOTGN" , "DSSKEACT" ,
		"DSSKEATK" , "DSSKEDTH" , "DSSKEPCH" , "DSSKESIT" , "DSSKESWG" , "DSSKLATK" ,
		"DSSKLDTH" , "DSSLOP"   , "DSSPIDTH" , "DSSPISIT" , "DSSSDTH"  , "DSSSSIT"  ,
		"DSSTNMOV" , "DSSWTCHN" , "DSSWTCHX" , "DSTELEPT" , "DSTINK"   , "DSVILACT" ,
		"DSVILATK" , "DSVILDTH" , "DSVILSIT" , "DSVIPAIN" , "DSWPNUP"
	};
	size_t i;
	for (i=0;i<NUMDOOM2SOUNDS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HERETIC sound
static bool_t is_hereticsound(const char *s)
{
#define NUMHERETICSOUNDS 133
	static const char *stuff[NUMHERETICSOUNDS] =
	{
		// Heretic IWAD sound names
		"AMB1"     , "AMB10"    , "AMB11"    , "AMB2"     , "AMB3"     , "AMB4"     ,
		"AMB5"     , "AMB6"     , "AMB7"     , "AMB8"     , "AMB9"     , "ARTIUP"   ,
		"ARTIUSE"  , "BLSHIT"   , "BLSSHT"   , "BOUNCE"   , "BOWSHT"   , "BSTACT"   ,
		"BSTATK"   , "BSTDTH"   , "BSTPAI"   , "BSTSIT"   , "BURN"     , "CHAT"     ,
		"CHICACT"  , "CHICATK"  , "CHICDTH"  , "CHICPAI"  , "CHICPK1"  , "CHICPK2"  ,
		"CHICPK3"  , "CLKACT"   , "CLKATK"   , "CLKDTH"   , "CLKPAI"   , "CLKSIT"   ,
		"DORCLS"   , "DORMOV"   , "DOROPN"   , "GFRAG"    , "GIBDTH"   , "GLDHIT"   ,
		"GLOOP"    , "GNTACT"   , "GNTFUL"   , "GNTHIT"   , "GNTPOW"   , "GNTUSE"   ,
		"HEDACT"   , "HEDAT1"   , "HEDAT2"   , "HEDAT3"   , "HEDDTH"   , "HEDPAI"   ,
		"HEDSIT"   , "HRNHIT"   , "HRNPOW"   , "HRNSHT"   , "IMPAT1"   , "IMPAT2"   ,
		"IMPDTH"   , "IMPPAI"   , "IMPSIT"   , "ITEMUP"   , "KEYUP"    , "KGTAT2"   ,
		"KGTATK"   , "KGTDTH"   , "KGTPAI"   , "KGTSIT"   , "LOBHIT"   , "LOBPOW"   ,
		"LOBSHT"   , "MINACT"   , "MINAT1"   , "MINAT2"   , "MINAT3"   , "MINDTH"   ,
		"MINPAI"   , "MINSIT"   , "MUMAT1"   , "MUMAT2"   , "MUMDTH"   , "MUMHED"   ,
		"MUMPAI"   , "MUMSIT"   , "NEWPOD"   , "PHOHIT"   , "PHOPOW"   , "PHOSHT"   ,
		"PLRCDTH"  , "PLRDTH"   , "PLROOF"   , "PLRPAI"   , "PLRWDTH"  , "PODEXP"   ,
		"PSTART"   , "PSTOP"    , "RAMPHIT"  , "RAMRAIN"  , "RESPAWN"  , "RIPSLOP"  ,
		"SBTACT"   , "SBTDTH"   , "SBTPAI"   , "SNKACT"   , "SNKATK"   , "SNKDTH"   ,
		"SNKPAI"   , "SNKSIT"   , "SORACT"   , "SORATK"   , "SORDBON"  , "SORDEXP"  ,
		"SORDSPH"  , "SORPAI"   , "SORRISE"  , "SORSIT"   , "SORZAP"   , "STFCRK"   ,
		"STFHIT"   , "STFPOW"   , "STNMOV"   , "SWITCH"   , "TELEPT"   , "WATERFL"  ,
		"WIND"     , "WIZACT"   , "WIZATK"   , "WIZDTH"   , "WIZPAI"   , "WIZSIT"   ,
		"WPNUP"
	};
	size_t i;
	for (i=0;i<NUMHERETICSOUNDS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HEXEN sound (valid also for DEATHKINGS)
static bool_t is_hexensound(const char *s)
{
#define NUMHEXENSOUNDS 218
	static const char *stuff[NUMHEXENSOUNDS] =
	{
		// Hexen IWAD sound names
		"ACID5"    , "ARMOREXP" , "ART1"     , "ARTACT1"  , "AXE5"     , "BALLS1"   ,
		"BATS"     , "BELLRNG"  , "BIRD"     , "BISHAPP"  , "BISHDTH1" , "BITE4"    ,
		"BLANK"    , "BLASTR"   , "BLDDRP1"  , "BLOOD1"   , "BLUR6"    , "BOARD1"   ,
		"BOUNCE2"  , "BROOK1"   , "BSHHIT2"  , "BSHPN1"   , "BUBBLE"   , "CENT1"    ,
		"CENT2"    , "CENTHIT2" , "CHAINS"   , "CHAT3"    , "CHNSWCH8" , "CLHMM"    ,
		"CLXDTH1"  , "CLXDTH2"  , "CLXDTH3"  , "CNTDTH1"  , "CNTSHLD4" , "CONE3"    ,
		"CORK"     , "CRKETS"   , "CRKETS1"  , "DEFAULT"  , "DEMATK2"  , "DORSTP1B" ,
		"DORSTP3"  , "DORSTP4"  , "DRAGDIE2" , "DRAGPN2"  , "DRAGSIT1" , "DRCRK5A"  ,
		"DRLTCH3A" , "DROP2"    , "DRSTP2"   , "DRSTP7"   , "ETHIT1"   , "ETHPORT1" ,
		"FACE1"    , "FALL1"    , "FALLHIT"  , "FEET4"    , "FGTCDTH"  , "FGTDDTH"  ,
		"FGTFALL"  , "FGTGRUNT" , "FGTHMM"   , "FGTPAIN"  , "FGTXDTH1" , "FGTXDTH2" ,
		"FGTXDTH3" , "FIRED2"   , "FIRED3"   , "FIRED5"   , "FIREDHIT" , "FLECH4"   ,
		"FLY3"     , "FROGS"    , "FROSTY1"  , "FROSTY2"  , "GAME1"    , "GLASS5"   ,
		"GLBHISS1" , "GLBHIT4"  , "GLOOP1"   , "GNTACT1"  , "GNTMIS1"  , "GNTPOW"   ,
		"GONG"     , "GRTNGS1"  , "GRUNT1"   , "HAMBLO8A" , "HAMFIR1"  , "HAMFLY1"  ,
		"HAMMIS2"  , "HAMWAL1"  , "HMHIT1A"  , "HOLY3"    , "ICEBRK1A" , "ICEDTH1"  ,
		"ICEMV2"   , "IMPACT3"  , "IMPFIRE2" , "INSECTS1" , "KATYDID"  , "KEYS2A"   ,
		"KORACT"   , "KORATK"   ,  "KORCOM"  , "KORDTH1"  , "KORPN1"   , "KORSIT"   ,
		"LAVA2"    , "LITE2"    , "LOCKED"   , "MAGE4"    , "MAGEBALL" , "MAYBE1"   ,
		"MGCDTH"   , "MGDTH"    , "MGFALL"   , "MGGRUNT"  , "MGHMM"    , "MGPAIN"   ,
		"MGXDTH1"  , "MGXDTH2"  , "MGXDTH3"  , "MINACT1"  , "MINACT2"  , "MINDTH4"  ,
		"MINPAIN4" , "MINSIT1"  , "MTLMV3"   , "MTLSTRT1" , "MUCK5"    , "MUMPUN5"  ,
		"OWL"      , "PICUP5"   , "PIECE1"   , "PIGDTH2"  , "PIGPAIN2" , "PIGRUNT1" ,
		"PLRBURN"  , "PLRCDTH"  , "PLRDTH"   , "PLRPAIN3" , "POIS2"    , "POP"      ,
		"POTBRK1"  , "PUFF1"    , "PUNCH8"   , "PUNCHMIS" , "PUP4"     , "PUZSLV"   ,
		"PUZSLV1"  , "QUAKE2"   , "RAITH1B"  , "RAITH3"   , "RAITH4A"  , "RAITH5A"  ,
		"RATHDTH2" , "READY1"   , "RESPAWN"  , "ROCKS"    , "SAMPLE11" , "SBTDTH3"  ,
		"SBTSIT5"  , "SERPPN1"  , "SHARDS1B" , "SHLURP"   , "SORBLEXP" , "SORBOSS1" ,
		"SORBOSS2" , "SORBOSS3" , "SORDIE2"  , "SPAWN3"   , "SPELL1"   , "SPIKE2"   ,
		"SPIKE3"   , "SPIRT5"   , "SPIRT7"   , "SPIRTS1"  , "SPIT6"    , "SQUEAL1"  ,
		"SRFC1"    , "SRFC3"    , "SRPDTH1"  , "STB1D"    , "STEEL1"   , "STEEL2"   ,
		"STEP"     , "STMDR1"   , "STNMV4"   , "STRETCH3" , "STRIKE1"  , "STRIKE3"  ,
		"STRONG1"  , "SWORD2"   , "SWTCH6"   , "SWTCHRP1" , "SWTCHV4"  , "SYAB2D"   ,
		"TAUR1"    , "TAUR2"    , "TAUR4"    , "THNDR1"   , "TICK"     , "TICTOC"   ,
		"TORCH2"   , "TPORT1"   , "TREEBRK"  , "TREEBURN" , "VAMP5"    , "WAND4"    ,
		"WEPELE2"  , "WIND3"    , "WING1"    , "WOOSH3"   , "WRSHIP1"  , "WTRCRT7"  ,
		"WTRHIT"   , "WTRSWIP"
	};
	size_t i;
	for (i=0;i<NUMHEXENSOUNDS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE sound
static bool_t is_strifesound(const char *s)
{
#define NUMSTRIFESOUNDS 135
	static const char *stuff[NUMSTRIFESOUNDS] =
	{
		// Strife IWAD sound names
		"DSAGRAC1" , "DSAGRAC2" , "DSAGRAC3" , "DSAGRAC4" , "DSAGRDPN" , "DSAGRDTH" ,
		"DSAGRSEE" , "DSAIRLCK" , "DSALARM"  , "DSALNACT" , "DSALNDTH" , "DSALNPN"  ,
		"DSALNSEE" , "DSAMALN1" , "DSAMALN2" , "DSAMALN3" , "DSAMALN4" , "DSAMALN5" ,
		"DSAMALN6" , "DSAMBBAR" , "DSAMBPPL" , "DSBAREXP" , "DSBDCLS"  , "DSBDOPN"  ,
		"DSBGLASS" , "DSBURNME" , "DSCHAIN"  , "DSCHANT"  , "DSDIFOOL" , "DSDRCHNC" ,
		"DSDRCHNO" , "DSDRLMTC" , "DSDRLMTO" , "DSDRLWUD" , "DSDRSMTC" , "DSDRSMTO" ,
		"DSDRSTON" , "DSDRSWUD" , "DSDSRPTR" , "DSEXPLOD" , "DSFIRXPL" , "DSFLBURN" ,
		"DSFLIDL"  , "DSINQACT" , "DSINQDTH" , "DSINQJMP" , "DSINQSEE" , "DSITEMUP" ,
		"DSITMBK"  , "DSKEYCRD" , "DSLGFIRE" , "DSLORPN"  , "DSLORSEE" , "DSMASK"   ,
		"DSMEATHT" , "DSMISLHT" , "DSMNALDT" , "DSMNALSE" , "DSMTALHT" , "DSNOWAY"  ,
		"DSOOF"    , "DSPCRUSH" , "DSPESPNA" , "DSPESPNB" , "DSPESPNC" , "DSPESPND" ,
		"DSPGRACT" , "DSPGRDAT" , "DSPGRDPN" , "DSPGRDTH" , "DSPGRSEE" , "DSPHOOT"  ,
		"DSPLASMA" , "DSPLDETH" , "DSPLPAIN" , "DSPLXDTH" , "DSPRGPN"  , "DSPROGAC" ,
		"DSPROTFL" , "DSPROTON" , "DSPSDTHA" , "DSPSDTHB" , "DSPSDTHC" , "DSPSTART" ,
		"DSPSTOP"  , "DSPULCHN" , "DSRADIO"  , "DSRATACT" , "DSRB2ACT" , "DSRB2DTH" ,
		"DSRB2PN"  , "DSRB2SEE" , "DSREACTR" , "DSREAVAT" , "DSREAVPN" , "DSREBACT" ,
		"DSREBDTH" , "DSREVACT" , "DSREVBLD" , "DSREVDTH" , "DSREVSEE" , "DSRFLITE" ,
		"DSRIFLE"  , "DSRLAUNC" , "DSSGLHIT" , "DSSIGIL"  , "DSSIGLUP" , "DSSLOP"   ,
		"DSSMFIRE" , "DSSNTACT" , "DSSNTDTH" , "DSSNTSEE" , "DSSPDATK" , "DSSPDWLK" ,
		"DSSPIDTH" , "DSSPISIT" , "DSSTATIC" , "DSSTNMOV" , "DSSWBOLT" , "DSSWISH"  ,
		"DSSWKNOB" , "DSSWSCAN" , "DSSWSTON" , "DSSWTCHN" , "DSTELEPT" , "DSTEND"   ,
		"DSVALVE"  , "DSWBRLDT" , "DSWDRIP"  , "DSWFALL"  , "DSWPNUP"  , "DSWRIVER" ,
		"DSWSPLSH" , "DSXBOW"   , "DSYEAH"
	};
	size_t i;
	for (i=0;i<NUMSTRIFESOUNDS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE voice
//
// These are surrounded by V_ markers in VOICES.WAD
// but there's nothing to prevent somebody from
// overriding some of them in a PWAD without markers.
//
// Nobody knows EXACTLY what STRIFE would do in such
// cases; however, in general it has proved to be the
// case that source port authors are very lax regarding
// standards compliance and as a result, it is expected
// that most source ports will just use the sound
// without any warning or error. Accordingly, we check
// for these by name, just in case they are present.
//
static bool_t is_strifevoice(const char *s)
{
#define NUMSTRIFEVOICES 371
	static const char *stuff[NUMSTRIFEVOICES] =
	{
		// Strife voices IWAD sound names
		"ADG01"    , "AG301"    , "AGG01"    , "BBX01"    , "BBX02"    , "BGG01"    ,
		"BGG02"    , "BGG03"    , "CTT01"    , "CTT02"    , "DER01"    , "DER02"    ,
		"DER03"    , "DGG01"    , "DGG02"    , "DGG03"    , "DGTBL"    , "DOW01"    ,
		"DRTBL"    , "DWTBL"    , "DWW01"    , "F1TBLA"   , "F2TBLA"   , "F3TBLA"   ,
		"FOR01A"   , "FOR02A"   , "FOR03A"   , "FOR04A"   , "FOTBLA"   , "FP101A"   ,
		"FP102A"   , "FP201A"   , "FP301A"   , "GEO01"    , "GEO02"    , "GEO03"    ,
		"GETBL"    , "GOTBL"    , "GOV01"    , "GOV02"    , "GOV03"    , "GOV04"    ,
		"GOV05"    , "GOV06"    , "GOV07"    , "GOV08"    , "GOV09"    , "GOV10"    ,
		"GOV11"    , "GOV6A1"   , "HA001"    , "HA002"    , "HA003"    , "HA004"    ,
		"HA005"    , "HA006"    , "HA007"    , "HATBL"    , "JDW01"    , "JDW02"    ,
		"JWTBL"    , "KET01"    , "KET02"    , "KET03"    , "KETBL"    , "KEV01"    ,
		"KEV02"    , "KNTBL"    , "LOM03"    , "LOM04"    , "LOM05"    , "LOM06"    ,
		"MAC01"    , "MAC02"    , "MAC03"    , "MAC04"    , "MAC05"    , "MAC06"    ,
		"MAC07"    , "MAC08"    , "MAC09"    , "MAC10"    , "MAC10A1"  , "MAC10B1"  ,
		"MAC11"    , "MAC12"    , "MAC13"    , "MAC14"    , "MAC15"    , "MAC16"    ,
		"MAC17"    , "MAC18"    , "MAC19"    , "MAC20"    , "MAC666"   , "MACRWD"   ,
		"MAE01"    , "MAE02"    , "MAE03"    , "MAE04"    , "MAE05"    , "MAE06"    ,
		"MAG01"    , "MAG02"    , "MAG03"    , "MAG04"    , "MCTBL"    , "MLTBL"    ,
		"MOTBL"    , "ORC01"    , "ORC02"    , "ORC03"    , "ORC04"    , "ORC05"    ,
		"ORC06"    , "ORC07"    , "ORE01"    , "ORE02"    , "ORTBL"    , "PDG01"    ,
		"PDG02"    , "PDG03"    , "PPP01A"   , "PPP02A"   , "PPP03A"   , "PPP04"    ,
		"PPP05"    , "PPP06A"   , "PPP07A"   , "PPP08"    , "PRO1"     , "PRO2"     ,
		"PRO3"     , "PRO4"     , "PRO5"     , "PRO6"     , "PRO7"     , "PRTBL"    ,
		"QFMRM1"   , "QFMRM2"   , "QFMRM3"   , "QFMRM4"   , "QFMRM5"   , "QFMRM6"   ,
		"QFMRM7"   , "QFMRM8"   , "QUI01"    , "QUI02"    , "QUI03"    , "QUI04"    ,
		"QUI05"    , "QUI06"    , "QUTBL"    , "REBRM1"   , "REBRM2"   , "REBRM3"   ,
		"REBRM4"   , "REBRM5"   , "REBRM6"   , "REBRM7"   , "REBRM8"   , "REBRM9"   ,
		"RET01"    , "RET02"    , "RET03"    , "RET04"    , "RET05"    , "RET06"    ,
		"RET07"    , "RET08"    , "RET09"    , "RET10"    , "RET11"    , "RET12"    ,
		"RETBL"    , "RGG01"    , "RGTBL"    , "RIC01"    , "RIC02"    , "RIE01"    ,
		"RPP01"    , "RRTBL"    , "SAM01A"   , "SAM02A"   , "SAM03A"   , "SAM04A"   ,
		"SAM05A"   , "SATBL"    , "SS501B"   , "SS502B"   , "SS503B"   , "SS601A"   ,
		"SS602A"   , "SS603A"   , "SUR4A1"   , "TBTBL"    , "TCB01"    , "TCB02"    ,
		"TCB03"    , "TCC01"    , "TCH01"    , "TCH02"    , "TCH03"    , "TCT01"    ,
		"TETBL"    , "TTTBL"    , "VOC1"     , "VOC10"    , "VOC100"   , "VOC101"   ,
		"VOC102"   , "VOC103"   , "VOC104"   , "VOC105"   , "VOC106"   , "VOC11"    ,
		"VOC12"    , "VOC120"   , "VOC121"   , "VOC122"   , "VOC128"   , "VOC129"   ,
		"VOC13"    , "VOC130"   , "VOC14"    , "VOC15"    , "VOC16"    , "VOC17"    ,
		"VOC18"    , "VOC19"    , "VOC2"     , "VOC20"    , "VOC200"   , "VOC201"   ,
		"VOC202"   , "VOC203"   , "VOC204"   , "VOC205"   , "VOC206"   , "VOC207"   ,
		"VOC208"   , "VOC209"   , "VOC21"    , "VOC210"   , "VOC211"   , "VOC212"   ,
		"VOC213"   , "VOC214"   , "VOC215"   , "VOC216"   , "VOC217"   , "VOC218"   ,
		"VOC219"   , "VOC22"    , "VOC220"   , "VOC221"   , "VOC222"   , "VOC223"   ,
		"VOC224"   , "VOC225"   , "VOC226"   , "VOC227"   , "VOC228"   , "VOC229"   ,
		"VOC23"    , "VOC230"   , "VOC231"   , "VOC232"   , "VOC233"   , "VOC234"   ,
		"VOC235"   , "VOC236"   , "VOC237"   , "VOC24"    , "VOC25"    , "VOC26"    ,
		"VOC27"    , "VOC28"    , "VOC29"    , "VOC3"     , "VOC30"    , "VOC31"    ,
		"VOC32"    , "VOC33"    , "VOC34"    , "VOC35"    , "VOC36"    , "VOC37"    ,
		"VOC38"    , "VOC39"    , "VOC4"     , "VOC40"    , "VOC41"    , "VOC42"    ,
		"VOC43"    , "VOC44"    , "VOC45"    , "VOC46"    , "VOC47"    , "VOC48"    ,
		"VOC49"    , "VOC5"     , "VOC50"    , "VOC51"    , "VOC52"    , "VOC53"    ,
		"VOC54"    , "VOC55"    , "VOC56"    , "VOC57"    , "VOC58"    , "VOC59"    ,
		"VOC6"     , "VOC60"    , "VOC61"    , "VOC62"    , "VOC63"    , "VOC64"    ,
		"VOC65"    , "VOC66"    , "VOC67"    , "VOC68"    , "VOC69"    , "VOC7"     ,
		"VOC70"    , "VOC71"    , "VOC72"    , "VOC73"    , "VOC74"    , "VOC75"    ,
		"VOC76"    , "VOC77"    , "VOC78"    , "VOC79"    , "VOC8"     , "VOC80"    ,
		"VOC81"    , "VOC82"    , "VOC83"    , "VOC84"    , "VOC85"    , "VOC86"    ,
		"VOC87"    , "VOC88"    , "VOC89"    , "VOC9"     , "VOC90"    , "VOC91"    ,
		"VOC92"    , "VOC93"    , "VOC94"    , "VOC95"    , "VOC96"    , "VOC97"    ,
		"VOC98"    , "VOC99"    , "WDM01"    , "WDM02"    , "WER01"    , "WER02"    ,
		"WER03"    , "WER05"    , "WER06"    , "WER07"    , "WER08"    , "WER09"    ,
		"WNTBL"    , "WOR01"    , "WOR02"    , "WOR03"    , "WRTBL"
	};
	size_t i;
	for (i=0;i<NUMSTRIFEVOICES;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it DOOM music
static bool_t is_doom1music(const char *s)
{
#define NUMDOOM1MUSICS 32
	static const char *stuff[NUMDOOM1MUSICS] =
	{
		// Doom 1 IWAD music names
		"D_BUNNY"  , "D_E1M1"   , "D_E1M2"   , "D_E1M3"   , "D_E1M4"   , "D_E1M5"   ,
		"D_E1M6"   , "D_E1M7"   , "D_E1M8"   , "D_E1M9"   , "D_E2M1"   , "D_E2M2"   ,
		"D_E2M3"   , "D_E2M4"   , "D_E2M5"   , "D_E2M6"   , "D_E2M7"   , "D_E2M8"   ,
		"D_E2M9"   , "D_E3M1"   , "D_E3M2"   , "D_E3M3"   , "D_E3M4"   , "D_E3M5"   ,
		"D_E3M6"   , "D_E3M7"   , "D_E3M8"   , "D_E3M9"   , "D_INTER"  , "D_INTRO"  ,
		"D_INTROA" , "D_VICTOR"
	};
	int i;
	for (i=0;i<NUMDOOM1MUSICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it DOOM2 music
static bool_t is_doom2music(const char *s)
{
#define NUMDOOM2MUSICS 35
	static const char *stuff[NUMDOOM2MUSICS] =
	{
		// Doom 2 IWAD music names (valid also for TNT and PLUTONIA)
		"D_ADRIAN" , "D_AMPIE"  , "D_BETWEE" , "D_COUNT2" , "D_COUNTD" , "D_DDTBL2" ,
		"D_DDTBL3" , "D_DDTBLU" , "D_DEAD"   , "D_DEAD2"  , "D_DM2INT" , "D_DM2TTL" ,
		"D_DOOM"   , "D_DOOM2"  , "D_EVIL"   , "D_IN_CIT" , "D_MESSAG" , "D_MESSG2" ,
		"D_OPENIN" , "D_READ_M" , "D_ROMER2" , "D_ROMERO" , "D_RUNNI2" , "D_RUNNIN" ,
		"D_SHAWN"  , "D_SHAWN2" , "D_SHAWN3" , "D_STALKS" , "D_STLKS2" , "D_STLKS3" ,
		"D_TENSE"  , "D_THE_DA" , "D_THEDA2" , "D_THEDA3" , "D_ULTIMA"
	};
	size_t i;
	for (i=0;i<NUMDOOM2MUSICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it HERETIC music
static bool_t is_hereticmusic(const char *s)
{
#define NUMHERETICMUSICS 22
	static const char *stuff[NUMHERETICMUSICS] =
	{
		// Heretic IWAD music names
		"MUS_CPTD" , "MUS_E1M1" , "MUS_E1M2" , "MUS_E1M3" , "MUS_E1M4" , "MUS_E1M5" ,
		"MUS_E1M6" , "MUS_E1M7" , "MUS_E1M8" , "MUS_E1M9" , "MUS_E2M1" , "MUS_E2M2" ,
		"MUS_E2M3" , "MUS_E2M4" , "MUS_E2M6" , "MUS_E2M7" , "MUS_E2M8" , "MUS_E2M9" ,
		"MUS_E3M2" , "MUS_E3M3" , "MUS_INTR" , "MUS_TITL"
	};
	size_t i;
	for (i=0;i<NUMHERETICMUSICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it HEXEN music (valid also for DEATHKINGS)
static bool_t is_hexenmusic(const char *s)
{
#define NUMHEXENMUSICS 37
	static const char *stuff[NUMHEXENMUSICS] =
	{
		// Hexen IWAD music names
		"BLECHR"   , "BONESR"   , "BORKR"    , "CHAP_1R"  , "CHAP_2R"  , "CHAP_3R"  ,
		"CHAP_4R"  , "CHARTR"   , "CHESS"    , "CHIPPYR"  , "CRUCIBR"  , "CRYPTR"   ,
		"DEEPR"    , "FALCONR"  , "FANTAR"   , "FOOJAR"   , "FORTR"    , "FUBASR"   ,
		"GROVER"   , "HALL"     , "HEXEN"    , "HUB"      , "JACHR"    , "LEVELR"   ,
		"OCTOR"    , "ORB"      , "PERCR"    , "RITHMR"   , "SECRETR"  , "SIMONR"   ,
		"SIXATER"  , "STALKR"   , "SWAMPR"   , "VOIDR"    , "WINNOWR"  , "WOBABYR"  ,
		"WUTZITR"
	};
	size_t i;
	for (i=0;i<NUMHEXENMUSICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it STRIFE music
static bool_t is_strifemusic(const char *s)
{
#define NUMSTRIFEMUSICS 23
	static const char *stuff[NUMSTRIFEMUSICS] =
	{
		// Strife IWAD music names
		"D_ACTION" , "D_CASTLE" , "D_DANGER" , "D_DARK"   , "D_DARKER" , "D_DRONE"  ,
		"D_END"    , "D_FAST"   , "D_FIGHT"  , "D_HAPPY"  , "D_INSTRY" , "D_INTRO"  ,
		"D_LOGO"   , "D_MARCH"  , "D_MOOD"   , "D_PANTHR" , "D_SAD"    , "D_SLIDE"  ,
		"D_SPENSE" , "D_STRIKE" , "D_TAVERN" , "D_TECH"   , "D_TRIBAL"
	};
	size_t i;
	for (i=0;i<NUMSTRIFEMUSICS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE dialog
static bool_t is_strifedialog(const char *s)
{
#define NUMSTRIFEDIALOGS 81
	static const char *stuff[NUMSTRIFEDIALOGS] =
	{
		// Strife dialog names
		"LOG1"     , "LOG10"    , "LOG100"   , "LOG1001"  , "LOG1002"  , "LOG1003"  ,
		"LOG1004"  , "LOG1005"  , "LOG1006"  , "LOG1007"  , "LOG1008"  , "LOG1009"  ,
		"LOG1010"  , "LOG1011"  , "LOG1012"  , "LOG1013"  , "LOG1014"  , "LOG1015"  ,
		"LOG1016"  , "LOG1017"  , "LOG1018"  , "LOG1019"  , "LOG102"   , "LOG1020"  ,
		"LOG1021"  , "LOG1022"  , "LOG1023"  , "LOG1024"  , "LOG1025"  , "LOG1026"  ,
		"LOG1027"  , "LOG1028"  , "LOG1029"  , "LOG103"   , "LOG104"   , "LOG106"   ,
		"LOG11"    , "LOG120"   , "LOG13"    , "LOG14"    , "LOG15"    , "LOG18"    ,
		"LOG19"    , "LOG2"     , "LOG20"    , "LOG21"    , "LOG211"   , "LOG22"    ,
		"LOG24"    , "LOG25"    , "LOG26"    , "LOG28"    , "LOG3"     , "LOG33"    ,
		"LOG37"    , "LOG38"    , "LOG4"     , "LOG45"    , "LOG46"    , "LOG47"    ,
		"LOG48"    , "LOG50"    , "LOG56"    , "LOG57"    , "LOG59"    , "LOG64"    ,
		"LOG70"    , "LOG74"    , "LOG75"    , "LOG76"    , "LOG79"    , "LOG83"    ,
		"LOG85"    , "LOG87"    , "LOG88"    , "LOG89"    , "LOG93"    , "LOG95"    ,
		"LOG96"    , "LOG97"    , "LOG99"
	};
	size_t i;
	for (i=0;i<NUMSTRIFEDIALOGS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a STRIFE conversation
static bool_t is_strifeconversation(const char *s)
{
#define NUMSTRIFECONVERSATIONS 23
	static const char *stuff[NUMSTRIFECONVERSATIONS] =
	{
		// Strife conversation names
		"SCRIPT00" , "SCRIPT01" , "SCRIPT02" , "SCRIPT03" , "SCRIPT04" , "SCRIPT05" ,
		"SCRIPT06" , "SCRIPT07" , "SCRIPT08" , "SCRIPT10" , "SCRIPT11" , "SCRIPT12" ,
		"SCRIPT14" , "SCRIPT15" , "SCRIPT17" , "SCRIPT18" , "SCRIPT19" , "SCRIPT23" ,
		"SCRIPT27" , "SCRIPT31" , "SCRIPT32" , "SCRIPT33" , "SCRIPT34"
	};
	size_t i;
	for (i=0;i<NUMSTRIFECONVERSATIONS;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HERETIC page graphic
static bool_t is_hereticpage(const char *s)
{
#define NUMHERETICPAGES 7
	static const char *stuff[NUMHERETICPAGES] =
	{
		// Heretic page names
		"CREDIT"   , "E2END"    , "FINAL1"   , "FINAL2"   , "HELP1"    , "HELP2"    ,
		"TITLE"
	};
	size_t i;
	for (i=0;i<NUMHERETICPAGES;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it a HEXEN page graphic
static bool_t is_hexenpage(const char *s)
{
#define NUMHEXENPAGES 8
	static const char *stuff[NUMHEXENPAGES] =
	{
		// HeXen page names
		"CREDIT"   , "FINALE1"  , "FINALE2"  , "FINALE3"  , "HELP1"    , "HELP2"    ,
		"INTERPIC" , "TITLE"
	};
	size_t i;
	for (i=0;i<NUMHEXENPAGES;i++)
	{
		if (wnmatch(stuff[i],s))
			return TRUE;
	}
	return FALSE;
}

// Is it any lump list start
static bool_t is_anylumpliststart (const char *s)
{
	/*
		This function is designed to work irrespective of
		whether the strings are C strings (8+NUL) or WAD
		lump names (8 padded with NUL where less than 8).
		The input is assumed to be 8 or less in all cases.
	*/
	if (
		 (s[0]!=NUL) &&
		 (s[1]=='_') &&
		 (s[2]=='S') &&
		 (s[3]=='T') &&
		 (s[4]=='A') &&
		 (s[5]=='R') &&
		 (s[6]=='T') &&
		 (s[7]==NUL)
		)
	{
		return TRUE;
	}
	if (
		 (s[0]!=NUL) &&
		 (s[1]!=NUL) &&
		 (s[2]=='_') &&
		 (s[3]=='S') &&
		 (s[4]=='T') &&
		 (s[5]=='A') &&
		 (s[6]=='R') &&
		 (s[7]=='T')
	   )
	{
		return TRUE;
	}
	return FALSE;
}

// Is it any lump list end
static bool_t is_anylumplistend (const char *s)
{
	/*
		This function is designed to work irrespective of
		whether the strings are C strings (8+NUL) or WAD
		lump names (8 padded with NUL where less than 8).
		The input is assumed to be 8 or less in all cases.
	*/
	if (
		 (s[0]!=NUL) &&
		 (s[1]=='_') &&
		 (s[2]=='E') &&
		 (s[3]=='N') &&
		 (s[4]=='D') &&
		 (s[5]==NUL)
	   )
	{
		return TRUE;
	}
	if (
		 (s[0]!=NUL) &&
		 (s[1]!=NUL) &&
		 (s[2]=='_') &&
		 (s[3]=='E') &&
		 (s[4]=='N') &&
		 (s[5]=='D') &&
		 (s[6]==NUL)
		)
	{
		return TRUE;
	}
	return FALSE;
}

// Is it any Heretic or Hexen font list start
static bool_t is_herianfontstart (
	const char *s,
	game_t game)
{
	/*
		This function is designed to work irrespective of
		whether the strings are C strings (8+NUL) or WAD
		lump names (8 padded with NUL where less than 8).
		The input is assumed to be 8 or less in all cases.
	*/
	// CHECK FOR FONT STARTS IN BOTH (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HERETIC) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F') &&
			 (s[1]=='O') &&
			 (s[2]=='N') &&
			 (s[3]=='T') &&
			 ( (s[4]=='A' ) || (s[4]=='B') )  &&
			 (s[5]=='_') &&
			 (s[6]=='S') &&
			 (s[7]==NUL)
		   )
		{
			return TRUE;
		}
	}
	// CHECK FOR FONT STARTS IN HEXEN ONLY (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F' ) &&
			 (s[1]=='O' ) &&
			 (s[2]=='N' ) &&
			 (s[3]=='T' ) &&
			 (s[4]=='A' ) &&
			 (s[5]=='Y' ) &&
			 (s[6]=='_' ) &&
			 (s[7]=='S' )
		   )
		{
			return TRUE;
		}
	}
	// NOT A HERETIC OR HEXEN FONT END AT ALL OR
	// ELSE NOT A GAME FOR WHICH WE RECOGNISE THEM.
	return FALSE;
}

// Is it any Heretic or Hexen font list end
static bool_t is_herianfontend (
	const char *s,
	game_t game)
{
	/*
		This function is designed to work irrespective of
		whether the strings are C strings (8+NUL) or WAD
		lump names (8 padded with NUL where less than 8).
		The input is assumed to be 8 or less in all cases.
	*/
	// CHECK FOR FONT ENDS IN BOTH (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HERETIC) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F') &&
			 (s[1]=='O') &&
			 (s[2]=='N') &&
			 (s[3]=='T') &&
			 ( (s[4]=='A' ) || (s[4]=='B') )  &&
			 (s[5]=='_') &&
			 (s[6]=='E') &&
			 (s[7]==NUL)
		   )
		{
			return TRUE;
		}
	}
	// CHECK FOR FONT ENDS IN HEXEN ONLY (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F' ) &&
			 (s[1]=='O' ) &&
			 (s[2]=='N' ) &&
			 (s[3]=='T' ) &&
			 (s[4]=='A' ) &&
			 (s[5]=='Y' ) &&
			 (s[6]=='_' ) &&
			 (s[7]=='E' )
		   )
		{
			return TRUE;
		}
	}
	// NOT A HERETIC OR HEXEN FONT END AT ALL OR
	// ELSE NOT A GAME FOR WHICH WE RECOGNISE THEM.
	return FALSE;
}

// Is it any Heretic or Hexen font list marker (extended)
static bool_t is_herianfontmarkerex (
	const char *s,												// lump name to identify
	game_t game,												// game for which WAD was designed
	bool_t *def_heretic,										// definitely a marker for Heretic
	bool_t *def_hexen,											// definitely a marker for HeXen
	bool_t *def_start)											// start of list flag (FALSE means end/neither) for lump name
{
	/*
		This function is designed to work irrespective of
		whether the strings are C strings (8+NUL) or WAD
		lump names (8 padded with NUL where less than 8).
		The input is assumed to be 8 or less in all cases.
	*/
	/*
		RETURN VALUES FROM THIS FUNCTION ARE AS FOLLOWS:
		=====================================================
		                   RESULT|DEF_HERETIC|DEF_HEXEN|START
		                  +------+-----------+---------+-----
		                NO|FALSE  FALSE       FALSE     FALSE
		     HERETIC START|TRUE   TRUE        FALSE     TRUE
		       HEXEN START|TRUE   FALSE       TRUE      TRUE
		MAYBE EITHER START|TRUE   FALSE       FALSE     TRUE
		       HERETIC END|TRUE   TRUE        FALSE     FALSE
		         HEXEN END|TRUE   FALSE       TRUE      FALSE
		  MAYBE EITHER END|TRUE   FALSE       FALSE     FALSE
		=====================================================
	*/
	// CHECK FOR FONTS IN BOTH (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HERETIC) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F') &&
			 (s[1]=='O') &&
			 (s[2]=='N') &&
			 (s[3]=='T') &&
			 ( (s[4]=='A' ) || (s[4]=='B') )  &&
			 (s[5]=='_') &&
			 ( (s[6]=='S' ) || (s[6]=='E') )  &&
			 (s[7]==NUL)
		   )
		{
			if (game==GAME_HERETIC)
			{
				*def_heretic=TRUE;
				*def_hexen=FALSE;
				*def_start=((s[6]=='S')?TRUE:FALSE);
				return TRUE;
			}
			if ( (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
			{
				*def_heretic=FALSE;
				*def_hexen=TRUE;
				*def_start=((s[6]=='S')?TRUE:FALSE);
				return TRUE;
			}
			// (game==GAME_UNKNOWN)
			*def_heretic=FALSE;
			*def_hexen=FALSE;
			*def_start=((s[6]=='S')?TRUE:FALSE);
			return TRUE;
		}
	}
	// CHECK FOR FONTS IN HEXEN ONLY (OR IF UNKNOWN)
	if ( (game==GAME_UNKNOWN) || (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
	{
		if (
			 (s[0]=='F' ) &&
			 (s[1]=='O' ) &&
			 (s[2]=='N' ) &&
			 (s[3]=='T' ) &&
			 (s[4]=='A' ) &&
			 (s[5]=='Y' ) &&
			 (s[6]=='_' ) &&
			 ( (s[7]=='S' ) || (s[7]=='E') )
		   )
		{
			if ( (game==GAME_HEXEN) || (game==GAME_DEATHKINGS) )
			{
				*def_heretic=FALSE;
				*def_hexen=TRUE;
				*def_start=((s[7]=='S')?TRUE:FALSE);
				return TRUE;
			}
			// (game==GAME_UNKNOWN)
			*def_heretic=FALSE;
			*def_hexen=FALSE;
			*def_start=((s[7]=='S')?TRUE:FALSE);
			return TRUE;
		}
	}
	// NOT A HERETIC OR HEXEN FONT MARKER AT ALL OR
	// ELSE NOT A GAME FOR WHICH WE RECOGNISE THEM.
	*def_heretic=FALSE;
	*def_hexen=FALSE;
	*def_start=FALSE;
	return FALSE;
}

// Identify lump type by syntax then name
type_t LINIdentifyLumpTypeBySyntaxThenName (
	const char *s,												// lump to be identified
	size_t index,												// index of entry in WAD directory
	bool_t identify_names,										// identify screen images by name (READ MANUAL BEFORE USING!)
	bool_t identify_pages,										// identify screen images as pages (READ MANUAL BEFORE USING!)
	bool_t identify_graphics,									// identify screen images as graphics (READ MANUAL BEFORE USING!)
	bool_t identify_voices,										// identify loose STRIFE VOICES by name (READ MANUAL BEFORE USING!)
	bool_t detect_sounds,										// detect sounds by content (READ MANUAL BEFORE USING!)
	bool_t detect_musics,										// detect musics by content (READ MANUAL BEFORE USING!)
	bool_t detect_graphics,										// detect graphics by content (READ MANUAL BEFORE USING!)
	bool_t recognised_names,									// identify sounds/musics/dialogs/conversations by recognised names
	bool_t loose_markers,										// allow nonstandard list marker characters
	bool_t named_markers,										// loose markers use names only (READ MANUAL BEFORE USING!)
	bool_t loose_headers,										// allow nonstandard map name headers (not just E\?M\? and MAP\?\?)
	bool_t isempty,												// lump has zero size
	bool_t issound,												// lump data indicates a sound file
	bool_t ismusic,												// lump data indicates a music entry
	bool_t isgraphic,											// lump data indicates a graphic entry
	game_t game)												// game for which WAD was designed
{
	// Documentation
	/*
		This function checks a name as a list marker by syntax
		and to some extent by name. If there is no match, the
		name is then checked against DOOM standard entry names,
		such as THINGS and PNAMES, then against other formats.
	*/
	// Variables
	bool_t isstart;
	bool_t isend;
	bool_t def_heretic;
	bool_t def_hexen;
	bool_t def_start;
	// Check for starts and ends
	if ( is_anylumpliststart(s) || is_herianfontstart(s,game) )
	{
		isstart=TRUE;
		isend=FALSE;
	}
	else if ( is_anylumplistend(s) || is_herianfontend(s,game) )
	{
		isstart=FALSE;
		isend=TRUE;
	}
	else
	{
		isstart=FALSE;
		isend=FALSE;
	}
	if ( isstart || isend )
	{
		if  (
				( (s[0]=='S') || (s[0]=='P') || (s[0]=='F') ) &&
				( (s[1]=='1') || (s[1]=='2') || (s[1]=='3') ) &&
				(  s[2]=='_' )
			)
		{
			return (isstart?TYPE_SUBSTART:TYPE_SUBEND);
		}
		if  (
				( (s[0]=='S') && (s[1]=='S') && (s[2]=='_') ) ||
				( (s[0]=='P') && (s[1]=='P') && (s[2]=='_') ) ||
				( (s[0]=='F') && (s[1]=='F') && (s[2]=='_') )
			)
		{
			return (isstart?TYPE_POORSTART:TYPE_POOREND);
		}
		if  (
				( (s[0]=='S') && (s[1]=='_') ) ||
				( (s[0]=='P') && (s[1]=='_') ) ||
				( (s[0]=='F') && (s[1]=='_') ) ||
				( (s[0]=='C') && (s[1]=='_') ) ||
				( (s[0]=='A') && (s[1]=='_') ) ||
				( (s[0]=='T') && (s[1]=='X') && (s[2]=='_') ) ||
				( (s[0]=='V') && (s[1]=='_') )
			)
		{
			return (isstart?TYPE_GOODSTART:TYPE_GOODEND);
		}
		if (is_herianfontmarkerex(
			s,													// lump name to identify
			game,												// game for which WAD was designed
			&def_heretic,										// definitely a marker for Heretic
			&def_hexen,											// definitely a marker for HeXen
			&def_start))										// start of list flag (FALSE means end/neither) for lump name
		{
			// HANDLE KNOWN CASES
			if (!def_heretic && !def_hexen)
			{
				return (def_start?TYPE_HERIANFONTSTART:TYPE_HERIANFONTEND);
			}
			if (def_heretic && !def_hexen)
			{
				return (def_start?TYPE_HERETICFONTSTART:TYPE_HERETICFONTEND);
			}
			if (!def_heretic && def_hexen)
			{
				return (def_start?TYPE_HEXENFONTSTART:TYPE_HEXENFONTEND);
			}
			// ERROR IF GET HERE
			FatalAbort(1,__FILE__,__LINE__,"Logic error during Heretic/HeXen font checking of lump %s",s);
		}
		if ( loose_markers && (named_markers || isempty) )
		{
			return (isstart?TYPE_SOMESTART:TYPE_SOMEEND);
		}
	}
	// Check for textures
	if (
	     (s[0]=='T')  &&
	     (s[1]=='E')  &&
	     (s[2]=='X')  &&
	     (s[3]=='T')  &&
	     (s[4]=='U')  &&
	     (s[5]=='R')  &&
	     (s[6]=='E')  &&
	     ( ISDIGIT(s[7]) || (s[7]=='S') )
	   )
	{
		return TYPE_TEXTURE;
	}
	// Check for pnames
	if (wnmatch(s,"PNAMES"))
	{
		return TYPE_PNAMES;
	}
	// Check for map data (e.g., THINGS, SSEGS, ...)
	if (
		 (wnmatch(s,"THINGS"))   ||
		 (wnmatch(s,"LINEDEFS")) ||
		 (wnmatch(s,"SIDEDEFS")) ||
		 (wnmatch(s,"VERTEXES")) ||
		 (wnmatch(s,"SEGS"))     ||
		 (wnmatch(s,"SSECTORS")) ||
		 (wnmatch(s,"NODES"))    ||
		 (wnmatch(s,"SECTORS"))  ||
		 (wnmatch(s,"REJECT"))   ||
		 (wnmatch(s,"BLOCKMAP")) ||
		 (wnmatch(s,"BEHAVIOR")) ||
		 (wnmatch(s,"SCRIPTS"))
	   )
	{
		return TYPE_MAPDATA;
	}
	// Check for OpenGL map data (e.g., GL_VERT, GL_SEGS, ...)
	if (
		 (wnmatch(s,"GL_VERT"))  ||
		 (wnmatch(s,"GL_SEGS"))  ||
		 (wnmatch(s,"GL_SSECT")) ||
		 (wnmatch(s,"GL_NODES")) ||
		 (wnmatch(s,"GL_PVS"))
	   )
	{
		return TYPE_GLMAPDATA;
	}
	// Check for named items (e.g., graphic, music, standard map, ...)
	switch (game)
	{
		case GAME_UNKNOWN:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (!recognised_names) && (s[0]=='M') && (s[1]=='U') && (s[2]=='S') && (s[3]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				return TYPE_GLMAPNAME;
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if ( (!recognised_names) && (s[0]=='L') && (s[1]=='O') && (s[2]=='G') )
			{
				if ( ISDIGIT(s[3]) && (s[4]==NUL) )
					return TYPE_DIALOG;
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
					return TYPE_DIALOG;
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && (s[6]==NUL) )
					return TYPE_DIALOG;
//
//				Not used at the moment. Who knows what might
//				happen in the future if and when source port
//				authors get Strife support working properly?
//
//				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && ISDIGIT(s[6]) && (s[7]==NUL) )
//					return TYPE_DIALOG;
			}
			if ( identify_voices && (!recognised_names) && (s[0]=='V') && (s[1]=='O') && (s[2]=='C') )
			{
				if ( ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && (s[6]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
//
//				Not used at the moment. Who knows what might
//				happen in the future if and when source port
//				authors get Strife support working properly?
//
//				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && ISDIGIT(s[6]) && (s[7]==NUL) )
//				{
//					if (!detect_sounds || issound)
//					{
//						return TYPE_VOICE;
//					}
//				}
			}
			if (
				 (!recognised_names) &&
				 (s[0]=='S')     &&
				 (s[1]=='C')     &&
				 (s[2]=='R')     &&
				 (s[3]=='I')     &&
				 (s[4]=='P')     &&
				 (s[5]=='T')     &&
				 ISDIGIT(s[6])   &&
				 ISDIGIT(s[7])
				)
			{
				return TYPE_CONVERSATION;
			}
			if ( is_hereticpage(s) || is_hexenpage(s) )
			{
				if ( !identify_pages && !identify_graphics )
				{
					if (!identify_names)
					{
						FatalAbort(1,__FILE__,__LINE__,"Invalid graphic/page identification options should have been trapped by now");
					}
					return TYPE_UNKNOWN;
				}
				if ( !identify_pages &&  identify_graphics )
				{
					if (!detect_graphics || isgraphic)
					{
						return TYPE_GRAPHIC;
					}
					else
					{
						return TYPE_UNKNOWN;
					}
				}
				if (  identify_pages && !identify_graphics )
				{
					return TYPE_PAGE;
				}
				if (  identify_pages &&  identify_graphics )
				{
					return TYPE_AUTO;
				}
				FatalAbort(1,__FILE__,__LINE__,"Identification of graphic or page %s failed",s);
			}
			if (is_doom1graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom2graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_hereticgraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_hexengraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_strifegraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom1pcsfx(s))
				return TYPE_PCSFX;
			if (is_doom2pcsfx(s))
				return TYPE_PCSFX;
			if (is_strifepcsfx(s))
				return TYPE_PCSFX;
			if (is_doom1sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_doom2sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_hereticsound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_hexensound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_strifesound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (identify_voices && is_strifevoice(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_VOICE;
				}
			}
			if (is_doom1music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_doom2music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_hereticmusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_hexenmusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_strifemusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_strifedialog(s))
				return TYPE_DIALOG;
			if (is_strifeconversation(s))
				return TYPE_CONVERSATION;
			break;
		case GAME_DOOM:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format MAP?? (lump %s) not recognised in DOOM unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_MAP?? (lump %s) not recognised in DOOM unless +gm is used",s);
				}
			}
			if (is_doom1graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom1pcsfx(s))
				return TYPE_PCSFX;
			if (is_doom1sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_doom1music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_DOOM2:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in DOOM2 unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in DOOM2 unless +gm is used",s);
				}
			}
			if (is_doom2graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom2pcsfx(s))
				return TYPE_PCSFX;
			if (is_doom2sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_doom2music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_TNT:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in TNT unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in TNT unless +gm is used",s);
				}
			}
			if (is_doom2graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom2pcsfx(s))
				return TYPE_PCSFX;
			if (is_doom2sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_doom2music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_PLUTONIA:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in PLUTONIA unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in PLUTONIA unless +gm is used",s);
				}
			}
			if (is_doom2graphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_doom2pcsfx(s))
				return TYPE_PCSFX;
			if (is_doom2sound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_doom2music(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_HERETIC:
			if ( (!recognised_names) && (s[0]=='M') && (s[1]=='U') && (s[2]=='S') && (s[3]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format MAP?? (lump %s) not recognised in Heretic unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_MAP?? (lump %s) not recognised in Heretic unless +gm is used",s);
				}
			}
			if (is_hereticpage(s))
			{
				if ( !identify_names && !identify_pages )
				{
					if (!identify_graphics)
					{
						FatalAbort(1,__FILE__,__LINE__,"Invalid graphic/page identification options should have been trapped by now");
					}
					if (!detect_graphics || isgraphic)
					{
						return TYPE_GRAPHIC;
					}
					else
					{
						return TYPE_UNKNOWN;
					}
				}
				if ( !identify_names &&  identify_pages )
				{
					if (!identify_graphics)
					{
						return TYPE_PAGE;
					}
					else
					{
						return TYPE_AUTO;
					}
				}
				if (  identify_names && !identify_pages )
				{
					return TYPE_PAGE;
				}
				if (  identify_names &&  identify_pages )
				{
					return TYPE_PAGE;
				}
				FatalAbort(1,__FILE__,__LINE__,"Identification of graphic or page %s failed",s);
			}
			if (is_hereticgraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_hereticsound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_hereticmusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_HEXEN:
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in HeXen unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in HeXen unless +gm is used",s);
				}
			}
			if (is_hexenpage(s))
			{
				if ( !identify_names && !identify_pages )
				{
					if (!identify_graphics)
					{
						FatalAbort(1,__FILE__,__LINE__,"Invalid graphic/page identification options should have been trapped by now");
					}
					if (!detect_graphics || isgraphic)
					{
						return TYPE_GRAPHIC;
					}
					else
					{
						return TYPE_UNKNOWN;
					}
				}
				if ( !identify_names &&  identify_pages )
				{
					if (!identify_graphics)
					{
						return TYPE_PAGE;
					}
					else
					{
						return TYPE_AUTO;
					}
				}
				if (  identify_names && !identify_pages )
				{
					return TYPE_PAGE;
				}
				if (  identify_names &&  identify_pages )
				{
					return TYPE_PAGE;
				}
				FatalAbort(1,__FILE__,__LINE__,"Identification of graphic or page %s failed",s);
			}
			if (is_hexengraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_hexensound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_hexenmusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_DEATHKINGS:
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in DeathKings unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in DeathKings unless +gm is used",s);
				}
			}
			if (is_hexenpage(s))
			{
				if ( !identify_names && !identify_pages )
				{
					if (!identify_graphics)
					{
						FatalAbort(1,__FILE__,__LINE__,"Invalid graphic/page identification options should have been trapped by now");
					}
					if (!detect_graphics || isgraphic)
					{
						return TYPE_GRAPHIC;
					}
					else
					{
						return TYPE_UNKNOWN;
					}
				}
				if ( !identify_names &&  identify_pages )
				{
					if (!identify_graphics)
					{
						return TYPE_PAGE;
					}
					else
					{
						return TYPE_AUTO;
					}
				}
				if (  identify_names && !identify_pages )
				{
					return TYPE_PAGE;
				}
				if (  identify_names &&  identify_pages )
				{
					return TYPE_PAGE;
				}
				FatalAbort(1,__FILE__,__LINE__,"Identification of graphic or page %s failed",s);
			}
			if (is_hexengraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_hexensound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (is_hexenmusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			break;
		case GAME_STRIFE:
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='S') )
			{
				if (!detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='P') )
				return TYPE_PCSFX;
			if ( (!recognised_names) && (s[0]=='D') && (s[1]=='_') )
			{
				if (!detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if ( (s[0]=='M') && (s[1]=='A') && (s[2]=='P') && ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				return TYPE_MAPNAME;
			if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') &&(s[3]=='M') && (s[4]=='A') && (s[5]=='P') && ISDIGIT(s[6]) && ISDIGIT(s[7]) )
				return TYPE_GLMAPNAME;
			if (!loose_headers)
			{
				if ( (s[0]=='E') && ISDIGIT(s[1]) && (s[2]=='M') && ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format E?M? (lump %s) not recognised in Strife unless +gm is used",s);
				}
				if ( (s[0]=='G') && (s[1]=='L') && (s[2]=='_') && (s[3]=='E') && ISDIGIT(s[4]) && (s[5]=='M') && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					ErrorAbort(1,__FILE__,__LINE__,"Map name format GL_E?M? (lump %s) not recognised in Strife unless +gm is used",s);
				}
			}
			if ( (!recognised_names) && (s[0]=='L') && (s[1]=='O') && (s[2]=='G') )
			{
				if ( ISDIGIT(s[3]) && (s[4]==NUL) )
					return TYPE_DIALOG;
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
					return TYPE_DIALOG;
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && (s[6]==NUL) )
					return TYPE_DIALOG;
//
//				Not used at the moment. Who knows what might
//				happen in the future if and when source port
//				authors get Strife support working properly?
//
//				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && ISDIGIT(s[6]) && (s[7]==NUL) )
//					return TYPE_DIALOG;
			}
			if ( identify_voices && (!recognised_names) && (s[0]=='V') && (s[1]=='O') && (s[2]=='C') )
			{
				if ( ISDIGIT(s[3]) && (s[4]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && (s[5]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && (s[6]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
//
//				Not used at the moment. Who knows what might
//				happen in the future if and when source port
//				authors get Strife support working properly?
//
//				if ( ISDIGIT(s[3]) && ISDIGIT(s[4]) && ISDIGIT(s[5]) && ISDIGIT(s[6]) && (s[7]==NUL) )
				{
					if (!detect_sounds || issound)
					{
						return TYPE_VOICE;
					}
				}
			}
		if (
				 (!recognised_names) &&
				 (s[0]=='S')     &&
				 (s[1]=='C')     &&
				 (s[2]=='R')     &&
				 (s[3]=='I')     &&
				 (s[4]=='P')     &&
				 (s[5]=='T')     &&
				 ISDIGIT(s[6])   &&
				 ISDIGIT(s[7])
				)
				return TYPE_CONVERSATION;
			if (is_strifegraphic(s))
			{
				if (!detect_graphics || isgraphic)
				{
					return TYPE_GRAPHIC;
				}
			}
			if (is_strifepcsfx(s))
				return TYPE_PCSFX;
			if (is_strifesound(s))
			{
				if (recognised_names || !detect_sounds || issound)
				{
					return TYPE_SOUND;
				}
			}
			if (identify_voices && is_strifevoice(s))
			{
				// Explicit use of identify_voices
				// should override detect_sounds,
				// as really a specialised variant
				// of the recognised_names option.
				// Of course, if the entry is not
				// a valid sound, you may get some
				// warnings further down the line.
//				if (recognised_names || !detect_sounds || issound)
//				{
					return TYPE_VOICE;
//				}
			}
			if (is_strifemusic(s))
			{
				if (recognised_names || !detect_musics || ismusic)
				{
					return TYPE_MUSIC;
				}
			}
			if (is_strifedialog(s))
				return TYPE_DIALOG;
			if (is_strifeconversation(s))
				return TYPE_CONVERSATION;
			break;
		default:
			FatalAbort(1,__FILE__,__LINE__,"Unrecognised value %d in variable \"game\"",game);
			break;
		////
	}
	// If we still don't know then try to identify by content
	if (detect_sounds && issound)
	{
//		EventState(VERBOSITY_WARNINGS,"Type of entry %s (entry %ld) resolved as SOUND",s,index);
		return TYPE_DETECTED_SOUND;
	}
	if (detect_musics && ismusic)
	{
//		EventState(VERBOSITY_WARNINGS,"Type of entry %s (entry %ld) resolved as MUSIC",s,index);
		return TYPE_DETECTED_MUSIC;
	}
	if (detect_graphics && isgraphic)
	{
//		EventState(VERBOSITY_WARNINGS,"Type of entry %s (entry %ld) resolved as GRAPHIC",s,index);
		return TYPE_DETECTED_GRAPHIC;
	}
	// Ok, we give up
	return TYPE_UNKNOWN;
}

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/
