/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

String manipulation over and above that of string.h

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"
#include "strmanip.h"

/**********************************************************************************************************************************/
/****************************************************** String Manipulation *******************************************************/
/**********************************************************************************************************************************/

// Remove leading spaces
void STRRemoveLeadingSpaces (char *str)
{
	// VARIABLES
	size_t spaceend;
	size_t outpos,inpos;
	// FIND LEADING SPACES STRING
	spaceend=0;
	while (ISSPACE(str[spaceend]))
	{
		spaceend++;
	}
	// DONE IF NO LEADING SPACES
	if (spaceend==0)
	{
		return;
	}
	// REMOVE LEADING SPACES
	outpos=0;
	inpos=spaceend;
	while (str[inpos]!=NUL)
	{
		str[outpos++]=str[inpos++];
	}
	str[outpos]=NUL;
}

// Remove trailing spaces
void STRRemoveTrailingSpaces (char *str)
{
	// VARIABLES
	size_t nulpos=0;
	// GET LENGTH
	while (str[nulpos]!=NUL)
	{
		nulpos++;
	}
	// DONE IF ZERO LENGTH
	if (nulpos==0)
	{
		return;
	}
	// REMOVE TRAILING SPACES
	while ( (nulpos>0) && (ISSPACE(str[nulpos-1])) )
	{
		nulpos--;
	}
	str[nulpos]=NUL;
}

// Remove leading and trailing spaces
void STRRemoveSurroundingSpaces (char *str)
{
	// VARIABLES
	size_t nulpos;
	size_t spaceend;
	size_t outpos,inpos;
	// GET LENGTH
	nulpos=0;
	while (str[nulpos]!=NUL)
	{
		nulpos++;
	}
	// DONE IF ZERO LENGTH
	if (nulpos==0)
	{
		return;
	}
	// REMOVE TRAILING SPACES
	while ( (nulpos>0) && (ISSPACE(str[nulpos-1])) )
	{
		nulpos--;
	}
	str[nulpos]=NUL;
	// DONE IF NOW ZERO LENGTH
	if (nulpos==0)
	{
		return;
	}
	// FIND LEADING SPACES STRING
	spaceend=0;
	while (ISSPACE(str[spaceend]))
	{
		spaceend++;
	}
	// DONE IF NO LEADING SPACES
	if (spaceend==0)
	{
		return;
	}
	// REMOVE LEADING SPACES
	outpos=0;
	inpos=spaceend;
	while (str[inpos]!=NUL)
	{
		str[outpos++]=str[inpos++];
	}
	str[outpos]=NUL;
}

// Replace multiple spaces with a single space
void STRRemoveRepeatedSpaces (char *str)
{
	FatalAbort(1,__FILE__,__LINE__,"STRRemoveRepeatedSpaces is not yet implemented!!");
#if 0

	// work in progress - do not use

	// VARIABLES
	size_t outpos=0;



	// STEP TO NEXT RUN OF SPACES
	while ( (str[outpos]!=NUL) && (!ISSPACE(str[outpos])) )
	{
		outpos++;
	}
	// DONE IF END OF STRING AND NOT FOUND ANY SPACES
	if (str[outpos]==NUL)
	{
		return;
	}
	// SKIP OVER REPEATED SPACES
	inpos=outpos+1;


		outpos=0;
		inpos=spaceend;
		while (str[inpos]!=NUL)
		{
			str[outpos++]=str[inpos++];
		}
		str[outpos]=NUL;
#endif
}

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/
