#ifndef __SERVICES_H__
#define __SERVICES_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

Base services

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include <stdarg.h>
#include <stdio.h>
//nclude "services.h"

// Special characters
#define NUL    '\0'
#define TAB    '\t'
#define LF     '\n'
#define CR     '\r'
#define SPACE  ' '
#define FSLASH '/'
#define BSLASH '\\'

// Compatibility
#ifdef WIN32
#define __WIN32__
#endif
#ifdef _WIN32
#define __WIN32__
#endif
#ifdef S_SPLINT_S
#define __CYGWIN__
#endif
#ifdef __CYGWIN__
#undef __WIN32__
#endif
#ifdef __VISUALC__
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#endif

// Initialise platform flag
#undef __SETPLATFORM__

// Platform specifics
#if defined(__WIN32__)
#define __SETPLATFORM__ 1										// have set platform specifics
#define __ISBIGENDIAN__ 0										// machine is big-endian
#define __FILENAMESCI__ 1										// filenames actually are case insensitive
#define __FILENAMESCC__ 1										// filenames may be shown case insensitive if desired
#undef TRUE
#undef FALSE
typedef unsigned char bool_t;
#define TRUE ((bool_t)1)
#define FALSE ((bool_t)0)
typedef unsigned char UINT08;
typedef unsigned short int UINT16;
typedef unsigned long int UINT32;
typedef unsigned long long int UINT64;
typedef char SINT08;
typedef short int SINT16;
typedef long int SINT32;
typedef long long int SINT64;
#define UINT08_MIN 0
#define UINT16_MIN 0
#define UINT32_MIN 0UL
#define UINT64_MIN 0ULL
#define UINT08_MAX 255
#define UINT16_MAX 65535
#define UINT32_MAX 4294967295UL
#define UINT64_MAX 18446744073709551615ULL
#define SINT08_MIN -128
#define SINT16_MIN -32768
#define SINT32_MIN -2147483648L
#define SINT64_MIN -9223372036854775808LL
#define SINT08_MAX 127
#define SINT16_MAX 32767
#define SINT32_MAX 2147483647L
#define SINT64_MAX 9223372036854775807LL
#endif // defined(__WIN32__)

// Platform specifics
#if defined(__CYGWIN__)
#include <sys/types.h>
#define __SETPLATFORM__ 1										// have set platform specifics
#define __ISBIGENDIAN__ 0										// machine is big-endian
#define __FILENAMESCI__ 1										// filenames actually are case insensitive
#define __FILENAMESCC__ 0										// filenames may not be shown case insensitive (should mimic U**X)
#undef TRUE
#undef FALSE
typedef _Bool bool_t;
#define TRUE ((bool_t)1)
#define FALSE ((bool_t)0)
typedef unsigned char UINT08;
typedef __uint16_t UINT16;
typedef __uint32_t UINT32;
typedef __uint64_t UINT64;
typedef char SINT08;
typedef __int16_t SINT16;
typedef __int32_t SINT32;
typedef __int64_t SINT64;
#define UINT08_MIN 0
#define UINT16_MIN 0
#define UINT32_MIN 0UL
#define UINT64_MIN 0ULL
#define UINT08_MAX 255
//efine UINT16_MAX 65535
//efine UINT32_MAX 4294967295UL
//efine UINT64_MAX 18446744073709551615ULL
#define SINT08_MIN -128
#define SINT16_MIN -32768
#define SINT32_MIN -2147483648L
#define SINT64_MIN -9223372036854775808LL
#define SINT08_MAX 127
#define SINT16_MAX 32767
#define SINT32_MAX 2147483647L
#define SINT64_MAX 9223372036854775807LL
#endif // defined(__CYGWIN__)

// Platform specifics
#if defined(__LINUX__)
#include <sys/types.h>
#define __SETPLATFORM__ 1										// have set platform specifics
#define __ISBIGENDIAN__ 0										// machine is big-endian
#define __FILENAMESCI__ 0										// filenames actually are case insensitive
#define __FILENAMESCC__ 0										// filenames may not be shown case insensitive (should mimic U**X)
#undef TRUE
#undef FALSE
typedef _Bool bool_t;
#define TRUE ((bool_t)1)
#define FALSE ((bool_t)0)
typedef unsigned char UINT08;
typedef __uint16_t UINT16;
typedef __uint32_t UINT32;
typedef __uint64_t UINT64;
typedef char SINT08;
typedef __int16_t SINT16;
typedef __int32_t SINT32;
typedef __int64_t SINT64;
#define UINT08_MIN 0
#define UINT16_MIN 0
#define UINT32_MIN 0UL
#define UINT64_MIN 0ULL
#define UINT08_MAX 255
#define UINT16_MAX 65535
#define UINT32_MAX 4294967295UL
#define UINT64_MAX 18446744073709551615ULL
#define SINT08_MIN -128
#define SINT16_MIN -32768
#define SINT32_MIN -2147483648L
#define SINT64_MIN -9223372036854775808LL
#define SINT08_MAX 127
#define SINT16_MAX 32767
#define SINT32_MAX 2147483647L
#define SINT64_MAX 9223372036854775807LL
#endif // defined(__LINUX__)

// Check platform flag
#ifndef __SETPLATFORM__
#error "You need to set up platform specifics for your platform!"
#endif

// For convenience
#if __ISBIGENDIAN__
#define __ISLITTLEENDIAN__ 0
#else
#define __ISLITTLEENDIAN__ 1
#endif

// Deinitialise platform flag
#undef __SETPLATFORM__

// File position offset
typedef long int fofs_t;

// Use during debugging
#define STATEALL
#define PARANOID

// File name case handling
#if __FILENAMESCC__==0											// if can not PRESENT filenames case insensitive...
#define FNCASE 0												// case file names (0=leave,1=lower,2=upper)
#else
#if defined(__WIN32__)
#define FNCASE 2												// case file names (0=leave,1=lower,2=upper)
#else
#define FNCASE 0												// case file names (0=leave,1=lower,2=upper)
#endif
#endif

/**********************************************************************************************************************************/
/********************************************************* Event Handling *********************************************************/
/**********************************************************************************************************************************/

#define MAX_EVENT_LIST 16										// list depth
#define MAX_EVENT_TEXT 1024										// maximum list entry text

typedef struct
{
	UINT32 code;												// event code
	char text[MAX_EVENT_TEXT+1];								// event text
}
event_item_t;

/**********************************************************************************************************************************/
/**************************************************** Command-Line Pre-Parsing ****************************************************/
/**********************************************************************************************************************************/

// Parse argv[] and argc style parameters from a string
void ParseArgvAndArgcFromString (
	char *str,													// command line to create argv and argc from
	char **out_copy,											// modified copy of string (needed for subsequent parsing)
	int *out_argc,												// number of arguments (0 is a dummy)
	char **out_argv[]);											// pointer to array of string pointers

/**********************************************************************************************************************************/
/****************************************************** Endian-Ness Handling ******************************************************/
/**********************************************************************************************************************************/

// Read a little-endian SINT16 by reference
void RDLend16SR (SINT16 *out, const SINT16 in);

// Read a little-endian SINT32 by reference
void RDLend32SR (SINT32 *out, const SINT32 in);

// Read a little-endian SINT64 by reference
void RDLend64SR (SINT64 *out, const SINT64 in);

// Read a little-endian UINT16 by reference
void RDLend16UR (UINT16 *out, const UINT16 in);

// Read a little-endian UINT32 by reference
void RDLend32UR (UINT32 *out, const UINT32 in);

// Read a little-endian UINT64 by reference
void RDLend64UR (UINT64 *out, const UINT64 in);

// Read a little-endian SINT16 by value
SINT16 RDLend16SV (const SINT16 in);

// Read a little-endian SINT32 by value
SINT32 RDLend32SV (const SINT32 in);

// Read a little-endian SINT64 by value
SINT64 RDLend64SV (const SINT64 in);

// Read a little-endian UINT16 by value
UINT16 RDLend16UV (const UINT16 in);

// Read a little-endian UINT32 by value
UINT32 RDLend32UV (const UINT32 in);

// Read a little-endian UINT64 by value
UINT64 RDLend64UV (const UINT64 in);

// Read a big-endian SINT16 by reference
void RDBend16SR (SINT16 *out, const SINT16 in);

// Read a big-endian SINT32 by reference
void RDBend32SR (SINT32 *out, const SINT32 in);

// Read a big-endian SINT64 by reference
void RDBend64SR (SINT64 *out, const SINT64 in);

// Read a big-endian UINT16 by reference
void RDBend16UR (UINT16 *out, const UINT16 in);

// Read a big-endian UINT32 by reference
void RDBend32UR (UINT32 *out, const UINT32 in);

// Read a big-endian UINT64 by reference
void RDBend64UR (UINT64 *out, const UINT64 in);

// Read a big-endian SINT16 by value
SINT16 RDBend16SV (const SINT16 in);

// Read a big-endian SINT32 by value
SINT32 RDBend32SV (const SINT32 in);

// Read a big-endian SINT64 by value
SINT64 RDBend64SV (const SINT64 in);

// Read a big-endian UINT16 by value
UINT16 RDBend16UV (const UINT16 in);

// Read a big-endian UINT32 by value
UINT32 RDBend32UV (const UINT32 in);

// Read a big-endian UINT64 by value
UINT64 RDBend64UV (const UINT64 in);

/**********************************************************************************************************************************/
/************************************************************ Utility *************************************************************/
/**********************************************************************************************************************************/

//
// Several target applications were developed originally on
// traditional-style systems in the "old days" and so there is
// no benefit whatever in using CTYPE or LOCALE: as far as
// these applications are concerned, the only valid digits are
// 0x30..0x39 and ANSI, or even plain ASCII, is the codeset.
//
// It is recommended to change the macros below, if you want to
// support internationalisation, rather than the main code.
//
#define ISLOWER(x) (((unsigned char)(x)>=(unsigned char)0x61)&&((unsigned char)(x)<=(unsigned char)0x7A))
#define ISUPPER(x) (((unsigned char)(x)>=(unsigned char)0x41)&&((unsigned char)(x)<=(unsigned char)0x5A))
#define TOLOWER(x) (ISUPPER(x)?((char)(x)+(char)32):((char)(x)))
#define TOUPPER(x) (ISLOWER(x)?((char)(x)-(char)32):((char)(x)))
#define ISALPHA(x) (ISLOWER(x)||ISUPPER(x))
#define ISDIGIT(x) (((unsigned char)(x)>=(unsigned char)0x30)&&((unsigned char)(x)<=(unsigned char)0x39))
#define ISSPACE(x) ((unsigned char)(x)==(unsigned char)SPACE)

/**********************************************************************************************************************************/
/******************************************************** Case Conversion *********************************************************/
/**********************************************************************************************************************************/

// Convert a string to lower case
void lowercase (char *s);

// Convert a string to upper case
void uppercase (char *s);

/**********************************************************************************************************************************/
/***************************************************** String Equality Tests ******************************************************/
/**********************************************************************************************************************************/

// Case Insensitive String Equality Test
bool_t cimatch (const char *s1, const char *s2);

// Case Sensitive String Equality Test
bool_t csmatch (const char *s1, const char *s2);

/**********************************************************************************************************************************/
/*************************************************** Memory Array Equality Test ***************************************************/
/**********************************************************************************************************************************/

// Memory Array Equality Test
bool_t mamatch (const void *x, size_t xsize, const void *y, size_t ysize);

/**********************************************************************************************************************************/
/********************************************************* File Handling **********************************************************/
/**********************************************************************************************************************************/

// Copy data from a file at current position into memory
void FILESegmentReadIntoMemory (
	FILE *infile,												// file to read from
	void *buffer,												// segment
	size_t count);												// size of segment

// Copy data from memory into a file at current position
void FILESegmentWriteFromMemory (
	FILE *outfile,												// file to write to
	void *buffer,												// segment
	size_t count);												// size of segment

// Copy segment of one file into another at current positions
void FILESegmentCopyBetweenFiles (
	FILE *infile,												// file to read from
	FILE *outfile,												// file to write to
	size_t count);												// size of segment

/**********************************************************************************************************************************/
/**************************************************** Non-Error Event Logging *****************************************************/
/**********************************************************************************************************************************/

// Verbosity level
typedef enum
{
	VERBOSITY_STATEMENTS,										// statements
	VERBOSITY_ERRORS,											// statements + errors
	VERBOSITY_WARNINGS,											// statements + errors + warnings
	VERBOSITY_CORRECTIONS,										// statements + errors + warnings + corrections
	VERBOSITY_PROGRESS,											// statements + errors + warnings + corrections + progress
	VERBOSITY_ACTIONS,											// statements + errors + warnings + corrections + progress + actions
	VERBOSITY_DETAILS,											// statements + errors + warnings + corrections + progress + actions + details
	VERBOSITY_INTERNALS,										// statements + errors + warnings + corrections + progress + actions + details + internals
	VERBOSITY_MAXPLUSONE										// verbosity levels
} verbosity_t;

// Set verbosity level
void EventSetVerbosity(verbosity_t verbosity);

// Get overall verbosity level
void EventGetVerbosity(verbosity_t *verbosity);

// Generic event logger
void EventState(verbosity_t priority, char *message,...);

/**********************************************************************************************************************************/
/********************************************************* Error Handling *********************************************************/
/**********************************************************************************************************************************/

// Generic error logger
void ErrorAbort(
	unsigned int status,										// status code for this error
	char *filenm,												// source file name (from __FILE__)
	long int lineno,											// source line number (from __LINE__)
	char *message,												// message format
	...);														// message arguments

// Severe (internal) error logger
void FatalAbort(
	unsigned int status,										// status code for this error
	char *filenm,												// source file name (from __FILE__)
	long int lineno,											// source line number (from __LINE__)
	char *message,												// message format
	...);														// message arguments

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __SERVICES_H__
