#ifndef __FILESYS_H__
#define __FILESYS_H__

/**********************************************************************************************************************************/
/********************************************************* Documentation **********************************************************/
/**********************************************************************************************************************************/

/*

File system routines

*/

/**********************************************************************************************************************************/
/*********************************************************** Systemics ************************************************************/
/**********************************************************************************************************************************/

// Includes
#include "services.h"

/**********************************************************************************************************************************/
/*************************************************** File Specification Parsing ***************************************************/
/**********************************************************************************************************************************/

// Return full pathname (allocated)
void FILEGetFullSpec (const char *infilename, char **outfilename);

/**********************************************************************************************************************************/
/******************************************************* File Manipulation ********************************************************/
/**********************************************************************************************************************************/

// Truncate file to specified size (leave at eof)
void FILETruncateAndSeekEOF (FILE *fp, size_t size);

/**********************************************************************************************************************************/
/***************************************************** Program Name and Path ******************************************************/
/**********************************************************************************************************************************/

// Get the master configuration file directory
void FILEGetMasterConfigFileDirectory (const char *envvarname, char **outfilespec);

/**********************************************************************************************************************************/
/********************************************************** End of File ***********************************************************/
/**********************************************************************************************************************************/

#endif // __FILESYS_H__
