/*************************************************************************
 *  musserver.h
 *
 *  Copyright (C) 1995 Michael Heasley (mheasley@hmc.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *************************************************************************/

/* User-configurable parameters: program defaults */

/* Change this to your preferred default playback device: external midi, FM
   synth, or Gravis Ultrasound */

#define USE_DEV EXT_MIDI
/* #define USE_DEV FM_SYNTH */
/* #define USE_DEV GUS */


/* If you normally need the -u command-line switch to specify a particular
   device type, uncomment this line and change the type as needed */

/* #define USE_TYPE 8 */


/* If you use a GUS, define the following to force loading of 8 bit patches by
   default.  Using the -8 option at run time will then turn off this restriction */

#undef FORCE_8_BIT


/* If you use a GUS, define the following to force loading of all patches
   before music starts.  Using the -a option at run time will then cause it to
   load patches at the beginning of each song */

#undef LOAD_GUS_FIRST


/* This is where musserver searches for GUS patches.  It first searches
   PATCH_PATH1, then PATCH_PATH2. */

#define PATCH_PATH1	"/dos/ultrasnd/midi"
#define PATCH_PATH2	"/usr/local/lib/Plib"

/* End of user-configurable section */

#define MUS_VERSION "1.22"

struct mus_header {			/* header of music lump */
	char		id[4];
	unsigned short	music_size;
	unsigned short	header_size;
	unsigned short	channels;
	unsigned short	sec_channels;
	unsigned short	instrnum;
	unsigned short	dummy;
}; 

struct opl_instr {
	unsigned short   flags;
	unsigned char    finetune;
	unsigned char    note;
	sbi_instr_data   patchdata;
};

struct synth_voice {
	signed int    note;
	signed int    channel;
};

#define NO_SYNTH -1
#define FM_SYNTH 1
#define EXT_MIDI 2
#define GUS 3
#define LIST_DEV -1
#define TERMINATED 4
#define MSG_WAIT 0
#define GUS_ALL 0
#define GUS_ONE 1
