/************************************************************************
   gusload.c  --  loads patches for musserver
   Some of this code was adapted from code written by Hannu Solovainen

   Original Copyright (C) 1994-1996 Nathan I. Laredo

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Send your comments and all your spare pocket change to
   laredo@gnu.ai.mit.edu (Nathan Laredo) or to PSC 1, BOX 709, 2401
   Kelly Drive, Lackland AFB, TX 78236-5128, USA.
 *************************************************************************/

/* Modified for musserver by Michael Heasley in January 1996 */

void gus_load(int pgm)
{
    int i, j, patfd, offset;
    struct pat_header header;
    struct sample_header sample;
    char buf[256], name[256];
    struct stat info;

    if (patchloaded[pgm] < 0)
        return;

    if (patchloaded[pgm] == 1)
        return;

    if (gmvoice[pgm] == NULL) {
        patchloaded[pgm] = -1;
        return;
    }
    sprintf(name, PATCH_PATH1 "/%s.pat", gmvoice[pgm]);

    if (stat(name, &info) == -1) {
        sprintf(name, PATCH_PATH2 "/%s.pat", gmvoice[pgm]);
        if (stat(name, &info) == -1)
            return;
    }
    if ((patfd = open(name, O_RDONLY, 0)) == -1)
        return;
    if (spaceleft < info.st_size) {
        if (!use8bit)
            gus_reload_8_bit();
        if (use8bit)
            if (spaceleft < info.st_size / 2) {
                close(patfd);
                patchloaded[pgm] = -1;  /* no space for patch */
                return;
            }
    }
    if (read(patfd, buf, 0xef) != 0xef) {
        close(patfd);
        return;
    }
    memcpy((char *) &header, buf, sizeof(header));

    if (strncmp(header.magic, "GF1PATCH110", 12)) {
        close(patfd);
        return;
    }
    if (strncmp(header.version, "ID#000002", 10)) {
        close(patfd);
        return;
    }
    header.nr_waveforms = *(unsigned short *) &buf[85];
    header.master_volume = *(unsigned short *) &buf[87];

    offset = 0xef;

    for (i = 0; i < header.nr_waveforms; i++) {

        if (lseek(patfd, offset, 0) == -1) {
            close(patfd);
            return;
        }
        if (read(patfd, &buf, sizeof(sample)) != sizeof(sample)) {
            close(patfd);
            return;
        }
        memcpy((char *) &sample, buf, sizeof(sample));

        /*
         * Since some fields of the patch record are not 32bit aligned, we must
         * handle them specially.
         */
        sample.low_note = *(int *) &buf[22];
        sample.high_note = *(int *) &buf[26];
        sample.base_note = *(int *) &buf[30];
        sample.detune = *(short *) &buf[34];
        sample.panning = (unsigned char) buf[36];

        memcpy(sample.envelope_rate, &buf[37], 6);
        memcpy(sample.envelope_offset, &buf[43], 6);

        sample.tremolo_sweep = (unsigned char) buf[49];
        sample.tremolo_rate = (unsigned char) buf[50];
        sample.tremolo_depth = (unsigned char) buf[51];

        sample.vibrato_sweep = (unsigned char) buf[52];
        sample.vibrato_rate = (unsigned char) buf[53];
        sample.vibrato_depth = (unsigned char) buf[54];
        sample.modes = (unsigned char) buf[55];
        sample.scale_frequency = *(short *) &buf[56];
        sample.scale_factor = *(unsigned short *) &buf[58];

        offset = offset + 96;
        patch = (struct patch_info *) malloc(sizeof(*patch) + sample.len);

        if (patch == NULL) {
            close(patfd);
            return;
        }
        patch->key = GUS_PATCH;
        patch->device_no = seq_dev;
        patch->instr_no = pgm;
        patch->mode = sample.modes | WAVE_TREMOLO |
            WAVE_VIBRATO | WAVE_SCALE;
        patch->len = (use8bit ? sample.len / 2 : sample.len);
        patch->loop_start =
            (use8bit ? sample.loop_start / 2 : sample.loop_start);
        patch->loop_end = (use8bit ? sample.loop_end / 2 : sample.loop_end);
        patch->base_note = sample.base_note;
        patch->high_note = sample.high_note;
        patch->low_note = sample.low_note;
        patch->base_freq = sample.base_freq;
        patch->detuning = sample.detune;
        patch->panning = (sample.panning - 7) * 16;

        memcpy(patch->env_rate, sample.envelope_rate, 6);
        for (j = 0; j < 6; j++) /* tone things down slightly */
            patch->env_offset[j] =
                (736 * sample.envelope_offset[j] + 384) / 768;

        if (reverb)
            if (pgm < 120)
                patch->env_rate[3] = (2 << 6) | (12 - (reverb >> 4));
            else if (pgm > 127)
                patch->env_rate[1] = (3 << 6) | (63 - (reverb >> 1));

        patch->tremolo_sweep = sample.tremolo_sweep;
        patch->tremolo_rate = sample.tremolo_rate;
        patch->tremolo_depth = sample.tremolo_depth;

        patch->vibrato_sweep = sample.vibrato_sweep;
        patch->vibrato_rate = sample.vibrato_rate;
        patch->vibrato_depth = sample.vibrato_depth;

        patch->scale_frequency = sample.scale_frequency;
        patch->scale_factor = sample.scale_factor;

        patch->volume = header.master_volume;

        if (lseek(patfd, offset, 0) == -1) {
            close(patfd);
            return;
        }
        if (read(patfd, patch->data, sample.len) != sample.len) {
            close(patfd);
            return;
        }
        if (patch->mode & WAVE_16_BITS && use8bit) {
            patch->mode &= ~WAVE_16_BITS;
            /* cut out every other byte to make 8-bit data from 16-bit */
            for (j = 0; j < patch->len; j++)
                patch->data[j] = patch->data[1 + j * 2];
        }
        SEQ_WRPATCH(patch, sizeof(*patch) + patch->len);
        free(patch);
        offset = offset + sample.len;
    }
    close(patfd);
    spaceleft = seq_dev;
    ioctl(seqfd, SNDCTL_SYNTH_MEMAVL, &spaceleft);
    patchloaded[pgm] = 1;
    return;
}

void gus_reload_8_bit()
{
    int i;

    if (ioctl(seqfd, SNDCTL_SEQ_RESETSAMPLES, &seq_dev) == -1) {
      {
      printf("musserver: couldn't reset GUS samples, exiting.\n");
      cleanup(-1);
      }
    }
    spaceleft = seq_dev;
    ioctl(seqfd, SNDCTL_SYNTH_MEMAVL, &spaceleft);
    totalspace = spaceleft;
    use8bit = 1;
    for (i = 0; i < 256; i++)
        if (patchloaded[i] > 0) {
            patchloaded[i] = 0;
            gus_load(i);
        }
}
