/****************************************************************************\
;                                                                            ;
;  ulmp.h - project LMP control center                                       ;
;  header file of ulmp.c                                                     ;
;                                                                            ;
;  general LMP routines                                                      ;
;                                                                            ;
;  Uwe Girlich                                                               ;
;  Erika-von-Brockdorff-Strasse 2                                            ;
;  04159 Leipzig                                                             ;
;  Deutschland/Germany                                                       ;
;  E-mail: girlich@aix520.informatik.uni-leipzig.de                          ;
;                                                                            ;
\****************************************************************************/


#ifndef __ULMP_H
#define __ULMP_H


#include <stdio.h>

#define C_MOUSE         1
#define C_KEY_OLD       2
#define C_KEY_NEW       4
#define C_KEY           (C_KEY_OLD | C_KEY_NEW)
#define ruleCOOP  0
#define ruleDEATH 1
#define ruleALT   2
#define MAXPLAYER   4
#define SHORT_SIZE  7
#define LONG_SIZE  13
#define SHORT_TIC   4
#define LONG_TIC    6

#define UNKNOWN   0
#define WRONG     1
#define DOOM_old  2
#define DOOM_new  4
#define DOOM2     8
#define HERETIC  16
#define TICTIME  1.0/35.0


extern char *PlayerColor[];
extern char *WeaponName[];
extern char *ArtifactName[];

typedef struct {
                 unsigned char go;
                 unsigned char strafe;
                 unsigned char turn;
                 unsigned char use;
                 unsigned char fl;
                 unsigned char art;
               } TIC_t;


typedef struct {
                 unsigned char header[13];
                 int           headersize;
                 int           game;
                 unsigned char versionbyte;
                 unsigned char skill;
                 unsigned char episode;
                 unsigned char map;
                 unsigned char multirule;
                 unsigned char respawn;
                 unsigned char fast;
                 unsigned char nomonsters;
                 unsigned char mainplayer;
                 int           playernum;
                 int           num[MAXPLAYER];
                 char          *filename;
                 FILE          *file;
                 long          filesize;
                 long          datasize;
                 long          tics;
                 int           ticsize;
                 double        time;
		 char          *gs;
		 char          *ns;
               } LMP_t;


typedef struct {
                 char          *filename;
                 FILE          *file;
                 long          filesize;
               } LS_t;


typedef struct {
                 unsigned long hist[128];
                 unsigned long sum;
                 char *command;
                 int maxm;
                 unsigned char m[3];
                 unsigned char control;
                 unsigned char last;
               } STAT_t; 


typedef struct {
                 char*         versionstring;
		 int           game;
                 unsigned char versionbyte;
		 unsigned int  string_no;
               } VK;
extern VK VersionKey[];
#define VersionKeys 16

/* LMP */
void LMP_init(LMP_t *l, char *filename, char *mode);
int LMP_checkgametype(LMP_t *l);
void LMP_readheader(LMP_t *l);
void LMP_writeheader(LMP_t *l);
void LMP_init(LMP_t *l, char *filename, char *mode);
int LMP_checkgametype(LMP_t *l);
void LMP_readheader(LMP_t *l);
void LMP_writeheader(LMP_t *l);
void LMP_writequitbyte(LMP_t *l);
void LMP_putgametic(LMP_t *l, TIC_t *t);
void LMP_getgametic(LMP_t *l, TIC_t *t);
void LMP_done(LMP_t *l);

/* LS */
void LS_init(LS_t *l, char *filename, char *mode);
void LS_done(LS_t *l);

/* STAT */
void STAT_init(STAT_t *s, char *command, int maxm);
void STAT_calc(STAT_t *s);
int STAT_turncheck(STAT_t *s, unsigned char t1, unsigned char t2, unsigned char t3);
char *STAT_writehist(STAT_t *s, char *buf);
void STAT_done(STAT_t *s);

void getversion(unsigned char versionbyte, int *game, char *filename,
                char **gs, char **ns);
unsigned char strtoversionbyte(char *s);


#endif /* __ULMP_H */


/*-- file end ulmp.h ---------------------------------------------------------*/

