
load $env(DAHOME)/lib/libdoomarena.so

set force 0

if {$argc == 0} {
    cd $env(DAHOME)/wads
    set wads [exec find . -name *.wad -print]
} else {
    if {[lindex $argv 0] == "-force"} {
	set argv [lrange $argv 1 end]
	set force 1
    }
    set wads $argv
}

wad open $env(DAHOME)/doom2.wad

foreach wad $wads {
    set info [file rootname $wad].info
    if {!$force && [file exists $info]} {
	continue
    }
    set sum [exec /bin/sum -r $wad]
    set id [wad open $wad]
    set levels [wad levels $id]
    if {[llength [lindex $levels 0]] == 2} {
	set doom doom1
    } else {
	set doom doom2
    }
    puts "$wad $doom"
    set file [open $info w]
    puts $file "set sum [list $sum]"
    puts $file "set doom $doom"
    puts $file "set info [list $levels]"
    close $file
    if {$levels != ""} {
	set file [open [file rootname $wad].map w]
	eval wad dumpmaps $file $levels
	close $file
    }
}
wad close all
