#include <stdio.h>
#include <errno.h>
#include <tcl.h>
#include <tk.h>
#include "doomarena.h"

int
Tcl_ReadSomethingCmd(ClientData clientData, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int fd, rc, status;
  FILE *file;
  char buf[4097];

  if (argc != 2) {
    sprintf(interp->result, "wrong # args: should be \"%s file\"",
	    argv[0]);
    return TCL_ERROR;
  }

  if (Tcl_GetOpenFile(interp, argv[1], 0, 0, &file) == TCL_ERROR)
    return TCL_ERROR;

  fd = fileno(file);

  rc = read(fd, buf, 4096);
  if (rc == -1 && errno == EAGAIN) {
    interp->result = "EAGAIN";
    return TCL_ERROR;
  }
  if (rc == 0)
    return TCL_OK;

  buf[rc] = '\0';
  Tcl_SetResult(interp, buf, TCL_VOLATILE);
  return TCL_OK;
}
