# ------------------------------------------------------------------
# "busy" set the cursor to a watch, invokes a command, and then
# restores the cursor.  It handles exceptions properly.
# ------------------------------------------------------------------

set busyRecurse 0
proc begin_busy {} {
    global busyRecurse
    incr busyRecurse
    if {$busyRecurse > 1} {return}
    
    wmbusy . 1
    blt_busy hold .
    foreach i [winfo children .] {
	if { [winfo toplevel $i] != "." } {
	    wmbusy $i 1
	    blt_busy hold $i
	}
    }
    if [winfo ismapped .] {
	update idletasks
    }
}

proc end_busy {} {
    global busyRecurse
    incr busyRecurse -1
    if {$busyRecurse > 0} {return}

    wmbusy . 0
    blt_busy release .
    foreach i [winfo children .] {  
	if { [winfo toplevel $i] != "." } {
	    wmbusy $i 0
	    catch {blt_busy release $i}
	}
    }
}

proc busy {command} {
    global errorInfo errorCode
    begin_busy
    set code [catch {uplevel $command} retval]
    end_busy
    if {$code == 1} { error $retval $errorInfo $errorCode }
    return $retval
}
