# ------------------------------------------------------------------
# "default" only sets the given variable if it is not yet set
# ------------------------------------------------------------------

proc default {variable value} {
    upvar $variable var

    if {[info exists var] == 0} {
	set var $value
    }
}

# ------------------------------------------------------------------
# "basename" and "dirname" behave like their UNIX conterparts
# ------------------------------------------------------------------

proc basename {path} {
    set path [string trimright $path /]
    regsub .*/ $path {} basename 
    return $basename
}

proc dirname {path} {
    set path [string trimright $path /]
    regsub {[^/]*$} $path {} dirname
    set dirname [string trimright $dirname /]
    if {$dirname == ""} {set dirname .}
    return $dirname
}

# ------------------------------------------------------------------
# "usort" is the same as "lsort", but also enforces uniqueness
# ------------------------------------------------------------------

proc usort {args} {
    set unique ""
    set prev ""
    set list [eval lsort $args]
    foreach elem $list {
	if {$elem != $prev} {
	    lappend unique $elem
	}
	set prev $elem
    }
    return $unique
}

# ------------------------------------------------------------------
# "aload" loads a list consisting of key/value pairs
# ------------------------------------------------------------------

proc aload {values {array ""}} {
    if {$array == ""} {
	set command [format {
	    foreach _array_pair {%s} {
		set [lindex $_array_pair 0] [lindex $_array_pair 1]
	    }
	    unset _array_pair
	} $values]

	uplevel $command
    } else {
	upvar $array v
	foreach elem $values {
	    set v([lindex $elem 0]) [lindex $elem 1]
	}
    }
}

# ------------------------------------------------------------------
# "aload_argv" stores values from argv into an associative array.
# It assumes that each -flag is followed by zero or more arguments.
# ------------------------------------------------------------------

proc aload_argv {argv array} {
    upvar $array args

    set key ""
    set value ""

    foreach elem $argv {
	if {[string index $elem 0] == "-"} {
	    if {$key != ""} {
		set args($key) $value
	    } elseif {$value != ""} {
		set args("") $value
	    }
	    set key [string range $elem 1 end]
	    if {$key == ""} {set key "-"}
	    set value ""
	} else {
	    lappend value $elem
	}
    }

    if {$key != ""} {
	set args($key) $value
    } elseif {$value != ""} {
	set args("") $value
    }
}
