/* sockio.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#ifndef __TURBOC__
#include <sys/time.h>
#endif
#include <sys/types.h>
#include "dfcss.h"
#include "sock.h"

int ASockWrite(sd, buff)
#ifdef __TURBOC__
tcp_Socket *sd;
#else
int sd;
#endif
char *buff;
{
	unsigned char slen[3];
    short len;
	int n;

    len = MIN(strlen(buff), 0xFFFF);

    slen[0] = (char) len & 0x00FF;
    slen[1] = (char) (len >> 8) & 0x00FF;

	if (SockWrite(sd, slen, 2) < 0) return(-1);
	if ((n=SockWrite(sd, buff, strlen(buff))) < 0) return(-1);
	return(n);
}

int ASockRead(sd, buff)
#ifdef __TURBOC__
tcp_Socket *sd;
#else
int sd;
#endif
char *buff;
{
	unsigned char slen[3];
    short len;
	int nread;

	SockRead(sd, slen, 2);

    len = ((((int) slen[1])<<8) & 0xFF00) | ((int) slen[0] & 0x00FF);
	if ((nread = SockRead(sd, buff, len)) < 0) return(-1);
	buff[nread] = '\0';
	return(nread);
}


#ifdef __TURBOC__
int NSockRead(sd, buff)
tcp_Socket *sd;
char *buff;
{
    int nread;
	if (sock_dataready(sd)) {
		nread = ASockRead(sd, buff);
		if (nread != -1) buff[nread] = '\0';
		return(nread);
	}
	return(0);
}
#else

int NSockRead(sd, buff)
int sd;
char *buff;
{
	struct timeval tv;
	fd_set rfds, trfds;
	int maxfd;
	int nread;

	FD_ZERO(&rfds);
	FD_SET(sd, &rfds);
	maxfd = sd +1;
	tv.tv_sec = 0;
	tv.tv_usec = 100;
	trfds = rfds;
	if (select(maxfd, &trfds, NULL, NULL, &tv) < 0)
		perror("select:");

	if (FD_ISSET(sd, &trfds)){
		nread = ASockRead(sd, buff);
		if (nread != -1) buff[nread] = '\0';
		return(nread);
	}
	return(0);
}
#endif
