/* fileio.c */
/*
 
 * Copyright 1994 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <stdio.h>

int writefile(fname, buff, n)
char *fname;
char *buff;
int n;
{
	FILE *fp;
	int nb, where = 0;

	if (!(fp = fopen(fname, "w"))) return(-1);

	do{
		if ((nb=fwrite(buff+where, sizeof(char), n-where, fp)) < 0){
            perror("Write_File: write failed");
			return(-1);
		}
		where += nb;
	} while(n-where > 0 && nb > 0);

	fclose(fp);
	return(where);
}


int readfile(fname, buff, n)
char *fname;
char *buff;
int n;
{
	FILE *fp;
	int nb, where = 0;

	if (!(fp = fopen(fname, "r"))) return(-1);

	do{
		if ((nb=fread(buff+where, sizeof(char), n-where, fp)) < 0){
            perror("Read_File: read failed");
			return(-1);
		}
		where += nb;
	} while(n-where > 0 && nb > 0);

	buff[where] = '\0';
	fclose(fp);
	return(where);
}

