/*

   TPRX.H

   (c) 1996 by Oliver Kraus

*/

#ifndef _TPRX_H
#define _TPRX_H

#include <stdio.h>
#include <time.h>
#include "tp.h"

/*
#define TPRX_B_LEN  500
#define TPRX_B_CNT  130
*/
#define TPRX_B_LEN  400
#define TPRX_B_CNT  160
#define TPRX_RX_ADD 10

struct _tprx_struct
{
   int flags;              /* TP_FLAGs                                */

   int is_test_mode;       /* == 0 normal mode                        */

   unsigned short socket;  /* ipx socket number                       */
   int is_adr_known;       /* is destination address known            */
   ipx_adr_struct adr;     /* destination address                     */

   int is_ended;           /* 1 if file ok or error                   */

   char *f_name;           /* pointer file name (allocated memory)    */
   int  f_exist;           /* 0 if f_name does not exist              */
   FILE *fp;               /* file pointer                            */
   long f_len;             /* file length                             */
   long f_pos;             /* current file position                   */
   clock_t f_start;        /* when did we start writing to the file?  */
   int f_is_write_data;
   int f_is_skip;
   unsigned long f_crc;
   unsigned long f_remote_crc;
   unsigned f_attr;        /* file attribute                          */
   unsigned short f_time;  /* file time                               */
   unsigned short f_date;  /* file date                               */

   /* Conditions:   1.   b_cnt <= b_len/2                             */
   /*               2.1. 16 Bit Systems: b_cnt*b_len < 2^16           */
   /*               2.2. 32 Bit Systems: b_cnt*b_len < 2^32           */

   int b_is_any_present;   /* is there any a block present            */
   size_t b_len;           /* block length                            */
   int b_cnt;              /* max no of blks in pool (==TPRX_B_CNT)   */
   int b_curr_cnt;         /* current blks in use (b_curr_cnt<=b_cnt) */
   int b_in_cnt;           /* incoming block counter                  */
   char *b_is_present;     /* block received array (b_cnt)            */
   size_t b_pool_size;     /* size of block memory pool (b_cnt*b_len) */
   char *b_pool_ptr;       /* block memory pool                       */

   short *b_missed_list;
   int b_missed_cnt;

   int  rx_cnt;            /* rx_cnt = b_cnt+TPRX_RX_ADD              */
   char **rx_data;         /* rx_cnt blocks with b_len bytes          */
   ipx_ecb_struct **rx_ecb;

   char *tx_data;          /* b_len bytes transmit buffer             */
   ipx_ecb_struct *tx_ecb; /* transmit ecb                            */

   clock_t small_delay;    /* values for repeated message generation  */
   clock_t large_delay;

   clock_t clock_dest;     /* destination time                        */

   void (*state_fn)(struct _tprx_struct *tprx); /* state function ptr */
   void (*rep_state_fn)(struct _tprx_struct *tprx);

   tp_pdata_struct pdata;
   int (*aux)( int msg, void *data );
   int is_aux;
};
typedef struct _tprx_struct tprx_struct;
typedef struct _tprx_struct *tprx_type;

#define tprx_IsAnyPresent(tprx) ((tprx)->b_is_any_present)

#define tprx_SetState(tprx, _state) ((tprx)->state_fn = (_state))
#define tprx_SetRepeatedState(tprx, _state) ((tprx)->rep_state_fn = (_state))
#define tprx_GetRepeatedState(tprx) ((tprx)->rep_state_fn)


/*---- public member functions --------------------------------------------*/

tprx_type tprx_Open(unsigned short socket);
void tprx_Close(tprx_type tprx);
int tprx_Dispatch(tprx_type tprx);
/* #define tprx_Dispatch(tprx) ((tprx)->state_fn(tprx)) */
void tprx_SetAux(tprx_type tprx, int (*aux)( int msg, void *data ));
void tprx_DoAux(tprx_type tprx, int msg, void *data);

#define tprx_SetFlag(tprx, flag) ((tprx)->flags |= (flag))
#define tprx_ClrFlag(tprx, flag) ((tprx)->flags &= ~(flag))

#endif
