/*

   IPX.H

*/

struct _ipx_adr_struct
{
    unsigned char netadd[4];
    unsigned char nodeadd[6];
    unsigned short socket;
};
typedef struct _ipx_adr_struct ipx_adr_struct;

struct _ipx_header_struct
{
    unsigned short checksum;
    unsigned short length;
    unsigned char tc;
    unsigned char type;
    ipx_adr_struct dest;
    ipx_adr_struct source;
};
typedef struct _ipx_header_struct ipx_header_struct;

/* event control block */
struct _ipx_ecb_struct
{
    void far *linkaddress;
    void (far *esraddress)();
    unsigned char inuse;
    unsigned char cc;
    unsigned short socket;
    unsigned char workspace[16];
    unsigned char immedaddr[6];
    unsigned short fragcount;
    void far *fragaddr1;
    unsigned short fragsize1;
    void far *fragaddr2;
    unsigned short fragsize2;
    ipx_header_struct head;
};
typedef struct _ipx_ecb_struct ipx_ecb_struct;

unsigned short reverse_word(unsigned short);

#pragma aux reverse_word =                \
   "xchg AH,AL"                           \
   parm caller [AX] nomemory              \
   value [AX]                             \
   modify exact [AX] nomemory;


int ipx_init(void);
ipx_adr_struct far *ipx_get_local_net_number(void);
int ipx_open_socket(unsigned short socket);
int ipx_open_new_socket(unsigned short far *socket);
void ipx_close_socket(unsigned short socket);
int ipx_send_ecb(ipx_ecb_struct far *ecb);
int ipx_listen_ecb(ipx_ecb_struct far *ecb);
int ipx_cancel_ecb(ipx_ecb_struct far *ecb);
void ipx_dispatch(void);
int ipx_is_ecb_in_use(ipx_ecb_struct far *ecb);
ipx_ecb_struct far *ipx_get_send_ecb(ipx_header_struct far *head, void far *data, unsigned short size);
ipx_ecb_struct far *ipx_get_receive_ecb(unsigned short socket, void far *data, unsigned short size);
ipx_header_struct far *ipx_get_header(ipx_adr_struct far *dest,
   unsigned short dest_socket, unsigned short source_socket);
ipx_ecb_struct far *ipx_fill_send_ecb(ipx_ecb_struct far *ecb,
   ipx_header_struct far *head, void far *data, unsigned short size);
ipx_ecb_struct far *ipx_fill_receive_ecb(ipx_ecb_struct far *ecb,
   unsigned short socket, void far *data, unsigned short size);
char *ipx_get_ecb_inuse_string(ipx_ecb_struct far *ecb);
char *ipx_get_ecb_cc_string(ipx_ecb_struct far *ecb);
