/*

   CCOMMON.H

   (c) 1996 Oliver Kraus

   C_DOS             MS-DOS like OS used
      C_DPMI         Use DPMI Interface
         C_DPMI386   Use DPMI int386 calls
   C_UNIX      Unix System used

*/

#ifndef _CCOMMON_H
#define _CCOMMON_H

#ifdef MSDOS
#ifndef C_DOS
#define C_DOS
#endif
#endif

#ifdef UNIX
#ifndef C_DOS
#ifndef C_UNIX
#define C_UNIX
#endif
#endif
#endif

/* default to unix */
#ifndef C_DOS
#ifndef C_UNIX
#define C_UNIX
#endif
#endif


/* dpmi section */
#ifdef C_DOS
#define C_DELIMITER_CHAR '\\'
#define C_DELIMITER_STR "\\"

#define C_DPMI

#ifdef __WATCOMC__
#ifdef __386__
#ifndef C_DPMI386
#define C_DPMI386
#endif
#endif
#endif

#endif /* C_DOS */

#ifdef C_UNIX
#define C_DELIMITER_CHAR '/'
#define C_DELIMITER_STR "/"
#endif

#define C_MAX_PATH 2048
#define C_MAX_FILE 300
#define C_MAX_PATHNAME (C_MAX_PATH+C_MAX_FILE)

#endif /* _CCOMMON_H */
