comment #

NetBIOS Library.

Copyright (c) 1994 Mark Thomas.

NPS Software.

	#

NCB STRUC
        ncbCommand      db ?            ; Command to execute
        ncbRetCode      db ?            ; Return Code, 0 if ok
        ncbLSN          db ?            ; Local Session Number
        ncbNum          db ?            ; Name Number
        ncbBufAdr       dd ?            ; Address of Message Buffer
        ncbBufLen       dw ?            ; Length of message, up to 512
        ncbCallName     db 16 DUP (0)   ; Name to call
        ncbName         db 16 DUP (0)   ; Local Name used
	ncbRTO		db ?		; Receive Time Out 0.5 incr
        ncbSTO          db ?            ; Send Time Out in 0.5 incr
        ncbPost         dd ?            ; Address of User Interupt routine
        ncbLANA_Num     db ?            ; Number of Adapter card
        ncbCMD_Done     db ?            ; Command Completed Flag.
        ncbRES          db 14 DUP (0)   ; Internal use of NetBios
NCB ENDS


; NCB Command codes.

ncNoWait                EQU 080h                ; NoWait bit for commands.

ncReset                 EQU 032h
ncCancel                EQU 035h
ncAddName               EQU 030h
ncDeleteName            EQU 031h
ncAddGroup              EQU 036h
ncCall                  EQU 010h
ncListen                EQU 011h
ncHangup                EQU 012h
ncReceiveAny            EQU 016h
ncReceive               EQU 015h
ncSend                  EQU 014h
ncSendDataGram          EQU 020h
ncReceiveDataGram       EQU 021h
ncGetStatus             EQU 034h
ncGetAdapterStatus      EQU 033h


; NETBIOS Error codes

neNoError               EQU 00h
neIllegalLength         EQU 01h
neInvalidCommand        EQU 03h
neTimeOut               EQU 05h
neIncomplete            EQU 06h
neInvalidLSN            EQU 08h
neNoResources           EQU 09h
neSessionClosed         EQU 0Ah
neCommandCanceled       EQU 0Bh
neDuplicateLocalName    EQU 0Dh
neNameTableFull         EQU 0Eh
neActiveSessions        EQU 0Fh
neLocalSessionTableFull EQU 11h
neRemoteNotListening    EQU 12h
neInvalidNameNumber     EQU 13h
neNameNotFound          EQU 14h
neNameNotFoundCALL      EQU 15h
neNameAlreadyExists     EQU 16h
neNameDeleted           EQU 17h
neSessionTerminated     EQU 18h
neNameConflict          EQU 19h
neInterfaceBusy         EQU 21h
neTooManyCommands       EQU 22h
neBadLANA               EQU 23h
neCancelAfterCompleted  EQU 24h
neInvalidCancel         EQU 26h
neNotCompleted		EQU FFh
