comment #

DOOM Network Copier Server Program.

Copyright (c) 1994 Mark Thomas.

NPS Software.

	#

INCLUDE NETBIOS.INC

CRLF	EQU 0Dh, 0Ah
CR	EQU 0Dh

TransferSize	EQU 65500			; Size of the file read buffer.


DoomSession	STRUC				; Session state.
	dsProcedure	dw 0
	dsSessionNCB	dw ?
	dsSessionName	dw ?
	dsCurrentFile	dw 0
	dsCurrentHandle dw ?
	dsLSN		db ?
DoomSession	ENDS


DoomFile	STRUC
	dfExists	dw ?
	dfName		dw ?
DoomFile	ENDS

; dfExists Equates

df_FileEnd	EQU 0000h
df_FileExists	EQU 0001h
df_FileAbsent	EQU 0002h


_DATA	SEGMENT PARA PUBLIC 'DATA'

	DoomServerName	dw 0
	DoomServerName1 db 'DoomServerOne',0,0,0
	DoomServerName2 db 'DoomServerTwo',0,0,0

	SessionNames LABEL BYTE
			db 'DoomLocal__01',0,0,0
			db 'DoomLocal__02',0,0,0
			db 'DoomLocal__03',0,0,0
			db 'DoomLocal__04',0,0,0

	DoomServerNum	db ?

						; List of files for DOOM.
						; Default status is absent,
						; actual status is found at
						; startup.

	FirstDoomFile	dw ?

	DoomFileList	DoomFile <df_FileAbsent, offset DoomFile1>
			DoomFile <df_FileAbsent, offset DoomFile2>
			DoomFile <df_FileAbsent, offset DoomFile3>
			DoomFile <df_FileAbsent, offset DoomFile4>
			DoomFile <df_FileAbsent, offset DoomFile5>
			DoomFile <df_FileAbsent, offset DoomFile6>
			DoomFile <df_FileAbsent, offset DoomFile7>
			DoomFile <df_FileAbsent, offset DoomFile8>
	DoomUserFile:	DoomFile <df_FileEnd, 0>
			DoomFile <df_FileEnd, 0>

	DoomFile1	db 'DOOM.EXE',0
	DoomFile2	db 'DOOM.WAD',0
	DoomFile3	db 'DOOM1.WAD',0
	DoomFile4	db 'SETUP.EXE',0
	DoomFile5	db 'IPXSETUP.EXE',0
	DoomFile6	db 'DEFAULT.CFG',0
	DoomFile7	db 'DOOM2.EXE',0
	DoomFile8	db 'DOOM2.WAD',0
	UserFile	db 13 DUP (0)


	WorkNCB 	NCB <>

	SessionNCB01	NCB <>
	SessionNCB02	NCB <>
	SessionNCB03	NCB <>
	SessionNCB04	NCB <>

	CurrentSession	dw ?

	TransferSegment dw ?

	SessionCount	dw 0

	DoomSession1 DoomSession<offset S_Disconnected, offset SessionNCB01>
	DoomSession2 DoomSession<offset S_Disconnected, offset SessionNCB02>
	DoomSession3 DoomSession<offset S_Disconnected, offset SessionNCB03>
	DoomSession4 DoomSession<offset S_Disconnected, offset SessionNCB04>


						; Packet types:
	pktAllDone	db 1			; All done, hangup
	pktNewFile	db 2, 13 DUP (?)	; Start new file with name.
	pktData 	db 3, 0, 0		; File data, size bytes.
	pktEndFile	db 4			; End of file.


	errAborted	db 'Escape pressed, transfer aborted.$'
	errNoNetBIOS	db 'NetBIOS is not installed.$'
	errMissingFiles db 'Cannot find any DOOM files.$'
	errBothServers	db 'Two servers are already active on the network.$'
	errError	db CRLF, '!ERROR!: $'
	errDOSError	db 'DOS error: '
		doserrno	db 'xx.$'
	errNetBIOSError db 'NetBIOS error: '
		nberrno 	db 'xx.$'

	msgAddingName1	db 'Trying first server name.', '$'
	msgAddingName2	db CR, 'First server name is use, trying second.', '$'

	msgConnected	db CRLF, '   Connected to remote.', CRLF, '$'
	msgDoneXfer	db '   Transfer completed.', CRLF, '$'
	msgSending	db 'Sending: $'
	msgCRLF 	db CRLF, '$'
	msgFound	db '  $'

msgWelcome LABEL BYTE
db CRLF
db '[DOOM Network Copier Server v1.00.  Copyright (c) 1994 Mark Thomas]'
db CRLF, '$'

msgServer LABEL BYTE
db '   Server Mode   Press Escape to abort [could be a delay]'
db CRLF, '$'

	HexTable	db '0123456789ABCDEF'

_DATA	ENDS


_TEXT	SEGMENT PARA PUBLIC 'CODE'
ASSUME CS:_TEXT, DS:_DATA, ES:_DATA, SS:_STACK

Extrn	nbDetect:NEAR
Extrn	nbAddName:NEAR
Extrn	nbListen:NEAR
Extrn	nbHangup:NEAR
Extrn	nbSend:NEAR
Extrn	nbDeleteName:NEAR
Extrn	nbSendNCB:NEAR
Extrn	nbClearNCB:NEAR


Main	PROC NEAR
	mov	ax,_DATA
	mov	ds,ax

	mov	dx,offset msgWelcome		; Hello!
	call	PrintString

	mov	bx,_ZZZZ			; Resize the memory block.
	mov	ax,es
	sub	bx,ax
	inc	bx
	mov	ah,04ah
	int	21h
	call	CheckDOSError

	mov	si,0080h			; Parse command line...
	mov	ch,0				; takes a single filename
	mov	cl,es:[si]			; as an argument.
	jcxz	NoCommandLine
SkipSpace:
	inc	si
	mov	al,es:[si]
	cmp	al,' '
	jne	SkippedSpace
	loop	SkipSpace
SkippedSpace:
	jcxz	NoCommandLine
	cmp	cx,12				; Max file length.
	ja	NoCommandLine
	mov	di,offset UserFile
CopyFile:
	mov	al,es:[si]			; Copy the filename..
	mov	ds:[di],al
	inc	di
	inc	si
	loop	CopyFile

	mov	di,offset DoomUserFile		; and initialise another
	mov	[di].dfExists,df_FileAbsent	; DoomFile structure.
	mov	[di].dfName,offset UserFile
NoCommandLine:

	mov	ax,_DATA
	mov	es,ax

	mov	ah,048h 			; Allocate transfer buffer.
	mov	bx,(TransferSize+3+16) / 16	; +3 pkt header, +16 rounding
	int	21h
	call	CheckDOSError
	mov	TransferSegment,ax

	call	nbDetect			; Is NetBIOS installed.
	jnz	NetBIOSInstalled
	mov	ax,offset errNoNetBIOS
	jmp	Error
NetBIOSInstalled:

	xor	cx,cx
	mov	si,offset DoomFileList		; Check which DOOM files to
CheckAll:					; exist in the current
	mov	dx,[si].dfName			; directory.
	or	dx,dx
	jz	AllFilesDone
	mov	ax,03d00h
	int	21h
	jc	NoDoomFile
	mov	bx,ax				; File exists, close it and
	mov	ah,3eh				; set its status appropriately
	int	21h				; and display the filename.

	mov	word ptr [si].dfExists,df_FileExists
	inc	cx

	cmp	cx,6
	jne	NoLineWrap
	mov	dx,offset msgCRLF
	call	PrintString
NoLineWrap:
	mov	dx,offset msgFound
	call	PrintString
	mov	dx,[si].dfName
	call	Print0String

NoDoomFile:
	add	si,SIZE DoomFile
	jmp	CheckAll
AllFilesDone:
	or	cx,cx
	jnz	SomeFiles
	mov	ax,offset errMissingFiles	; No files were found at all,
	jmp	Error				; abort.
SomeFiles:

	mov	bx,offset DoomFileList - SIZE DoomFile
noFileExist01:
	add	bx,SIZE DoomFile
	cmp	word ptr [bx].dfExists,df_FileAbsent
	je	noFileExist01
	mov	FirstDoomFile,bx

	mov	dx,offset msgCRLF
	call	PrintString
	mov	dx,offset msgCRLF
	call	PrintString

	mov	dx,offset msgAddingName1
	call	PrintString

	mov	bx,offset WorkNCB		; Try to add the DOOM server
	mov	si,offset DoomServerName1	; name to the table.
	call	nbAddName
	cmp	al,neNameAlreadyExists
	je	TrySecondServer
	cmp	al,neNameConflict
	je	TrySecondServer
	call	CheckNetBIOSError
	mov	si,offset DoomServerName1
	mov	bx,0				; DoomServerOne uses session
	jmp	AddedServerName 		; names 1-4
TrySecondServer:

	mov	dx,offset msgAddingName2
	call	PrintString

	mov	bx,offset WorkNCB
	mov	si,offset DoomServerName2	; Add the servers name to the
	call	nbAddName			; NetBIOS name table.
	mov	si,offset DoomServerName2
	mov	bx,4				; DoomServerTwo uses session
	cmp	al,neNoError			; names 5-8
	je	AddedServerName
	mov	ax,offset errBothServers
	jmp	Error
AddedServerName:
	mov	DoomServerName,si

	mov	si,offset SessionNames		; Adjust the session names
	mov	al,bl				; and the DoomSession
	mov	cx,4				; structures according to
	mov	bx,offset DoomSession1		; which server was found.
SetNames:
	add	byte ptr [si]+12,al
	mov	[bx].dsSessionName,si
	add	si,16				; Size of NetBIOS name.
	add	bx,SIZE DoomSession
	loop	SetNames

	mov	dx,offset msgServer
	call	PrintString

	mov	SessionCount,0

ServerLoop:					; DOOM Server loop, process
	mov	bx,offset DoomSession1		; each session continuously
	mov	CurrentSession,bx		; until an error occurs or
	call	[bx].dsProcedure		; a is key pressed.

	mov	bx,offset DoomSession2
	mov	CurrentSession,bx
	call	[bx].dsProcedure

	mov	bx,offset DoomSession3
	mov	CurrentSession,bx
	call	[bx].dsProcedure

	mov	bx,offset DoomSession4
	mov	CurrentSession,bx
	call	[bx].dsProcedure

	mov	ah,1				; Any keys waiting?
	int	16h
	jz	NoKeyPress
	mov	ah,0				; Yes is it Escape?
	int	16h
	cmp	al,01bh
	jne	NoKeyPress
	mov	ax,offset errAborted
	jmp	Error
NoKeyPress:
	jmp	ServerLoop
Error:						; AX = error message
	push	ax
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
	mov	dx,offset errError
	call	PrintString
	pop	dx
	call	PrintString
Exit:

	mov	si,offset DoomSession1		; DoomServer has finished,
	cmp	[si].dsCurrentFile,0		; hangup any active sessions.
	je	NoSession1
	mov	bx,offset WorkNCB
	mov	al,[si].dsLSN
	call	nbHangup
NoSession1:

	mov	si,offset DoomSession2
	cmp	[si].dsCurrentFile,0
	je	NoSession2
	mov	bx,offset WorkNCB
	mov	al,[si].dsLSN
	call	nbHangup
NoSession2:

	mov	si,offset DoomSession3
	cmp	[si].dsCurrentFile,0
	je	NoSession3
	mov	bx,offset WorkNCB
	mov	al,[si].dsLSN
	call	nbHangup
NoSession3:

	mov	si,offset DoomSession4
	cmp	[si].dsCurrentFile,0
	je	NoSession4
	mov	bx,offset WorkNCB
	mov	al,[si].dsLSN
	call	nbHangup
NoSession4:

	mov	si,DoomServerName		; Remote the DoomServer name
	or	si,si				; from the name table.
	jz	NoNameAdded
	mov	bx,offset WorkNCB
	call	nbDeleteName
NoNameAdded:
	mov	ah,04ch
	int	21h
Main	ENDP


S_Disconnected		PROC NEAR		; Session Disconnected, issue
	mov	si,CurrentSession		; a listen command to check
	mov	bx,[si].dsSessionNCB		; for any remote computers
	call	nbClearNCB			; trying to connect.

	mov	[bx].ncbCommand,ncListen OR ncNoWait

	mov	dx,[si].dsSessionName		; Use the no wait version,
						; the result will be polled
	mov	si,DoomServerName		; in S_WaitingForCall.	If
	lea	di,[bx].ncbName 		; no calls are received the
	mov	cx,16/2 			; Listen command is issued
	rep	movsw				; again.

	mov	si,dx
	lea	di,[bx].ncbCallName
	mov	cx,16/2
	rep	movsw

	xor	ax,ax
	mov	word ptr [bx].ncbPost+2,ax
	mov	word ptr [bx].ncbPost,ax

	mov	[bx].ncbRTO,10
	mov	[bx].ncbSTO,10

	mov	[bx].ncbLANA_Num,0

	call	nbSendNCB			; Listen for remote computers
	call	CheckNetBIOSError		; trying to call the server.

	mov	si,CurrentSession
	mov	[si].dsProcedure,offset S_WaitingForCall
	ret
S_Disconnected		ENDP


S_WaitingForCall	PROC NEAR
	mov	si,CurrentSession
	mov	bx,[si].dsSessionNCB		; Has the command completed
	mov	al,[bx].ncbCMD_Done		; yet.
	cmp	al,0FFh 			; No, maybe next time.
	je	StillWaiting
	cmp	al,neNoError			; Yes, was there an error.
	je	Connected			; No error,session established.
	cmp	al,neTimeOut			; If it timed out, try again.
	je	TimedOut
	call	CheckNetBIOSError		; Error, will not return.

TimedOut:
	mov	si,CurrentSession
	mov	[si].dsProcedure,offset S_Disconnected
	jmp	StillWaiting

Connected:					; Connected, start on files.
	inc	SessionCount

	mov	si,CurrentSession
	mov	[si].dsProcedure,offset S_SendingFile
	mov	ax,FirstDoomFile
	mov	[si].dsCurrentFile,ax

	mov	[si].dsCurrentHandle,0
	mov	al,[bx].ncbLSN
	mov	[si].dsLSN,al

	mov	dx,offset msgConnected
	call	PrintString
StillWaiting:
	ret
S_WaitingForCall	ENDP


S_SendingFile	PROC NEAR
	mov	si,CurrentSession
	mov	bx,[si].dsCurrentHandle 	; Get the current file handle
	or	bx,bx				; If it is zero, then no file
	jz	NoFile
	jmp	DoingSendFile			; is currently being set, get
NoFile:
	mov	bx,[si].dsCurrentFile		; the next in the list.
	mov	dx,[bx]
	or	dx,dx				; If the next item in the list
	jnz	SendNextFile			; is 0 then that is all the

	mov	bx,[si].dsSessionNCB
	mov	al,[si].dsLSN			; files to be transfered, send
	mov	dx,ds				; the AllDone packet to the
	mov	di,offset pktAllDone		; remote and it will hangup
	mov	cx,1				; and quit, ready to play DOOM.
	call	nbSend
	call	CheckNetBIOSError

	mov	bx,[si].dsSessionNCB
	mov	al,[si].dsLSN			; Hangup at this end of the
	call	nbHangup			; session.
	call	CheckNetBIOSError

	mov	[si].dsProcedure,offset S_Disconnected
	mov	[si].dsCurrentFile,0

	mov	dx,offset msgDoneXfer		; This session goes back to
	call	PrintString			; waiting for a call.

	mov	ax,SessionCount
	dec	ax
	mov	SessionCount,ax
	or	ax,ax
	jz	ActiveSessions
ActiveSessions:

	mov	dx,offset msgServer
	call	PrintString
	jmp	DoneSending

SendNextFile:					; There is another file in the
	mov	dx,[bx].dfName			; list, open it.
	mov	ax,03d00h
	int	21h
	call	CheckDOSError
	mov	[si].dsCurrentHandle,ax

	push	si				; Notify the remote that a new
	mov	di,offset pktNewFile		; file will be sent by sending
	inc	di				; a NewFile packet which
	mov	si,dx				; contains the name of the new
CopyString:					; file.
	lodsb
	stosb
	or	al,al
	jnz	CopyString
	pop	si

	mov	bx,[si].dsSessionNCB
	mov	al,[si].dsLSN			; Send this off to the remote.
	mov	dx,ds
	mov	di,offset pktNewFile
	mov	cx,14
	call	nbSend
	call	CheckNetBIOSError

	mov	dx,offset msgSending		; Print the name of the file
	call	PrintString			; that has been started.
	mov	dx,offset pktNewFile
	inc	dx
	call	Print0String
	mov	dx,offset msgCRLF
	call	PrintString
	jmp	DoneSending

DoingSendFile:					; Continue sending a file,
	push	ds				; transfering ~65500 bytes at
	mov	cx,TransferSize 		; at time to the remote.
	mov	ah,03fh
	mov	ds,TransferSegment
	mov	dx,3
	int	21h
	mov	byte ptr ds:[0000h],3		; 3=Data packet
	mov	ds:[0001h],ax			; Length
	mov	cx,ax
	pop	ds
	call	CheckDOSError
	jcxz	AtEOF				; If 0 bytes were read then
						; the file is at EOF, the
	mov	bx,[si].dsSessionNCB
	mov	al,[si].dsLSN			; xfer is complete.
	mov	dx,TransferSegment		; Otherwise send off the data
	mov	di,0				; to the remote.
	add	cx,3
	call	nbSend
	call	CheckNetBIOSError
	jmp	DoneSending
AtEOF:
	mov	ah,03eh 			; When a complete file has been
	int	21h				; transfered, close the file.
	xor	ax,ax				; Set the session file handle
	mov	[si].dsCurrentHandle,ax 	; to zero, and go to the next

	mov	bx,[si].dsCurrentFile		; item in the file list.
noFileExist:
	add	bx,SIZE DoomFile
	cmp	word ptr [bx].dfExists,df_FileAbsent
	je	noFileExist
	mov	[si].dsCurrentFile,bx

	mov	bx,[si].dsSessionNCB
	mov	al,[si].dsLSN
	mov	dx,ds				; Notify the remote that the
	mov	di,offset pktEndFile		; file has been completed
	mov	cx,1				; by sending a EndFile packet.
	call	nbSend
	call	CheckNetBIOSError
DoneSending:
	ret
S_SendingFile	ENDP


CheckDOSError	PROC NEAR
	jnc	NoDOSError
	mov	dl,al
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
	mov	di,offset doserrno
	call	DL2str
	mov	ax,offset errDOSError
	jmp	Error
NoDOSError:
	ret
CheckDOSError	ENDP


CheckNetBIOSError	PROC NEAR
	or	al,al
	jz	NoNetBIOSError
	mov	dl,al
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
	mov	di,offset nberrno
	call	DL2str
	mov	ax,offset errNetBIOSError
	jmp	Error
NoNetBIOSError:
	ret
CheckNetBIOSError	ENDP


DL2str	PROC NEAR		; dl = hex number, di=dest.
	mov	ah,0
	mov	al,dl
	shr	al,4
	mov	si,ax
	mov	al,[offset HexTable]+si
	stosb
	mov	al,dl
	and	al,0Fh
	mov	si,ax
	mov	al,[offset HexTable]+si
	stosb
	ret
DL2str	ENDP


PrintString	PROC NEAR	; DX=string
	mov	ah,09h
	int	21h
	ret
PrintString	ENDP


Print0String	PROC NEAR	; DX=string
	push	si
	mov	si,dx
Prn0Str:
	lodsb
	or	al,al
	jz	EOString
	mov	ah,02h
	mov	dl,al
	int	21h
	jmp	short Prn0Str
EOString:
	pop	si
	ret
Print0String	ENDP

_TEXT	ENDS

_STACK	SEGMENT PARA STACK 'STACK'
	dw 8192 DUP (?)
_STACK	ENDS

_ZZZZ	SEGMENT PARA PRIVATE 'ZZZZ'
_ZZZZ	ENDS

END Main
