comment #

DOOM Network Copier Client Program.

Copyright (c) 1994 Mark Thomas.

NPS Software.

        #

INCLUDE NETBIOS.INC

CRLF	EQU 0Dh, 0Ah
CR	EQU 0Dh

TransferSize    EQU 65500


_DATA   SEGMENT PARA PUBLIC 'DATA'

        DoomServer      dw ?
        DoomServerName1 db 'DoomServerOne',0,0,0
        DoomServerName2 db 'DoomServerTwo',0,0,0

        SessionName     db 'DoomLocal__01',0,0,0
        SessionLSN      db ?

        SessionNCB      NCB <>

        NameAdded       db 0
        SessionActive   db 0

        TransferSegment dw ?

        FileHandle      dw 0

        errAborted      db 'Escape pressed, transfer aborted.$'
        errFileWrite    db 'Bad file write (disk full?).$'
        errNoSession    db 'Cannot get a session with a server.$'
        errBadPacket    db 'Received bad packet from server.$'
	errNoNetBIOS	db 'NetBIOS is not installed.$'
        errDOSError     db 'DOS error: '
		doserrno	db 'xxh.$'
	errNetBIOSError db 'NetBIOS error: '
		nberrno 	db 'xxh.$'
	errError	db CRLF, '!ERROR! $'

	msgTryServer1	db 'Attemping to connect to DoomServerOne.$'
	msgTryServer2	db CR, 'Attemping to connect to DoomServerTwo.$'

	msgDoneXfer	db 'Transfer completed, disconnecting.', CRLF, '$'
	msgCRLF 	db CRLF, '$'

msgWelcome LABEL BYTE
db CRLF
db '[DOOM Network Copier Client v1.00.  Copyright (c) 1994 Mark Thomas]'
db CRLF, '$'

msgClient LABEL BYTE
db CR, '   Client Mode   Press Escape to abort [could be a delay]'
db CRLF, '$'

        msgReceiving    db 'Receiving:  $'
        msgCountFiller  db '          0$'
        msgReceiveCount db 08h,08h,08h,08h,08h,08h,08h,08h
        CountString     db 'xxxxxxxx$'


        pktAllDone      db 1
        pktNewFile      db 2, 13 DUP (?)
        pktData         db 3, 0, 0
        pktEndFile      db 4

        HexTable        db '0123456789ABCDEF'

        BytesReceived   dd ?

_DATA   ENDS


_TEXT   SEGMENT PARA PUBLIC 'CODE'
ASSUME CS:_TEXT, DS:_DATA, ES:_DATA, SS:_STACK

Extrn   nbDetect:NEAR
Extrn   nbAddName:NEAR
Extrn   nbListen:NEAR
Extrn   nbHangup:NEAR
Extrn   nbSend:NEAR
Extrn   nbDeleteName:NEAR
Extrn   nbCall:NEAR
Extrn	nbReceive:NEAR


Main    PROC NEAR
        mov     ax,_DATA
        mov     ds,ax

        mov     bx,_ZZZZ
	mov	ax,es				; Shrink memory block.
        sub     bx,ax
        inc     bx
        mov     ah,04ah
        int     21h
        call    CheckDOSError

        mov     ax,_DATA
        mov     es,ax

	mov	dx,offset msgWelcome		; Hello!
	call	PrintString

	call	nbDetect			; Is NetBIOS installed?
	jnz	NetBIOSInstalled
	mov	ax,offset errNoNetBIOS
        jmp     Error
NetBIOSInstalled:

        mov     ah,048h                         ; Allocate transfer buffer.
        mov     bx,(TransferSize+3+16) / 16     ; +3 pkt header, +16 rounding
        int     21h
        call    CheckDOSError
        mov     TransferSegment,ax

	mov	dx,offset msgTryServer1 	; Try to find a free session
	call	PrintString			; name by adding the local
						; session name 1-8 until one
						; is successful.
	mov	DoomServer,offset DoomServerName1
AllSessions:
        mov     bx,offset SessionNCB
	mov	si,offset SessionName		; Add the session name to the
	call	nbAddName			; NetBIOS name table.
        cmp     al,neNameAlreadyExists
        je      TryNextSession
        cmp     al,neNameConflict 
        je      TryNextSession
	call	CheckNetBIOSError
        mov     NameAdded,1
        jmp     GotServerSession
TryNextSession:
        mov     si,offset SessionName
        mov     al,[si]+12
        cmp     al,'8'                          ; If name 8 was reached and was
        jne     NotLastTry                      ; unsuccessful then either there
        mov     ax,offset errNoSession          ; is an error or all 8 names
        jmp     Error                           ; are in use.
NotLastTry:
        cmp     al,'4'                          ; Names 1-4 are handled by the
	jne	NoSecondTry			; DoomServerOne, 5-8 by the 2nd.

        push    ax
	mov	dx,offset msgTryServer2
	call	PrintString
	pop	ax

        mov     DoomServer,offset DoomServerName2
NoSecondTry:
        inc     al
        mov     [si]+12,al
        jmp     AllSessions
GotServerSession:
        mov     bx,offset SessionNCB            ; Successfuly added a local
        mov     si,offset SessionName           ; name, now try to contact the
        mov     dx,DoomServer                   ; server.
        call    nbCall
	call	CheckNetBIOSError
        mov     al,[bx].ncbLSN                  ; Success, record the LSN.
	mov	SessionLSN,al			; Set the SesssionActive flag
	mov	SessionActive,1 		; to ensure that the session
						; is closed on exit/error.
	mov	dx,offset msgClient
	call	PrintString

TransferLoop:
        mov     bx,offset SessionNCB
        mov     dx,TransferSegment              ; Receive a packet from the
        mov     di,0                            ; server into the transfer
        mov     cx,TransferSize+3               ; buffer.
        mov     al,SessionLSN
        call    nbReceive
	call	CheckNetBIOSError

        push    es
        mov     es,TransferSegment
        mov     al,es:[0000h]
        pop     es
        mov     bx,FileHandle                   ; *BX = file handle*
        cmp     al,1                            ; Packet Type 1: AllDone.
	je	P_AllDone			; Xfer is complete end session
        cmp     al,2                            ; Packet Type 2: NewFile.
	je	P_NewFile			; Start new file.

        or      bx,bx                           ; remaining two require that
        jz      BadPacket                       ; a file is already open.
        cmp     al,3                            ; Packet Type 3: Data.
	je	P_Data				; Data for a file.
        cmp     al,4                            ; Packet Type 4: EndFile.
        jne     BadPacket
	jmp	P_EndFile			; File complete, all data sent.
BadPacket:
        mov     ax,offset errBadPacket
        jmp     Error

P_AllDone:
        jmp     Exit

P_NewFile:
        or      bx,bx                           ; New file, no file should
        jnz     BadPacket                       ; be open already.
        push    ds
        mov     ds,TransferSegment              ; Create a new file with the
        mov     dx,1                            ; name from the packet.
        mov     ah,3ch
        xor     cx,cx
        int     21h
        pop     ds
        call    CheckDOSError
        mov     FileHandle,ax
        xor     ax,ax                           ; Reset the bytes received
        mov     word ptr [BytesReceived],ax     ; count.
        mov     word ptr [BytesReceived]+2,ax
	mov	dx,offset msgReceiving		; Print a message to say
	call	PrintString
						; that a new file has been
						; started.
        push    ds
        mov     ds,TransferSegment              ; Print the name of the new
	mov	dx,1				; file (have to put a $ at
	mov	si,dx				; the end of the string).
NotEnd:
        lodsb
        or      al,al
        jnz     NotEnd
	mov	byte ptr [si-1],'$'
	call	PrintString
        pop     ds
	mov	dx,offset msgCountFiller
	call	PrintString
        jmp     DonePacket

P_Data:
        push    ds                              ; Receive the next part of the
        mov     ds,TransferSegment              ; files data.
        mov     dx,03h                          ; Write the data from the
        mov     cx,ds:[0001h]                   ; packet to the file.
        mov     ah,040h
        int     21h
        mov     cx,ds:[0001]
        pop     ds
        call    CheckDOSError
        cmp     cx,ax                           ; Check that the correct
        je      WriteCountOk                    ; amount was written
	mov	ax,offset errFileWrite
        jmp     Error
WriteCountOk:
        add     word ptr [BytesReceived],ax     ; Update the bytes received
        adc     word ptr [BytesReceived]+2,0    ; counter

        mov     dx,word ptr [BytesReceived]+2   ; Print the new byte count
        mov     ax,word ptr [BytesReceived]     ; to the screen.
        mov     ch,8 OR 80h
        mov     di,offset CountString
	call	bin2dec
	mov	dx,offset msgReceiveCount
	call	PrintString
        jmp     DonePacket

P_EndFile:
        mov     ah,03eh                         ; End file, close the open
        int     21h                             ; file.
        call    CheckDOSError
        mov     FileHandle,0
	mov	dx,offset msgCRLF		; Print a CR/LF to end the
	call	PrintString
						; byte count line.
        jmp     DonePacket
DonePacket:
        mov     ah,1                            ; Check for any keypresses.
        int     16h
        jz      NoKeyPress
        mov     ah,0
        int     16h
        cmp     al,01bh
        jne     NoKeyPress
        mov     ax,offset errAborted
        jmp     Error
NoKeyPress:
        jmp     TransferLoop

Error:
        push    ax
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
	mov	dx,offset errError
	call	PrintString
	pop	dx
	call	PrintString
Exit:
        cmp     SessionActive,1
        jne     NoSession
        mov     bx,offset SessionNCB
        mov     al,SessionLSN
        call    nbHangup
NoSession:

        cmp     NameAdded,1
        jne     NoNameAdded
        mov     bx,offset SessionNCB
        mov     si,offset SessionName
        call    nbDeleteName
NoNameAdded:
        mov     ah,04ch
        int     21h
Main    ENDP


bin2dec         PROC NEAR
comment #
        Parameters : DX:AX = number to printed
                     CH = minimum number of digits to be displayed
                      bit 7 set for right justification
                     CL = 0FFh if number to be displayed as a signed number
                     DI = Destination for converted string.
        Returns    : DI = ASCII string representation of the decimal
                        value of input
        Destroys   : AX CX DX, DI modified

 This procedure converts a 32-bit binary number into an ASCII string
 representation of its decimal value.  There are several options
 with this conversion: to right justify the resulting string in the
 field width given in CL, or to display the result as a signed number.
        #

        push    bx
        cmp     cl,0FFh                         ; Is the number to printed
        mov     cl,0                            ; *CL counts digits*
        jne     more_number                     ; with a sign?
        or      dx,dx                           ; yes print a minus sign if
        jns     more_number                     ; appropriate
        not     ax
        not     dx
        add     ax,1
        adc     dx,0                            ; Set bit in CH to force the
        or      ch,040h                         ; printing of the '-'
more_number:
        mov     bx,10                           ; 10 divisor
        call    divide                          ; Save all remainders on the
        push    bx                              ; stack to get them off later
        inc     cl                              ; Increment the count
        mov     bx,ax
        or      ax,ax                           ; If the quotient is zero all
        jnz     more_number                     ; digits have been processed
        test    ch,080h                         ; Was right justification
        jz      no_right_justify                ; specified?
        and     ch,NOT 080h
        push    cx                              ; Save the flags for later.
        test    ch,040h                         ; If a minus sign is to be
        jz      no_minus_adjust                 ; printed, make sure that
        and     ch,NOT 040h                     ; only the count remains in CH
        inc     cl                              ; The count of digits will
no_minus_adjust:                                ; also be one bigger.
        mov     al,' '
        sub     ch,cl                           ; CH-CL = no. of pad digits.
        mov     cl,ch                           ; Fill between the number of
        mov     ch,0                            ; digits and the field width
        rep     stosb                           ; with spaces.
        pop     cx
no_right_justify:
        test    ch,040h
        jz      more_characters
        mov     al,'-'                          ; Print a minus sign if
        stosb                                   ; required.
more_characters:
        pop     ax                              ; Restore the remainder from
        or      al,030h                         ; the division and convert
        stosb                                   ; it to ASCII.
        dec     cl                              ; Loop until all digits have
        jnz     more_characters                 ; been POPed off the stack.
        pop     bx
        ret
bin2dec ENDP


divide  PROC NEAR
comment #
        Parameters : DX:AX = 32 bit dividend
                     BX = divisor

        Returns    : DX:AX = quotient
                     BX = remainder
        Destroys   : None

 General purpose 32 bit by 16 bit unsigned divide, DX:AX by BX
 This must be used instead of the plain machine unsigned divide
 for cases where the quotient may overflow 16 bits (for example,
 dividing 100,000 by 2).  If called with a zero divisor, this
 routine returns the dividend unchanged and gives no warning.

 This function is from a public domain source file, author unknown.
        #

        push    cx
        or      bx,bx
        jz      div1                            ; Exit if dividing by zero
        push    ax                              ; 0:dividend_upper/divisor
        mov     ax,dx
        xor     dx,dx
        div     bx
        mov     cx,ax                           ; CX = quotient1
        pop     ax                              ; remainder1:
        div     bx                              ;       dividend_lower/divisor
        mov     bx,cx
        xchg    bx,dx                           ; DX:AX = quotient1:quotient2
div1:
        pop     cx
        ret                                     ; BX = remainder2
divide  ENDP


PrintString	PROC NEAR	; DX=string
	mov	ah,09h
	int	21h
	ret
PrintString	ENDP


CheckDOSError   PROC NEAR
	jnc	NoDOSError
        mov     dl,al
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
        mov     di,offset doserrno
        call    DL2str
        mov     ax,offset errDOSError
        jmp     Error
NoDOSError:
        ret
CheckDOSError   ENDP


CheckNetBIOSError	PROC NEAR
        or      al,al
	jz	NoNetBIOSError
        mov     dl,al
	mov	ax,_DATA
	mov	ds,ax
	mov	es,ax
        mov     di,offset nberrno
        call    DL2str
	mov	ax,offset errNetBIOSError
        jmp     Error
NoNetBIOSError:
        ret
CheckNetBIOSError	ENDP


DL2str  PROC NEAR               ; dl = hex number, di=dest.
        mov     ah,0
        mov     al,dl
	shr	al,4
        mov     si,ax
        mov     al,[offset HexTable]+si
        stosb
        mov     al,dl
	and	al,0Fh
        mov     si,ax
        mov     al,[offset HexTable]+si
        stosb
        ret
DL2str	ENDP

_TEXT   ENDS

_STACK  SEGMENT PARA STACK 'STACK'
        dw 8192 DUP (?)
_STACK  ENDS

_ZZZZ   SEGMENT PARA PRIVATE 'ZZZZ'
_ZZZZ   ENDS

END Main
