
 /* 
 
 Copyright(C) 2007 Simon Howard

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 02111-1307, USA.

 --

 Hook into the mouse interrupt to call a function whenever it
 is invoked. 

 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <process.h>
#include <values.h>

#define MOUSE_INTERRUPT 0x33

struct INTERRUPT { unsigned bp,di,si,ds,es,dx,cx,bx,ax,ip,cs,fl; }; 

static void interrupt (*real_mouse_isr)();
static void (*mouse_callback_func)(void);

/* Replacement mouse driver ISR.  This wraps the real mouse driver
 * ISR, but calls the callback function as well. */

static void interrupt mouse_isr(struct INTERRUPT regs)
{
        mouse_callback_func();

        _AX = regs.ax;
        _BX = regs.bx;
        _CX = regs.cx;
        _DX = regs.dx;
        _ES = regs.es;
        _SI = regs.si;
        _DI = regs.di;

        real_mouse_isr();

        regs.ax = _AX;
        regs.bx = _BX;
        regs.cx = _CX;
        regs.dx = _DX;
        regs.es = _ES;
        regs.si = _SI;
        regs.di = _DI;
}

/* Install the given hook to run whenever a call is made into the
 * mouse driver. */

void init_mouse_hook(void (*callback)(void))
{
        void interrupt (*isr)();

        mouse_callback_func = callback;

        real_mouse_isr = getvect(MOUSE_INTERRUPT);

        isr = MK_FP(_CS, (int) mouse_isr);
        setvect(MOUSE_INTERRUPT, isr);
}

/* Uninstall the hook and restore the mouse driver. */

void shutdown_mouse_hook(void)
{
        setvect(MOUSE_INTERRUPT, real_mouse_isr);
}

