// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------
//
// A library of misc. stuff.
//
//--------------------------------------------------------------------------


#include "lmpit.h"

/* Dumps an error to the screen and quits ***********************************/
void error(char *s, ...)
{
        va_list args;
        va_start(args, s);

        textmode(C80);
        vprintf(s, args);
        abort();
}

/* Finds if IPX is available (Cool!) ****************************************/

int findipx(void)
{
        union REGS reg;

        reg.x.ax=0x7a00;
        int86(0x2f,&reg,&reg);

        if(reg.h.al==0xff)
                return 1;

        return 0;
}

/* Make a string to lowercase *********************************************/
char *strlwr(char *s)
{
        static char *p;

        for(p=s;*s;s++)
                *s=tolower(*s);
        return(p);
}

/* Make a string to uppercase *********************************************/
char *strupr(char *s)
{
        static char *p;

        for(p=s;*s;s++)
                *s=toupper(*s);
        return(p);
}

/* My string handler *******************************************************/
char *sf_text(char *def_text,int x, int y, int maxstr,int strtype)
{
        char tempstr[50];
        static char work[50];
        char inpc;

        strcpy(work,def_text);

        for(;;)
        {
                gotoxy(x,y);
                if((strtype!=STR_TEXT) && (strtype!=STR_DIR))
                {
                        if(strlen(work)==maxstr) printf("%s",work);
                        if(strlen(work)<maxstr) printf("%s",work);
                }
                else
                        cprintf("%s",work);
                fflush(stdout);
                inpc=getch();
                if(inpc==27)
                {
                        strcpy(work,def_text);
                        break;
                }
                if(inpc==0) getch();
                if((inpc>31 && inpc<127) && inpc!=34 && strlen(work)<maxstr)
                {
                        if((strtype==STR_PHONE) && !isdigit(inpc) && inpc!=',') continue;
                        if((strtype==STR_NUM) && !isdigit(inpc)) continue;
                        if((strtype==STR_HEX) && !isxdigit(inpc)) continue;
                        if((strtype==STR_FILEN) && !isalnum(inpc)
                                                && (inpc!='.')
                                                && (inpc!='_')
                                                && (inpc!='!') ) continue;
                        if((strtype==STR_DIR) && !isalnum(inpc) && (inpc!='.') && (inpc!=':') && (inpc!='\\')) continue;
                        gotoxy(x,y);
                        sprintf(work,"%s%c",work,inpc);
                        fflush(stdout);
                }
                if(inpc==8 && strlen(work)>0)
                {
                        if((strlen(work)<maxstr) && (strtype!=STR_TEXT))
                        {
                                gotoxy(x,y);
                                printf("%s ",work);
                                fflush(stdout);
                        }
                        strcpy(tempstr,work);
                        memset(work, 0, 50); 
                        strncpy(work,tempstr,strlen(tempstr)-1);
                        gotoxy(x,y);
                        if(strtype==STR_TEXT)
                                cprintf("%s ",work);
                        else
                                printf("%s ",work);
                        fflush(stdout);
                }
                if(inpc==13)
                        break;
        }
        return(work);
}

/* check_file returns 0 if it finds the file or 1 if it doesn't ***********/

int check_file(char filen[])
{
        FILE *fstream;

        fstream=fopen(filen,"r");

        if(fstream)
        {
                fclose(fstream);
                return(0);
        }
        if(fstream==0)
        {
                printf("\t%s not found!\n",filen);
                return(1);
        }
}
