// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------

#include "lmpit.h"

/* Manipulate a LMP *******************************************************/
void manipulate()
{
        int temp, selected=0;
        char in1;

        redraw:
        display_screen();
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(20,9); cputs("           LMP Manipulation               ");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(20,10);cputs("                                          ");
        gotoxy(20,11);cputs("                                          ");
        gotoxy(20,12);cputs("                                          ");
        gotoxy(20,13);cputs("                                          ");
        gotoxy(20,14);cputs("                                          ");
        gotoxy(20,15);cputs("                                          ");
        gotoxy(20,16);cputs("                                          ");

        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=10;temp<18;temp++)
        {       gotoxy(62,temp); cputs(""); }
        gotoxy(22,17);cputs("");
        textbackground(LIGHTGRAY);textcolor(DARKGRAY);
        gotoxy(23,12);cputs("Shorten LMP           Remove Pauses ");
        gotoxy(23,13);cputs("          ");

        gotoxy(23,14);cputs("Remove Game saves ");
        gotoxy(23,15);cputs("");

        textbackground(BLACK); textcolor(WHITE);
        gotoxy(22,12);cputs(" Shorten LMP ");
        gotoxy(45,12);cputs(" Remove Pauses ");
        gotoxy(22,14);cputs(" Remove Game Saves ");
        textcolor(RED);
        gotoxy(23,12);cputs("S");
        gotoxy(53,12);cputs("P");
        gotoxy(30,14);cputs("G");
        textcolor(WHITE);

        for(;;)
        {
                if(selected==0) gotoxy(23,12);
                if(selected==1) gotoxy(53,12);
                if(selected==2) gotoxy(30,14);
                in1=getch();
                if(in1==27) break;
                if(in1==0) getch();
                if(in1==9)
                {
                        selected++;
                        if(selected==3) selected=0;
                }
                if((in1==13) | (in1==' '))
                {
                        if(selected==0)
                                in1='S';
                        if(selected==1)
                                in1='P';
                        if(selected==2)
                                in1='G';
                }
                if((in1=='S') |(in1=='s'))
                {
                        shorten();
                        goto redraw;
                }
                if((in1=='P') |(in1=='p'))
                {
                        nopause();
                        goto redraw;
                }
                if((in1=='G') |(in1=='g'))
                {
                        nosaves();
                        goto redraw;
                }
        }
}

/* Shorten the LMP *******************************************************/
void shorten()
{
        char tempstr[12];
        int temp, num_seconds, num_tics, num_gametics, num_players;
        int count;
        FILE *fstream, *fstream2;
        tic mytic;

        display_screen();
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(20,9); cputs("              Shorten LMP                 ");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(20,10);cputs("  Shorten the LMP to how many seconds?    ");
        gotoxy(20,11);cputs("                                          ");
        gotoxy(20,12);cputs("                                          ");
        gotoxy(20,13);cputs("                                          ");
        gotoxy(20,14);cputs("                                          ");
        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=10;temp<16;temp++)
        {       gotoxy(62,temp); cputs(""); }
        gotoxy(22,15);cputs("");

        textbackground(BLACK); textcolor(WHITE);
        gotoxy(23,13);cputs("                                     ");
        gotoxy(23,13);

        strcpy(tempstr,sf_text("",23,13,10,STR_NUM));
        num_seconds=atoi(tempstr);
        if(!strcmp(tempstr,"")) return ;

        num_gametics=num_seconds*35;
        num_players=lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3];
        num_tics=num_gametics*num_players;

        rename(loaded_lmp,"~LMPIT.TMP");
        fstream=fopen("~LMPIT.TMP","rb");
        fstream2=fopen(loaded_lmp,"wb");

        fread(&lmp,sizeof(lmptype),1,fstream);
        fwrite(&lmp,sizeof(lmptype),1,fstream2);

        for(count=0;count<num_tics;count++)
        {
                fread(&mytic,sizeof(tic),1,fstream);
                if((mytic.forward==-128)|(mytic.strafe==-128) 
                  |(mytic.turn==-128)|(mytic.other==0x80)) break;
                fwrite(&mytic,sizeof(tic),1,fstream2);
        }

        fputc(0x80,fstream2);
        fputc(0x80,fstream2);
        fputc(0x80,fstream2);   // Several just to be sure

        fclose(fstream);
        fclose(fstream2);
}

void nopause()
{
        FILE *fstream, *fstream2;
        int paused_flag=0;
        unsigned char temp;
        tic mytic;
        char a;

        if(lmp.nomonsters==0)
        {
                display_screen();
                textbackground(RED); textcolor(BLACK);
                gotoxy(20,9); cputs("                 WARNING                  ");
                textbackground(LIGHTGRAY); textcolor(BLACK);
                gotoxy(20,10);cputs("                                          ");
                gotoxy(20,11);cputs("   This MAY cause your demo to go out     ");
                gotoxy(20,12);cputs("              of sync!                    ");
                gotoxy(20,13);cputs("                                          ");
                gotoxy(20,14);cputs("         [Press Y to continue]            ");
                gotoxy(20,15);cputs("                                          ");
                gotoxy(20,16);cputs("                                          ");
                textbackground(BLACK); textcolor(LIGHTGRAY);
                for(temp=10;temp<18;temp++)
                {       gotoxy(62,temp); cputs(""); }
                gotoxy(22,17);cputs("");

                a=getch();
                if( !((a=='Y') | (a=='y')) ) return;
                display_screen();
        }

        rename(loaded_lmp,"~LMPIT.TMP");
        fstream=fopen("~LMPIT.TMP","rb");
        fstream2=fopen(loaded_lmp,"wb");

        fread(&lmp,sizeof(lmptype),1,fstream);
        fwrite(&lmp,sizeof(lmptype),1,fstream2);

        for(;;)
        {
                fread(&mytic,sizeof(tic),1,fstream);
                if(mytic.other==0x81)
                {
                        paused_flag=!paused_flag;
                        continue;
                }
                if((mytic.forward==-128)|(mytic.strafe==-128)
                  |(mytic.turn==-128)|(mytic.other==0x80)) break;
                if(!paused_flag) fwrite(&mytic,sizeof(tic),1,fstream2);
        }

        fputc(0x80,fstream2);
        fputc(0x80,fstream2);
        fputc(0x80,fstream2);   // Several just to be sure

        fclose(fstream);
        fclose(fstream2);
}

void nosaves()
{
        FILE *fstream, *fstream2;
        int paused_flag=0;
        unsigned char temp;
        tic mytic;
        int a1,a2,a3,a4,a5,a6,a7,a8;
        char a;

  
        if(lmp.nomonsters==0)
        {
                display_screen();
                textbackground(RED); textcolor(BLACK);
                gotoxy(20,9); cputs("                WARNING                   ");
                textbackground(LIGHTGRAY); textcolor(BLACK);
                gotoxy(20,10);cputs("                                          ");
                gotoxy(20,11);cputs("   This MAY cause your demo to go out     ");
                gotoxy(20,12);cputs("              of sync!                    ");
                gotoxy(20,13);cputs("                                          ");
                gotoxy(20,14);cputs("         [Press Y to continue]            ");
                gotoxy(20,15);cputs("                                          ");
                gotoxy(20,16);cputs("                                          ");
                textbackground(BLACK); textcolor(LIGHTGRAY);
                for(temp=10;temp<18;temp++)
                {       gotoxy(62,temp); cputs(""); }
                gotoxy(22,17);cputs("");
                a=getch();
                if( !((a=='Y') | (a=='y')) ) return;
                display_screen();
        }

        rename(loaded_lmp,"~LMPIT.TMP");
        fstream=fopen("~LMPIT.TMP","rb");
        fstream2=fopen(loaded_lmp,"wb");

        fread(&lmp,sizeof(lmptype),1,fstream);
        fwrite(&lmp,sizeof(lmptype),1,fstream2);

        for(;;)
        {
                fread(&mytic,sizeof(tic),1,fstream);

                if(mytic.other)
                {
                        a1=(mytic.other & 1);
                        a2=(mytic.other & 2)/2;
                        a3=(mytic.other & 4)/4;
                        a4=(mytic.other & 8)/8;
                        a5=(mytic.other & 16)/16;
                        a6=(mytic.other & 32)/32;
                        a7=(mytic.other & 64)/64;
                        a8=(mytic.other & 128)/128;

                        if((!a1) && a2 && a8) mytic.other=0;
                }

                if((mytic.forward==-128)|(mytic.strafe==-128)
                  |(mytic.turn==-128)|(mytic.other==0x80)) break;
                if(!paused_flag) fwrite(&mytic,sizeof(tic),1,fstream2);
        }

        fputc(0x80,fstream2);
        fputc(0x80,fstream2);
        fputc(0x80,fstream2);   // Several just to be sure

        fclose(fstream);
        fclose(fstream2);
}

/*
  (d) the bits of this byte indicate what actions the player is engaged in:

      bit 0     Fire current weapon
      bit 1     Use (a switch, open a door, etc.)
      bit 2     Change weapon to the one indicated in bits 3-5:

      bits 5-3 = 000 Fist or Chainsaw
                 001 Pistol
                 010 Shotgun
                 011 Chaingun
                 100 Rocket Launcher
                 101 Plasma Rifle
                 110 BFG 9000
                 111 Super Shotgun (DOOM 2 only)

      bit 6     unused
      bit 7     indicates a special action which alters the meanings
                  of the other bits:

                bits 1-0 = 01 pause or unpause
                         = 10 save game in slot # recorded in bits 4 to 2
                                (slot number can thus be 0 to 7 but
                                 should NOT be 6 or 7 or else!)
*/

