// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------

#include "lmpit.h"

/** Edit the header *******************************************************/

void edit_header()
{
        int total_players, temp1;

        total_players=lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3];
        display_screen();
        display_info(1);
        for(;;)
        {
                display_info(0);
                temp1=getinput();
                if(temp1==1)            // ESC
                {
                        load_lmp(loaded_lmp);   // Reload
                        break;
                }
                if(temp1==2)            // Enter
                {
                        if((lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3])==total_players)
                        {
                                save_lmp(loaded_lmp);
                                break;
                        }
                        else
                        {
                                more_players(total_players);
                                display_info(1);
                                continue;
                        }
                }
        }
}

/* Display LMP Info ******************************************************/

void display_info(int firstime)
{
        short temp;

        textbackground(LIGHTGRAY); textcolor(BLACK);
        if(firstime)
        {
                textbackground(BLACK); textcolor(WHITE);
                gotoxy(5,3); cputs("                                                        ");
                gotoxy(33-(strlen(loaded_lmp)/2),3);cputs(loaded_lmp);

                textbackground(LIGHTGRAY); textcolor(BLACK);
                gotoxy(5,4); cputs("                                                        ");
                gotoxy(5,5); cputs("                                                        ");
                gotoxy(5,6); cputs("                                                        ");
                gotoxy(5,7); cputs("                                                        ");
                gotoxy(5,8); cputs("                                                        ");
                gotoxy(5,9); cputs("                                                        ");
                gotoxy(5,10);cputs("                                                        ");
                gotoxy(5,11);cputs("                                                        ");
                gotoxy(5,12);cputs("                                                        ");
                gotoxy(5,13);cputs("                                                        ");
                gotoxy(5,14);cputs("                                                        ");
                gotoxy(5,15);cputs("                                                        ");
                gotoxy(5,16);cputs("                                                        ");
                gotoxy(5,17);cputs("                                                        ");
        }
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(6,4); cprintf(" 1. Demo version:                                1.%i\n",lmp.version-100);
        gotoxy(6,5); cprintf(" 2. Skill level:                                   %i\n",lmp.skill_level+1);
        gotoxy(6,6); cprintf(" 3. Episode:                                       %i\n",lmp.episode);
        gotoxy(6,7); cprintf(" 4. Level:                                        %02i\n",lmp.level);
        gotoxy(6,8); cprintf(" 5. Mode:                             ");
                if(lmp.mode==0) cputs("1-Player/Co-op");
                if(lmp.mode==1) cputs("    Deathmatch");
                if(lmp.mode==2) cputs(" Deathmatch II");
        gotoxy(6,9); cprintf(" 6. Respawn:                                     ");
                if(lmp.respawn) cputs(" On");
                else cputs("Off");
        gotoxy(6,10);cprintf(" 7. Fast:                                        ");
                if(lmp.fast) cputs(" On");
                else cputs("Off");
        gotoxy(6,11);cprintf(" 8. Monsters:                                    ");
                if(lmp.nomonsters) cputs("Off");
                else cputs(" On");
        gotoxy(6,12);cprintf(" 9. Viewpoint:                              Player %i\n",lmp.viewpoint+1);
        gotoxy(6,13);cprintf(" A. Player 1:                            ");
                if(lmp.player[0]) cputs("    In game");
                else cputs("Not In game");
        gotoxy(6,14);cprintf(" B. Player 2:                            ");
                if(lmp.player[1]) cputs("    In game");
                else cputs("Not In game");
        gotoxy(6,15);cprintf(" C. Player 3:                            ");
                if(lmp.player[2]) cputs("    In game");
                else cputs("Not In game");
        gotoxy(6,16);cprintf(" D. Player 4:                            ");
                if(lmp.player[3]) cputs("    In game");
                else cputs("Not In game");

        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=4;temp<18;temp++)
        {       gotoxy(61,temp); cputs(""); }
        gotoxy(7,18);cputs("");
}

/* Input for 'editing lmp' screen *****************************************/

int getinput()
{
        int temp;
        char in1;
        char tempstr[10];

        gotoxy(0,0);
        in1=getch();

        if(in1==27) return 1;
        if(in1==13) return 2;

        if(in1=='1')
        {
                lmp.version++;
                if(lmp.version==110) lmp.version=106;
        }
        if(in1=='2')
        {
                lmp.skill_level++;
                if(lmp.skill_level==5) lmp.skill_level=0;
        }
        if(in1=='3')
        {
                lmp.episode++;
                if(lmp.episode==5) lmp.episode=1;
        }
        if(in1=='4')
        {
                textbackground(BLACK); textcolor(WHITE);
                gotoxy(56,7); cprintf("  ");
                strcpy(tempstr,sf_text("",56,7,2,STR_NUM));
                lmp.level=atoi(tempstr);
                if(lmp.level>32) lmp.level=32;
                if(lmp.level<1) lmp.level=1;
        }
        if(in1=='5')
        {
                lmp.mode++;
                if(lmp.mode==3) lmp.mode=0;
        }
        if(in1=='6')
                lmp.respawn=!lmp.respawn;
        if(in1=='7')
                lmp.fast=!lmp.fast;
        if(in1=='8')
                lmp.nomonsters=!lmp.nomonsters;
        if(in1=='9')
                for(;;)
                {
                        lmp.viewpoint++;
                        if(lmp.viewpoint>3) lmp.viewpoint=0;
                        if(lmp.player[lmp.viewpoint]) break;
                }

        if( (in1=='A') | (in1=='a') )
        {
                lmp.player[0]=!lmp.player[0];
                if(!lmp.player[0])
                {          
                        if((lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3])==0) lmp.player[0]=1;
                        if(lmp.viewpoint==0)
                                for(;;)
                                {
                                        lmp.viewpoint++;
                                        if(lmp.viewpoint>3) lmp.viewpoint=0;
                                        if(lmp.player[lmp.viewpoint]) break;
                                }

                }
        }
        if((in1=='B')| (in1=='b'))
        {
                lmp.player[1]=!lmp.player[1];
                if(!lmp.player[1])
                {
                        if((lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3])==0) lmp.player[1]=1;
                        if(lmp.viewpoint==1)
                                for(;;)
                                {
                                        lmp.viewpoint++;
                                        if(lmp.viewpoint>3) lmp.viewpoint=0;
                                        if(lmp.player[lmp.viewpoint]) break;
                                }
                }
        }
        if((in1=='C')| (in1=='c'))
        {
                lmp.player[2]=!lmp.player[2];
                if(!lmp.player[2])
                {
                        if((lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3])==0) lmp.player[2]=1;
                        if(lmp.viewpoint==2)
                                for(;;)
                                {
                                        lmp.viewpoint++;
                                        if(lmp.viewpoint>3) lmp.viewpoint=0;
                                        if(lmp.player[lmp.viewpoint]) break;
                                }
                }
        }
        if((in1=='D')| (in1=='d'))
        {
                lmp.player[3]=!lmp.player[3];
                if(!lmp.player[3])
                {
                        if((lmp.player[0]+lmp.player[1]+lmp.player[2]+lmp.player[3])==0) lmp.player[3]=1;
                        if(lmp.viewpoint==3)
                                for(;;)
                                {
                                        lmp.viewpoint++;
                                        if(lmp.viewpoint>3) lmp.viewpoint=0;
                                        if(lmp.player[lmp.viewpoint]) break;
                                }
                }
        }

        return 0;
}

/* Wrong amount o' players! **********************************************/

void more_players(int players_needed)
{
        int temp;

        display_screen();
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(18,9); cputs("             Players                      ");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(18,10);cprintf("  You need to select %i players!           ",players_needed);
        gotoxy(18,11);cputs("                                          ");
        gotoxy(18,12);cputs("                                          ");
        gotoxy(18,13);cputs("                                          ");
        gotoxy(18,14);cputs("                                          ");
        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=10;temp<16;temp++)
        {       gotoxy(60,temp); cputs(""); }
        gotoxy(20,15);cputs("");
        textbackground(LIGHTGRAY);textcolor(DARKGRAY);
        gotoxy(31,12);cputs("           ");
        gotoxy(31,13);cputs("");
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(30,12);cputs("     OK     ");
        textcolor(WHITE);
        gotoxy(35,12); getch();
}
