;---------------------------------------------------------------------------
;
; DMS   v0.12          Instant 180-degree turns in Doom!
; 
;   Copyright (c) Tom Klok and Dave 'Zoid' Kirsch         August, 1994
;
; DMS   v0.13      Support for keyboard added.
; DMS   v0.15     Toggle key to disable/enable mouse Y movement added.
;       Modifications by Lincoln Yeoh. 
;
;   Freely distributable as long as copyright and attributions
;   are maintained.
;
;   a344@mindlink.bc.ca, tom@auggy.mlnet.com
;   zoid@mindlink.bc.ca, zoid@grog.mlnet.com
;
;---------------------------------------------------------------------------

		.286

bk              equ     8
ht              equ     9
lf              equ     10
ff              equ     12
cr              equ     13
eof             equ     26
eos             equ     '$'

mouse_vector    equ     033h
_buttons        equ     00003h
_mickeys        equ     0000Bh
_query          equ     0DEADh
chk_response    equ     0D00Dh
chk_version     equ     0012Ah

dos_vector      equ     021h
_outstr         equ     00900h
_getvec         equ     03500h + mouse_vector
_setvec         equ     02500h + mouse_vector
_tsr            equ     03100h
_free           equ     04900h
_exit           equ     04C00h
_exit1          equ     _exit + 1

env_offset      equ     0002ch
tail_buff       equ     00081h

turn_90         equ     1463
turn_180        equ     turn_90 * 2
turn_270        equ     -turn_90
button_left     equ     1
button_right    equ     2
button_mid      equ     4
button_none     equ     8               ; Any four button mice for PCs? 

msdos           macro   name, val
		ifdef   &name
		mov     ax, &name
		ifdef   &val
		mov     dx, offset &val
		endif
		endif
		int     dos_vector
		endm

;---------------------------------------------------------------------------

code_seg        segment public
		assume  cs:code_seg, ds:nothing, es:nothing
		org     00100h

dms:            jmp     install

;---------------------------------------------------------------------------

		align   4
old_vector:     db      'oldv'
		; +x is right, +y is backwards
newmickeysx     dw      0               ; if non-zero, we're going to pass
newmickeysy     dw      0               ; if non-zero, we're going to pass
mickeyset       db      0

;DON'T CHANGE ORDER OF FOLLOWING LINES OR INSERT ANYTHING IN BETWEEN

button          db      0               ; 1 = left, 2 = right, 4 = middle
flipkeydwn      db      52              ;Default set to .
flipkeyup       db      52+128
mvtogkeydwn     db      45              ;Toggle key to disable mouse f/b.
mvtogkeyup      db      45+128          ;Key set to X
; that's it.                                         

keypressed      db      0
mvlock          db      0               ;Disable mouse forward/backward?
togpressed      db      0
oldal           db      0
;---------------------------------------------------------------------------

dms_proc:       cmp     ax, _buttons            ; get button info?
		je      getbutton

		cmp     ax, _mickeys            ; get mickeys?
		jne     nopemick
		jmp      getmickeys
nopemick:
		cmp     ax, _query              ; installation check?
		jne     old_handler

		mov     ax, chk_response        ; yes, we're here!
		mov     bx, chk_version
		mov     di, offset button
		iret

old_handler:
		jmp     dword ptr cs:[old_vector]

getbutton:      ; call the mouse handler (we're going to change it)
		; But first check the keyboard!
		pushf
		mov     cs:[oldal], al
		in      al,060h
		cmp     al,flipkeydwn
		jne     notit
		cmp     cs:[keypressed], 0
		jnz     getnkey                  ; If key hasn't been lifted since 
					; the last flip, don't keep flipping!
		mov     cs:[newmickeysx], turn_180
		inc     cs:[keypressed]          ; Okay it's  down now
		jmp     getnkey
		
notit:
		cmp     al,flipkeyup
		jne     getnkey

; flipkey has been released

		mov     cs:[keypressed], 0       ; So flip on next flipkeydwn
getnkey:         
		cmp     al,mvtogkeydwn
		jne     notit2
		cmp     cs:[togpressed],0
		jnz     chkbkey
		xor     cs:[mvlock],1
		inc     cs:[togpressed]
		jmp     chkbkey
notit2:
		cmp     al,mvtogkeyup
		jne     chkbkey
		mov     cs:[togpressed],0
chkbkey:
		nop
getbut:
		mov     al, cs:[oldal]
		call    dword ptr cs:[old_vector]

		mov     al, cs:[button]
		xor     bl, al
		test    bl, al                  ; test for button set
		jnz     nomickey

		; button(s) were pressed... are we debouncing?

		cmp     cs:[mickeyset], 0
		jnz     doiret                  ; debouncing, so ignore it

		; set up our fake mickeys

		mov     cs:[newmickeysx], turn_180
		inc     cs:[mickeyset]          ; debouce next time
		iret

nomickey:
		xor     bl, al
		mov     cs:[mickeyset], 0       ; not debouncing next time
		iret

getmickeys:     ; call the mouse handler (we're going to change it)

		pushf
		call    dword ptr cs:[old_vector]

		add     cx, cs:[newmickeysx]    ; zoot!  do the turn
		mov     cs:[newmickeysx], 0
		cmp     cs:[mvlock],0
		jz      doiret                 ; No lock- mouse ymove enabled
		mov     dx,0
			    
doiret:         iret

end_of_tsr:

;---------------------------------------------------------------------------

ttl:            db      "DMS v0.12 (c) "
		db      " Tom Klok/Dave 'Zoid' Kirsch",cr,lf
		db      "DMS v0.13 "
		db      ??date
		db      " keyboard support added by Lincoln Yeoh.",cr,eos
keypls:         db      cr,lf,"Please press your 180-flip key or press Esc for the default '.' "
		db      cr,lf,eos
keypls2:        db      cr,lf,"Please press your y-toggle key or press Esc for the default 'X' "
		db      cr,lf,eos
keynotok:       db      "Sorry, extended keys not supported!",cr,lf,eos
keyset:         db      "Alright! Let's get going!",cr,lf,eos
welcome:        db      ': installed!',cr,lf,eos
update_str:     db      ': buttons updated.',cr,lf,eos
usage_str:      db      cr,lf,lf,"Usage: DMS -[l][m][r][n] where LMR represent "
		db      "Left, Mid, Right mouse buttons.",cr,lf
		db      "And N for none of the above...",cr,lf
		db      "The default button selection is '-r' for Right."
		db      cr,lf,lf,"Freely distributable.  "
		db      "Queries or comments to a344@mindlink.bc.ca."
crlfeos         db      cr,lf,eos
buttons_str     db      "Mouse buttons to activate: ",eos
left_str        db      "left+",eos
middle_str      db      "middle+",eos
right_str       db      "right+",eos
none_str        db      "NONE ",eos
backup_str      db      bk,"."
		db      cr,lf,eos

;---------------------------------------------------------------------------

install:
		msdos   _outstr, ttl

		; chk command line for mouse button preferences

		mov     si, tail_buff+1
chk_cmd:
		lodsb

		cmp     al, cr          ; is it the terminator?
		je      cmd_done
		cmp     al, 0
		je      cmd_done

		cmp     al, ' '
		je      chk_cmd
		cmp     al, '-'
		je      chk_cmd
		cmp     al, '/'
		je      chk_cmd

		and     al, 0dfh        ; to uppercase

		cmp     al, 'L'
		jne     next2
		or      cs:[button], button_left
		jmp     chk_cmd
next2:
		cmp     al, 'R'
		jne     next3
		or      cs:[button], button_right
		jmp     chk_cmd
next3:
		cmp     al, 'M'
		jne     next4
		or      cs:[button], button_mid
		jmp     chk_cmd
next4:                                  ; For those who don't want to use mouse
		cmp     al, 'N'
		jne     show_usage
		or      cs:[button], button_none
		jmp     chk_cmd
show_usage:
		msdos   _outstr, usage_str
		msdos   _exit1
cmd_done:
		cmp     cs:[button], 0
		jne     moreinstall
		or      cs:[button], button_right
moreinstall:
		msdos   _outstr, keypls
waitup:
		in      al,060h
		cmp     al,128
		jb     waitup
		cmp     al,224
		je      waitk
waitdwn:
		in      al,060h
		cmp     al,224
		je      waitk
		cmp     al,128
		jnb     waitdwn
		jmp     keyok
waitk:
		in      al,060h
		cmp     al,224
		je     waitk
		msdos   _outstr, keynotok
		jmp     moreinstall
keyok:
		cmp     al,1
		je      waitup2
		mov     cs:[flipkeydwn],al
		add     al,128
		mov     cs:[flipkeyup],al
waitup2:
		in      al,060h
		cmp     al,128
		jb     waitup2
		msdos   _outstr, keyset
moreinstallB:
		msdos   _outstr, keypls2
waitupB:
		in      al,060h
		cmp     al,128
		jb     waitupB
		cmp     al,224
		je      waitkB
waitdwnB:
		in      al,060h
		cmp     al,224
		je      waitkB
		cmp     al,128
		jnb     waitdwnB
		jmp     keyokB
waitkB:
		in      al,060h
		cmp     al,224
		je     waitkB
		msdos   _outstr, keynotok
		jmp     moreinstallB
keyokB:
		cmp     al,1
		je      waitup2B
		mov     cs:[mvtogkeydwn],al
		add     al,128
		mov     cs:[mvtogkeyup],al
waitup2B:
		in      al,060h
		cmp     al,128
		jb     waitup2B
		msdos   _outstr, keyset

		mov     ax, _query
		int     mouse_vector
		cmp     ax, chk_response
		je      change_button

		msdos   _outstr, welcome

		msdos   _getvec                 ; es:bx <- int 33h pointer
		mov     word ptr [old_vector], bx
		mov     word ptr [old_vector + 2], es
		msdos   _setvec, dms_proc       ; int 33h pointer <- ds:dx

		call    display_buttons

		mov     ax, ds:[env_offset]     ; get envt segment
		mov     es, ax
		msdos   _free

		mov     dx, offset end_of_tsr
		add     dx, 15
		shr     dx, 4
		msdos   _tsr

change_button:
		push    di
		msdos   _getvec                 ; es:bx <- int 33h pointer
		mov     al, cs:[button]
		pop     di
		mov     es:[di], al
		mov     al, cs:[flipkeydwn]
		mov     es:[di+1], al
		mov     al, cs:[flipkeyup]
		mov     es:[di+2], al
		mov     al, cs:[mvtogkeydwn]
		mov     es:[di+3], al
		mov     al, cs:[mvtogkeyup]
		mov     es:[di+4], al
		msdos   _outstr, update_str
		call    display_buttons
		msdos   _exit1

display_buttons:
		msdos   _outstr, buttons_str
		test    cs:[button], button_none
		je      gotbuttons
		msdos   _outstr, none_str       
		jmp     db3
gotbuttons:
		test    cs:[button], button_left
		je      db1
		msdos   _outstr, left_str
db1:
		test    cs:[button], button_mid
		je      db2
		msdos   _outstr, middle_str
db2:
		test    cs:[button], button_right
		je      db3
		msdos   _outstr, right_str
db3:
		msdos   _outstr, backup_str
		ret


;---------------------------------------------------------------------------

code_seg        ends
		end     dms

