/*VISUALIZ.C----------------------------------------------------------------
Un visualizador para JBSP v1.02
por josemanuel, LsJmDM  // Cdigo y algoritmos prestados en parte de
NODENAV v 0.8 por Frank Palazzolo y DEU 5.21 & 5.3 por RQ y TV
---------------------------------------------------------------------------*/
/*
  	GRAFICOS
*/
	GrTextOption textopt;   /* text options */
static __inline__ void Iniciagraf(void)
{
   GrSetMode(GR_width_height_color_graphics, 640, 480, 16);
   x_maxima = GrSizeX()-1;
   y_maxima = GrSizeY()-1;
   /*======
        	CARGA LAS FUENTES
   ======*/
/* textopt.txo_font = GrLoadFont("@:pc8x8.fnt");
   if(textopt.txo_font = NULL)
      	ProgError("BUG: Can't load pc8x8 font.");*/
   textopt.txo_font = &GrDefaultFont;
   textopt.txo_fgcolor.v = RED;
   textopt.txo_direct = GR_TEXT_RIGHT;
   textopt.txo_xalign = GR_ALIGN_LEFT;
   textopt.txo_yalign = GR_ALIGN_TOP;
   textopt.txo_chrtype = GR_BYTE_TEXT;
   ingraf = VERDAD;
}

void Iniciagraf320(void)
{
   GrSetMode(GR_width_height_color_graphics, 320, 240, 256);
   x_maxima = GrSizeX()-1;
   y_maxima = GrSizeY()-1;
   ingraf = VERDAD;
}

static __inline__ void Cierragraf(void)
{
   GrSetMode(GR_default_text);
   ingraf = MENTIRA;
} 

static __inline__ void borrapantalla(void)
{
  GrClearScreen(BLACK);
}
static __inline__ void Dibujacontorno(void)
{
 GrLine( 0, 0, x_maxima, 0, BLUE);
 GrLine( 0, 0, 0, y_maxima, BLUE);
 GrLine( 0, y_maxima, x_maxima, y_maxima, BLUE);
 GrLine( x_maxima, 0, x_maxima, y_maxima, BLUE);
}   
/* 
    Dibuja el mapa completo
*/
static __inline__ void DibujaMapa(void)
{
   static int i;
   num_linedefs = num_lines;
   min_x = mapminx;
   min_y = mapminy;
   max_x = mapmaxx;
   max_y = mapmaxy;

   mit_x = (min_x + max_x) / 2;
   mit_y = (min_y + max_y) / 2;
   
   scala_x = ((float)320 / (float)(max_x - mit_x)) * (float)0.90;
   scala_y = ((float)240 / (float)(max_y - mit_y)) * (float)0.90;
   
   if (scala_x < scala_y) {
       Scale = scala_x;
   } else {
       Scale = scala_y;
   } /* endif */
   
   
   for (i=0;i<num_linedefs;i++)
   {
     GrLine(SCREENX(vertices[linedefs[i].start].x), 
            SCREENY(vertices[linedefs[i].start].y),
            SCREENX(vertices[linedefs[i].end].x),
            SCREENY(vertices[linedefs[i].end].y),
            LIGHTBLUE);
   } 
}

static __inline__ void Dibujalinea( int iver, int fver, int color ) 
{
   GrLine(SCREENX(vertices[iver].x), 
          SCREENY(vertices[iver].y),
          SCREENX(vertices[fver].x),
          SCREENY(vertices[fver].y),
          color);
}
static __inline__ void Dibujasector(int sector, int color)
{
  static int i;
  for (i=0;i<num_lines;i++)
   {
     if(sidedefs[linedefs[i].sidedef1].sector == sector)
     {   
        GrLine(SCREENX(vertices[linedefs[i].start].x), 
            SCREENY(vertices[linedefs[i].start].y),
            SCREENX(vertices[linedefs[i].end].x),
            SCREENY(vertices[linedefs[i].end].y),
            color);
     }
     else if(linedefs[i].sidedef2 != -1)
     {
       if(sidedefs[linedefs[i].sidedef2].sector == sector)
       {    
          GrLine(SCREENX(vertices[linedefs[i].start].x), 
              SCREENY(vertices[linedefs[i].start].y),
              SCREENX(vertices[linedefs[i].end].x),
              SCREENY(vertices[linedefs[i].end].y),
              color);
       }       
     }
   } 
}
static __inline__ void Dibujanodo(int mix, int miy, int max, int may, int color)
{
  GrBox( SCREENX(mix), SCREENY(miy), 
         SCREENX(max), SCREENY(may), color);
}  
static __inline__ void Dibcorlinea(int minx, int miny, int maxx, int maxy, int color)
{
  GrLine(SCREENX(minx), SCREENY(miny), SCREENX(maxx), SCREENY(maxy), color);
}
/*--------------------------------------------------------------------------*/
void tprogress(void)
{
	if(!((++pcnt)&15))
		fprintf(stderr,"%c\b","/-\\|"[((pcnt)>>4)&3]);
}
static __inline__ void progress()
{
   if(!ingraf)
             tprogress();
	else
     {
          if(!((++pcnt)&15))
     	{
	  		if(!pixel)//Borra el ltimo
	  		{
       			if(pixelcolor==BLUE)
		  			pixelcolor = GREEN;
	  			else
	  	  			pixelcolor = BLUE;
	  		}
       	GrLine(pixel+2, 0, pixel+2, 0, pixelcolor);
	  	++pixel;
		}
     }
}
/*
   	display a picture "picname" at coords x0, y0 and not beyond x1, y1
	traducida a JBSP por LSJMDM 11, mayo, 1997
*/

void DisplayPic( int x0, int y0, int x1, int y1,/* char *picname*/int dir)
{
// MDirPtr             dir;
//necesario con picname como argumento   int			dir;
   int                 xsize, ysize, xofs, yofs;
   int                 x, y;
   unsigned char 	*lpColumnData;
   unsigned char	*lpColumn;
   long			*lpNeededOffsets;
   int		       nColumns, nCurrentColumn;
   long                lCurrentOffset;
   long			picoffset;
   int		       fColumnInMemory;
   int		       i, n;
   unsigned char       bRowStart, bColored;


// if (bioskey( 1) != 0)
//    return; /* speedup */
// dir = FindMasterDir( MasterDir, picname);
// dir = FindDirSeek( picname, 1); //Se considera nivel 1 porque slo
   //se repiten una vez en el WAD
//   if (dir == NULL)		INNECESARIO
//   {
//      SetColor( DARKGRAY);
//      DrawScreenLine( x0, y0, x1, y1);
//      DrawScreenLine( x0, y1, x1, y0);
//      return;
//   }
// BasicWadSeek( dir->wadfile, dir->dir.start);
   //Guarda el offset del lump en el WAD
   picoffset = direc[dir].start;
   fseek(infile, picoffset, 0);
// BasicWadRead( dir->wadfile, &xsize, 2L);
   fread(&xsize,2L,1,infile);
// BasicWadRead( dir->wadfile, &ysize, 2L);
   fread(&ysize,2L,1,infile);
// BasicWadRead( dir->wadfile, &xofs, 2L);
   fread(&xofs,2L,1,infile);
// BasicWadRead( dir->wadfile, &yofs, 2L);
   fread(&yofs,2L,1,infile);
   /* ignore the picture offsets */
// xofs = 0;
// yofs = 0;
   /* No, no los ignores */
   xofs = (x_maxima - xsize)/2;
   yofs = (y_maxima - ysize)/2;

#define TEX_COLUMNBUFFERSIZE	(60L * 1024L)
#define TEX_COLUMNSIZE		512L

   nColumns = xsize;

   /* Note from CJS:
      I tried to use far memory originally, but kept getting out-of-mem errors
      that is really strange - I assume that the wad dir et al uses all
      the far mem, and there is only near memory available. NEVER seen
      this situation before..... I'll keep them huge pointers anyway,
      in case something changes later
   */
   lpColumnData    = (unsigned char*)GetMemory( TEX_COLUMNBUFFERSIZE);
   lpNeededOffsets = (long *)GetMemory( nColumns * 4L);
// BasicWadRead( dir->wadfile, lpNeededOffsets, nColumns * 4L);
   fread(lpNeededOffsets, nColumns * 4L, 1, infile);
   /* read first column data, and subsequent column data */
// BasicWadSeek( dir->wadfile, dir->dir.start + lpNeededOffsets[ 0]);
   fseek(infile, picoffset+lpNeededOffsets[ 0], 0);
// BasicWadRead( dir->wadfile, lpColumnData, TEX_COLUMNBUFFERSIZE);
   fread(lpColumnData, TEX_COLUMNBUFFERSIZE, 1, infile);
   
   for (nCurrentColumn = 0; nCurrentColumn < nColumns; nCurrentColumn++)
   {
      lCurrentOffset  = lpNeededOffsets[ nCurrentColumn];
      fColumnInMemory = lCurrentOffset >= lpNeededOffsets[ 0] && lCurrentOffset < (long)(lpNeededOffsets[ 0] + TEX_COLUMNBUFFERSIZE - TEX_COLUMNSIZE);
      if (fColumnInMemory)
      {
	 lpColumn = &lpColumnData[ lCurrentOffset - lpNeededOffsets[ 0]];
      }
      else
      {
	 lpColumn = GetMemory( TEX_COLUMNSIZE);
//	 BasicWadSeek( dir->wadfile, dir->dir.start + lCurrentOffset);
	 fseek(infile, picoffset+lCurrentOffset, 0);
//	 BasicWadRead( dir->wadfile, lpColumn, TEX_COLUMNSIZE);
         fread(lpColumn, TEX_COLUMNSIZE, 1, infile);
      }

      /* we now have the needed column data, one way or another, so write it */
      n = 1;
      bRowStart = lpColumn[ 0];
      while (bRowStart != 255 && n < TEX_COLUMNSIZE)
      {
	 bColored = lpColumn[ n];
	 n += 2;	/* skip over 'null' pixel in data */
	 for (i = 0; i < bColored; i++)
	 {
	    x = x0 + xofs + nCurrentColumn;
	    y = y0 + yofs + bRowStart + i;
	    if (x >= x0 && y >= y0 && x <= x1 && y <= y1)
//OJO	       putpixel( x, y, lpColumn[ i + n]);
//	       GrLine(x, y, x, y, lpColumn[ i + n]);
	       GrPlot(x, y, lpColumn [i + n]);
	 }
	 n += bColored + 1;	/* skip over written pixels, and the 'null' one */
	 bRowStart = lpColumn[ n++];
      }
      if (bRowStart != 255)
	 ProgError( "BUG: bRowStart != 255.");

      if (!fColumnInMemory)
//	 FreeFarMemory( lpColumn);
	 free( lpColumn);
   }//del for, que dibuja columna a columna
   
// FreeMemory( lpColumnData);
   free( lpColumnData);
// FreeMemory( lpNeededOffsets);
   free( lpNeededOffsets);
}
/*
   load one "playpal" palette and change all palette colours
   Adaptada por LSJMDM  07/mayo/1997
*/

void SetDoomPalette( int playpalnum)
{
// MDirPtr             dir;
   int			dir;
// unsigned char huge *dpal;
   unsigned char 	*dpal;
// BCINT                 n;
   int 			n;
   
   if (playpalnum < 0 && playpalnum > 13)
      ProgError("Playpal no vlido");
// dir = FindMasterDir( MasterDir, "PLAYPAL");
   dir = FindDirSeek( "PLAYPAL", 1);
// if (dir)
// {
//    dpal = (unsigned char*)GetFarMemory( 768 * sizeof( char));
      dpal = (unsigned char*)GetMemory( 768 * sizeof( char));
//    BasicWadSeek( dir->wadfile, dir->dir.start);
      fseek(infile, direc[dir].start, 0);	
      for (n = 0; n <= playpalnum; n++)
//   	 BasicWadRead( dir->wadfile, dpal, 768L);
	 fread(dpal, 768L, 1, infile);
      GrResetColors();
      for(n=0;n<254;n++)
         GrAllocCell();
      for(n=0;n<256;n++)
         GrSetColor(n,dpal[3*n],dpal[3*n+1],dpal[3*n+2]);
//    FreeFarMemory( dpal );
      free( dpal);
//  }
}
void VisNodos( int nivel)
{
     int i;
	unsigned short int j;
     int key = 0; int zoom;
	short int max_x, max_y, min_x, min_y, mid_x, mid_y;
     float scale_x, scale_y, scale, orzoom;
     char L_type, R_type;
     unsigned short int up_node[4096];
     char temp[120];

	Leenodos(nivel);
	up_node[num_pnodes-1] = num_pnodes-1;
     for(i=0;i<num_pnodes;i++)
     {
           if (!(pnodes[i].chleft & 0x8000))
                        up_node[pnodes[i].chleft] = i;
           if (!(pnodes[i].chright & 0x8000))
                        up_node[pnodes[i].chright] = i;
     }
	j = num_pnodes - 1;
     orzoom = Scale;
     zoom = 0;
     while (key != 'Q')
     {
          borrapantalla();
     	Dibujacontorno();

        	min_x = min(min(pnodes[j].maxx1,pnodes[j].minx1),
                      min(pnodes[j].maxx2,pnodes[j].minx2));
          min_y = min(min(pnodes[j].maxy1,pnodes[j].miny1),
                      min(pnodes[j].maxy2,pnodes[j].miny2));
          max_x = max(max(pnodes[j].maxx1,pnodes[j].minx1),
                      max(pnodes[j].maxx2,pnodes[j].minx2));
          max_y = max(max(pnodes[j].maxy1,pnodes[j].miny1),
                      max(pnodes[j].maxy2,pnodes[j].miny2));

        	mid_x = (min_x + max_x) / 2;
        	mid_y = (min_y + max_y) / 2;

        	scale_x = ((float)320 / (float)(max_x - mid_x)) * (float)0.90;
        	scale_y = ((float)240 / (float)(max_y - mid_y)) * (float)0.90;

        	if (scale_x < scale_y)
        	{
           	scale = scale_x;
        	}
        	else
        	{
           	scale = scale_y;
        	} /* endif */
		if(!zoom)
               scale = orzoom;

    	     DibujaMapaZoom( scale, mid_x, mid_y);

          Dibujanodo(pnodes[j].minx1,
                      pnodes[j].miny1,
                       pnodes[j].maxx1,
                        pnodes[j].maxy1,
                         RED);
          Dibujanodo(pnodes[j].minx2,
                      pnodes[j].miny2,
                       pnodes[j].maxx2,
                        pnodes[j].maxy2,
                         BLUE);

          Dibcorlinea(pnodes[j].x,
         			   pnodes[j].y,
                        pnodes[j].x+pnodes[j].dx,
			          pnodes[j].y+pnodes[j].dy,
                          GREEN);
          if(pnodes[j].chleft & 0x8000)
             L_type = 'S';
	     else
             L_type = 'N';
          if(pnodes[j].chright & 0x8000)
             R_type = 'S';
          else
             R_type = 'N';

          sprintf(temp,"JBsp v%s        N:%#04x     %c:%#04hx   %c:%#04hx        Zoom: %i", VERSION,
          	j, L_type,pnodes[j].chleft & 0x7fff,R_type,pnodes[j].chright & 0x7fff, zoom);

          GrDrawString(temp, strlen(temp), 1, 1, &textopt);

          fflush(stdout);
          key = toupper(getch());
          if (key == 'L' && L_type == 'N')
                j = pnodes[j].chleft;
          if (key == 'R' && R_type == 'N')
                j = pnodes[j].chright;
          if (key == 'U')
                j = up_node[j];
          if (key == 'Z')
             	if(zoom)
               	zoom = 0;
               else
               	zoom = 1;
     }//del while
	free( pnodes);
     pnodes = NULL;
}
void DibujaMapaZoom(float scale, short int mid_x, short int mid_y)
{
   static int i;
   num_linedefs = num_lines;

   Scale = scale;
   mit_x = mid_x;
   mit_y = mid_y;
   for (i=0;i<num_linedefs;i++)
   {
     GrLine(SCREENX(vertices[linedefs[i].start].x), 
            SCREENY(vertices[linedefs[i].start].y),
            SCREENX(vertices[linedefs[i].end].x),
            SCREENY(vertices[linedefs[i].end].y),
            GRAY);
   } 
}
void VisReject(int nivel)
{
     unsigned char *reject;//reject descomprimida
     long			lreject;//Longitud del reject descomprimido
     long			ldata;//longitud del reject en el WAD
     long 		a, b=0;//Para los bucles
     int 			sector=0;//sector que se est dibujando
     int 			tecla = 0;
     char 		temp[120];
     //Primero "descomprime" el reject de bits a bytes
     ldata = direc[FindDirSeek("REJECT", nivel)].length;
	lreject = num_sects * num_sects;
     reject = (unsigned char *)GetMemory(lreject);//Coloca memoria
     Leereject(nivel);
     for(a = 0; a<ldata; ++a)
     {
/*        reject[b] = (data[a] >> 1); ++b;
          reject[b] = (data[a] >> 2); ++b;
          reject[b] = (data[a] << 3); ++b;
          reject[b] = (data[a] << 4); ++b;
          reject[b] = (data[a] << 5); ++b;
          reject[b] = (data[a] << 6); ++b;
          reject[b] = (data[a] << 7); ++b;
          reject[b] = (data[a] << 8); ++b;
*/
          if(data[a] & 0) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 1) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 2) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 3) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 4) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 5) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 6) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
          if(data[a] & 7) reject[b] = VERDAD;
          else reject[b] = MENTIRA;
          ++b;
     }
     while(tecla !='Q')
     {
     	//dibuja el mapa
	     DibujaMapa();
          //Y dibuja los sectores con bit = 0(a los que se puede atacar)
    		//apunta a donde est el array de bits para ese sector
	     b = sector * num_sects;
    		//busca sector a sector en el reject
	     for(a=0; a< num_sects; ++a)
     	{
          	if(!reject[b+a])
          		Dibujasector(a, RED);
	     }
          //dibuja el sector actual de reject
	     Dibujasector( sector, GREEN);

          sprintf(temp,"JBsp v%s                Sector: %i de %li     Tamao: %li                            ",
          			VERSION, sector, num_sects, ldata);
	     GrDrawString(temp, strlen(temp), 1, 1, &textopt);
	     fflush(stdout);
        	tecla = toupper(getch());
        	if (tecla == 'S')
               if((sector+1) < num_sects)
          		++sector;
          if (tecla == 'A')
          	if((sector-1)> -1)
	          	--sector;

	     if (tecla == 'F')
               if((sector+10) < num_sects)
          		sector+=10;
          if (tecla == 'D')
          	if((sector-10)> -1)
	          	sector-=10;
	}
     free( reject);
     reject = NULL;
}
//eof