/*------JBSP----------------------------------------------------------------*

  JBsp, un constructor de nodos para los juegos de Id.
  Copyright, LS JmDM. Versin 1.02, DOS-32 bit.
  
  Basado en BSP 1.5x por Colin Reed.
  
  Diseado, realizado y compilado por LS JmDM en Corrales, Zamora, Espaa.
  
*--------------------------------------------------------------------------*/ 
#define VERSION "1.02"
/*-----Includes------*/
#include "jbsp.h"
#include "structs.h"
//#include "idstrcs.h"

/*---Variables globales----*/
static Bool gfxsi;//Para los grficos
static Bool idbsp;
static Bool jmreject;
static Bool ver;
static Bool debug;
static Bool t;
static Bool bsp15;
static Bool bsp21;
static int dstreject;
static int nivel;//nivel que se est procesando
static int niv;//Nivel a procesar( dicho por el usuario )
/*--Variables grficas------------------------*/
static int max_x, max_y, min_x, min_y, num_linedefs, mit_x, mit_y;
static int x_maxima, y_maxima;
static float scala_y, scala_x, Scale;
static unsigned char pixel;
static unsigned char pixelcolor = GREEN;
static Bool ingraf;//Estamos en modo grfico?
/*- Global Vars ------------------------------------------------------------*/
static FILE *infile,*outfile;
static char *testwad;
static char *outwad;

static struct wad_header *wad = NULL;//cabecera del wad de entrada
static struct directory *direc = NULL;//Directorio del wad en entrada
static struct directory *outdirec = NULL;//Directorio del wad de salida

static struct Thing *things;
static long num_things = 0;
static long things_start = 0;

static struct Vertex *vertices;
static long num_verts = 0;
static long vertices_start = 0;

static struct LineDef *linedefs;
static long num_lines = 0;
static long linedefs_start = 0;

static struct SideDef *sidedefs;
static long num_sides = 0;
static long sidedefs_start = 0;

static struct Sector *sectors;
static long num_sects = 0;
static long sectors_start = 0;

static struct SSector *ssectors;
static long num_ssectors = 0;
static long ssectors_start = 0;

static struct Pseg *psegs = NULL;
static long num_psegs = 0;
static long segs_start = 0;

static struct Pnode *pnodes = NULL;
static long num_pnodes = 0;
static long pnode_indx = 0;
static long pnodes_start = 0;

static struct Seg *tsegs = NULL;
static long num_tsegs = 0;

static struct Node *nodelist = NULL;
static long num_nodes = 0;

static unsigned char *data;/* Para la reject */

static long reject_start; 
static long reject_size;

static struct Block blockhead;
static short int *blockptrs;
static short int *blocklists=NULL;
static long blockptrs_size;
static long blockmap_size;
static long blockmap_start;

static struct splitter sp;

static short node_x;
static short node_y;
static short node_dx;
static short node_dy;

static short lminx;
static short lmaxx;
static short lminy;
static short lmaxy;

static short mapminx;
static short mapmaxx;
static short mapminy;
static short mapmaxy;

static long psx,psy,pex,pey,pdx,pdy;
static long lsx,lsy,lex,ley;

static unsigned char pcnt;

long dir_start = 12;//oJo CoN eSTo									/* Skip Pwad header*/
long dir_entries = 0;//iDeM
/*---Variables para el reject------*/
static Int8      *connections;
static bline_t   *blines;
static bbox_t    *secboxes;
static bchain_t  *bchains;
static Int16      numsectors;
static Int16      numblines;
static Int16      numbchains;
static STORAGE   *chains_i;
static STORAGE   *lines;

/*- Prototypes -------------------------------------------------------------*/
/*----Prototipos para visualiz.c-----*/
static __inline__ void Iniciagraf(void);
static __inline__ void Cierragraf(void);
static __inline__ void borrapantalla(void);
static __inline__ void Dibujacontorno(void);
static __inline__ void DibujaMapa(void);
static __inline__ void Dibujalinea(int iver, int fver, int color);
static __inline__ void Dibujasector(int sector, int color);
static __inline__ void Dibujanodo(int mix, int miy, int max, int may, int color);
static __inline__ void progress();
void DibujaMapaZoom(float scale, short int mid_x, short int mid_y);
/*--para maquina.c---*/
static __inline__ void OpenWadFile(char *);
//static __inline__ int  FindDir(char *);
static __inline__ void GetThings(int nivel);
static __inline__ void GetVertexes(int nivel);
static __inline__ void GetLinedefs(int nivel);
static __inline__ void GetSidedefs(int nivel);
static __inline__ void GetSectors(int nivel);
static __inline__ void FindLimits(struct Seg *);

static __inline__ Bool Encuentranivel(int nivel);
static __inline__ int FindDirSeek(char *name, int nivel);
static __inline__ Bool FindDirSeekNivel(char *name, int nivel);
void Salvanivel(int nivel);
void Guardanivel(int nivel);
void Leenivel(int nivel);
void freemem(void);
/*-----para visor3d.c-----*/
void Dibujanivel3D( int nivel );
void Puntos3D( int nivel );
void Crealineas(int nivel);
void Dibmap3D( int nivel );

/*-----para idbsp.c---------*/

/*----para jbsp.c-----*/
static __inline__ struct Seg *CreateSegs15();
static __inline__ struct Seg *CreateSegs21();

static struct Node *CreateNode(struct Seg *);
static __inline__ void DivideSegs15(struct Seg *,struct Seg **,struct Seg **);
static __inline__ void DivideSegs21(struct Seg *,struct Seg **,struct Seg **);
static __inline__ int IsItConvex15(struct Seg *);
static __inline__ int IsItConvex21(struct Seg *);

static __inline__ struct Seg *PickNode15(struct Seg *);
static __inline__ struct Seg *PickNode21(struct Seg *);
static __inline__ void ComputeIntersection15(short int *,short int *);
static __inline__ void ComputeIntersection21(short int *,short int *);
static __inline__ int DoLinesIntersect();
static __inline__ int SplitDist(struct Seg *);

static void ReverseNodes(struct Node *);
static __inline__ long CreateBlockmap(void);

static __inline__ int IsLineDefInside(int, int, int, int, int);
static __inline__ int CreateSSector(struct Seg *);

static __inline__ void *CreaReject(int distancia);
static __inline__ Bool DistMin(int sector1, int sector2, int distancia);
static __inline__ void *CreateRejectData(void);
/*-----Includes con cdigo fuente--------*/
#include "jbsp.c"
#include "maquina.c"
#include "visualiz.c"
//#include "visor3d.c"
//#include "idbsp.c"
/*----------main----------*/
int main(int argc,char *argv[])
{

     int i;// para gestionar el bucle de los argumentos de entrada
	char *end;
     long f;
       
   printf("* Constructor BSP para Doom %s (c) LSJmDM - Corrales, Zamora, Espaa        *\n", VERSION);
	printf("*                                                                             *\n");
	printf("* Basado en BSP 2.1x de Colin Reed. (c) LSJmDM - Junio, 1997                  *\n");

     gfxsi = VERDAD;
     jmreject = MENTIRA;
     ingraf = MENTIRA;

     idbsp = MENTIRA;
     bsp15 = MENTIRA;
     bsp21 = VERDAD;
//      Bucle con las opciones (prestado de QBSP, id software)
     for (i=1 ; i<argc ; i++)
	{
		if (argv[i][0] != '-')
		     break;
		else if(!strcmp (argv[i], "-id"))
		     idbsp = VERDAD;
		else if(!strcmp ( argv[i], "-ver"))
		     ver = VERDAD;
          else if(!strcmp ( argv[i], "-bsp15"))
		{
          	bsp15 = VERDAD;
               bsp21 = MENTIRA;
          }
		else if(!strcmp ( argv[i], "-t"))
		     t = VERDAD;
		else if(!strcmp ( argv[i], "-debug"))
		     debug = VERDAD;
		else if (!strcmp (argv[i],"-factor"))
		{
		  f=strtol(argv[i+1],&end,10);
		  factor=f>0 && !*end ? f : 0;
		  i++;
		}
		else if (!strcmp (argv[i],"-nivel"))
		{
		  f=strtol(argv[i+1],&end,10);
		  niv = (int)f;
		  i++;
		}
		else if (!strcmp (argv[i],"-jmreject"))
		{
		  char *end;
		  long f;
		  f=strtol(argv[i+1],&end,10);
		  dstreject=(int)f;
		  if(dstreject > 60000) dstreject = 600;
		  if(dstreject < 0 ) dstreject = 0;
		  jmreject = VERDAD;
		  i++;
		}
		else if (!strcmp (argv[i],"-nograf"))
			gfxsi = MENTIRA;
		else
		{
			 printf("Opcin %s desconocida", argv[i]);
			 exit(0);
		}	 
	}//FIN DE LA GESTION DE aRGuMeNToS
	
	if (i != argc - 2 && i != argc - 1)
	{
	  printf("\nEste constructor fue creado mediante la teora contenida en DEU5 (OBJECTS.C)\n"
		       "\nAgradecimientos :-\n"
		       "Colin Reed     (creed@graymatter.on.ca) por el constructor original.\n"
		       "Matt Fell      (msfell@aol.com) por The Unofficial Doom Specs.\n"
		       "Raphael Quinet (Raphael.Quinet@eed.ericsson.se) por DEU la idea original.\n"
		       "Mark Harrison  (harrison@lclark.edu) por encontrar un error en BSP 1.1x\n"
                       "Lee Killough   (killough@convex.com) por implementar mayor rendimiento\n"
		       "Frank Pazzolo  (??????) por Nodenav, del cual se ha tomado codigo\n"
		       "\nCompilado y estructurado en Corrales, Zamora, Espaa."
		       "\nUso:\n"
		       "JBSP [-ver] [-t] [-bsp15] [-nivel nn] [-factor nn] [-jmreject nnn] [-nograf] \n"
		       "inwad {salida.wad}\n"
		       "(Si no se especifica salida.wad, TMP.WAD ser escita)\n"
		       );
		exit(0);
	}
	                
        testwad = argv[i];
	if(argv[i+1] != NULL) outwad = argv[i+1];/* Get output name*/
	else outwad = "tmp.wad";

	if(!gfxsi && ver)
	  ProgError("-ver y -nograf no se pueden especificar a la vez");
	if(bsp15 && bsp21)
     	ProgError("BUG: bsp15 y bsp21 son ambos verdad");

	OpenWadFile(testwad);	/* Opens and reads directory*/
	nivel = 1;
	//A CALCULAR
	if(!ver)//Si no es ver, construir los nodos
	{
	  if(t || niv != 0)//Procesa todos los lumps
	  {
	  	int a,b;//Para el for
	  	
	  	//Abre el wad de salida
	  	if((outfile = fopen(outwad,"wb")) == NULL)
			ProgError("Error: No se puede crear fichero de salida PWAD %s", outwad);
		fwrite(wad,4,1,outfile);
		//reserva espacio
		fwrite(wad, 8, 1, outfile);
		//Si niv != 0, procesa el nivel y adis
		if(niv != 0)
		{
			if(!Encuentranivel(niv))
				ProgError("No existe el nivel %i en el WAD", niv);
               printf("Nivel: %.8s\n", direc[FindDirSeek("THINGS", niv)-1].name);
			ConstruyeNodos(niv);
			if(!gfxsi)
				printf("Encontrados %lu vertices usados\n",num_verts);
			if(gfxsi)
				Cierragraf();
			Guardanivel(niv);//guarda el nmero de nivel al wad de salida
			freemem();
			fwrite(outdirec,(sizeof(struct directory)*dir_entries),1,outfile);
		        //el numero de entradas
			fseek(outfile, 4, SEEK_SET);
			fwrite( &dir_entries, sizeof(long), 1, outfile);
			//y el offset del directorio
			fwrite( &dir_start, sizeof(long), 1, outfile);
			fclose(outfile);
			exit (0);//ADIOS
		}	
		//Copia lump a lump, y si es nivel, procsalo
		a = wad->num_entries;
		for(b=0; b<a; ++b)
		{
			//Si no es THINGS, copiala y a otra cosa, mariposa
			if(strcmp(direc[b+1].name, "THINGS"))
			{
				printf(" Copiando %.8s ...\n", direc[b].name);
				GuardaLump(b);
			}	
			else//Si no, construye nodos
			{	
				printf("\n Procesando el nivel %.8s ...\n", direc[b].name);
				ConstruyeNodos(nivel);
				if(!gfxsi)
					printf("Encontrados %lu vertices usados\n",num_verts);
				if(gfxsi)
					Cierragraf();
				Guardanivel(nivel);//guarda el nmero de nivel al wad de salida
				freemem();
				nivel += 1;
				b += 10;
			}	
		}//del for
	  	fwrite(outdirec,(sizeof(struct directory)*dir_entries),1,outfile);
	        //el numero de entradas
		fseek(outfile, 4, SEEK_SET);
		fwrite( &dir_entries, sizeof(long), 1, outfile);
		//y el offset del directorio
		fwrite( &dir_start, sizeof(long), 1, outfile);
		fclose(outfile);
		exit (0);//ADIOS
	  }//de t || niv != 0
	  else
	  {
	  	while(Encuentranivel(nivel))/*Procesa todos los niveles del WAD*/
	  	{
		  printf("\nNivel = %i,", nivel); printf(" %s\n", direc[FindDirSeek("THINGS", nivel)-1].name);
		  ConstruyeNodos(nivel);
		  if(!gfxsi)
    		         printf("Encontrados %lu vertices usados\n",num_verts);
	          if(gfxsi)
	             Cierragraf();
	          if(!Encuentranivel(nivel+1))
		  {
		  printf("Completa la construccin de los NODOS, REJECT y BLOCKMAP\n");  
		  printf("Guardado todo en PWAD %s\n",outwad);	
	          if(gfxsi)
	             delay(1500);
		  }
		  if(nivel == 1)
		  {
		    if((outfile = fopen(outwad,"wb")) == NULL)
		    {
	                 printf("Error: No se puede crear fichero de salida PWAD %s", outwad);
			 exit(0);
	            }
		    fwrite(wad,4,1,outfile);
		    //reserva espacio
		    fwrite(wad, 8, 1, outfile);
		  }
		  Guardanivel(nivel);//guarda el nmero de nivel al wad de salida
		  freemem();
	          ++nivel;// a por el siguiente nivel
        	}//de encuentranivel	
		//escribe el directorio
		fwrite(outdirec,(sizeof(struct directory)*dir_entries),1,outfile);
	        //el numero de entradas
		fseek(outfile, 4, SEEK_SET);
		fwrite( &dir_entries, sizeof(long), 1, outfile);
		//y el offset del directorio
		fwrite( &dir_start, sizeof(long), 1, outfile);
		fclose(outfile);
	  }//del else de if (t
	}//de if(!ver)
     else //visor
     {
          char tecla;
          Bool redibuja = 1;
          Bool relee = 1;

          while(Encuentranivel(nivel))
          {
            if(relee)
            {
              	Leenivel(nivel);
	      	num_tsegs = 0;
               //Usa por ahora la versin bsp 1.5x(Junio-1997)
	      	tsegs = CreateSegs15(); /* Initially create segs*/
	      	FindLimits(tsegs);/* Find limits of vertices*/
	      	mapminx = lminx;	/* store as map limits*/
		      mapmaxx = lmaxx;
		      mapminy = lminy;
	     	 mapmaxy = lmaxy;
           	if(gfxsi)
           	{
                     char temp[120];

           		 Iniciagraf();
	                Dibujacontorno();
     	           DibujaMapa();
                     sprintf(temp, "JBsp v%s     Nivel: %i    %s",
                    			VERSION, nivel, direc[FindDirSeek("THINGS", nivel)-1].name);
               	 GrDrawString(temp, strlen(temp), 1, 1, &textopt);
               }
            }
            else if(redibuja)
            {
               if(gfxsi)
               {
                    char temp[120];

               	borrapantalla();
               	Dibujacontorno();
				DibujaMapa();
                    sprintf(temp, "JBsp v%s     Nivel: %i    %s",
                    			VERSION, nivel, direc[FindDirSeek("THINGS", nivel)-1].name);
               	GrDrawString(temp, strlen(temp), 1, 1, &textopt);
			}
            }

            tecla = getch();
            if(tecla == 'S' || tecla == 's')
            {
              if(Encuentranivel(nivel+1))
              {
                nivel++;
                freemem();
	                relee = VERDAD;
                continue;
              }
              else
              {
                relee = MENTIRA;
                redibuja = MENTIRA;
                continue;
              }  
            }  
            if(tecla == 'Q' || tecla == 'q')
            {
              freemem();
              break;
            }  
            if(tecla == 'A' || tecla == 'a')
            {
              if(nivel > 1)
              {
                nivel --;
                freemem();
                relee = VERDAD;
                continue;
              }
              else
              {  
                relee = MENTIRA;
                redibuja = MENTIRA;
                continue;
              }
            }  
            //Visor de NODOS
            if(tecla == 'N' || tecla == 'n')
            {
               VisNodos(nivel);
            	relee = MENTIRA;
               redibuja = VERDAD;
            	continue;
            }
            //Visor de REJECT
            if(tecla == 'R' || tecla == 'r')
            {
               VisReject(nivel);
            	relee = MENTIRA;
               redibuja = VERDAD;
            	continue;
            }
/*          if(tecla == 'J' || tecla == 'j')
            {	//Visor en tres dimensiones
              borrapantalla();//Borra la Pantalla
              Dibujanivel3D( nivel );//LLama a dibujanivel3d, visor3d.c
              redibuja = VERDAD;
              relee = MENTIRA;
              continue;
            }*/
            relee = MENTIRA;
            redibuja = MENTIRA;
          }//del while  
     	Cierragraf();
     }//del visor de niveles
     return 0;//adios
}
