/*
				WAD_DWD.H
*/
#ifndef __WAD_DWD__
#define __WAD_DWD__

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <memory.h>
#include <string.h>
#include "doomdata.h"

#define MAX_SPECIFIC 30

typedef struct
{
		char            identification[4];                      /* IWAD or PWAD */
		long            numlumps;
		long            infotableofs;
} wadinfo_t;


typedef struct
{
		long             filepos;
		long             size;
		char            name[8];
} lumpinfo_t;

void Error(char *, ...);
void *SafeCalloc(unsigned, size_t);
void *ReadWAD(FILE *, long, size_t);
void *ReadStorage(FILE *, lumpinfo_t *, long *, size_t);
void WriteHeader(FILE *);
void WriteSectors(FILE *, long, mapsector_t *);
/* void WriteLines(FILE *, long, maplinedef_t *, mapvertex_t *, mapsidedef_t *, mapsector_t *); */
void WriteLines(FILE *, long, maplinedef_t *, mapvertex_t *, mapsidedef_t *);
void WriteThings(FILE *, long, mapthing_t *);
/* void WriteSideAndSector(FILE *, mapsidedef_t *, mapsector_t *); */
void WriteSide(FILE *, mapsidedef_t *);
void WriteSector(FILE *, mapsector_t *);
void ExtractResource(FILE *, lumpinfo_t *);
void ExtractLevel(FILE *, FILE *, lumpinfo_t *);
int ParseSpecificLevels(char *, char *levels[]);
boolean TestSpecificLevel(char *, char *levels[], int);
#endif
